/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;

public class JRPrintServiceExporter
extends JRAbstractExporter
implements Printable {
    public JRGraphics2DExporter exporter = null;
    public boolean displayPageDialog = false;
    public boolean displayPageDialogOnlyOnce = false;
    public boolean displayPrintDialog = false;
    public boolean displayPrintDialogOnlyOnce = false;
    public int reportIndex = 0;
    private PrintService printService = null;
    public static Class m;
    public static Class l;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        this.setOffset();
        try {
            Object object;
            Boolean bl2;
            Boolean bl3;
            PrintServiceAttributeSet printServiceAttributeSet;
            this.setExportContext();
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            if ((printServiceAttributeSet = (PrintServiceAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET)) == null) {
                printServiceAttributeSet = new HashPrintServiceAttributeSet();
            }
            if ((bl3 = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG)) != null) {
                this.displayPageDialog = bl3;
            }
            Boolean bl4 = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG_ONLY_ONCE);
            if (this.displayPageDialog && bl4 != null) {
                this.displayPageDialogOnlyOnce = bl4;
            }
            if ((bl2 = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG)) != null) {
                this.displayPrintDialog = bl2;
            }
            Boolean bl5 = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG_ONLY_ONCE);
            if (this.displayPrintDialog && bl5 != null) {
                this.displayPrintDialogOnlyOnce = bl5;
            }
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            JRPrinterAWT.initPrinterJobFields(printerJob);
            printerJob.setPrintable(this);
            this.printService = (PrintService)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE);
            if (this.printService == null && ((PrintService[])(object = PrintServiceLookup.lookupPrintServices(null, printServiceAttributeSet))).length > 0) {
                this.printService = object[0];
            }
            if (this.printService == null) {
                throw new JRException("No suitable print service found.");
            }
            try {
                printerJob.setPrintService(this.printService);
            }
            catch (PrinterException printerException) {
                throw new JRException(printerException);
            }
            object = null;
            if (this.displayPrintDialogOnlyOnce || this.displayPageDialogOnlyOnce) {
                object = new HashPrintRequestAttributeSet();
                this.setDefaultPrintRequestAttributeSet((PrintRequestAttributeSet)object);
                this.setOrientation((JasperPrint)this.jasperPrintList.get(0), (PrintRequestAttributeSet)object);
                if (this.displayPageDialogOnlyOnce) {
                    if (printerJob.pageDialog((PrintRequestAttributeSet)object) == null) {
                        return;
                    }
                    this.displayPageDialog = false;
                }
                if (this.displayPrintDialogOnlyOnce) {
                    if (!printerJob.printDialog((PrintRequestAttributeSet)object)) {
                        return;
                    }
                    this.displayPrintDialog = false;
                }
            }
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.exporter = new JRGraphics2DExporter();
                this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
                this.exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, this.parameters.get(JRExporterParameter.PROGRESS_MONITOR));
                this.exporter.setParameter(JRExporterParameter.OFFSET_X, this.parameters.get(JRExporterParameter.OFFSET_X));
                this.exporter.setParameter(JRExporterParameter.OFFSET_Y, this.parameters.get(JRExporterParameter.OFFSET_Y));
                this.exporter.setParameter(JRExporterParameter.CLASS_LOADER, this.classLoader);
                this.exporter.setParameter(JRExporterParameter.URL_HANDLER_FACTORY, this.urlHandlerFactory);
                if (this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.exporter.setParameter(JRExporterParameter.FILTER, this.filter);
                }
                this.exporter.setParameter(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE, this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE));
                if (this.displayPrintDialog || this.displayPageDialog || !this.displayPrintDialogOnlyOnce && !this.displayPageDialogOnlyOnce) {
                    object = new HashPrintRequestAttributeSet();
                    this.setDefaultPrintRequestAttributeSet((PrintRequestAttributeSet)object);
                    this.setOrientation(this.jasperPrint, (PrintRequestAttributeSet)object);
                }
                try {
                    if (!this.isModeBatch) {
                        object.add(new PageRanges(this.startPageIndex + 1, this.endPageIndex + 1));
                    }
                    printerJob.setJobName("JasperReports - " + this.jasperPrint.getName());
                    if (this.displayPageDialog) {
                        printerJob.pageDialog((PrintRequestAttributeSet)object);
                    }
                    if (this.displayPrintDialog) {
                        if (printerJob.printDialog((PrintRequestAttributeSet)object)) {
                            printerJob.print((PrintRequestAttributeSet)object);
                        }
                    } else {
                        printerJob.print((PrintRequestAttributeSet)object);
                    }
                }
                catch (PrinterException printerException) {
                    throw new JRException(printerException);
                }
                ++this.reportIndex;
            }
            this.printService = printerJob.getPrintService();
        }
        finally {
            this.resetExportContext();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (n2 < 0 || n2 >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
        this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(n2));
        try {
            this.exporter.exportReport();
        }
        catch (JRException jRException) {
            throw new PrinterException(jRException.getMessage());
        }
        return 0;
    }

    private void setOrientation(JasperPrint jasperPrint, PrintRequestAttributeSet printRequestAttributeSet) {
        if (!printRequestAttributeSet.containsKey(m == null ? (m = JRPrintServiceExporter.a("javax.print.attribute.standard.MediaPrintableArea")) : m)) {
            int n2;
            int n3;
            switch (jasperPrint.getOrientation()) {
                case 2: {
                    n3 = jasperPrint.getPageHeight();
                    n2 = jasperPrint.getPageWidth();
                    break;
                }
                default: {
                    n3 = jasperPrint.getPageWidth();
                    n2 = jasperPrint.getPageHeight();
                }
            }
            printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, (float)n3 / 72.0f, (float)n2 / 72.0f, 25400));
        }
        if (!printRequestAttributeSet.containsKey(l == null ? (l = JRPrintServiceExporter.a("javax.print.attribute.standard.OrientationRequested")) : l)) {
            OrientationRequested orientationRequested;
            switch (jasperPrint.getOrientation()) {
                case 2: {
                    orientationRequested = OrientationRequested.LANDSCAPE;
                    break;
                }
                default: {
                    orientationRequested = OrientationRequested.PORTRAIT;
                }
            }
            printRequestAttributeSet.add(orientationRequested);
        }
    }

    private void setDefaultPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        PrintRequestAttributeSet printRequestAttributeSet2 = (PrintRequestAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET);
        if (printRequestAttributeSet2 != null) {
            printRequestAttributeSet.addAll(printRequestAttributeSet2);
        }
    }

    public static boolean checkAvailablePrinters() {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            Attribute[] attributeArray = printServiceArray[i2].getAttributes().toArray();
            for (int i3 = 0; i3 < attributeArray.length; ++i3) {
                if (!attributeArray[i3].equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) continue;
                return true;
            }
        }
        return false;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

