/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRCsvExporter
extends JRAbstractExporter {
    private static final String CSV_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.csv.exclude.origin.";
    public String delimiter = null;
    public String recordDelimiter = null;
    public Writer writer = null;
    public JRExportProgressMonitor progressMonitor = null;
    public ExporterNature nature = null;

    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
            this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), CSV_ORIGIN_EXPORTER_FILTER_PREFIX);
        }
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        this.nature = new JRCsvExporterNature(this.filter);
        String string = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
        this.delimiter = this.getStringParameterOrDefault(JRCsvExporterParameter.FIELD_DELIMITER, "net.sf.jasperreports.export.csv.field.delimiter");
        this.recordDelimiter = this.getStringParameterOrDefault(JRCsvExporterParameter.RECORD_DELIMITER, "net.sf.jasperreports.export.csv.record.delimiter");
        StringBuffer stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (stringBuffer != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                stringBuffer.append(this.writer.toString());
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (file == null) {
            String string2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (string2 != null) {
                file = new File(string2);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            outputStream = new FileOutputStream(file);
            this.writer = new OutputStreamWriter(outputStream, string);
            this.exportReportToWriter();
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportReportToWriter() throws JRException, IOException {
        for (int i2 = 0; i2 < this.jasperPrintList.size(); ++i2) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(i2);
            List list = this.jasperPrint.getPages();
            if (list == null || list.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
            }
            for (int i3 = this.startPageIndex; i3 <= this.endPageIndex; ++i3) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(i3);
                this.exportPage(jRPrintPage);
            }
        }
        this.writer.flush();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws IOException {
        JRGridLayout jRGridLayout = new JRGridLayout(this.nature, jRPrintPage.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        CutsInfo cutsInfo = jRGridLayout.getXCuts();
        CutsInfo cutsInfo2 = jRGridLayout.getYCuts();
        StringBuffer stringBuffer = null;
        JRPrintElement jRPrintElement = null;
        String string = null;
        boolean bl2 = true;
        for (int i2 = 0; i2 < jRExporterGridCellArray.length; ++i2) {
            stringBuffer = new StringBuffer();
            if (!cutsInfo2.isCutNotEmpty(i2)) continue;
            bl2 = true;
            for (int i3 = 0; i3 < jRExporterGridCellArray[i2].length; ++i3) {
                if (jRExporterGridCellArray[i2][i3].getWrapper() != null) {
                    jRPrintElement = jRExporterGridCellArray[i2][i3].getWrapper().getElement();
                    if (!(jRPrintElement instanceof JRPrintText)) continue;
                    JRStyledText jRStyledText = this.getStyledText((JRPrintText)jRPrintElement);
                    string = jRStyledText == null ? "" : jRStyledText.getText();
                    if (!bl2) {
                        stringBuffer.append(this.delimiter);
                    }
                    stringBuffer.append(this.prepareText(string));
                    bl2 = false;
                    continue;
                }
                if (!cutsInfo.isCutNotEmpty(i3)) continue;
                if (!bl2) {
                    stringBuffer.append(this.delimiter);
                }
                bl2 = false;
            }
            if (stringBuffer.length() <= 0) continue;
            this.writer.write(stringBuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText) {
        return jRPrintText.getFullStyledText(JRStyledTextAttributeSelector.NONE);
    }

    public String prepareText(String string) {
        String string2 = null;
        if (string != null) {
            boolean bl2 = false;
            if (string.indexOf(this.delimiter) >= 0 || string.indexOf(this.recordDelimiter) >= 0) {
                bl2 = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"\n", true);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if ("\"".equals(string3)) {
                    bl2 = true;
                    stringBuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(string3)) {
                    bl2 = true;
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
            if (bl2) {
                string2 = "\"" + string2 + "\"";
            }
        }
        return string2;
    }
}

