/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog(l == null ? (l = JExcelApiExporter.a("net.sf.jasperreports.engine.export.JExcelApiExporter")) : l);
    public static final Colour WHITE = Colour.WHITE;
    public static final Colour BLACK = Colour.BLACK;
    public static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map colorsCache = new ReferenceMap();
    private static Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map loadedCellStyles = new HashMap();
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map numberFormats;
    private Map dateFormats;
    public Map formatPatternsMap = null;
    public boolean createCustomPalette;
    public Map workbookColours = new HashMap();
    public Map usedColours = new HashMap();
    public ExporterNature nature = null;
    public static Class l;

    public JExcelApiExporter() {
        this.numberFormats = new HashMap();
        this.dateFormats = new HashMap();
    }

    public void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.createCustomPalette = this.getBooleanParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, "net.sf.jasperreports.export.xls.create.custom.palette", false);
        if (this.createCustomPalette) {
            this.initCustomPalette();
        }
        this.nature = new JExcelApiExporterNature(this.filter, this.isIgnoreGraphics);
    }

    public void initCustomPalette() {
        for (int i2 = 0; i2 < FIXED_COLOURS.length; ++i2) {
            Colour colour = FIXED_COLOURS[i2];
            this.setColourUsed(colour);
        }
    }

    public void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    public void setColourUsed(Colour colour, Color color) {
        if (log.isDebugEnabled()) {
            log.debug("Modifying palette colour " + colour.getValue() + " to " + color);
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        this.workbook.setColourRGB(colour, n2, n3, n4);
        RGB rGB = new RGB(n2, n3, n4);
        this.usedColours.put(colour, rGB);
    }

    public void setBackground() {
        this.backgroundMode = this.isWhitePageBackground ? Pattern.SOLID : Pattern.NONE;
    }

    public void openWorkbook(OutputStream outputStream) throws JRException {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
    }

    public void createSheet(String string) {
        this.sheet = this.workbook.createSheet(string, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    public void closeWorkbook(OutputStream outputStream) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
        catch (WriteException writeException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), writeException);
        }
    }

    public void setColumnWidth(int n2, int n3) {
        CellView cellView = new CellView();
        cellView.setSize(n3);
        this.sheet.setColumnView(n2, cellView);
    }

    public void setRowHeight(int n2, int n3) throws JRException {
        try {
            this.sheet.setRowView(n2, n3 * 20);
        }
        catch (RowsExceededException rowsExceededException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), rowsExceededException);
        }
    }

    public void setCell(int n2, int n3) {
    }

    public void removeColumn(int n2) {
        this.sheet.removeColumn(n2);
    }

    public void addBlankCell(JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        Colour colour = BLACK;
        if (jRExporterGridCell.getForecolor() != null) {
            colour = this.getWorkbookColour(jRExporterGridCell.getForecolor());
        }
        Pattern pattern = this.backgroundMode;
        Colour colour2 = WHITE;
        if (jRExporterGridCell.getCellBackcolor() != null) {
            pattern = Pattern.SOLID;
            colour2 = this.getWorkbookColour(jRExporterGridCell.getCellBackcolor());
        }
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, writableFont, jRExporterGridCell);
        try {
            this.sheet.addCell((WritableCell)new Blank(n2, n3, (CellFormat)writableCellFormat));
        }
        catch (RowsExceededException rowsExceededException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), rowsExceededException);
        }
        catch (WriteException writeException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), writeException);
        }
    }

    public void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n2, n3);
        Colour colour = this.getWorkbookColour(jRPrintLine.getLinePen().getLineColor());
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(Pattern.SOLID, colour, writableFont, jRExporterGridCell);
        Blank blank = new Blank(n2, n3, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (Exception exception) {
            throw new JRException("Can't add cell.", exception);
        }
    }

    public void exportRectangle(JRPrintGraphicElement jRPrintGraphicElement, JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n2, n3);
        Colour colour = WHITE;
        Pattern pattern = this.backgroundMode;
        if (jRExporterGridCell.getCellBackcolor() != null) {
            pattern = Pattern.SOLID;
            colour = this.getWorkbookColour(jRExporterGridCell.getCellBackcolor());
        }
        Colour colour2 = this.getWorkbookColour(jRPrintGraphicElement.getLinePen().getLineColor());
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour2.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour, writableFont, jRExporterGridCell);
        Blank blank = new Blank(n2, n3, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (Exception exception) {
            throw new JRException("Can't add cell.", exception);
        }
    }

    public void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n2, n3);
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText != null) {
            Colour colour = this.getWorkbookColour(jRPrintText.getForecolor());
            WritableFont writableFont = this.getLoadedFont(jRPrintText, colour.getValue());
            JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JExcelApiExporter.getTextAlignHolder(jRPrintText);
            int n4 = this.getHorizontalAlignment(textAlignHolder);
            int n5 = this.getVerticalAlignment(textAlignHolder);
            int n6 = this.getRotation(textAlignHolder);
            Pattern pattern = this.backgroundMode;
            Colour colour2 = WHITE;
            if (jRExporterGridCell.getCellBackcolor() != null) {
                pattern = Pattern.SOLID;
                colour2 = this.getWorkbookColour(jRExporterGridCell.getCellBackcolor());
            }
            StyleInfo styleInfo = new StyleInfo(this, pattern, colour2, n4, n5, n6, writableFont, jRExporterGridCell);
            String string = jRStyledText.getText();
            String string2 = null;
            JRHyperlinkProducer jRHyperlinkProducer = this.getCustomHandler(jRPrintText);
            if (jRHyperlinkProducer == null) {
                switch (jRPrintText.getHyperlinkType()) {
                    case 2: {
                        string2 = jRPrintText.getHyperlinkReference();
                        break;
                    }
                }
            } else {
                string2 = jRHyperlinkProducer.getHyperlink(jRPrintText);
            }
            try {
                if (string2 != null) {
                    try {
                        URL uRL = new URL(string2);
                        WritableHyperlink writableHyperlink = new WritableHyperlink(n2, n3, n2, n3, uRL);
                        this.sheet.addHyperlink(writableHyperlink);
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.warn("Reference \"" + string2 + "\" could not be parsed as URL: " + malformedURLException);
                    }
                }
                this.addCell(n2, n3, jRPrintText, string, styleInfo);
            }
            catch (Exception exception) {
                throw new JRException("Can't add cell.", exception);
            }
        }
    }

    public void addCell(int n2, int n3, JRPrintText jRPrintText, String string, StyleInfo styleInfo) throws WriteException, RowsExceededException, JRException {
        CellValue cellValue = this.isDetectCellType ? this.getDetectedCellValue(n2, n3, jRPrintText, string, styleInfo) : (this.isAutoDetectCellType ? this.getAutoDetectedCellValue(n2, n3, string, styleInfo) : this.getLabelCell(n2, n3, string, styleInfo));
        this.sheet.addCell((WritableCell)cellValue);
    }

    public CellValue getDetectedCellValue(int n2, int n3, JRPrintText jRPrintText, String string, StyleInfo styleInfo) throws JRException {
        TextValue textValue = this.getTextValue(jRPrintText, string);
        CellTextValueHandler cellTextValueHandler = new CellTextValueHandler(this, n2, n3, styleInfo);
        textValue.handle(cellTextValueHandler);
        return cellTextValueHandler.getResult();
    }

    public NumberFormat getNumberFormat(String string) {
        String string2 = this.getConvertedPattern(string);
        NumberFormat numberFormat = (NumberFormat)this.numberFormats.get(string2);
        if (numberFormat == null) {
            numberFormat = new NumberFormat(string2);
            this.numberFormats.put(string2, numberFormat);
        }
        return numberFormat;
    }

    public DateFormat getDateFormat(String string) {
        String string2 = this.getConvertedPattern(string);
        DateFormat dateFormat = (DateFormat)this.dateFormats.get(string2);
        if (dateFormat == null) {
            dateFormat = new DateFormat(string2);
            this.dateFormats.put(string2, dateFormat);
        }
        return dateFormat;
    }

    public CellValue getAutoDetectedCellValue(int n2, int n3, String string, StyleInfo styleInfo) throws JRException {
        CellValue cellValue;
        try {
            double d2 = Double.parseDouble(string);
            WritableCellFormat writableCellFormat = this.getLoadedCellStyle(styleInfo);
            cellValue = new Number(n2, n3, d2, (CellFormat)writableCellFormat);
        }
        catch (NumberFormatException numberFormatException) {
            cellValue = this.getLabelCell(n2, n3, string, styleInfo);
        }
        return cellValue;
    }

    public CellValue getLabelCell(int n2, int n3, String string, StyleInfo styleInfo) throws JRException {
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(styleInfo);
        Label label = new Label(n2, n3, string, (CellFormat)writableCellFormat);
        return label;
    }

    public void addMergeRegion(JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        if (jRExporterGridCell.getColSpan() > 1 || jRExporterGridCell.getRowSpan() > 1) {
            try {
                if (this.isCollapseRowSpan) {
                    this.sheet.mergeCells(n2, n3, n2 + jRExporterGridCell.getColSpan() - 1, n3);
                } else {
                    this.sheet.mergeCells(n2, n3, n2 + jRExporterGridCell.getColSpan() - 1, n3 + jRExporterGridCell.getRowSpan() - 1);
                }
            }
            catch (JXLException jXLException) {
                throw new JRException("Can't merge cells.", jXLException);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.horizontalAlignment) {
            case 3: {
                return Alignment.RIGHT.getValue();
            }
            case 2: {
                return Alignment.CENTRE.getValue();
            }
            case 4: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.verticalAlignment) {
            case 3: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case 2: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case 4: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.rotation) {
            case 1: {
                return Orientation.PLUS_90.getValue();
            }
            case 2: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell, int n2, int n3, int n4) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n2, n3);
        int n5 = Math.max(jRPrintImage.getLineBox().getTopPadding(), JExcelApiExporter.getBorderCorrection(jRPrintImage.getLineBox().getTopPen()));
        int n6 = Math.max(jRPrintImage.getLineBox().getLeftPadding(), JExcelApiExporter.getBorderCorrection(jRPrintImage.getLineBox().getLeftPen()));
        int n7 = Math.max(jRPrintImage.getLineBox().getBottomPadding(), JExcelApiExporter.getBorderCorrection(jRPrintImage.getLineBox().getBottomPen()));
        int n8 = Math.max(jRPrintImage.getLineBox().getRightPadding(), JExcelApiExporter.getBorderCorrection(jRPrintImage.getLineBox().getRightPen()));
        int n9 = jRPrintImage.getWidth() - n6 - n8;
        n9 = n9 < 0 ? 0 : n9;
        int n10 = jRPrintImage.getHeight() - n5 - n7;
        n10 = n10 < 0 ? 0 : n10;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && n9 > 0 && n10 > 0) {
            if (jRRenderable.getType() == 0 && (jRRenderable = JRImageRenderer.getOnErrorRendererForImageData(jRRenderable, jRPrintImage.getOnErrorType())) != null) {
                jRRenderable = JRImageRenderer.getOnErrorRendererForDimension(jRRenderable, jRPrintImage.getOnErrorType());
            }
        } else {
            jRRenderable = null;
        }
        if (jRRenderable != null) {
            int n11 = n9;
            int n12 = n10;
            Dimension2D dimension2D = jRRenderable.getDimension();
            if (dimension2D != null) {
                n11 = (int)dimension2D.getWidth();
                n12 = (int)dimension2D.getHeight();
            }
            float f2 = 0.0f;
            switch (jRPrintImage.getHorizontalAlignment()) {
                case 3: {
                    f2 = 1.0f;
                    break;
                }
                case 2: {
                    f2 = 0.5f;
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            float f3 = 0.0f;
            switch (jRPrintImage.getVerticalAlignment()) {
                case 3: {
                    f3 = 1.0f;
                    break;
                }
                case 2: {
                    f3 = 0.5f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
            BufferedImage bufferedImage = new BufferedImage(jRPrintImage.getWidth(), jRPrintImage.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            switch (jRPrintImage.getScaleImage()) {
                case 1: {
                    int n13 = (int)(f2 * (float)(n9 - n11));
                    int n14 = (int)(f3 * (float)(n10 - n12));
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(new Rectangle(n6, n5, n9, n10));
                    try {
                        jRRenderable.render(graphics2D, new Rectangle(n13 + n6, n14 + n5, n11, n12));
                        break;
                    }
                    finally {
                        graphics2D.setClip(shape);
                    }
                }
                case 2: {
                    jRRenderable.render(graphics2D, new Rectangle(n6, n5, n9, n10));
                    break;
                }
                default: {
                    if (jRPrintImage.getHeight() <= 0) break;
                    double d2 = (double)n11 / (double)n12;
                    if (d2 > (double)n9 / (double)n10) {
                        n11 = n9;
                        n12 = (int)((double)n9 / d2);
                    } else {
                        n11 = (int)((double)n10 * d2);
                        n12 = n10;
                    }
                    int n15 = n6 + (int)(f2 * (float)(n9 - n11));
                    int n16 = n5 + (int)(f3 * (float)(n10 - n12));
                    jRRenderable.render(graphics2D, new Rectangle(n15, n16, n11, n12));
                }
            }
            Pattern pattern = this.backgroundMode;
            Colour colour = WHITE;
            if (jRPrintImage.getMode() == 1) {
                pattern = Pattern.SOLID;
                colour = this.getWorkbookColour(jRPrintImage.getBackcolor());
            }
            Colour colour2 = this.getWorkbookColour(jRPrintImage.getLineBox().getPen().getLineColor());
            WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour2.getValue());
            WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour, writableFont, jRExporterGridCell);
            try {
                this.sheet.addCell((WritableCell)new Blank(n2, n3, (CellFormat)writableCellFormat));
                WritableImage writableImage = new WritableImage((double)(n2 - n4), (double)n3, (double)jRExporterGridCell.getColSpan(), (double)jRExporterGridCell.getRowSpan(), JRImageLoader.loadImageDataFromAWTImage(bufferedImage, (byte)3));
                this.sheet.addImage(writableImage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JRException("The cell cannot be added", exception);
            }
            catch (Error error) {
                error.printStackTrace();
                throw new JRException("The cell cannot be added", error);
            }
        }
    }

    public Colour getWorkbookColour(Color color) {
        Colour colour;
        if (this.createCustomPalette) {
            colour = (Colour)this.workbookColours.get(color);
            if (colour == null) {
                colour = this.determineWorkbookColour(color);
                this.workbookColours.put(color, colour);
            }
        } else {
            colour = JExcelApiExporter.getNearestColour(color);
        }
        return colour;
    }

    public Colour determineWorkbookColour(Color color) {
        Colour colour;
        int n2 = 999;
        Colour colour2 = null;
        int n3 = 999;
        Colour colour3 = null;
        Colour[] colourArray = Colour.getAllColours();
        for (int i2 = 0; i2 < colourArray.length; ++i2) {
            Colour colour4 = colourArray[i2];
            RGB rGB = (RGB)this.usedColours.get(colour4);
            RGB rGB2 = rGB == null ? colour4.getDefaultRGB() : rGB;
            int n4 = JExcelApiExporter.rgbDistance(color, rGB2);
            if (n4 < n2) {
                n2 = n4;
                colour2 = colour4;
            }
            if (n4 == 0) break;
            if (rGB != null || n4 >= n3) continue;
            n3 = n4;
            colour3 = colour4;
        }
        if (n2 == 0) {
            if (!this.usedColours.containsKey(colour2)) {
                this.setColourUsed(colour2);
            }
            colour = colour2;
        } else if (colour3 == null) {
            if (log.isWarnEnabled()) {
                log.warn("No more available colours in the palette.  Using the nearest match for " + color);
            }
            colour = colour2;
        } else {
            this.setColourUsed(colour3, color);
            colour = colour3;
        }
        return colour;
    }

    public static Colour getNearestColour(Color color) {
        Colour colour = (Colour)colorsCache.get(color);
        if (colour == null) {
            Colour[] colourArray = Colour.getAllColours();
            if (colourArray != null && colourArray.length > 0) {
                int n2 = 999;
                for (int i2 = 0; i2 < colourArray.length; ++i2) {
                    Colour colour2 = colourArray[i2];
                    int n3 = JExcelApiExporter.rgbDistance(color, colour2.getDefaultRGB());
                    if (n3 >= n2) continue;
                    n2 = n3;
                    colour = colour2;
                }
            }
            colorsCache.put(color, colour);
        }
        return colour;
    }

    public static int rgbDistance(Color color, RGB rGB) {
        int n2 = Math.abs(rGB.getRed() - color.getRed()) + Math.abs(rGB.getGreen() - color.getGreen()) + Math.abs(rGB.getBlue() - color.getBlue());
        return n2;
    }

    private WritableFont getLoadedFont(JRFont jRFont, int n2) throws JRException {
        String string;
        int n3;
        Object object = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (n3 = 0; n3 < this.loadedFonts.size(); ++n3) {
                string = (WritableFont)this.loadedFonts.get(n3);
                int n4 = jRFont.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --n4;
                }
                String string2 = jRFont.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(string2)) {
                    string2 = (String)this.fontMap.get(string2);
                }
                if (!string.getName().equals(string2) || string.getColour().getValue() != n2 || string.getPointSize() != n4 || !(string.getUnderlineStyle() == UnderlineStyle.SINGLE ? jRFont.isUnderline() : !jRFont.isUnderline()) || string.isStruckout() != jRFont.isStrikeThrough() || !(string.getBoldWeight() == BoldStyle.BOLD.getValue() ? jRFont.isBold() : !jRFont.isBold()) || string.isItalic() != jRFont.isItalic()) continue;
                object = string;
                break;
            }
        }
        try {
            if (object == null) {
                n3 = jRFont.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --n3;
                }
                string = jRFont.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(string)) {
                    string = (String)this.fontMap.get(string);
                }
                object = new WritableFont(WritableFont.createFont((String)string), n3, jRFont.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, jRFont.isItalic(), jRFont.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)n2));
                object.setStruckout(jRFont.isStrikeThrough());
                this.loadedFonts.add(object);
            }
        }
        catch (Exception exception) {
            throw new JRException("Can't get loaded fonts.", exception);
        }
        return object;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern pattern, Colour colour, WritableFont writableFont, JRExporterGridCell jRExporterGridCell) throws JRException {
        StyleInfo styleInfo = new StyleInfo(this, pattern, colour, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
        return this.getLoadedCellStyle(styleInfo);
    }

    public WritableCellFormat getLoadedCellStyle(StyleInfo styleInfo) throws JRException {
        WritableCellFormat writableCellFormat = (WritableCellFormat)this.loadedCellStyles.get(styleInfo);
        if (writableCellFormat == null) {
            try {
                writableCellFormat = styleInfo.getDisplayFormat() == null ? new WritableCellFormat(styleInfo.font) : new WritableCellFormat(styleInfo.font, styleInfo.getDisplayFormat());
                writableCellFormat.setBackground(styleInfo.backcolor, styleInfo.mode);
                writableCellFormat.setAlignment(Alignment.getAlignment((int)styleInfo.horizontalAlignment));
                writableCellFormat.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleInfo.verticalAlignment));
                writableCellFormat.setOrientation(Orientation.getOrientation((int)styleInfo.rotation));
                writableCellFormat.setWrap(true);
                if (!this.isIgnoreCellBorder) {
                    BoxStyle boxStyle = styleInfo.box;
                    writableCellFormat.setBorder(Border.TOP, boxStyle.topBorder, boxStyle.topBorderColour);
                    writableCellFormat.setBorder(Border.BOTTOM, boxStyle.bottomBorder, boxStyle.bottomBorderColour);
                    writableCellFormat.setBorder(Border.LEFT, boxStyle.leftBorder, boxStyle.leftBorderColour);
                    writableCellFormat.setBorder(Border.RIGHT, boxStyle.rightBorder, boxStyle.rightBorderColour);
                }
            }
            catch (Exception exception) {
                throw new JRException("Error setting cellFormat-template.", exception);
            }
            this.loadedCellStyles.put(styleInfo, writableCellFormat);
        }
        return writableCellFormat;
    }

    public static BorderLineStyle getBorderLineStyle(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 > 0.0f) {
            switch (jRPen.getLineStyle()) {
                case 1: {
                    return BorderLineStyle.DASHED;
                }
            }
            if (f2 >= 2.0f) {
                return BorderLineStyle.THICK;
            }
            if (f2 >= 1.0f) {
                return BorderLineStyle.MEDIUM;
            }
            if (f2 >= 0.5f) {
                return BorderLineStyle.THIN;
            }
            return BorderLineStyle.HAIR;
        }
        return BorderLineStyle.NONE;
    }

    private final void setSheetSettings(WritableSheet writableSheet) {
        PageOrientation pageOrientation = this.jasperPrint.getOrientation() == 1 ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize paperSize = this.getSuitablePaperSize(this.jasperPrint);
        if (paperSize != null) {
            writableSheet.setPageSetup(pageOrientation, paperSize, 0.0, 0.0);
        } else {
            writableSheet.setPageSetup(pageOrientation);
        }
        SheetSettings sheetSettings = writableSheet.getSettings();
        sheetSettings.setTopMargin(0.0);
        sheetSettings.setLeftMargin(0.0);
        sheetSettings.setRightMargin(0.0);
        sheetSettings.setBottomMargin(0.0);
        sheetSettings.setHeaderMargin(0.0);
        sheetSettings.setFooterMargin(0.0);
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasperPrint) {
        if (jasperPrint == null) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        PaperSize paperSize = null;
        if (jasperPrint.getPageWidth() != 0 && jasperPrint.getPageHeight() != 0) {
            double d2 = (double)jasperPrint.getPageWidth() / 72.0;
            double d3 = (double)jasperPrint.getPageHeight() / 72.0;
            l3 = Math.round(d3 * 25.4);
            l2 = Math.round(d2 * 25.4);
            for (int i2 = 3; i2 < 6; ++i2) {
                int n2 = this.calculateWidthForDinAN(i2);
                int n3 = this.calculateHeightForDinAN(i2);
                if (((long)n2 != l2 || (long)n3 != l3) && ((long)n3 != l2 || (long)n2 != l3)) continue;
                if (i2 == 3) {
                    paperSize = PaperSize.A3;
                    break;
                }
                if (i2 == 4) {
                    paperSize = PaperSize.A4;
                    break;
                }
                if (i2 != 5) break;
                paperSize = PaperSize.A5;
                break;
            }
            if (paperSize == null) {
                if (l2 == 216L && l3 == 279L || l2 == 279L && l3 == 216L) {
                    paperSize = PaperSize.LETTER;
                }
                if (l2 == 216L && l3 == 356L || l2 == 356L && l3 == 216L) {
                    paperSize = PaperSize.LEGAL;
                }
            }
        }
        return paperSize;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText jRPrintText) {
        short s2;
        short s3;
        short s4 = jRPrintText.getRotation();
        block0 : switch (jRPrintText.getRotation()) {
            case 1: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s3 = 3;
                        break;
                    }
                    case 2: {
                        s3 = 2;
                        break;
                    }
                    case 3: {
                        s3 = 1;
                        break;
                    }
                    case 4: {
                        s3 = 4;
                        break;
                    }
                    default: {
                        s3 = 3;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s2 = 1;
                        break block0;
                    }
                    case 2: {
                        s2 = 2;
                        break block0;
                    }
                    case 3: {
                        s2 = 3;
                        break block0;
                    }
                }
                s2 = 1;
                break;
            }
            case 2: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s3 = 1;
                        break;
                    }
                    case 2: {
                        s3 = 2;
                        break;
                    }
                    case 3: {
                        s3 = 3;
                        break;
                    }
                    case 4: {
                        s3 = 4;
                        break;
                    }
                    default: {
                        s3 = 1;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s2 = 3;
                        break block0;
                    }
                    case 2: {
                        s2 = 2;
                        break block0;
                    }
                    case 3: {
                        s2 = 1;
                        break block0;
                    }
                }
                s2 = 3;
                break;
            }
            default: {
                s2 = jRPrintText.getHorizontalAlignment();
                s3 = jRPrintText.getVerticalAlignment();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(s2, s3, s4);
    }

    private final int calculateWidthForDinAN(int n2) {
        return (int)(Math.pow(2.0, -0.25 - (double)n2 / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinAN(int n2) {
        return (int)(Math.pow(2.0, 0.25 - (double)n2 / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinBN(int n2) {
        return (int)(Math.pow(2.0, -((double)n2 / 2.0)) * 1000.0);
    }

    private final int calculateHeightForDinBN(int n2) {
        return (int)(Math.pow(2.0, 0.5 - (double)n2 / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinCN(int n2) {
        return (int)(Math.pow(2.0, -0.125 - (double)n2 / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinCN(int n2) {
        return (int)(Math.pow(2.0, 0.375 - (double)n2 / 2.0) * 1000.0);
    }

    public void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n2, n3);
        Colour colour = this.getWorkbookColour(jRPrintFrame.getForecolor());
        Colour colour2 = WHITE;
        Pattern pattern = this.backgroundMode;
        if (jRPrintFrame.getMode() == 1) {
            pattern = Pattern.SOLID;
            colour2 = this.getWorkbookColour(jRPrintFrame.getBackcolor());
        }
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, writableFont, jRExporterGridCell);
        Blank blank = new Blank(n2, n3, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (JXLException jXLException) {
            throw new JRException("Can't add cell.", jXLException);
        }
    }

    private String getConvertedPattern(String string) {
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(string)) {
            return (String)this.formatPatternsMap.get(string);
        }
        return string;
    }

    public ExporterNature getNature() {
        return this.nature;
    }

    public static int getBorderCorrection(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 > 0.0f) {
            switch (jRPen.getLineStyle()) {
                case 1: {
                    return 1;
                }
            }
            if (f2 >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class StyleInfo {
        public final Pattern mode;
        public final Colour backcolor;
        public final int horizontalAlignment;
        public final int verticalAlignment;
        public final int rotation;
        public final WritableFont font;
        public final BoxStyle box;
        private DisplayFormat displayFormat;
        private int hashCode;
        private final JExcelApiExporter this$0;

        public StyleInfo(JExcelApiExporter jExcelApiExporter, Pattern pattern, Colour colour, int n2, int n3, int n4, WritableFont writableFont, JRExporterGridCell jRExporterGridCell) {
            JRPrintElement jRPrintElement;
            this.this$0 = jExcelApiExporter;
            this.box = new BoxStyle(this.this$0);
            this.mode = pattern;
            this.backcolor = colour;
            this.horizontalAlignment = n2;
            this.verticalAlignment = n3;
            this.rotation = n4;
            this.font = writableFont;
            JRLineBox jRLineBox = jRExporterGridCell.getBox();
            if (jRLineBox != null) {
                this.box.setBox(jRLineBox);
            }
            if ((jRPrintElement = jRExporterGridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.box.setPen(((JRCommonGraphicElement)((Object)jRPrintElement)).getLinePen());
            }
            this.computeHash();
        }

        public void computeHash() {
            int n2 = this.mode.hashCode();
            n2 = 31 * n2 + this.backcolor.hashCode();
            n2 = 31 * n2 + this.horizontalAlignment;
            n2 = 31 * n2 + this.verticalAlignment;
            n2 = 31 * n2 + this.rotation;
            n2 = 31 * n2 + this.font.hashCode();
            n2 = 31 * n2 + (this.box == null ? 0 : this.box.hashCode());
            this.hashCode = n2 = 31 * n2 + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            StyleInfo styleInfo = (StyleInfo)object;
            return styleInfo.mode.equals(this.mode) && styleInfo.backcolor.equals(this.backcolor) && styleInfo.horizontalAlignment == this.horizontalAlignment && styleInfo.verticalAlignment == this.verticalAlignment && styleInfo.rotation == this.rotation && styleInfo.font.equals((Object)this.font) && (styleInfo.box == null ? this.box == null : this.box != null && styleInfo.box.equals(this.box)) && (styleInfo.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && styleInfo.displayFormat.equals(this.displayFormat));
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + ")";
        }
    }

    protected class BoxStyle {
        public BorderLineStyle topBorder;
        public BorderLineStyle bottomBorder;
        public BorderLineStyle leftBorder;
        public BorderLineStyle rightBorder;
        public Colour topBorderColour;
        public Colour bottomBorderColour;
        public Colour leftBorderColour;
        public Colour rightBorderColour;
        private int hash;
        private final JExcelApiExporter this$0;

        public BoxStyle(JExcelApiExporter jExcelApiExporter) {
            this.this$0 = jExcelApiExporter;
            this.topBorder = BorderLineStyle.NONE;
            this.bottomBorder = BorderLineStyle.NONE;
            this.leftBorder = BorderLineStyle.NONE;
            this.rightBorder = BorderLineStyle.NONE;
            this.topBorderColour = BLACK;
            this.bottomBorderColour = BLACK;
            this.leftBorderColour = BLACK;
            this.rightBorderColour = BLACK;
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox jRLineBox) {
            this.topBorder = JExcelApiExporter.getBorderLineStyle(jRLineBox.getTopPen());
            this.topBorderColour = this.this$0.getWorkbookColour(jRLineBox.getTopPen().getLineColor());
            this.bottomBorder = JExcelApiExporter.getBorderLineStyle(jRLineBox.getBottomPen());
            this.bottomBorderColour = this.this$0.getWorkbookColour(jRLineBox.getBottomPen().getLineColor());
            this.leftBorder = JExcelApiExporter.getBorderLineStyle(jRLineBox.getLeftPen());
            this.leftBorderColour = this.this$0.getWorkbookColour(jRLineBox.getLeftPen().getLineColor());
            this.rightBorder = JExcelApiExporter.getBorderLineStyle(jRLineBox.getRightPen());
            this.rightBorderColour = this.this$0.getWorkbookColour(jRLineBox.getRightPen().getLineColor());
            this.hash = this.computeHash();
        }

        public void setPen(JRPen jRPen) {
            if (this.topBorder == BorderLineStyle.NONE && this.leftBorder == BorderLineStyle.NONE && this.bottomBorder == BorderLineStyle.NONE && this.rightBorder == BorderLineStyle.NONE) {
                this.topBorder = JExcelApiExporter.getBorderLineStyle(jRPen);
                this.topBorderColour = this.this$0.getWorkbookColour(jRPen.getLineColor());
                this.bottomBorder = this.topBorder;
                this.bottomBorderColour = this.topBorderColour;
                this.leftBorder = this.topBorder;
                this.leftBorderColour = this.topBorderColour;
                this.rightBorder = this.topBorder;
                this.rightBorderColour = this.topBorderColour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int n2 = this.topBorder.hashCode();
            n2 = 31 * n2 + this.topBorderColour.hashCode();
            n2 = 31 * n2 + this.bottomBorder.hashCode();
            n2 = 31 * n2 + this.bottomBorderColour.hashCode();
            n2 = 31 * n2 + this.leftBorder.hashCode();
            n2 = 31 * n2 + this.leftBorderColour.hashCode();
            n2 = 31 * n2 + this.rightBorder.hashCode();
            n2 = 31 * n2 + this.rightBorderColour.hashCode();
            return n2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            BoxStyle boxStyle = (BoxStyle)object;
            return boxStyle.topBorder.equals(this.topBorder) && boxStyle.topBorderColour.equals(this.topBorderColour) && boxStyle.leftBorder.equals(this.leftBorder) && boxStyle.leftBorderColour.equals(this.leftBorderColour) && boxStyle.bottomBorder.equals(this.bottomBorder) && boxStyle.bottomBorderColour.equals(this.bottomBorderColour) && boxStyle.rightBorder.equals(this.rightBorder) && boxStyle.rightBorderColour.equals(this.rightBorderColour);
        }

        public String toString() {
            return "(" + this.topBorder.getValue() + "/" + this.topBorderColour.getValue() + "," + this.bottomBorder.getValue() + "/" + this.bottomBorderColour.getValue() + "," + this.leftBorder.getValue() + "/" + this.leftBorderColour.getValue() + "," + this.rightBorder.getValue() + "/" + this.rightBorderColour.getValue() + ")";
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final StyleInfo baseStyle;
        private CellValue result;
        private final JExcelApiExporter this$0;

        public CellTextValueHandler(JExcelApiExporter jExcelApiExporter, int n2, int n3, StyleInfo styleInfo) {
            this.this$0 = jExcelApiExporter;
            this.x = n2;
            this.y = n3;
            this.baseStyle = styleInfo;
        }

        public void handle(StringTextValue stringTextValue) throws JRException {
            WritableCellFormat writableCellFormat = this.this$0.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, stringTextValue.getText(), (CellFormat)writableCellFormat);
        }

        public void handle(NumberTextValue numberTextValue) throws JRException {
            if (numberTextValue.getPattern() != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)this.this$0.getNumberFormat(numberTextValue.getPattern()));
            }
            WritableCellFormat writableCellFormat = this.this$0.getLoadedCellStyle(this.baseStyle);
            this.result = numberTextValue.getValue() == null ? this.blank(writableCellFormat) : new Number(this.x, this.y, numberTextValue.getValue().doubleValue(), (CellFormat)writableCellFormat);
        }

        public void handle(DateTextValue dateTextValue) throws JRException {
            this.baseStyle.setDisplayFormat((DisplayFormat)this.this$0.getDateFormat(dateTextValue.getPattern()));
            WritableCellFormat writableCellFormat = this.this$0.getLoadedCellStyle(this.baseStyle);
            this.result = dateTextValue.getValue() == null ? this.blank(writableCellFormat) : new DateTime(this.x, this.y, dateTextValue.getValue(), (CellFormat)writableCellFormat);
        }

        public void handle(BooleanTextValue booleanTextValue) throws JRException {
            WritableCellFormat writableCellFormat = this.this$0.getLoadedCellStyle(this.baseStyle);
            this.result = booleanTextValue.getValue() == null ? this.blank(writableCellFormat) : new Boolean(this.x, this.y, booleanTextValue.getValue().booleanValue(), (CellFormat)writableCellFormat);
        }

        public Blank blank(WritableCellFormat writableCellFormat) {
            return new Blank(this.x, this.y, (CellFormat)writableCellFormat);
        }

        public CellValue getResult() {
            return this.result;
        }
    }
}

