/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRVerifier {
    private static String[] textFieldClassNames = null;
    private static String[] imageClassNames = null;
    private static String[] subreportClassNames = null;
    private static Class[] templateTypes = new Class[]{g == null ? (g = JRVerifier.a("java.lang.String")) : g, z == null ? (z = JRVerifier.a("java.io.File")) : z, n == null ? (n = JRVerifier.a("java.net.URL")) : n, q == null ? (q = JRVerifier.a("java.io.InputStream")) : q, p == null ? (p = JRVerifier.a("net.sf.jasperreports.engine.JRTemplate")) : p};
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    private JRExpressionCollector expressionCollector;
    public static Class g;
    public static Class z;
    public static Class n;
    public static Class q;
    public static Class p;
    public static Class v;
    public static Class A;
    public static Class w;
    public static Class B;
    public static Class c;
    public static Class o;
    public static Class i;
    public static Class j;
    public static Class k;
    public static Class r;
    public static Class d;
    public static Class s;
    public static Class l;
    public static Class t;
    public static Class e;
    public static Class x;
    public static Class m;
    public static Class y;
    public static Class h;
    public static Class u;
    public static Class f;
    public static Class b;
    public static Class a;

    public JRVerifier(JasperDesign jasperDesign) {
        this(jasperDesign, null);
    }

    public JRVerifier(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) {
        this.jasperDesign = jasperDesign;
        this.brokenRules = new ArrayList();
        this.expressionCollector = jRExpressionCollector != null ? jRExpressionCollector : JRExpressionCollector.collector(this.jasperDesign);
    }

    public void addBrokenRule(String string, Object object) {
        JRValidationFault jRValidationFault = new JRValidationFault();
        jRValidationFault.setMessage(string);
        jRValidationFault.setSource(object);
        this.brokenRules.add(jRValidationFault);
    }

    public void addBrokenRule(Exception exception, Object object) {
        JRValidationFault jRValidationFault = new JRValidationFault();
        jRValidationFault.setMessage(exception.getMessage());
        jRValidationFault.setSource(object);
        this.brokenRules.add(jRValidationFault);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) {
        JRVerifier jRVerifier = new JRVerifier(jasperDesign, jRExpressionCollector);
        return jRVerifier.verifyDesign();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign, null);
    }

    public Collection verifyDesign() {
        this.jasperDesign.preprocess();
        this.verifyDesignAttributes();
        this.verifyReportTemplates();
        this.verifyReportFonts();
        this.verifyDataset(this.jasperDesign.getMainDesignDataset());
        this.verifyDatasets();
        this.verifyStyles();
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifyBand(this.jasperDesign.getDetail());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        this.verifyBand(this.jasperDesign.getNoData());
        return this.brokenRules;
    }

    private void verifyDesignAttributes() {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.addBrokenRule("Report name is missing.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.addBrokenRule("Column count must be greater than zero.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.addBrokenRule("Page width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.addBrokenRule("Page height must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.addBrokenRule("Column width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.addBrokenRule("Column spacing must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.addBrokenRule("Left margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.addBrokenRule("Right margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.addBrokenRule("Top margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.addBrokenRule("Bottom margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.addBrokenRule("The columns and the margins do not fit the page width.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getBackground() != null ? this.jasperDesign.getBackground().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The background section and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.addBrokenRule("The title section and the margins do not fit the page height.", (Object)this.jasperDesign);
            }
        } else if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The title section, the page and column headers and footers and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The page and column headers and footers and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getLastPageFooter() != null ? this.jasperDesign.getLastPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The page and column headers and footers and the margins do not fit the last page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getSummary() != null ? this.jasperDesign.getSummary().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The summary section and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getDetail() != null ? this.jasperDesign.getDetail().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The detail section, the page and column headers and footers and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getNoData() != null ? this.jasperDesign.getNoData().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.addBrokenRule("The noData section and the margins do not fit the page height.", (Object)this.jasperDesign);
        }
        this.verifyFormatFactoryClass();
    }

    public void verifyFormatFactoryClass() {
        String string = this.jasperDesign.getFormatFactoryClass();
        if (string != null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(string);
                if (!(v == null ? (v = JRVerifier.a("net.sf.jasperreports.engine.util.FormatFactory")) : v).isAssignableFrom(clazz)) {
                    this.addBrokenRule("The report format factory class is not compatible with " + (v == null ? (v = JRVerifier.a("net.sf.jasperreports.engine.util.FormatFactory")) : v).getName(), (Object)this.jasperDesign);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.addBrokenRule(classNotFoundException.toString(), (Object)this.jasperDesign);
            }
        }
    }

    private void verifyQuery(JRDesignDataset jRDesignDataset) {
        JRQuery jRQuery = jRDesignDataset.getQuery();
        if (jRQuery != null) {
            String string = jRQuery.getLanguage();
            JRQueryExecuterFactory jRQueryExecuterFactory = null;
            if (string == null || string.length() == 0) {
                this.addBrokenRule("Query language not set.", (Object)jRQuery);
            } else {
                try {
                    jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(jRQuery.getLanguage());
                }
                catch (JRException jRException) {
                    this.addBrokenRule("Query executer factory for " + string + " cannot be created.", (Object)jRQuery);
                }
            }
            JRQueryChunk[] jRQueryChunkArray = jRQuery.getChunks();
            if (jRQueryChunkArray != null && jRQueryChunkArray.length > 0) {
                Map map = jRDesignDataset.getParametersMap();
                block8: for (int i2 = 0; i2 < jRQueryChunkArray.length; ++i2) {
                    JRQueryChunk jRQueryChunk = jRQueryChunkArray[i2];
                    switch (jRQueryChunk.getType()) {
                        case 2: {
                            JRParameter jRParameter = (JRParameter)map.get(jRQueryChunk.getText());
                            if (jRParameter == null) {
                                this.addBrokenRule("Query parameter not found : " + jRQueryChunk.getText(), (Object)jRQuery);
                                continue block8;
                            }
                            if (jRQueryExecuterFactory == null) continue block8;
                            String string2 = null;
                            try {
                                string2 = jRParameter.getValueClassName();
                            }
                            catch (JRRuntimeException jRRuntimeException) {
                                // empty catch block
                            }
                            if (string2 == null || jRQueryExecuterFactory.supportsQueryParameterType(string2)) continue block8;
                            this.addBrokenRule("Parameter type not supported in query : " + jRQueryChunk.getText() + " class " + string2, (Object)jRQuery);
                            continue block8;
                        }
                        case 3: {
                            if (map.containsKey(jRQueryChunk.getText())) continue block8;
                            this.addBrokenRule("Query parameter not found : " + jRQueryChunk.getText(), (Object)jRQuery);
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(List list, Map map, Map map2, Map map3) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRExpression jRExpression = (JRExpression)iterator.next();
                JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
                if (jRExpressionChunkArray == null || jRExpressionChunkArray.length <= 0) continue;
                block6: for (int i2 = 0; i2 < jRExpressionChunkArray.length; ++i2) {
                    JRExpressionChunk jRExpressionChunk = jRExpressionChunkArray[i2];
                    switch (jRExpressionChunk.getType()) {
                        case 4: {
                            if (map3.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.addBrokenRule("Variable not found : " + jRExpressionChunk.getText(), (Object)jRExpression);
                            continue block6;
                        }
                        case 3: {
                            if (map2.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.addBrokenRule("Field not found : " + jRExpressionChunk.getText(), (Object)jRExpression);
                            continue block6;
                        }
                        case 2: {
                            if (map.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.addBrokenRule("Parameter not found : " + jRExpressionChunk.getText(), (Object)jRExpression);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(JRDesignDataset jRDesignDataset) {
        this.verifyExpressions(this.expressionCollector.getExpressions(jRDesignDataset), jRDesignDataset.getParametersMap(), jRDesignDataset.getFieldsMap(), jRDesignDataset.getVariablesMap());
    }

    private void verifyReportFonts() {
        JRReportFont[] jRReportFontArray = this.jasperDesign.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            for (int i2 = 0; i2 < jRReportFontArray.length; ++i2) {
                JRReportFont jRReportFont = jRReportFontArray[i2];
                if (jRReportFont.getName() != null && jRReportFont.getName().trim().length() != 0) continue;
                this.addBrokenRule("Report font name missing.", (Object)jRReportFont);
            }
        }
    }

    public void verifyReportTemplates() {
        JRReportTemplate[] jRReportTemplateArray = this.jasperDesign.getTemplates();
        if (jRReportTemplateArray != null) {
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                JRReportTemplate jRReportTemplate = jRReportTemplateArray[i2];
                this.verifyTemplate(jRReportTemplate);
            }
        }
    }

    public void verifyTemplate(JRReportTemplate jRReportTemplate) {
        JRExpression jRExpression = jRReportTemplate.getSourceExpression();
        if (jRExpression == null) {
            this.addBrokenRule("Template source expression missing.", (Object)jRReportTemplate);
        } else {
            try {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Template source expression value class not set.", (Object)jRExpression);
                } else if (!this.verifyTemplateSourceType(clazz)) {
                    this.addBrokenRule("Template source expression value class " + clazz.getName() + "not supported.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    public boolean verifyTemplateSourceType(Class clazz) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < templateTypes.length; ++i2) {
            Class clazz2 = templateTypes[i2];
            if (!clazz2.isAssignableFrom(clazz)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private void verifyStyles() {
        JRStyle[] jRStyleArray = this.jasperDesign.getStyles();
        if (jRStyleArray != null && jRStyleArray.length > 0) {
            for (int i2 = 0; i2 < jRStyleArray.length; ++i2) {
                JRStyle jRStyle = jRStyleArray[i2];
                if (jRStyle.getName() != null && jRStyle.getName().trim().length() != 0) continue;
                this.addBrokenRule("Report style name missing.", (Object)jRStyle);
            }
        }
    }

    private void verifyParameters(JRDesignDataset jRDesignDataset) {
        JRParameter[] jRParameterArray = jRDesignDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRParameterArray.length; ++i2) {
                JRParameter jRParameter;
                JRPropertiesHolder jRPropertiesHolder = jRParameter = jRParameterArray[i2];
                if (jRParameter.isSystemDefined()) {
                    jRPropertiesHolder = this.jasperDesign;
                }
                if (jRParameter.getName() == null || jRParameter.getName().trim().length() == 0) {
                    this.addBrokenRule("Parameter name missing.", (Object)jRPropertiesHolder);
                }
                if (jRParameter.getValueClassName() == null) {
                    this.addBrokenRule("Class not set for parameter : " + jRParameter.getName(), (Object)jRPropertiesHolder);
                    continue;
                }
                try {
                    Class clazz = jRParameter.getValueClass();
                    JRExpression jRExpression = jRParameter.getDefaultValueExpression();
                    if (jRExpression == null) continue;
                    try {
                        if (jRExpression.getValueClass() == null) {
                            this.addBrokenRule("No value class defined for the expression in parameter: " + jRParameter.getName(), (Object)jRExpression);
                            continue;
                        }
                        if (clazz.isAssignableFrom(jRExpression.getValueClass())) continue;
                        this.addBrokenRule("The parameter default value expression class is not compatible with the parameter's class : " + jRParameter.getName(), (Object)jRExpression);
                    }
                    catch (JRRuntimeException jRRuntimeException) {
                        this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                    }
                    continue;
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRPropertiesHolder);
                }
            }
        }
    }

    private void verifyFields(JRDesignDataset jRDesignDataset) {
        JRField[] jRFieldArray = jRDesignDataset.getFields();
        if (jRFieldArray != null && jRFieldArray.length > 0) {
            for (int i2 = 0; i2 < jRFieldArray.length; ++i2) {
                JRField jRField = jRFieldArray[i2];
                if (jRField.getName() == null || jRField.getName().trim().length() == 0) {
                    this.addBrokenRule("Field name missing.", (Object)jRField);
                }
                try {
                    Class clazz = jRField.getValueClass();
                    if (clazz != null) continue;
                    this.addBrokenRule("Class not set for field : " + jRField.getName(), (Object)jRField);
                    continue;
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRField);
                }
            }
        }
    }

    private void verifySortFields(JRDesignDataset jRDesignDataset) {
        JRField[] jRFieldArray = jRDesignDataset.getFields();
        JRSortField[] jRSortFieldArray = jRDesignDataset.getSortFields();
        if (jRSortFieldArray != null && jRSortFieldArray.length > 0) {
            for (int i2 = 0; i2 < jRSortFieldArray.length; ++i2) {
                JRSortField jRSortField = jRSortFieldArray[i2];
                String string = jRSortField.getName();
                if (string == null || string.trim().length() == 0) {
                    this.addBrokenRule("Sort field name missing.", (Object)jRSortField);
                    continue;
                }
                boolean bl2 = false;
                for (int i3 = 0; !bl2 && i3 < jRFieldArray.length; ++i3) {
                    bl2 = string.equals(jRFieldArray[i3].getName());
                }
                if (bl2) continue;
                this.addBrokenRule("Sort field \"" + string + "\" not declared.", (Object)jRSortField);
            }
        }
    }

    private void verifyVariables(JRDesignDataset jRDesignDataset) throws JRRuntimeException {
        JRVariable[] jRVariableArray = jRDesignDataset.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            boolean bl2 = jRDesignDataset.isMainDataset();
            for (int i2 = 0; i2 < jRVariableArray.length; ++i2) {
                byte by2;
                Object object;
                JRVariable jRVariable;
                block24: {
                    jRVariable = jRVariableArray[i2];
                    if (jRVariable.getName() == null || jRVariable.getName().trim().length() == 0) {
                        this.addBrokenRule("Variable name missing.", (Object)jRVariable);
                    }
                    try {
                        Class clazz = jRVariable.getValueClass();
                        if (clazz == null) {
                            this.addBrokenRule("Class not set for variable : " + jRVariable.getName(), (Object)jRVariable);
                            break block24;
                        }
                        object = jRVariable.getExpression();
                        if (object != null) {
                            try {
                                if (object.getValueClass() == null) {
                                    this.addBrokenRule("No value class for the expression has been set in variable: " + jRVariable.getName(), object);
                                } else if (jRVariable.getCalculation() != 1 && jRVariable.getCalculation() != 10 && jRVariable.getCalculation() != 8 && !clazz.isAssignableFrom(object.getValueClass())) {
                                    this.addBrokenRule("The variable expression class is not compatible with the variable's class : " + jRVariable.getName(), object);
                                }
                            }
                            catch (JRRuntimeException jRRuntimeException) {
                                this.addBrokenRule(jRRuntimeException, object);
                            }
                        }
                        if (jRVariable.getInitialValueExpression() == null) break block24;
                        try {
                            if (!clazz.isAssignableFrom(jRVariable.getInitialValueExpression().getValueClass())) {
                                this.addBrokenRule("The initial value class is not compatible with the variable's class : " + jRVariable.getName(), (Object)jRVariable.getInitialValueExpression());
                            }
                        }
                        catch (JRRuntimeException jRRuntimeException) {
                            this.addBrokenRule(jRRuntimeException, (Object)jRVariable.getInitialValueExpression());
                        }
                    }
                    catch (JRRuntimeException jRRuntimeException) {
                        this.addBrokenRule(jRRuntimeException, (Object)jRVariable);
                    }
                }
                byte by3 = jRVariable.getResetType();
                if (by3 == 4) {
                    if (jRVariable.getResetGroup() == null) {
                        this.addBrokenRule("Reset group missing for variable : " + jRVariable.getName(), (Object)jRVariable);
                    } else {
                        object = jRDesignDataset.getGroupsMap();
                        if (!object.containsKey(jRVariable.getResetGroup().getName())) {
                            this.addBrokenRule("Reset group \"" + jRVariable.getResetGroup().getName() + "\" not found for variable : " + jRVariable.getName(), (Object)jRVariable);
                        }
                    }
                }
                if ((by2 = jRVariable.getIncrementType()) == 4) {
                    if (jRVariable.getIncrementGroup() == null) {
                        this.addBrokenRule("Increment group missing for variable : " + jRVariable.getName(), (Object)jRVariable);
                    } else {
                        Map map = jRDesignDataset.getGroupsMap();
                        if (!map.containsKey(jRVariable.getIncrementGroup().getName())) {
                            this.addBrokenRule("Increment group \"" + jRVariable.getIncrementGroup().getName() + "\" not found for variable : " + jRVariable.getName(), (Object)jRVariable);
                        }
                    }
                }
                if (bl2) continue;
                if (by3 == 3 || by3 == 2) {
                    this.addBrokenRule("Variable " + jRVariable.getName() + " of dataset " + jRDesignDataset.getName() + " cannot have Column or Page reset type.", (Object)jRVariable);
                }
                if (by2 != 3 && by2 != 2) continue;
                this.addBrokenRule("Variable " + jRVariable.getName() + " of dataset " + jRDesignDataset.getName() + " cannot have Column or Page increment type.", (Object)jRVariable);
            }
        }
    }

    private void verifyGroups(JRDesignDataset jRDesignDataset) {
        JRGroup[] jRGroupArray = jRDesignDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            boolean bl2 = jRDesignDataset.isMainDataset();
            for (int i2 = 0; i2 < jRGroupArray.length; ++i2) {
                JRGroup jRGroup = jRGroupArray[i2];
                if (jRGroup.getName() == null || jRGroup.getName().trim().length() == 0) {
                    this.addBrokenRule("Group name missing.", (Object)jRGroup);
                }
                if (bl2) {
                    this.verifyGroupHeaderAndFooter(jRGroup);
                } else if (jRGroup.getGroupHeader() != null || jRGroup.getGroupFooter() != null) {
                    this.addBrokenRule("Group " + jRGroup.getName() + " cannot have header or footer sections.", (Object)jRGroup);
                }
                JRExpression jRExpression = jRGroup.getExpression();
                if (jRExpression != null) {
                    try {
                        Class clazz = jRExpression.getValueClass();
                        if (clazz == null) {
                            this.addBrokenRule("Class not set for group expression : " + jRGroup.getName(), (Object)jRExpression);
                        }
                    }
                    catch (JRRuntimeException jRRuntimeException) {
                        this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                    }
                }
                if (!bl2) continue;
                this.verifyBand(jRGroup.getGroupHeader());
                this.verifyBand(jRGroup.getGroupFooter());
            }
        }
    }

    private void verifyGroupHeaderAndFooter(JRGroup jRGroup) {
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.addBrokenRule("The '" + jRGroup.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.", (Object)jRGroup.getGroupHeader());
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.addBrokenRule("The '" + jRGroup.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.", (Object)jRGroup.getGroupFooter());
            }
        } else {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.addBrokenRule("The '" + jRGroup.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)jRGroup.getGroupHeader());
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.addBrokenRule("The '" + jRGroup.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)jRGroup.getGroupFooter());
            }
        }
    }

    private void verifyBand(JRBand jRBand) {
        JRElement[] jRElementArray;
        if (jRBand != null && (jRElementArray = jRBand.getElements()) != null && jRElementArray.length > 0) {
            JRExpression jRExpression = jRBand.getPrintWhenExpression();
            if (jRExpression != null) {
                try {
                    Class clazz = jRExpression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for band \"print when\" expression.", (Object)jRExpression);
                    } else if (!(A == null ? (A = JRVerifier.a("java.lang.Boolean")) : A).isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                JRElement jRElement = jRElementArray[i2];
                this.verifyPrintWhenExpr(jRElement);
                if (jRElement.getY() + jRElement.getHeight() > jRBand.getHeight()) {
                    this.addBrokenRule("Warning : Element bottom reaches outside band area : y=" + jRElement.getY() + " height=" + jRElement.getHeight() + " band-height=" + jRBand.getHeight(), (Object)jRElement);
                }
                this.verifyElement(jRElement);
            }
        }
    }

    public void verifyElement(JRElement jRElement) {
        if (jRElement instanceof JRStaticText) {
            this.verifyStaticText((JRStaticText)jRElement);
        } else if (jRElement instanceof JRTextField) {
            this.verifyTextField((JRTextField)jRElement);
        } else if (jRElement instanceof JRImage) {
            this.verifyImage((JRImage)jRElement);
        } else if (jRElement instanceof JRSubreport) {
            this.verifySubreport((JRSubreport)jRElement);
        } else if (jRElement instanceof JRCrosstab) {
            this.verifyCrosstab((JRDesignCrosstab)jRElement);
        } else if (jRElement instanceof JRChart) {
            this.verifyChart((JRChart)jRElement);
        } else if (jRElement instanceof JRFrame) {
            this.verifyFrame((JRFrame)jRElement);
        }
    }

    private void verifyPrintWhenExpr(JRElement jRElement) {
        JRExpression jRExpression = jRElement.getPrintWhenExpression();
        if (jRExpression != null) {
            try {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for element \"print when\" expression.", (Object)jRExpression);
                } else if (!(A == null ? (A = JRVerifier.a("java.lang.Boolean")) : A).isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifyStaticText(JRStaticText jRStaticText) {
        this.verifyFont(jRStaticText);
    }

    private void verifyTextField(JRTextField jRTextField) {
        JRExpression jRExpression;
        this.verifyFont(jRTextField);
        this.verifyAnchor(jRTextField);
        this.verifyHyperlink(jRTextField);
        if (jRTextField != null && (jRExpression = jRTextField.getExpression()) != null) {
            try {
                String string = jRExpression.getValueClassName();
                if (string == null) {
                    this.addBrokenRule("Class not set for text field expression.", (Object)jRExpression);
                } else if (Arrays.binarySearch(JRVerifier.getTextFieldClassNames(), string) < 0) {
                    this.addBrokenRule("Class \"" + string + "\" not supported for text field expression.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifyFont(JRFont jRFont) {
        Map map;
        JRReportFont jRReportFont = jRFont.getReportFont();
        if (jRReportFont != null && jRReportFont.getName() != null && !(map = this.jasperDesign.getFontsMap()).containsKey(jRReportFont.getName())) {
            this.addBrokenRule("Report font not found : " + jRReportFont.getName(), (Object)jRFont);
        }
    }

    private void verifyAnchor(JRAnchor jRAnchor) {
        if (jRAnchor != null) {
            JRExpression jRExpression = jRAnchor.getAnchorNameExpression();
            if (jRExpression != null) {
                try {
                    Class clazz = jRExpression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for anchor name expression.", (Object)jRExpression);
                    } else if (!(g == null ? (g = JRVerifier.a("java.lang.String")) : g).isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if (jRAnchor.getBookmarkLevel() != 0 && jRAnchor.getBookmarkLevel() < 1) {
                this.addBrokenRule("Bookmark level should be 0 or greater than 0", (Object)jRAnchor);
            }
        }
    }

    private void verifyHyperlink(JRHyperlink jRHyperlink) {
        if (jRHyperlink != null) {
            Object object;
            JRExpression jRExpression = jRHyperlink.getHyperlinkReferenceExpression();
            if (jRExpression != null) {
                try {
                    object = jRExpression.getValueClass();
                    if (object == null) {
                        this.addBrokenRule("Class not set for hyperlink reference expression.", (Object)jRExpression);
                    } else if (!(g == null ? (g = JRVerifier.a("java.lang.String")) : g).isAssignableFrom((Class<?>)object)) {
                        this.addBrokenRule("Class " + object + " not supported for hyperlink reference expression. Use java.lang.String instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRExpression = jRHyperlink.getHyperlinkAnchorExpression()) != null) {
                try {
                    object = jRExpression.getValueClass();
                    if (object == null) {
                        this.addBrokenRule("Class not set for hyperlink anchor expression.", (Object)jRExpression);
                    } else if (!(g == null ? (g = JRVerifier.a("java.lang.String")) : g).isAssignableFrom((Class<?>)object)) {
                        this.addBrokenRule("Class " + object + " not supported for hyperlink anchor expression. Use java.lang.String instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRExpression = jRHyperlink.getHyperlinkPageExpression()) != null) {
                try {
                    object = jRExpression.getValueClass();
                    if (object == null) {
                        this.addBrokenRule("Class not set for hyperlink page expression.", (Object)jRExpression);
                    } else if (!(w == null ? (w = JRVerifier.a("java.lang.Integer")) : w).isAssignableFrom((Class<?>)object)) {
                        this.addBrokenRule("Class " + object + " not supported for hyperlink page expression. Use java.lang.Integer instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRExpression = jRHyperlink.getHyperlinkTooltipExpression()) != null) {
                try {
                    object = jRExpression.getValueClass();
                    if (object == null) {
                        this.addBrokenRule("Class not set for hyperlink tooltip expression.", (Object)jRExpression);
                    } else if (!(g == null ? (g = JRVerifier.a("java.lang.String")) : g).isAssignableFrom((Class<?>)object)) {
                        this.addBrokenRule("Class " + object + " not supported for hyperlink tooltip expression. Use java.lang.String instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((object = jRHyperlink.getHyperlinkParameters()) != null) {
                for (int i2 = 0; i2 < ((JRHyperlinkParameter[])object).length; ++i2) {
                    JRHyperlinkParameter jRHyperlinkParameter = object[i2];
                    this.verifyHyperlinkParameter(jRHyperlinkParameter);
                }
            }
        }
    }

    public void verifyHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        String string;
        if (jRHyperlinkParameter != null && ((string = jRHyperlinkParameter.getName()) == null || string.length() == 0)) {
            this.addBrokenRule("Hyperlink parameter name missing.", (Object)jRHyperlinkParameter);
        }
    }

    private void verifyImage(JRImage jRImage) {
        JRExpression jRExpression;
        this.verifyAnchor(jRImage);
        this.verifyHyperlink(jRImage);
        if (jRImage != null && (jRExpression = jRImage.getExpression()) != null) {
            try {
                String string = jRExpression.getValueClassName();
                if (string == null) {
                    this.addBrokenRule("Class not set for image expression.", (Object)jRExpression);
                } else if (Arrays.binarySearch(JRVerifier.getImageClassNames(), string) < 0) {
                    this.addBrokenRule("Class \"" + string + "\" not supported for image expression.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifySubreport(JRSubreport jRSubreport) {
        if (jRSubreport != null) {
            JRSubreportReturnValue[] jRSubreportReturnValueArray;
            Object object;
            Object object2;
            JRExpression jRExpression = jRSubreport.getExpression();
            if (jRExpression != null) {
                try {
                    object2 = jRExpression.getValueClassName();
                    if (object2 == null) {
                        this.addBrokenRule("Class not set for subreport expression.", (Object)jRExpression);
                    } else if (Arrays.binarySearch(JRVerifier.getSubreportClassNames(), object2) < 0) {
                        this.addBrokenRule("Class \"" + (String)object2 + "\" not supported for subreport expression.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRExpression = jRSubreport.getParametersMapExpression()) != null) {
                try {
                    object2 = jRExpression.getValueClass();
                    if (object2 == null) {
                        this.addBrokenRule("Class not set for subreport parameters map expression.", (Object)jRExpression);
                    } else if (!(B == null ? (B = JRVerifier.a("java.util.Map")) : B).isAssignableFrom((Class<?>)object2)) {
                        this.addBrokenRule("Class " + object2 + " not supported for subreport parameters map expression. Use java.util.Map instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((object2 = jRSubreport.getParameters()) != null && ((JRSubreportParameter[])object2).length > 0) {
                for (int i2 = 0; i2 < ((JRSubreportParameter[])object2).length; ++i2) {
                    JRSubreportParameter jRSubreportParameter = object2[i2];
                    if (jRSubreportParameter.getName() == null || jRSubreportParameter.getName().trim().length() == 0) {
                        this.addBrokenRule("Subreport parameter name missing.", (Object)jRExpression);
                    }
                    if ((jRExpression = jRSubreportParameter.getExpression()) == null) continue;
                    try {
                        object = jRExpression.getValueClass();
                        if (object != null) continue;
                        this.addBrokenRule("Class not set for subreport parameter expression : " + jRSubreportParameter.getName() + ". Use java.lang.Object class.", (Object)jRExpression);
                        continue;
                    }
                    catch (JRRuntimeException jRRuntimeException) {
                        this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                    }
                }
            }
            if (jRSubreport.getConnectionExpression() != null && jRSubreport.getDataSourceExpression() != null) {
                this.addBrokenRule("Subreport cannot have both connection expresion and data source expression.", (Object)jRSubreport);
            }
            if ((jRExpression = jRSubreport.getConnectionExpression()) != null) {
                try {
                    Class clazz = jRExpression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for subreport connection expression.", (Object)jRExpression);
                    } else if (!(c == null ? (c = JRVerifier.a("java.sql.Connection")) : c).isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRExpression = jRSubreport.getDataSourceExpression()) != null) {
                try {
                    Class clazz = jRExpression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for subreport data source expression.", (Object)jRExpression);
                    } else if (!(o == null ? (o = JRVerifier.a("net.sf.jasperreports.engine.JRDataSource")) : o).isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for subreport data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            if ((jRSubreportReturnValueArray = jRSubreport.getReturnValues()) != null && jRSubreportReturnValueArray.length > 0) {
                for (int i3 = 0; i3 < jRSubreportReturnValueArray.length; ++i3) {
                    object = jRSubreportReturnValueArray[i3];
                    if (object.getSubreportVariable() == null || object.getSubreportVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value variable name missing.", object);
                    }
                    if (object.getToVariable() == null || object.getToVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value to variable name missing.", object);
                    }
                    if (this.jasperDesign.getVariablesMap().containsKey(object.getToVariable())) continue;
                    this.addBrokenRule("Subreport return value to variable not found.", object);
                }
            }
        }
    }

    private static synchronized String[] getTextFieldClassNames() {
        if (textFieldClassNames == null) {
            textFieldClassNames = new String[]{(A == null ? (A = JRVerifier.a("java.lang.Boolean")) : A).getName(), (i == null ? (i = JRVerifier.a("java.lang.Byte")) : i).getName(), (j == null ? (j = JRVerifier.a("java.util.Date")) : j).getName(), (k == null ? (k = JRVerifier.a("java.sql.Timestamp")) : k).getName(), (r == null ? (r = JRVerifier.a("java.sql.Time")) : r).getName(), (d == null ? (d = JRVerifier.a("java.lang.Double")) : d).getName(), (s == null ? (s = JRVerifier.a("java.lang.Float")) : s).getName(), (w == null ? (w = JRVerifier.a("java.lang.Integer")) : w).getName(), (l == null ? (l = JRVerifier.a("java.lang.Long")) : l).getName(), (t == null ? (t = JRVerifier.a("java.lang.Short")) : t).getName(), (e == null ? (e = JRVerifier.a("java.math.BigDecimal")) : e).getName(), (x == null ? (x = JRVerifier.a("java.lang.Number")) : x).getName(), (g == null ? (g = JRVerifier.a("java.lang.String")) : g).getName()};
            Arrays.sort(textFieldClassNames);
        }
        return textFieldClassNames;
    }

    private static synchronized String[] getImageClassNames() {
        if (imageClassNames == null) {
            imageClassNames = new String[]{(g == null ? (g = JRVerifier.a("java.lang.String")) : g).getName(), (z == null ? (z = JRVerifier.a("java.io.File")) : z).getName(), (n == null ? (n = JRVerifier.a("java.net.URL")) : n).getName(), (q == null ? (q = JRVerifier.a("java.io.InputStream")) : q).getName(), (m == null ? (m = JRVerifier.a("java.awt.Image")) : m).getName(), (y == null ? (y = JRVerifier.a("net.sf.jasperreports.engine.JRRenderable")) : y).getName()};
            Arrays.sort(imageClassNames);
        }
        return imageClassNames;
    }

    private static synchronized String[] getSubreportClassNames() {
        if (subreportClassNames == null) {
            subreportClassNames = new String[]{(g == null ? (g = JRVerifier.a("java.lang.String")) : g).getName(), (z == null ? (z = JRVerifier.a("java.io.File")) : z).getName(), (n == null ? (n = JRVerifier.a("java.net.URL")) : n).getName(), (q == null ? (q = JRVerifier.a("java.io.InputStream")) : q).getName(), (h == null ? (h = JRVerifier.a("net.sf.jasperreports.engine.JasperReport")) : h).getName()};
            Arrays.sort(subreportClassNames);
        }
        return subreportClassNames;
    }

    private void verifyCrosstab(JRDesignCrosstab jRDesignCrosstab) {
        this.verifyParameters(jRDesignCrosstab);
        JRCrosstabDataset jRCrosstabDataset = jRDesignCrosstab.getDataset();
        if (jRCrosstabDataset == null) {
            this.addBrokenRule("Crosstab dataset missing.", (Object)jRDesignCrosstab);
        } else {
            this.verifyElementDataset(jRCrosstabDataset);
        }
        this.verifyCellContents(jRDesignCrosstab.getHeaderCell(), "crosstab cell");
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRDesignCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray == null || jRCrosstabRowGroupArray.length == 0) {
            this.addBrokenRule("Crosstab should have at least one row group.", (Object)jRDesignCrosstab);
        } else {
            for (int i2 = 0; i2 < jRCrosstabRowGroupArray.length; ++i2) {
                this.verifyCrosstabRowGroup(jRCrosstabRowGroupArray[i2]);
            }
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRDesignCrosstab.getColumnGroups();
        if (jRCrosstabColumnGroupArray == null || jRCrosstabColumnGroupArray.length == 0) {
            this.addBrokenRule("Crosstab should have at least one column group.", (Object)jRDesignCrosstab);
        } else {
            for (int i3 = 0; i3 < jRCrosstabColumnGroupArray.length; ++i3) {
                this.verifyCrosstabColumnGroup(jRCrosstabColumnGroupArray[i3]);
            }
        }
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRDesignCrosstab.getMeasures();
        if (jRCrosstabMeasureArray == null || jRCrosstabMeasureArray.length == 0) {
            this.addBrokenRule("Crosstab should have at least one measure.", (Object)jRDesignCrosstab);
        } else {
            for (int i4 = 0; i4 < jRCrosstabMeasureArray.length; ++i4) {
                this.verifyCrosstabMeasure(jRCrosstabMeasureArray[i4]);
            }
        }
        this.verifyCrosstabCells(jRDesignCrosstab);
        this.verifyCellContents(jRDesignCrosstab.getWhenNoDataCell(), "when no data cell");
        this.verifyExpressions(jRDesignCrosstab);
    }

    private void verifyParameters(JRDesignCrosstab jRDesignCrosstab) {
        Object object;
        JRExpression jRExpression = jRDesignCrosstab.getParametersMapExpression();
        if (jRExpression != null) {
            try {
                object = jRExpression.getValueClass();
                if (object == null) {
                    this.addBrokenRule("Class not set for crosstab parameters map expression.", (Object)jRExpression);
                } else if (!(B == null ? (B = JRVerifier.a("java.util.Map")) : B).isAssignableFrom((Class<?>)object)) {
                    this.addBrokenRule("Class " + object + " not supported for crosstab parameters map expression. Use java.util.Map instead.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
        if ((object = jRDesignCrosstab.getParameters()) != null) {
            for (int i2 = 0; i2 < ((JRCrosstabParameter[])object).length; ++i2) {
                JRCrosstabParameter jRCrosstabParameter = object[i2];
                String string = jRCrosstabParameter.getName();
                if (string == null || string.length() == 0) {
                    this.addBrokenRule("Missing parameter name for crosstab.", (Object)jRCrosstabParameter);
                }
                JRExpression jRExpression2 = jRCrosstabParameter.getExpression();
                Class clazz = null;
                if (jRExpression2 != null) {
                    try {
                        clazz = jRExpression2.getValueClass();
                        if (clazz == null) {
                            this.addBrokenRule("Expression class not set for crosstab parameter " + string + ".", (Object)jRExpression2);
                        }
                    }
                    catch (JRRuntimeException jRRuntimeException) {
                        this.addBrokenRule(jRRuntimeException, (Object)jRExpression2);
                    }
                }
                try {
                    Class clazz2 = jRCrosstabParameter.getValueClass();
                    if (clazz2 == null) {
                        this.addBrokenRule("Class not set for crosstab parameter " + string + ".", (Object)jRCrosstabParameter);
                        continue;
                    }
                    if (clazz == null || clazz2.isAssignableFrom(clazz)) continue;
                    this.addBrokenRule("Incompatible expression class for crosstab parameter " + string + ".", (Object)jRCrosstabParameter);
                    continue;
                }
                catch (Exception exception) {
                    this.addBrokenRule(exception, (Object)jRCrosstabParameter);
                }
            }
        }
    }

    private void verifyCrosstabRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) {
        this.verifyCrosstabGroup(jRCrosstabRowGroup);
    }

    private void verifyCrosstabColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        this.verifyCrosstabGroup(jRCrosstabColumnGroup);
    }

    private void verifyCrosstabGroup(JRCrosstabGroup jRCrosstabGroup) {
        String string = jRCrosstabGroup.getName();
        if (string == null || string.length() == 0) {
            this.addBrokenRule("Crosstab group name missing.", (Object)jRCrosstabGroup);
        }
        this.verifyCrosstabBucket(jRCrosstabGroup);
        this.verifyCellContents(jRCrosstabGroup.getHeader(), string + " header");
        if (jRCrosstabGroup.hasTotal()) {
            this.verifyCellContents(jRCrosstabGroup.getTotalHeader(), string + " total header");
        }
    }

    private void verifyCrosstabBucket(JRCrosstabGroup jRCrosstabGroup) {
        block17: {
            JRCrosstabBucket jRCrosstabBucket = jRCrosstabGroup.getBucket();
            JRExpression jRExpression = jRCrosstabBucket.getExpression();
            Class clazz = null;
            if (jRExpression == null) {
                this.addBrokenRule("Crosstab bucket expression missing for group " + jRCrosstabGroup.getName() + ".", (Object)jRCrosstabBucket);
            } else {
                try {
                    clazz = jRExpression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Crosstab bucket expression class missing for group " + jRCrosstabGroup.getName() + ".", (Object)jRExpression);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
                }
            }
            try {
                Class clazz2;
                Class clazz3 = clazz2 = jRExpression == null ? null : jRExpression.getValueClass();
                if (clazz2 == null) {
                    this.addBrokenRule("Crosstab bucket value class missing for group " + jRCrosstabGroup.getName() + ".", (Object)jRCrosstabBucket);
                } else if (clazz != null && !clazz2.isAssignableFrom(clazz)) {
                    this.addBrokenRule("The class of the expression is not compatible with the class of the crosstab bucket for group " + jRCrosstabGroup.getName() + ".", (Object)jRExpression);
                }
                JRExpression jRExpression2 = jRCrosstabBucket.getComparatorExpression();
                if (jRExpression2 == null) {
                    if (clazz2 != null && !(u == null ? (u = JRVerifier.a("java.lang.Comparable")) : u).isAssignableFrom(clazz2)) {
                        this.addBrokenRule("No comparator expression specified and the value class is not comparable for crosstab group " + jRCrosstabGroup.getName() + ".", (Object)jRCrosstabBucket);
                    }
                    break block17;
                }
                try {
                    Class clazz4 = jRExpression2.getValueClass();
                    if (clazz4 == null) {
                        this.addBrokenRule("Crosstab bucket comparator expression class missing for group " + jRCrosstabGroup.getName() + ".", (Object)jRExpression2);
                    } else if (!(f == null ? (f = JRVerifier.a("java.util.Comparator")) : f).isAssignableFrom(clazz4)) {
                        this.addBrokenRule("The comparator expression should be compatible with java.util.Comparator for crosstab group " + jRCrosstabGroup.getName() + ".", (Object)jRExpression2);
                    }
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression2);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifyCrosstabCells(JRDesignCrosstab jRDesignCrosstab) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray;
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray;
        JRCrosstabCell[][] jRCrosstabCellArray = jRDesignCrosstab.getCells();
        JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[(jRCrosstabRowGroupArray = jRDesignCrosstab.getRowGroups()).length][(jRCrosstabColumnGroupArray = jRDesignCrosstab.getColumnGroups()).length];
        if (jRCrosstabCell == null || jRCrosstabCell.getWidth() == null) {
            this.addBrokenRule("Crosstab base cell width not specified.", (Object)jRDesignCrosstab);
        }
        if (jRCrosstabCell == null || jRCrosstabCell.getHeight() == null) {
            this.addBrokenRule("Crosstab base cell height not specified.", (Object)jRDesignCrosstab);
        }
        for (int i2 = jRCrosstabRowGroupArray.length; i2 >= 0; --i2) {
            for (int i3 = jRCrosstabColumnGroupArray.length; i3 >= 0; --i3) {
                JRCrosstabCell jRCrosstabCell2;
                JRCrosstabCell jRCrosstabCell3 = jRCrosstabCellArray[i2][i3];
                String string = this.getCrosstabCellText(jRCrosstabRowGroupArray, jRCrosstabColumnGroupArray, i2, i3);
                if (jRCrosstabCell3 == null) continue;
                JRCellContents jRCellContents = jRCrosstabCell3.getContents();
                if (i2 < jRCrosstabRowGroupArray.length && (jRCrosstabCell2 = jRCrosstabCellArray[jRCrosstabRowGroupArray.length][i3]) != null && jRCrosstabCell2.getContents().getWidth() != jRCellContents.getWidth()) {
                    this.addBrokenRule("Crosstab " + string + " width should be " + jRCrosstabCell2.getContents().getWidth() + ".", (Object)jRCrosstabCell3);
                }
                if (i3 < jRCrosstabColumnGroupArray.length && (jRCrosstabCell2 = jRCrosstabCellArray[i2][jRCrosstabColumnGroupArray.length]) != null && jRCrosstabCell2.getContents().getHeight() != jRCellContents.getHeight()) {
                    this.addBrokenRule("Crosstab " + string + " height should be " + jRCrosstabCell2.getContents().getHeight() + ".", (Object)jRCrosstabCell3);
                }
                this.verifyCellContents(jRCellContents, string);
            }
        }
    }

    private String getCrosstabCellText(JRCrosstabRowGroup[] jRCrosstabRowGroupArray, JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray, int n2, int n3) {
        String string = n2 == jRCrosstabRowGroupArray.length ? (n3 == jRCrosstabColumnGroupArray.length ? "cell" : jRCrosstabColumnGroupArray[n3].getName() + " total cell") : (n3 == jRCrosstabColumnGroupArray.length ? jRCrosstabRowGroupArray[n2].getName() + " total cell" : jRCrosstabRowGroupArray[n2].getName() + "," + jRCrosstabColumnGroupArray[n3].getName() + " total cell");
        return string;
    }

    private void verifyCrosstabMeasure(JRCrosstabMeasure jRCrosstabMeasure) {
        Class clazz;
        byte by2;
        String string = jRCrosstabMeasure.getName();
        if (string == null || string.trim().length() == 0) {
            this.addBrokenRule("Measure name missing.", (Object)jRCrosstabMeasure);
        }
        if ((by2 = jRCrosstabMeasure.getCalculation()) == 8) {
            this.addBrokenRule("Crosstab mesures cannot have system calculation", (Object)jRCrosstabMeasure);
        }
        JRExpression jRExpression = jRCrosstabMeasure.getValueExpression();
        Class clazz2 = null;
        if (jRExpression == null) {
            this.addBrokenRule("Missing expression for measure " + string, (Object)jRCrosstabMeasure);
        } else {
            try {
                clazz2 = jRExpression.getValueClass();
                if (clazz2 == null) {
                    this.addBrokenRule("Crosstab measure expression class missing for " + string + ".", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
        try {
            clazz = jRCrosstabMeasure.getValueClass();
            if (clazz == null) {
                this.addBrokenRule("Measure value class missing.", (Object)jRCrosstabMeasure);
            } else if (clazz2 != null && by2 != 1 && by2 != 10 && !clazz.isAssignableFrom(clazz2)) {
                this.addBrokenRule("The class of the expression is not compatible with the class of the measure " + string + ".", (Object)jRExpression);
            }
            if (jRCrosstabMeasure.getPercentageOfType() != 0) {
                Class clazz3 = jRCrosstabMeasure.getPercentageCalculatorClass();
                if (clazz3 == null) {
                    if (clazz != null && !JRPercentageCalculatorFactory.hasBuiltInCalculator(clazz)) {
                        this.addBrokenRule("Percentage calculator class needs to be specified for measure " + string + ".", (Object)jRCrosstabMeasure);
                    }
                } else if (!(b == null ? (b = JRVerifier.a("net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator")) : b).isAssignableFrom(clazz3)) {
                    this.addBrokenRule("Incompatible percentage calculator class for measure " + string + ".", (Object)jRCrosstabMeasure);
                }
            }
        }
        catch (JRRuntimeException jRRuntimeException) {
            this.addBrokenRule(jRRuntimeException, (Object)jRCrosstabMeasure);
        }
        try {
            clazz = jRCrosstabMeasure.getIncrementerFactoryClass();
            if (clazz != null && !(a == null ? (a = JRVerifier.a("net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory")) : a).isAssignableFrom(clazz)) {
                this.addBrokenRule("Crosstab measures need extended incrementers (net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory).", (Object)jRCrosstabMeasure);
            }
        }
        catch (JRRuntimeException jRRuntimeException) {
            this.addBrokenRule(jRRuntimeException, (Object)jRCrosstabMeasure);
        }
    }

    private void verifyExpressions(JRDesignCrosstab jRDesignCrosstab) {
        this.verifyExpressions(this.expressionCollector.getExpressions(jRDesignCrosstab), jRDesignCrosstab.getParametersMap(), new HashMap(), jRDesignCrosstab.getVariablesMap());
    }

    private void verifyChart(JRChart jRChart) {
        JRChartDataset jRChartDataset;
        if (jRChart.getEvaluationTime() == 7) {
            this.addBrokenRule("Charts do not support Auto evaluation time.", (Object)jRChart);
        }
        if ((jRChartDataset = jRChart.getDataset()) == null) {
            this.addBrokenRule("Chart dataset missing.", (Object)jRChart);
        } else {
            jRChartDataset.validate(this);
        }
    }

    private void verifyCellContents(JRCellContents jRCellContents, String string) {
        JRElement[] jRElementArray;
        if (jRCellContents != null && (jRElementArray = jRCellContents.getElements()) != null && jRElementArray.length > 0) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            JRLineBox jRLineBox = jRCellContents.getLineBox();
            if (jRLineBox != null) {
                n3 = jRLineBox.getTopPadding();
                n4 = jRLineBox.getLeftPadding();
                n5 = jRLineBox.getBottomPadding();
                n6 = jRLineBox.getRightPadding();
            }
            boolean bl2 = (n2 = jRCellContents.getWidth()) != Integer.MIN_VALUE;
            int n7 = n2 - n4 - n6;
            int n8 = jRCellContents.getHeight();
            boolean bl3 = n8 != Integer.MIN_VALUE;
            int n9 = n8 - n3 - n5;
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                JRHyperlink jRHyperlink;
                JRElement jRElement = jRElementArray[i2];
                this.verifyPrintWhenExpr(jRElement);
                if (bl2 && jRElement.getX() + jRElement.getWidth() > n7) {
                    this.addBrokenRule("Element reaches outside " + string + " width: x=" + jRElement.getX() + ", width=" + jRElement.getWidth() + ", available width=" + n7 + ".", (Object)jRElement);
                }
                if (bl3 && jRElement.getY() + jRElement.getHeight() > n9) {
                    this.addBrokenRule("Element reaches outside " + string + " height: y=" + jRElement.getY() + ", height=" + jRElement.getHeight() + ", available height=" + n9 + ".", (Object)jRElement);
                }
                if (jRElement instanceof JRStaticText) {
                    this.verifyStaticText((JRStaticText)jRElement);
                    continue;
                }
                if (jRElement instanceof JRTextField) {
                    jRHyperlink = (JRTextField)jRElement;
                    if (jRHyperlink.getEvaluationTime() != 1) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)jRHyperlink);
                    }
                    this.verifyTextField((JRTextField)jRHyperlink);
                    continue;
                }
                if (jRElement instanceof JRImage) {
                    jRHyperlink = (JRImage)jRElement;
                    if (jRHyperlink.getEvaluationTime() != 1) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)jRHyperlink);
                    }
                    this.verifyImage((JRImage)jRHyperlink);
                    continue;
                }
                if (jRElement instanceof JRFrame) {
                    this.verifyFrame((JRFrame)jRElement);
                    continue;
                }
                if (jRElement instanceof JRSubreport) {
                    this.addBrokenRule("Subreports are not allowed inside crosstab cells.", (Object)jRElement);
                    continue;
                }
                if (jRElement instanceof JRCrosstab) {
                    this.addBrokenRule("Crosstabs are not allowed inside crosstab cells.", (Object)jRElement);
                    continue;
                }
                if (!(jRElement instanceof JRChart)) continue;
                this.addBrokenRule("Charts are not allowed inside crosstab cells.", (Object)jRElement);
            }
        }
    }

    private void verifyElementDataset(JRElementDataset jRElementDataset) {
        JRExpression jRExpression;
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        if (jRDatasetRun != null) {
            byte by2;
            byte by3 = jRElementDataset.getIncrementType();
            if (by3 == 2 || by3 == 3) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page increment type.", (Object)jRElementDataset);
            }
            if ((by2 = jRElementDataset.getResetType()) == 2 || by2 == 3) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page reset type.", (Object)jRElementDataset);
            } else if (by2 != 1) {
                // empty if block
            }
            this.verifyDatasetRun(jRDatasetRun);
        }
        if ((jRExpression = jRElementDataset.getIncrementWhenExpression()) != null) {
            try {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for data set \"increment when\" expression.", (Object)jRExpression);
                } else if (!(A == null ? (A = JRVerifier.a("java.lang.Boolean")) : A).isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for dataset \"increment when\" expression. Use java.lang.Boolean instead.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifyDatasetRun(JRDatasetRun jRDatasetRun) {
        Object object;
        JRCloneable jRCloneable;
        Object object2;
        JRDesignDataset jRDesignDataset = null;
        String string = jRDatasetRun.getDatasetName();
        if (string == null || string.length() == 0) {
            this.addBrokenRule("Dataset name is missing for dataset run.", (Object)jRDatasetRun);
        } else {
            jRDesignDataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(string);
            if (jRDesignDataset == null) {
                this.addBrokenRule("Unknown dataset name " + string + ".", (Object)jRDatasetRun);
            }
        }
        JRExpression jRExpression = jRDatasetRun.getParametersMapExpression();
        if (jRExpression != null) {
            try {
                object2 = jRExpression.getValueClass();
                if (object2 == null) {
                    this.addBrokenRule("Class not set for dataset " + string + " parameters map expression.", (Object)jRExpression);
                } else if (!(B == null ? (B = JRVerifier.a("java.util.Map")) : B).isAssignableFrom((Class<?>)object2)) {
                    this.addBrokenRule("Class " + object2 + " not supported for dataset " + string + " parameters map expression. Use java.util.Map instead.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
        if ((object2 = jRDatasetRun.getParameters()) != null && ((JRDatasetParameter[])object2).length > 0) {
            for (int i2 = 0; i2 < ((JRDatasetParameter[])object2).length; ++i2) {
                JRExpression jRExpression2;
                jRCloneable = object2[i2];
                object = jRCloneable.getName();
                if (object == null || ((String)object).trim().length() == 0) {
                    this.addBrokenRule("Dataset " + string + " parameter name missing.", (Object)jRCloneable);
                }
                JRParameter jRParameter = null;
                if (jRDesignDataset != null && (jRParameter = (JRParameter)jRDesignDataset.getParametersMap().get(object)) == null) {
                    this.addBrokenRule("Unknown parameter " + (String)object + " in dataset " + string + ".", (Object)jRCloneable);
                }
                if ((jRExpression2 = jRCloneable.getExpression()) == null) continue;
                try {
                    Class clazz = jRExpression2.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for dataset " + string + " parameter expression : " + (String)object + ".", (Object)jRExpression2);
                        continue;
                    }
                    if (jRParameter == null || jRParameter.getValueClass().isAssignableFrom(clazz)) continue;
                    this.addBrokenRule("Class " + clazz + " not supported for parameter " + (String)object + " of dataset " + string + ". Use " + jRParameter.getValueClass() + " instead.", (Object)jRExpression2);
                    continue;
                }
                catch (JRRuntimeException jRRuntimeException) {
                    this.addBrokenRule(jRRuntimeException, (Object)jRExpression2);
                }
            }
        }
        JRExpression jRExpression3 = jRDatasetRun.getConnectionExpression();
        jRCloneable = jRDatasetRun.getDataSourceExpression();
        if (jRExpression3 != null && jRCloneable != null) {
            this.addBrokenRule("Dataset " + string + " cannot have both connection expresion and data source expression.", (Object)jRDatasetRun);
        }
        if (jRExpression3 != null) {
            try {
                object = jRExpression3.getValueClass();
                if (object == null) {
                    this.addBrokenRule("Class not set for dataset " + string + " connection expression.", (Object)jRExpression3);
                } else if (!(c == null ? (c = JRVerifier.a("java.sql.Connection")) : c).isAssignableFrom((Class<?>)object)) {
                    this.addBrokenRule("Class " + object + " not supported for dataset " + string + " connection expression. Use java.sql.Connection instead.", (Object)jRExpression3);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression3);
            }
        }
        if (jRCloneable != null) {
            try {
                object = jRCloneable.getValueClass();
                if (object == null) {
                    this.addBrokenRule("Class not set for dataset " + string + " data source expression.", (Object)jRCloneable);
                } else if (!(o == null ? (o = JRVerifier.a("net.sf.jasperreports.engine.JRDataSource")) : o).isAssignableFrom((Class<?>)object)) {
                    this.addBrokenRule("Class " + object + " not supported for dataset " + string + " data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.", (Object)jRCloneable);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRCloneable);
            }
        }
    }

    private void verifyDatasets() {
        JRDataset[] jRDatasetArray = this.jasperDesign.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i2 = 0; i2 < jRDatasetArray.length; ++i2) {
                JRDesignDataset jRDesignDataset = (JRDesignDataset)jRDatasetArray[i2];
                if (jRDesignDataset.getName() == null || jRDesignDataset.getName().trim().length() == 0) {
                    this.addBrokenRule("Dataset name is missing.", (Object)jRDesignDataset);
                }
                this.verifyDataset(jRDesignDataset);
            }
        }
    }

    private void verifyDataset(JRDesignDataset jRDesignDataset) {
        this.verifyExpressions(jRDesignDataset);
        this.verifyParameters(jRDesignDataset);
        this.verifyQuery(jRDesignDataset);
        this.verifyFields(jRDesignDataset);
        this.verifySortFields(jRDesignDataset);
        this.verifyVariables(jRDesignDataset);
        this.verifyGroups(jRDesignDataset);
        JRExpression jRExpression = jRDesignDataset.getFilterExpression();
        if (jRExpression != null) {
            try {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for filter expression.", (Object)jRExpression);
                } else if (!(A == null ? (A = JRVerifier.a("java.lang.Boolean")) : A).isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for filter expression. Use java.lang.Boolean instead.", (Object)jRExpression);
                }
            }
            catch (JRRuntimeException jRRuntimeException) {
                this.addBrokenRule(jRRuntimeException, (Object)jRExpression);
            }
        }
    }

    private void verifyFrame(JRFrame jRFrame) {
        JRElement[] jRElementArray = jRFrame.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            int n2 = jRFrame.getLineBox().getTopPadding();
            int n3 = jRFrame.getLineBox().getLeftPadding();
            int n4 = jRFrame.getLineBox().getBottomPadding();
            int n5 = jRFrame.getLineBox().getRightPadding();
            int n6 = jRFrame.getWidth() - n3 - n5;
            int n7 = jRFrame.getHeight() - n2 - n4;
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                JRElement jRElement = jRElementArray[i2];
                if (jRElement.getX() + jRElement.getWidth() > n6) {
                    this.addBrokenRule("Element reaches outside frame width: x=" + jRElement.getX() + ", width=" + jRElement.getWidth() + ", available width=" + n6 + ".", (Object)jRElement);
                }
                if (jRElement.getY() + jRElement.getHeight() > n7) {
                    this.addBrokenRule("Element reaches outside frame height: y=" + jRElement.getY() + ", height=" + jRElement.getHeight() + ", available height=" + n7 + ".", (Object)jRElement);
                }
                this.verifyElement(jRElement);
            }
        }
    }

    public void verify(JRCategoryDataset jRCategoryDataset) {
        this.verifyElementDataset(jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null) {
            for (int i2 = 0; i2 < jRCategorySeriesArray.length; ++i2) {
                this.verify(jRCategorySeriesArray[i2]);
            }
        }
    }

    public void verify(JRCategorySeries jRCategorySeries) {
        this.verifyHyperlink(jRCategorySeries.getItemHyperlink());
    }

    public void verify(JRPieDataset jRPieDataset) {
        this.verifyElementDataset(jRPieDataset);
        this.verifyHyperlink(jRPieDataset.getSectionHyperlink());
    }

    public void verify(JRHighLowDataset jRHighLowDataset) {
        this.verifyElementDataset(jRHighLowDataset);
        this.verifyHyperlink(jRHighLowDataset.getItemHyperlink());
    }

    public void verify(JRTimePeriodDataset jRTimePeriodDataset) {
        this.verifyElementDataset(jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null) {
            for (int i2 = 0; i2 < jRTimePeriodSeriesArray.length; ++i2) {
                this.verify(jRTimePeriodSeriesArray[i2]);
            }
        }
    }

    public void verify(JRTimePeriodSeries jRTimePeriodSeries) {
        this.verifyHyperlink(jRTimePeriodSeries.getItemHyperlink());
    }

    public void verify(JRTimeSeriesDataset jRTimeSeriesDataset) {
        this.verifyElementDataset(jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null) {
            for (int i2 = 0; i2 < jRTimeSeriesArray.length; ++i2) {
                this.verify(jRTimeSeriesArray[i2]);
            }
        }
    }

    public void verify(JRTimeSeries jRTimeSeries) {
        this.verifyHyperlink(jRTimeSeries.getItemHyperlink());
    }

    public void verify(JRValueDataset jRValueDataset) {
    }

    public void verify(JRXyDataset jRXyDataset) {
        this.verifyElementDataset(jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null) {
            for (int i2 = 0; i2 < jRXySeriesArray.length; ++i2) {
                this.verify(jRXySeriesArray[i2]);
            }
        }
    }

    public void verify(JRXySeries jRXySeries) {
        this.verifyHyperlink(jRXySeries.getItemHyperlink());
    }

    public void verify(JRXyzDataset jRXyzDataset) {
        this.verifyElementDataset(jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null) {
            for (int i2 = 0; i2 < jRXyzSeriesArray.length; ++i2) {
                this.verify(jRXyzSeriesArray[i2]);
            }
        }
    }

    public void verify(JRXyzSeries jRXyzSeries) {
        this.verifyHyperlink(jRXyzSeries.getItemHyperlink());
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

