/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRDesignGraphicElement
extends JRDesignElement
implements JRGraphicElement {
    private static final long serialVersionUID = 10200L;
    public JRPen linePen = new JRBasePen(this);
    public Byte fill;
    private Byte pen;

    public JRDesignGraphicElement(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    public JRPen getLinePen() {
        return this.linePen;
    }

    public byte getPen() {
        return JRPenUtil.getPenFromLinePen(this.linePen);
    }

    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    public void setPen(byte by2) {
        this.setPen(new Byte(by2));
    }

    public void setPen(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, this.linePen);
    }

    public byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    public Byte getOwnFill() {
        return this.fill;
    }

    public void setFill(byte by2) {
        this.setFill(new Byte(by2));
    }

    public void setFill(Byte by2) {
        Byte by3 = this.fill;
        this.fill = by2;
        this.getEventSupport().firePropertyChange("fill", by3, this.fill);
    }

    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

