/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.base.JRBaseExpression;
import net.sf.jasperreports.engine.design.JRDesignExpressionChunk;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignExpression
extends JRBaseExpression
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_VALUE_CLASS_NAME = "valueClassName";
    public List chunks = new ArrayList();
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignExpression() {
        this.regenerateId();
    }

    public void setValueClass(Class clazz) {
        this.setValueClassName(clazz.getName());
    }

    public void setValueClassName(String string) {
        String string2 = this.valueClassName;
        this.valueClassName = string;
        this.valueClass = null;
        this.valueClassRealName = null;
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_CLASS_NAME, string2, this.valueClassName);
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public JRExpressionChunk[] getChunks() {
        JRExpressionChunk[] jRExpressionChunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            jRExpressionChunkArray = new JRExpressionChunk[this.chunks.size()];
            this.chunks.toArray(jRExpressionChunkArray);
        }
        return jRExpressionChunkArray;
    }

    public void setChunks(List list) {
        this.chunks.clear();
        this.chunks.addAll(list);
    }

    public void addChunk(JRDesignExpressionChunk jRDesignExpressionChunk) {
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addChunk(byte by2, String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType(by2);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addTextChunk(String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType((byte)1);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addParameterChunk(String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType((byte)2);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addFieldChunk(String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType((byte)3);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addVariableChunk(String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType((byte)4);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void addResourceChunk(String string) {
        JRDesignExpressionChunk jRDesignExpressionChunk = new JRDesignExpressionChunk();
        jRDesignExpressionChunk.setType((byte)5);
        jRDesignExpressionChunk.setText(string);
        this.chunks.add(jRDesignExpressionChunk);
    }

    public void setText(String string) {
        String string2 = this.getText();
        this.chunks.clear();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "$", true);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("$")) {
                    if (n2 > 0) {
                        stringBuffer.append("$");
                    }
                    ++n2;
                    continue;
                }
                byte by2 = 1;
                if (n2 > 0) {
                    if (string3.startsWith("P{")) {
                        by2 = 2;
                    } else if (string3.startsWith("F{")) {
                        by2 = 3;
                    } else if (string3.startsWith("V{")) {
                        by2 = 4;
                    } else if (string3.startsWith("R{")) {
                        by2 = 5;
                    }
                }
                if (by2 == 1) {
                    if (n2 > 0) {
                        stringBuffer.append("$");
                    }
                    stringBuffer.append(string3);
                } else {
                    int n3 = string3.indexOf(125);
                    if (n3 > 0) {
                        if (n2 > 1) {
                            stringBuffer.append(string3);
                        } else {
                            if (stringBuffer.length() > 0) {
                                this.addTextChunk(stringBuffer.toString());
                            }
                            this.addChunk(by2, string3.substring(2, n3));
                            stringBuffer = new StringBuffer(string3.substring(n3 + 1));
                        }
                    } else {
                        if (n2 > 0) {
                            stringBuffer.append("$");
                        }
                        stringBuffer.append(string3);
                    }
                }
                n2 = 0;
            }
            if (n2 > 0) {
                stringBuffer.append("$");
            }
            if (stringBuffer.length() > 0) {
                this.addTextChunk(stringBuffer.toString());
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_TEXT, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignExpression jRDesignExpression = this;
        synchronized (jRDesignExpression) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        JRDesignExpression jRDesignExpression = (JRDesignExpression)super.clone();
        if (this.chunks != null) {
            jRDesignExpression.chunks = new ArrayList(this.chunks.size());
            for (int i2 = 0; i2 < this.chunks.size(); ++i2) {
                jRDesignExpression.chunks.add(((JRExpressionChunk)this.chunks.get(i2)).clone());
            }
        }
        return jRDesignExpression;
    }
}

