/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignElementGroup
extends JRBaseElementGroup
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ELEMENT_GROUP = "elementGroup";
    public static final String PROPERTY_CHILDREN = "children";
    private transient JRPropertyChangeSupport eventSupport;

    public void setElementGroup(JRElementGroup jRElementGroup) {
        JRElementGroup jRElementGroup2 = this.elementGroup;
        this.elementGroup = jRElementGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_ELEMENT_GROUP, jRElementGroup2, this.elementGroup);
    }

    public void addElement(JRDesignElement jRDesignElement) {
        jRDesignElement.setElementGroup(this);
        this.children.add(jRDesignElement);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, jRDesignElement, this.children.size() - 1);
    }

    public JRDesignElement removeElement(JRDesignElement jRDesignElement) {
        jRDesignElement.setElementGroup(null);
        int n2 = this.children.indexOf(jRDesignElement);
        if (n2 >= 0) {
            this.children.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, jRDesignElement, n2);
        }
        return jRDesignElement;
    }

    public void addElementGroup(JRDesignElementGroup jRDesignElementGroup) {
        jRDesignElementGroup.setElementGroup(this);
        this.children.add(jRDesignElementGroup);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, jRDesignElementGroup, this.children.size() - 1);
    }

    public JRDesignElementGroup removeElementGroup(JRDesignElementGroup jRDesignElementGroup) {
        jRDesignElementGroup.setElementGroup(null);
        int n2 = this.children.indexOf(jRDesignElementGroup);
        if (n2 >= 0) {
            this.children.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, jRDesignElementGroup, n2);
        }
        return jRDesignElementGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignElementGroup jRDesignElementGroup = this;
        synchronized (jRDesignElementGroup) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

