/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseDatasetRun;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignDatasetRun
extends JRBaseDatasetRun
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    private Map parametersMap = new HashMap();
    private List parametersList = new ArrayList();
    public static final String PROPERTY_CONNECTION_EXPRESSION = "connectionExpression";
    public static final String PROPERTY_DATASET_NAME = "datasetName";
    public static final String PROPERTY_DATA_SOURCE_EXPRESSION = "dataSourceExpression";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private transient JRPropertyChangeSupport eventSupport;

    public void addParameter(JRDatasetParameter jRDatasetParameter) throws JRException {
        if (this.parametersMap.containsKey(jRDatasetParameter.getName())) {
            throw new JRException("Duplicate declaration of dataset parameter : " + jRDatasetParameter.getName());
        }
        this.parametersMap.put(jRDatasetParameter.getName(), jRDatasetParameter);
        this.parametersList.add(jRDatasetParameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, jRDatasetParameter, this.parametersList.size() - 1);
    }

    public JRDatasetParameter removeParameter(String string) {
        JRDatasetParameter jRDatasetParameter = (JRDatasetParameter)this.parametersMap.remove(string);
        if (jRDatasetParameter != null) {
            int n2 = this.parametersList.indexOf(jRDatasetParameter);
            if (n2 >= 0) {
                this.parametersList.remove(n2);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, jRDatasetParameter, n2);
        }
        return jRDatasetParameter;
    }

    public JRDatasetParameter removeParameter(JRDatasetParameter jRDatasetParameter) {
        return this.removeParameter(jRDatasetParameter.getName());
    }

    public void setConnectionExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.connectionExpression;
        this.connectionExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_CONNECTION_EXPRESSION, jRExpression2, this.connectionExpression);
    }

    public void setDatasetName(String string) {
        String string2 = this.datasetName;
        this.datasetName = string;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_NAME, string2, this.datasetName);
    }

    public void setDataSourceExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.dataSourceExpression;
        this.dataSourceExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_SOURCE_EXPRESSION, jRExpression2, this.dataSourceExpression);
    }

    public void setParametersMapExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.parametersMapExpression;
        this.parametersMapExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, jRExpression2, this.parametersMapExpression);
    }

    public JRDatasetParameter[] getParameters() {
        JRDatasetParameter[] jRDatasetParameterArray = new JRDatasetParameter[this.parametersList.size()];
        this.parametersList.toArray(jRDatasetParameterArray);
        return jRDatasetParameterArray;
    }

    public Object clone() {
        JRDesignDatasetRun jRDesignDatasetRun = (JRDesignDatasetRun)super.clone();
        if (this.parametersList != null) {
            jRDesignDatasetRun.parametersList = new ArrayList(this.parametersList.size());
            jRDesignDatasetRun.parametersMap = new HashMap(this.parametersList.size());
            for (int i2 = 0; i2 < this.parametersList.size(); ++i2) {
                JRDatasetParameter jRDatasetParameter = (JRDatasetParameter)((JRDatasetParameter)this.parametersList.get(i2)).clone();
                jRDesignDatasetRun.parametersList.add(jRDatasetParameter);
                jRDesignDatasetRun.parametersMap.put(jRDatasetParameter.getName(), jRDatasetParameter);
            }
        }
        return jRDesignDatasetRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignDatasetRun jRDesignDatasetRun = this;
        synchronized (jRDesignDatasetRun) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

