/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_CHART_TYPE = "chartType";
    public static final String PROPERTY_CUSTOMIZER_CLASS = "customizerClass";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_LEGEND_FONT = "legendFont";
    public static final String PROPERTY_SUBTITLE_EXPRESSION = "subtitleExpression";
    public static final String PROPERTY_SUBTITLE_FONT = "subtitleFont";
    public static final String PROPERTY_TITLE_EXPRESSION = "titleExpression";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public byte chartType = 0;
    public boolean isShowLegend = false;
    public byte evaluationTime = 1;
    public byte hyperlinkType = 0;
    public String linkType;
    public byte hyperlinkTarget = 1;
    public byte titlePosition = 1;
    public Color titleColor = null;
    public Color subtitleColor = null;
    public Color legendColor = null;
    public Color legendBackgroundColor = null;
    public byte legendPosition = (byte)2;
    public JRFont titleFont = null;
    public JRFont subtitleFont = null;
    public JRFont legendFont = null;
    public String customizerClass;
    public JRGroup evaluationGroup = null;
    public JRExpression titleExpression = null;
    public JRExpression subtitleExpression = null;
    public JRExpression anchorNameExpression = null;
    public JRExpression hyperlinkReferenceExpression = null;
    public JRExpression hyperlinkAnchorExpression = null;
    public JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    private List hyperlinkParameters;
    public JRChartDataset dataset = null;
    public JRChartPlot plot = null;
    public JRLineBox lineBox;
    public int bookmarkLevel = 0;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRDesignChart(JRDefaultStyleProvider jRDefaultStyleProvider, byte by2) {
        super(jRDefaultStyleProvider);
        this.setChartType(by2);
        this.hyperlinkParameters = new ArrayList();
        this.lineBox = new JRBaseLineBox(this);
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean bl2) {
        boolean bl3 = this.isShowLegend;
        this.isShowLegend = bl2;
        this.getEventSupport().firePropertyChange("showLegend", bl3, this.isShowLegend);
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte by2) {
        byte by3 = this.evaluationTime;
        this.evaluationTime = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, by3, this.evaluationTime);
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup jRGroup) {
        JRGroup jRGroup2 = this.evaluationGroup;
        this.evaluationGroup = jRGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, jRGroup2, this.evaluationGroup);
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox jRBox) {
        JRBoxUtil.setBoxToLineBox(jRBox, this.lineBox);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont jRFont) {
        JRFont jRFont2 = this.titleFont;
        this.titleFont = jRFont;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_FONT, jRFont2, this.titleFont);
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte by2) {
        byte by3 = this.titlePosition;
        this.titlePosition = by2;
        this.getEventSupport().firePropertyChange("titlePosition", by3, this.titlePosition);
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.titleColor;
        this.titleColor = color;
        this.getEventSupport().firePropertyChange("titleColor", color2, this.titleColor);
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont jRFont) {
        JRFont jRFont2 = this.subtitleFont;
        this.subtitleFont = jRFont;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_FONT, jRFont2, this.subtitleFont);
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color color) {
        Color color2 = this.subtitleColor;
        this.subtitleColor = color;
        this.getEventSupport().firePropertyChange("subtitleColor", color2, this.subtitleColor);
    }

    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public void setLegendColor(Color color) {
        Color color2 = this.legendColor;
        this.legendColor = color;
        this.getEventSupport().firePropertyChange("legendColor", color2, this.legendColor);
    }

    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public void setLegendBackgroundColor(Color color) {
        Color color2 = this.legendBackgroundColor;
        this.legendBackgroundColor = color;
        this.getEventSupport().firePropertyChange("legendBackgroundColor", color2, this.legendBackgroundColor);
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont jRFont) {
        JRFont jRFont2 = this.legendFont;
        this.legendFont = jRFont;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_FONT, jRFont2, this.legendFont);
    }

    public byte getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(byte by2) {
        byte by3 = this.legendPosition;
        this.legendPosition = by2;
        this.getEventSupport().firePropertyChange("legendPosition", by3, this.legendPosition);
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public void setHyperlinkType(byte by2) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by2));
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(byte by2) {
        byte by3 = this.hyperlinkTarget;
        this.hyperlinkTarget = by2;
        this.getEventSupport().firePropertyChange("hyperlinkTarget", by3, this.hyperlinkTarget);
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.titleExpression;
        this.titleExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_EXPRESSION, jRExpression2, this.titleExpression);
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.subtitleExpression;
        this.subtitleExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_EXPRESSION, jRExpression2, this.subtitleExpression);
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.anchorNameExpression;
        this.anchorNameExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, jRExpression2, this.anchorNameExpression);
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", jRExpression2, this.hyperlinkReferenceExpression);
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", jRExpression2, this.hyperlinkAnchorExpression);
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", jRExpression2, this.hyperlinkPageExpression);
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte by2) {
        byte by3 = this.chartType;
        this.chartType = by2;
        switch (by2) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot, this);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot, this);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot, this);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 17: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot, this);
                break;
            }
            case 19: {
                this.plot = new JRDesignMultiAxisPlot(this.plot, this);
                this.dataset = null;
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot, this);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot, this);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot, this);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot, this);
                break;
            }
            case 18: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot, this);
                break;
            }
            case 16: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot, this);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot, this);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot, this);
                break;
            }
            case 20: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot, this);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_TYPE, by3, this.chartType);
    }

    public void setDataset(JRChartDataset jRChartDataset) {
        JRChartDataset jRChartDataset2 = this.dataset;
        switch (jRChartDataset.getDatasetType()) {
            case 2: {
                this.dataset = (JRDesignCategoryDataset)jRChartDataset;
                break;
            }
            case 7: {
                this.dataset = (JRDesignHighLowDataset)jRChartDataset;
                break;
            }
            case 1: {
                this.dataset = (JRDesignPieDataset)jRChartDataset;
                break;
            }
            case 5: {
                this.dataset = (JRDesignTimePeriodDataset)jRChartDataset;
                break;
            }
            case 6: {
                this.dataset = (JRDesignTimeSeriesDataset)jRChartDataset;
                break;
            }
            case 8: {
                this.dataset = (JRDesignValueDataset)jRChartDataset;
                break;
            }
            case 3: {
                this.dataset = (JRDesignXyDataset)jRChartDataset;
                break;
            }
            case 4: {
                this.dataset = (JRDesignXyzDataset)jRChartDataset;
            }
        }
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, jRChartDataset2, this.dataset);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitChart(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n2) {
        int n3 = this.bookmarkLevel;
        this.bookmarkLevel = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, n3, this.bookmarkLevel);
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String string) {
        String string2 = this.customizerClass;
        this.customizerClass = string;
        this.getEventSupport().firePropertyChange(PROPERTY_CUSTOMIZER_CLASS, string2, this.customizerClass);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        String string2 = this.linkType;
        this.linkType = string;
        this.getEventSupport().firePropertyChange("linkType", string2, this.linkType);
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", jRHyperlinkParameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        int n2 = this.hyperlinkParameters.indexOf(jRHyperlinkParameter);
        if (n2 >= 0) {
            this.hyperlinkParameters.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", jRHyperlinkParameter, n2);
        }
    }

    public void removeHyperlinkParameter(String string) {
        ListIterator listIterator = this.hyperlinkParameters.listIterator();
        while (listIterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)listIterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            listIterator.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", jRHyperlinkParameter, listIterator.nextIndex());
        }
    }

    public void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", jRExpression2, this.hyperlinkTooltipExpression);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRDesignChart jRDesignChart = (JRDesignChart)super.clone();
        if (this.hyperlinkParameters != null) {
            jRDesignChart.hyperlinkParameters = new ArrayList(this.hyperlinkParameters.size());
            for (int i2 = 0; i2 < this.hyperlinkParameters.size(); ++i2) {
                jRDesignChart.hyperlinkParameters.add(((JRHyperlinkParameter)this.hyperlinkParameters.get(i2)).clone());
            }
        }
        if (this.titleExpression != null) {
            jRDesignChart.titleExpression = (JRExpression)this.titleExpression.clone();
        }
        if (this.subtitleExpression != null) {
            jRDesignChart.subtitleExpression = (JRExpression)this.subtitleExpression.clone();
        }
        if (this.anchorNameExpression != null) {
            jRDesignChart.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            jRDesignChart.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            jRDesignChart.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            jRDesignChart.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            jRDesignChart.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        if (this.dataset != null) {
            jRDesignChart.dataset = (JRChartDataset)this.dataset.clone();
        }
        if (this.plot != null) {
            jRDesignChart.plot = (JRChartPlot)this.plot.clone(jRDesignChart);
        }
        return jRDesignChart;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
    }
}

