/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JRXmlDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final JRXPathExecuter xPathExecuter;
    private LocaleConvertUtilsBean convertBean = null;
    private Locale locale = null;
    private String datePattern = null;
    private String numberPattern = null;
    private TimeZone timeZone = null;
    public static Class c;
    public static Class m;
    public static Class l;
    public static Class d;
    public static Class f;
    public static Class e;
    public static Class i;
    public static Class k;
    public static Class g;
    public static Class h;
    public static Class a;
    public static Class j;
    public static Class b;

    public JRXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSource(Document document, String string) throws JRException {
        this.document = document;
        this.selectExpression = string;
        this.xPathExecuter = JRXPathExecuterUtils.getXPathExecuter();
        this.moveFirst();
    }

    public JRXmlDataSource(InputStream inputStream) throws JRException {
        this(inputStream, ".");
    }

    public JRXmlDataSource(InputStream inputStream, String string) throws JRException {
        this(JRXmlUtils.parse(new InputSource(inputStream)), string);
    }

    public JRXmlDataSource(String string) throws JRException {
        this(string, ".");
    }

    public JRXmlDataSource(String string, String string2) throws JRException {
        this(JRXmlUtils.parse(string), string2);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSource(File file, String string) throws JRException {
        this(JRXmlUtils.parse(file), string);
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be null");
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList(this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Object object;
        Class clazz;
        if (this.currentNode == null) {
            return null;
        }
        String string = jRField.getDescription();
        if (string == null || string.length() == 0) {
            return null;
        }
        Object object2 = null;
        if ((c == null ? (c = JRXmlDataSource.a("java.lang.Object")) : c) != (clazz = jRField.getValueClass()) && (object = this.xPathExecuter.selectObject(this.currentNode, string)) != null) {
            if (object instanceof Node) {
                String string2 = this.getText((Node)object);
                object2 = this.convertStringValue(string2, clazz);
            } else if (object instanceof Boolean && clazz.equals(m == null ? (m = JRXmlDataSource.a("java.lang.Boolean")) : m)) {
                object2 = object;
            } else if (object instanceof Number && (l == null ? (l = JRXmlDataSource.a("java.lang.Number")) : l).isAssignableFrom(clazz)) {
                object2 = this.convertNumber((Number)object, clazz);
            } else {
                String string3 = object.toString();
                object2 = this.convertStringValue(string3, clazz);
            }
        }
        return object2;
    }

    public Object convertStringValue(String string, Class clazz) {
        Object object = null;
        if ((d == null ? (d = JRXmlDataSource.a("java.lang.String")) : d).equals(clazz)) {
            object = string;
        } else if ((l == null ? (l = JRXmlDataSource.a("java.lang.Number")) : l).isAssignableFrom(clazz)) {
            object = this.getConvertBean().convert(string.trim(), clazz, this.locale, this.numberPattern);
        } else if ((f == null ? (f = JRXmlDataSource.a("java.util.Date")) : f).isAssignableFrom(clazz)) {
            object = this.getConvertBean().convert(string.trim(), clazz, this.locale, this.datePattern);
        } else if ((m == null ? (m = JRXmlDataSource.a("java.lang.Boolean")) : m).equals(clazz)) {
            object = Boolean.valueOf(string);
        }
        return object;
    }

    public Object convertNumber(Number number, Class clazz) throws JRException {
        Number number2 = null;
        if (clazz.equals(e == null ? (e = JRXmlDataSource.a("java.lang.Byte")) : e)) {
            number2 = new Byte(number.byteValue());
        } else if (clazz.equals(i == null ? (i = JRXmlDataSource.a("java.lang.Short")) : i)) {
            number2 = new Short(number.shortValue());
        } else if (clazz.equals(k == null ? (k = JRXmlDataSource.a("java.lang.Integer")) : k)) {
            number2 = new Integer(number.intValue());
        } else if (clazz.equals(g == null ? (g = JRXmlDataSource.a("java.lang.Long")) : g)) {
            number2 = new Long(number.longValue());
        } else if (clazz.equals(h == null ? (h = JRXmlDataSource.a("java.lang.Float")) : h)) {
            number2 = new Float(number.floatValue());
        } else if (clazz.equals(a == null ? (a = JRXmlDataSource.a("java.lang.Double")) : a)) {
            number2 = new Double(number.doubleValue());
        } else if (clazz.equals(j == null ? (j = JRXmlDataSource.a("java.math.BigInteger")) : j)) {
            number2 = BigInteger.valueOf(number.longValue());
        } else if (clazz.equals(b == null ? (b = JRXmlDataSource.a("java.math.BigDecimal")) : b)) {
            number2 = new BigDecimal(Double.toString(number.doubleValue()));
        } else {
            throw new JRException("Unknown number class " + clazz.getName());
        }
        return number2;
    }

    public JRXmlDataSource subDataSource(String string) throws JRException {
        Document document = this.subDocument();
        JRXmlDataSource jRXmlDataSource = new JRXmlDataSource(document, string);
        jRXmlDataSource.setLocale(this.locale);
        jRXmlDataSource.setDatePattern(this.datePattern);
        jRXmlDataSource.setNumberPattern(this.numberPattern);
        jRXmlDataSource.setTimeZone(this.timeZone);
        return jRXmlDataSource;
    }

    public JRXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document document = JRXmlUtils.createDocument(this.currentNode);
        return document;
    }

    public JRXmlDataSource dataSource(String string) throws JRException {
        JRXmlDataSource jRXmlDataSource = new JRXmlDataSource(this.document, string);
        jRXmlDataSource.setLocale(this.locale);
        jRXmlDataSource.setDatePattern(this.datePattern);
        jRXmlDataSource.setNumberPattern(this.numberPattern);
        jRXmlDataSource.setTimeZone(this.timeZone);
        return jRXmlDataSource;
    }

    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Node node2 = nodeList.item(i2);
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (node2.getNodeType() == 4) {
                string = node2.getNodeValue();
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (node2.getNodeType() != 5 || (string = this.getText(node2)) == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        JRXmlDataSource jRXmlDataSource = new JRXmlDataSource(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField jRDesignField = new JRDesignField();
        jRDesignField.setDescription("CustomerID");
        jRDesignField.setValueClass(d == null ? (d = JRXmlDataSource.a("java.lang.String")) : d);
        jRXmlDataSource.next();
        String string = (String)jRXmlDataSource.getFieldValue(jRDesignField);
        System.out.println(jRDesignField.getDescription() + "=" + string);
        JRXmlDataSource jRXmlDataSource2 = jRXmlDataSource.dataSource("/Northwind/Orders");
        JRDesignField jRDesignField2 = new JRDesignField();
        jRDesignField2.setDescription("OrderID");
        jRDesignField2.setValueClass(d == null ? (d = JRXmlDataSource.a("java.lang.String")) : d);
        jRXmlDataSource2.next();
        String string2 = (String)jRXmlDataSource2.getFieldValue(jRDesignField2);
        System.out.println(jRDesignField2.getDescription() + "=" + string2);
    }

    public LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            if (this.locale != null) {
                this.convertBean.setDefaultLocale(this.locale);
                this.convertBean.deregister();
            }
            this.convertBean.register(new JRDateLocaleConverter(this.timeZone), f == null ? (f = JRXmlDataSource.a("java.util.Date")) : f, this.locale);
        }
        return this.convertBean;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.convertBean = null;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
        this.convertBean = null;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String string) {
        this.numberPattern = string;
        this.convertBean = null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.convertBean = null;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

