/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRTableModelDataSource
implements JRRewindableDataSource {
    private TableModel tableModel = null;
    private int index = -1;
    private HashMap columnNames = new HashMap();

    public JRTableModelDataSource(TableModel tableModel) {
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            for (int i2 = 0; i2 < this.tableModel.getColumnCount(); ++i2) {
                this.columnNames.put(this.tableModel.getColumnName(i2), new Integer(i2));
            }
        }
    }

    public boolean next() {
        ++this.index;
        if (this.tableModel != null) {
            return this.index < this.tableModel.getRowCount();
        }
        return false;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String string = jRField.getName();
        Integer n2 = (Integer)this.columnNames.get(string);
        if (n2 != null) {
            return this.tableModel.getValueAt(this.index, n2);
        }
        if (string.startsWith("COLUMN_")) {
            return this.tableModel.getValueAt(this.index, Integer.parseInt(string.substring(7)));
        }
        throw new JRException("Unknown column name : " + string);
    }

    public void moveFirst() {
        this.index = -1;
    }
}

