/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.query.JRJpaQueryExecuter;

public class JRJpaDataSource
extends JRAbstractBeanDataSource
implements JRRewindableDataSource {
    private static final String MAPPING_INDEX_PREFIX = "COLUMN_";
    private static final int MAPPING_INDEX_PREFIX_LENGTH = "COLUMN_".length();
    private static final String MAPPING_INDEX_PROPERTY_SEP = ".";
    private static final int MAPPING_INDEX_PROPERTY_SEP_LENGTH = ".".length();
    private final JRJpaQueryExecuter queryExecuter;
    private final int pageSize;
    private int pageCount;
    private boolean nextPage;
    private List returnValues;
    private Iterator iterator;
    public Object currentRow;
    private Map fieldValueReaders;

    public JRJpaDataSource(JRJpaQueryExecuter jRJpaQueryExecuter, int n2) {
        super(true);
        this.queryExecuter = jRJpaQueryExecuter;
        this.pageSize = n2;
        this.fieldValueReaders = new HashMap();
        this.pageCount = 0;
        this.fetchPage();
    }

    public void fetchPage() {
        if (this.pageSize <= 0) {
            this.returnValues = this.queryExecuter.getResultList();
            this.nextPage = false;
        } else {
            this.returnValues = this.queryExecuter.getResultList(this.pageCount * this.pageSize, this.pageSize);
            this.nextPage = this.returnValues.size() == this.pageSize;
        }
        ++this.pageCount;
        this.initIterator();
    }

    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean bl2 = this.iterator.hasNext();
        if (!bl2 && this.nextPage) {
            this.fetchPage();
            boolean bl3 = bl2 = this.iterator != null && this.iterator.hasNext();
        }
        if (bl2) {
            this.currentRow = this.iterator.next();
        }
        return bl2;
    }

    public void moveFirst() {
        if (this.pageCount == 1) {
            this.initIterator();
        } else {
            this.pageCount = 0;
            this.fetchPage();
        }
    }

    private void initIterator() {
        this.iterator = this.returnValues == null ? null : this.returnValues.iterator();
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        FieldValueReader fieldValueReader = this.getFieldValueReader(jRField);
        return fieldValueReader.getValue();
    }

    public FieldValueReader getFieldValueReader(JRField jRField) {
        FieldValueReader fieldValueReader = (FieldValueReader)this.fieldValueReaders.get(jRField.getName());
        if (fieldValueReader == null) {
            String string = this.getPropertyName(jRField);
            fieldValueReader = this.createReader(string);
            this.fieldValueReaders.put(jRField.getName(), fieldValueReader);
        }
        return fieldValueReader;
    }

    private FieldValueReader createReader(String string) {
        FieldValueReader fieldValueReader = null;
        if (string.startsWith(MAPPING_INDEX_PREFIX)) {
            int n2 = string.indexOf(MAPPING_INDEX_PROPERTY_SEP, MAPPING_INDEX_PREFIX_LENGTH + 1);
            if (n2 < 0) {
                String string2 = string.substring(MAPPING_INDEX_PREFIX_LENGTH);
                try {
                    int n3 = Integer.parseInt(string2);
                    fieldValueReader = new IndexReader(this, n3 - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                String string3 = string.substring(MAPPING_INDEX_PREFIX_LENGTH, n2);
                try {
                    int n4 = Integer.parseInt(string3);
                    String string4 = string.substring(n2 + MAPPING_INDEX_PROPERTY_SEP_LENGTH);
                    fieldValueReader = new IndexPropertyReader(this, n4 - 1, string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (fieldValueReader == null) {
            fieldValueReader = new PropertyReader(this, string);
        }
        return fieldValueReader;
    }

    protected class IndexPropertyReader
    implements FieldValueReader {
        private final int position;
        private final String property;
        private final JRJpaDataSource this$0;

        public IndexPropertyReader(JRJpaDataSource jRJpaDataSource, int n2, String string) {
            this.this$0 = jRJpaDataSource;
            this.position = n2;
            this.property = string;
        }

        public Object getValue() throws JRException {
            Object[] objectArray = (Object[])this.this$0.currentRow;
            if (this.position < 0 || this.position >= objectArray.length) {
                throw new JRRuntimeException("Index " + this.position + " out of bounds for query result of length " + objectArray.length);
            }
            return JRAbstractBeanDataSource.getBeanProperty(objectArray[this.position], this.property);
        }
    }

    protected class IndexReader
    implements FieldValueReader {
        private final int position;
        private final JRJpaDataSource this$0;

        public IndexReader(JRJpaDataSource jRJpaDataSource, int n2) {
            this.this$0 = jRJpaDataSource;
            this.position = n2;
        }

        public Object getValue() throws JRException {
            Object[] objectArray = (Object[])this.this$0.currentRow;
            if (this.position < 0 || this.position >= objectArray.length) {
                throw new JRRuntimeException("Index " + this.position + " out of bounds for query result of length " + objectArray.length);
            }
            return objectArray[this.position];
        }
    }

    protected class PropertyReader
    implements FieldValueReader {
        private final String property;
        private final JRJpaDataSource this$0;

        public PropertyReader(JRJpaDataSource jRJpaDataSource, String string) {
            this.this$0 = jRJpaDataSource;
            this.property = string;
        }

        public Object getValue() throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(this.this$0.currentRow, this.property);
        }
    }

    protected static interface FieldValueReader {
        public Object getValue() throws JRException;
    }
}

