/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRCsvDataSource
implements JRDataSource {
    private DateFormat dateFormat = new SimpleDateFormat();
    private NumberFormat numberFormat = new DecimalFormat();
    private char fieldDelimiter = (char)44;
    private String recordDelimiter = "\n";
    private HashMap columnNames = new HashMap();
    private boolean useFirstRowAsHeader;
    private Vector fields;
    private Reader reader;
    private char[] buffer = new char[1024];
    private int position;
    private int bufSize;
    private boolean processingStarted;
    public static Class c;
    public static Class n;
    public static Class d;
    public static Class l;
    public static Class g;
    public static Class j;
    public static Class a;
    public static Class i;
    public static Class b;
    public static Class k;
    public static Class m;
    public static Class e;
    public static Class f;
    public static Class h;

    public JRCsvDataSource(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public JRCsvDataSource(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(inputStream, string)));
    }

    public JRCsvDataSource(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public JRCsvDataSource(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), string);
    }

    public JRCsvDataSource(Reader reader) {
        this.reader = reader;
    }

    public boolean next() throws JRException {
        try {
            if (!this.processingStarted) {
                if (this.useFirstRowAsHeader) {
                    this.parseRow();
                    for (int i2 = 0; i2 < this.fields.size(); ++i2) {
                        String string = (String)this.fields.get(i2);
                        this.columnNames.put(string, new Integer(i2));
                    }
                }
                this.processingStarted = true;
            }
            return this.parseRow();
        }
        catch (IOException iOException) {
            throw new JRException(iOException);
        }
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String string = jRField.getName();
        Integer n2 = (Integer)this.columnNames.get(string);
        if (n2 == null && string.startsWith("COLUMN_")) {
            n2 = Integer.valueOf(string.substring(7));
        }
        if (n2 == null) {
            throw new JRException("Unknown column name : " + string);
        }
        if (this.fields.size() > n2) {
            String string2 = (String)this.fields.get(n2);
            Class clazz = jRField.getValueClass();
            if (clazz.equals(c == null ? (c = JRCsvDataSource.a("java.lang.String")) : c)) {
                return string2;
            }
            if ((string2 = string2.trim()).length() == 0) {
                return null;
            }
            try {
                if (clazz.equals(n == null ? (n = JRCsvDataSource.a("java.lang.Boolean")) : n)) {
                    return string2.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (clazz.equals(d == null ? (d = JRCsvDataSource.a("java.lang.Byte")) : d)) {
                    return new Byte(this.numberFormat.parse(string2).byteValue());
                }
                if (clazz.equals(l == null ? (l = JRCsvDataSource.a("java.lang.Integer")) : l)) {
                    return new Integer(this.numberFormat.parse(string2).intValue());
                }
                if (clazz.equals(g == null ? (g = JRCsvDataSource.a("java.lang.Long")) : g)) {
                    return new Long(this.numberFormat.parse(string2).longValue());
                }
                if (clazz.equals(j == null ? (j = JRCsvDataSource.a("java.lang.Short")) : j)) {
                    return new Short(this.numberFormat.parse(string2).shortValue());
                }
                if (clazz.equals(a == null ? (a = JRCsvDataSource.a("java.lang.Double")) : a)) {
                    return new Double(this.numberFormat.parse(string2).doubleValue());
                }
                if (clazz.equals(i == null ? (i = JRCsvDataSource.a("java.lang.Float")) : i)) {
                    return new Float(this.numberFormat.parse(string2).floatValue());
                }
                if (clazz.equals(b == null ? (b = JRCsvDataSource.a("java.math.BigDecimal")) : b)) {
                    return new BigDecimal(this.numberFormat.parse(string2).toString());
                }
                if (clazz.equals(k == null ? (k = JRCsvDataSource.a("java.math.BigInteger")) : k)) {
                    return new BigInteger(String.valueOf(this.numberFormat.parse(string2).longValue()));
                }
                if (clazz.equals(m == null ? (m = JRCsvDataSource.a("java.lang.Number")) : m)) {
                    return this.numberFormat.parse(string2);
                }
                if (clazz.equals(e == null ? (e = JRCsvDataSource.a("java.util.Date")) : e)) {
                    return this.dateFormat.parse(string2);
                }
                if (clazz.equals(f == null ? (f = JRCsvDataSource.a("java.sql.Timestamp")) : f)) {
                    return new Timestamp(this.dateFormat.parse(string2).getTime());
                }
                if (clazz.equals(h == null ? (h = JRCsvDataSource.a("java.sql.Time")) : h)) {
                    return new Time(this.dateFormat.parse(string2).getTime());
                }
                throw new JRException("Field '" + jRField.getName() + "' is of class '" + clazz.getName() + "' and can not be converted");
            }
            catch (Exception exception) {
                throw new JRException("Unable to get value for field '" + jRField.getName() + "' of class '" + clazz.getName() + "'", exception);
            }
        }
        return null;
    }

    private boolean parseRow() throws IOException {
        String string;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.fields = new Vector();
        String string2 = this.getRow();
        if (string2 == null) {
            return false;
        }
        while (n2 < string2.length()) {
            char c2 = string2.charAt(n2);
            if (c2 == '\"') {
                if (!bl2) {
                    if (!bl3) {
                        bl2 = true;
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                } else if (n2 + 1 < string2.length() && string2.charAt(n2 + 1) == '\"') {
                    ++n2;
                } else {
                    bl2 = false;
                }
            }
            if (c2 == this.fieldDelimiter && !bl2) {
                string = string2.substring(n3, n2);
                if (bl4) {
                    bl4 = false;
                    bl3 = false;
                    string = "";
                } else if (bl3) {
                    if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
                        string = string.substring(1, string.length() - 1);
                        string = this.replaceAll(string, "\"\"", "\"");
                    } else {
                        string = "";
                    }
                    bl3 = false;
                }
                this.fields.add(string);
                n3 = n2 + 1;
            }
            if (++n2 != string2.length() || !bl2) continue;
            string2 = string2 + this.recordDelimiter + this.getRow();
        }
        string = string2.substring(n3, n2);
        if (string == null) {
            return true;
        }
        if (bl4) {
            string = "";
        } else if (bl3) {
            if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
                string = this.replaceAll(string, "\"\"", "\"");
            } else {
                string = "";
            }
        }
        this.fields.add(string);
        return true;
    }

    private String getRow() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                char c2;
                if ((c2 = this.getChar()) == this.recordDelimiter.charAt(0)) {
                    int n2;
                    char[] cArray = new char[this.recordDelimiter.length()];
                    cArray[0] = c2;
                    boolean bl2 = true;
                    for (n2 = 1; n2 < this.recordDelimiter.length() && bl2; ++n2) {
                        cArray[n2] = this.getChar();
                        if (cArray[n2] == this.recordDelimiter.charAt(n2)) continue;
                        bl2 = false;
                    }
                    if (bl2) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray, 0, n2);
                }
                stringBuffer.append(c2);
            }
        }
        catch (JRException jRException) {
            if (stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }
    }

    private char getChar() throws IOException, JRException {
        if (this.position + 1 > this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            this.position = 0;
            if (this.bufSize == -1) {
                throw new JRException("No more chars");
            }
        }
        return this.buffer[this.position++];
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char c2) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.fieldDelimiter = c2;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String string) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.recordDelimiter = string;
    }

    public void setColumnNames(String[] stringArray) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.columnNames.put(stringArray[i2], new Integer(i2));
        }
    }

    public void setUseFirstRowAsHeader(boolean bl2) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.useFirstRowAsHeader = bl2;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(string2);
        int n3 = 0;
        while (n2 >= 0) {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(string3);
            n3 = n2 += string2.length();
            n2 = string.indexOf(string2, n2);
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3, string.length()));
        }
        return stringBuffer.toString();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

