/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    public static final String CURRENT_BEAN_MAPPING = "_THIS";
    public PropertyNameProvider propertyNameProvider = null;
    public static final PropertyNameProvider FIELD_NAME_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        public String getPropertyName(JRField jRField) {
            return jRField.getName();
        }
    };
    public static final PropertyNameProvider FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        public String getPropertyName(JRField jRField) {
            if (jRField.getDescription() == null) {
                return jRField.getName();
            }
            return jRField.getDescription();
        }
    };

    public JRAbstractBeanDataSource(boolean bl2) {
        this.propertyNameProvider = bl2 ? FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER : FIELD_NAME_PROPERTY_NAME_PROVIDER;
    }

    public Object getFieldValue(Object object, JRField jRField) throws JRException {
        return JRAbstractBeanDataSource.getBeanProperty(object, this.getPropertyName(jRField));
    }

    public static Object getBeanProperty(Object object, String string) throws JRException {
        Object object2;
        block8: {
            object2 = null;
            if (JRAbstractBeanDataSource.isCurrentBeanMapping(string)) {
                object2 = object;
            } else if (object != null) {
                try {
                    object2 = PropertyUtils.getProperty(object, string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JRException("Error retrieving field value from bean : " + string, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new JRException("Error retrieving field value from bean : " + string, invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JRException("Error retrieving field value from bean : " + string, noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage().startsWith("Null property value for ")) break block8;
                    throw illegalArgumentException;
                }
            }
        }
        return object2;
    }

    public static boolean isCurrentBeanMapping(String string) {
        return CURRENT_BEAN_MAPPING.equals(string);
    }

    public String getPropertyName(JRField jRField) {
        return this.propertyNameProvider.getPropertyName(jRField);
    }

    public static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

