/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.TextElementConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class TextFieldConverter
extends TextElementConverter {
    private static final TextFieldConverter INSTANCE = new TextFieldConverter();

    private TextFieldConverter() {
    }

    public static TextFieldConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement jRElement) {
        JRBasePrintText jRBasePrintText = new JRBasePrintText(reportConverter.getDefaultStyleProvider());
        JRTextField jRTextField = (JRTextField)jRElement;
        this.copyTextElement(reportConverter, jRTextField, jRBasePrintText);
        jRBasePrintText.setStyledText(false);
        jRBasePrintText.setAnchorName(JRExpressionUtil.getExpressionText(jRTextField.getAnchorNameExpression()));
        jRBasePrintText.setBookmarkLevel(jRTextField.getBookmarkLevel());
        jRBasePrintText.setLinkType(jRTextField.getLinkType());
        jRBasePrintText.setPattern(jRTextField.getOwnPattern());
        jRBasePrintText.setText(JRExpressionUtil.getExpressionText(jRTextField.getExpression()));
        this.measureTextElement(jRBasePrintText);
        return jRBasePrintText;
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText) {
        String string = jRPrintText.getText();
        if (string == null) {
            string = "";
        }
        Map map = JRStyledTextAttributeSelector.NO_BACKCOLOR.getStyledTextAttributes(jRPrintText);
        JRStyledText jRStyledText = new JRStyledText();
        jRStyledText.append(string);
        jRStyledText.setGlobalAttributes(map);
        return jRStyledText;
    }
}

