/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Image;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;

public class ImageConverter
extends ElementConverter {
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement jRElement) {
        JRBasePrintImage jRBasePrintImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage jRImage = (JRImage)jRElement;
        this.copyGraphicElement(reportConverter, jRImage, jRBasePrintImage);
        jRBasePrintImage.copyBox(jRImage.getLineBox());
        jRBasePrintImage.setAnchorName(JRExpressionUtil.getExpressionText(jRImage.getAnchorNameExpression()));
        jRBasePrintImage.setBookmarkLevel(jRImage.getBookmarkLevel());
        jRBasePrintImage.setHorizontalAlignment(jRImage.getOwnHorizontalAlignment());
        jRBasePrintImage.setLazy(jRImage.isLazy());
        jRBasePrintImage.setLinkType(jRImage.getLinkType());
        jRBasePrintImage.setOnErrorType(jRImage.getOnErrorType());
        jRBasePrintImage.setVerticalAlignment(jRImage.getOwnVerticalAlignment());
        jRBasePrintImage.setRenderer(this.getRenderer(jRImage));
        jRBasePrintImage.setScaleImage(jRImage.getOwnScaleImage());
        return jRBasePrintImage;
    }

    private JRRenderable getRenderer(JRImage jRImage) {
        JRRenderable jRRenderable = null;
        Image image = null;
        String string = JRExpressionUtil.getSimpleExpressionText(jRImage.getExpression());
        if (string != null) {
            try {
                image = JRImageLoader.loadImage(JRLoader.loadBytesFromLocation(string));
                if (image == null) {
                    image = JRImageLoader.getImage((byte)1);
                    jRImage.setScaleImage((byte)1);
                    jRImage.setStretchType((byte)0);
                }
                jRRenderable = JRImageRenderer.getInstance(image, jRImage.getOnErrorType());
                return jRRenderable;
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
            }
        }
        try {
            image = JRImageLoader.getImage((byte)1);
            jRRenderable = JRImageRenderer.getInstance(image, jRImage.getOnErrorType());
            jRImage.setScaleImage((byte)1);
            jRImage.setStretchType((byte)0);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        return jRRenderable;
    }
}

