/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignFrame;

public class CrosstabConverter
extends FrameConverter {
    private static final CrosstabConverter INSTANCE = new CrosstabConverter();

    private CrosstabConverter() {
    }

    public static ElementConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement jRElement) {
        JRBasePrintFrame jRBasePrintFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        JRCrosstab jRCrosstab = (JRCrosstab)jRElement;
        this.copyElement(reportConverter, jRCrosstab, jRBasePrintFrame);
        List list = this.getCrosstabChildren(reportConverter, jRCrosstab);
        if (list != null && list.size() > 0) {
            ConvertVisitor convertVisitor = new ConvertVisitor(reportConverter, jRBasePrintFrame);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((JRChild)list.get(i2)).visit(convertVisitor);
            }
        }
        return jRBasePrintFrame;
    }

    private List getCrosstabChildren(ReportConverter reportConverter, JRCrosstab jRCrosstab) {
        ArrayList<JRFrame> arrayList = new ArrayList<JRFrame>();
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        int n2 = 0;
        for (int i2 = 0; i2 < jRCrosstabRowGroupArray.length; ++i2) {
            n2 += jRCrosstabRowGroupArray[i2].getWidth();
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        int n3 = 0;
        for (int i3 = 0; i3 < jRCrosstabColumnGroupArray.length; ++i3) {
            n3 += jRCrosstabColumnGroupArray[i3].getHeight();
        }
        JRCellContents jRCellContents = jRCrosstab.getHeaderCell();
        if (jRCellContents != null && jRCellContents.getWidth() != 0 && jRCellContents.getHeight() != 0) {
            arrayList.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, 0, 0, false, false, false));
        }
        this.addCrosstabColumnHeaders(reportConverter, jRCrosstab, n2, arrayList);
        this.addCrosstabRows(reportConverter, jRCrosstab, n2, n3, arrayList);
        if (jRCrosstab.getRunDirection() == 1) {
            this.mirrorElements(arrayList, jRCrosstab.getX(), jRCrosstab.getWidth());
        }
        return arrayList;
    }

    private void mirrorElements(List list, int n2, int n3) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRElement jRElement = (JRElement)iterator.next();
            int n4 = 2 * n2 + n3 - jRElement.getX() - jRElement.getWidth();
            jRElement.setX(n4);
        }
    }

    private JRFrame getCrosstabCellFrame(ReportConverter reportConverter, JRCellContents jRCellContents, int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
        List list;
        JRDesignFrame jRDesignFrame = new JRDesignFrame(jRCellContents.getDefaultStyleProvider());
        jRDesignFrame.setX(n2);
        jRDesignFrame.setY(n3);
        jRDesignFrame.setWidth(jRCellContents.getWidth());
        jRDesignFrame.setHeight(jRCellContents.getHeight());
        jRDesignFrame.setMode(jRCellContents.getMode());
        jRDesignFrame.setBackcolor(jRCellContents.getBackcolor());
        jRDesignFrame.setStyle(reportConverter.resolveStyle(jRCellContents));
        JRLineBox jRLineBox = jRCellContents.getLineBox();
        if (jRLineBox != null) {
            boolean bl5;
            jRDesignFrame.copyBox(jRLineBox);
            boolean bl6 = bl2 && jRLineBox.getLeftPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getRightPen().getLineWidth().floatValue() > 0.0f;
            boolean bl7 = bl3 && jRLineBox.getRightPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getLeftPen().getLineWidth().floatValue() > 0.0f;
            boolean bl8 = bl5 = bl4 && jRLineBox.getTopPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getBottomPen().getLineWidth().floatValue() > 0.0f;
            if (bl6) {
                ((JRBaseLineBox)jRDesignFrame.getLineBox()).copyLeftPen(jRLineBox.getRightPen());
            }
            if (bl7) {
                ((JRBaseLineBox)jRDesignFrame.getLineBox()).copyRightPen(jRLineBox.getLeftPen());
            }
            if (bl5) {
                ((JRBaseLineBox)jRDesignFrame.getLineBox()).copyTopPen(jRLineBox.getBottomPen());
            }
        }
        if ((list = jRCellContents.getChildren()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRChild jRChild = (JRChild)iterator.next();
                if (jRChild instanceof JRElement) {
                    jRDesignFrame.addElement((JRElement)jRChild);
                    continue;
                }
                if (!(jRChild instanceof JRElementGroup)) continue;
                jRDesignFrame.addElementGroup((JRElementGroup)jRChild);
            }
        }
        return jRDesignFrame;
    }

    private void addCrosstabColumnHeaders(ReportConverter reportConverter, JRCrosstab jRCrosstab, int n2, List list) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < jRCrosstabColumnGroupArray.length; ++i2) {
            JRCellContents jRCellContents;
            boolean bl2;
            JRCellContents jRCellContents2;
            JRCrosstabColumnGroup jRCrosstabColumnGroup = jRCrosstabColumnGroupArray[i2];
            if (jRCrosstabColumnGroup.getTotalPosition() == 1 && (jRCellContents2 = jRCrosstabColumnGroup.getTotalHeader()).getWidth() != 0 && jRCellContents2.getHeight() != 0) {
                bl2 = n3 == 0 && jRCrosstab.getHeaderCell() == null;
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents2, n2 + n3, n4, bl2 && jRCrosstab.getRunDirection() == 0, bl2 && jRCrosstab.getRunDirection() == 1, false));
                n3 += jRCellContents2.getWidth();
            }
            if ((jRCellContents2 = jRCrosstabColumnGroup.getHeader()).getWidth() != 0 && jRCellContents2.getHeight() != 0) {
                bl2 = n3 == 0 && jRCrosstab.getHeaderCell() == null;
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents2, n2 + n3, n4, bl2 && jRCrosstab.getRunDirection() == 0, bl2 && jRCrosstab.getRunDirection() == 1, false));
            }
            if (jRCrosstabColumnGroup.getTotalPosition() == 2 && (jRCellContents = jRCrosstabColumnGroup.getTotalHeader()).getWidth() != 0 && jRCellContents.getHeight() != 0) {
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, n2 + n3 + jRCellContents2.getWidth(), n4, false, false, false));
            }
            n4 += jRCrosstabColumnGroup.getHeight();
        }
    }

    private void addCrosstabRows(ReportConverter reportConverter, JRCrosstab jRCrosstab, int n2, int n3, List list) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < jRCrosstabRowGroupArray.length; ++i2) {
            JRCellContents jRCellContents;
            JRCellContents jRCellContents2;
            JRCrosstabRowGroup jRCrosstabRowGroup = jRCrosstabRowGroupArray[i2];
            if (jRCrosstabRowGroup.getTotalPosition() == 1 && (jRCellContents2 = jRCrosstabRowGroup.getTotalHeader()).getWidth() != 0 && jRCellContents2.getHeight() != 0) {
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents2, n4, n3 + n5, false, false, n5 == 0 && jRCrosstab.getHeaderCell() == null));
                this.addCrosstabDataCellsRow(reportConverter, jRCrosstab, n2, n3 + n5, i2, list);
                n5 += jRCellContents2.getHeight();
            }
            if ((jRCellContents2 = jRCrosstabRowGroup.getHeader()).getWidth() != 0 && jRCellContents2.getHeight() != 0) {
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents2, n4, n3 + n5, false, false, n5 == 0 && jRCrosstab.getHeaderCell() == null));
            }
            if (i2 == jRCrosstabRowGroupArray.length - 1) {
                this.addCrosstabDataCellsRow(reportConverter, jRCrosstab, n2, n3 + n5, jRCrosstabRowGroupArray.length, list);
            }
            if (jRCrosstabRowGroup.getTotalPosition() == 2 && (jRCellContents = jRCrosstabRowGroup.getTotalHeader()).getWidth() != 0 && jRCellContents.getHeight() != 0) {
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, n4, n3 + n5 + jRCellContents2.getHeight(), false, false, false));
                this.addCrosstabDataCellsRow(reportConverter, jRCrosstab, n2, n3 + n5 + jRCellContents2.getHeight(), i2, list);
            }
            n4 += jRCrosstabRowGroup.getWidth();
        }
    }

    private void addCrosstabDataCellsRow(ReportConverter reportConverter, JRCrosstab jRCrosstab, int n2, int n3, int n4, List list) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        if (jRCrosstabCellArray != null) {
            JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
            int n5 = n2;
            int n6 = n3;
            int n7 = 0;
            for (int i2 = 0; i2 < jRCrosstabColumnGroupArray.length; ++i2) {
                JRCellContents jRCellContents;
                JRCrosstabCell jRCrosstabCell;
                JRCrosstabColumnGroup jRCrosstabColumnGroup = jRCrosstabColumnGroupArray[i2];
                if (jRCrosstabColumnGroup.getTotalPosition() == 1 && (jRCrosstabCell = jRCrosstabCellArray[n4][i2]) != null && (jRCellContents = jRCrosstabCell.getContents()).getWidth() != 0 && jRCellContents.getHeight() != 0) {
                    list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, n5 + n7, n6, false, false, false));
                    n7 += jRCrosstabCellArray[n4][i2].getContents().getWidth();
                }
                if (i2 == jRCrosstabColumnGroupArray.length - 1 && (jRCrosstabCell = jRCrosstabCellArray[n4][jRCrosstabColumnGroupArray.length]) != null && (jRCellContents = jRCrosstabCell.getContents()).getWidth() != 0 && jRCellContents.getHeight() != 0) {
                    list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, n5 + n7, n6, false, false, false));
                }
                if (jRCrosstabColumnGroup.getTotalPosition() != 2 || (jRCrosstabCell = jRCrosstabCellArray[n4][i2]) == null || (jRCellContents = jRCrosstabCell.getContents()).getWidth() == 0 || jRCellContents.getHeight() == 0) continue;
                list.add(this.getCrosstabCellFrame(reportConverter, jRCellContents, n5 + n7 + jRCrosstabColumnGroup.getHeader().getWidth(), n6, false, false, false));
            }
        }
    }
}

