/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;

public class JasperPrint
implements Serializable,
JRPropertiesHolder {
    private static final long serialVersionUID = 10200L;
    private String name = null;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private byte orientation = 1;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private Map originsMap = new HashMap();
    private List originsList = new ArrayList();
    private List pages = new ArrayList();
    private transient Map anchorIndexes = null;
    private DefaultStyleProvider defaultStyleProvider = new DefaultStyleProvider(null, null);
    private String formatFactoryClass;
    private String localeCode;
    private String timeZoneId;
    private JRPropertiesMap propertiesMap = new JRPropertiesMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int n2) {
        this.pageWidth = n2;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int n2) {
        this.pageHeight = n2;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte by2) {
        this.orientation = by2;
    }

    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public String[] getPropertyNames() {
        return this.propertiesMap.getPropertyNames();
    }

    public String getProperty(String string) {
        return this.propertiesMap.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.propertiesMap.setProperty(string, string2);
    }

    public void removeProperty(String string) {
        this.propertiesMap.removeProperty(string);
    }

    public JRReportFont getDefaultFont() {
        return this.defaultStyleProvider.getDefaultFont();
    }

    public void setDefaultFont(JRReportFont jRReportFont) {
        this.defaultStyleProvider.a(jRReportFont);
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultStyleProvider;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] jRReportFontArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(jRReportFontArray);
        return jRReportFontArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public synchronized void addFont(JRReportFont jRReportFont) throws JRException {
        this.addFont(jRReportFont, false);
    }

    public synchronized void addFont(JRReportFont jRReportFont, boolean bl2) throws JRException {
        if (this.fontsMap.containsKey(jRReportFont.getName())) {
            if (!bl2) {
                throw new JRException("Duplicate declaration of report font : " + jRReportFont.getName());
            }
        } else {
            this.fontsList.add(jRReportFont);
            this.fontsMap.put(jRReportFont.getName(), jRReportFont);
            if (jRReportFont.isDefault()) {
                this.setDefaultFont(jRReportFont);
            }
        }
    }

    public synchronized JRReportFont removeFont(String string) {
        return this.removeFont((JRReportFont)this.fontsMap.get(string));
    }

    public synchronized JRReportFont removeFont(JRReportFont jRReportFont) {
        if (jRReportFont != null) {
            if (jRReportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(jRReportFont);
            this.fontsMap.remove(jRReportFont.getName());
        }
        return jRReportFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyleProvider.getDefaultStyle();
    }

    public synchronized void setDefaultStyle(JRStyle jRStyle) {
        this.defaultStyleProvider.a(jRStyle);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle[] getStyles() {
        JRStyle[] jRStyleArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(jRStyleArray);
        return jRStyleArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public synchronized void addStyle(JRStyle jRStyle) throws JRException {
        this.addStyle(jRStyle, false);
    }

    public synchronized void addStyle(JRStyle jRStyle, boolean bl2) throws JRException {
        if (this.stylesMap.containsKey(jRStyle.getName())) {
            if (!bl2) {
                throw new JRException("Duplicate declaration of report style : " + jRStyle.getName());
            }
        } else {
            this.stylesList.add(jRStyle);
            this.stylesMap.put(jRStyle.getName(), jRStyle);
            if (jRStyle.isDefault()) {
                this.setDefaultStyle(jRStyle);
            }
        }
    }

    public synchronized JRStyle removeStyle(String string) {
        return this.removeStyle((JRStyle)this.stylesMap.get(string));
    }

    public synchronized JRStyle removeStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            if (jRStyle.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(jRStyle);
            this.stylesMap.remove(jRStyle.getName());
        }
        return jRStyle;
    }

    public JROrigin[] getOrigins() {
        return this.originsList.toArray(new JROrigin[this.originsList.size()]);
    }

    public List getOriginsList() {
        return this.originsList;
    }

    public Map getOriginsMap() {
        return this.originsMap;
    }

    public synchronized void addOrigin(JROrigin jROrigin) {
        if (!this.originsMap.containsKey(jROrigin)) {
            this.originsList.add(jROrigin);
            this.originsMap.put(jROrigin, new Integer(this.originsList.size() - 1));
        }
    }

    public synchronized JROrigin removeOrigin(JROrigin jROrigin) {
        if (this.originsMap.containsKey(jROrigin)) {
            this.originsList.remove(jROrigin);
            this.originsMap = new HashMap();
            for (int i2 = 0; i2 < this.originsList.size(); ++i2) {
                this.originsMap.put(this.originsList.get(i2), new Integer(i2));
            }
        }
        return jROrigin;
    }

    public List getPages() {
        return this.pages;
    }

    public synchronized void addPage(JRPrintPage jRPrintPage) {
        this.anchorIndexes = null;
        this.pages.add(jRPrintPage);
    }

    public synchronized void addPage(int n2, JRPrintPage jRPrintPage) {
        this.anchorIndexes = null;
        this.pages.add(n2, jRPrintPage);
    }

    public synchronized JRPrintPage removePage(int n2) {
        this.anchorIndexes = null;
        return (JRPrintPage)this.pages.remove(n2);
    }

    public synchronized Map getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap();
            int n2 = 0;
            Iterator iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                JRPrintPage jRPrintPage = (JRPrintPage)iterator.next();
                List list = jRPrintPage.getElements();
                this.collectAnchors(list, n2, 0, 0);
                ++n2;
            }
        }
        return this.anchorIndexes;
    }

    public void collectAnchors(Collection collection, int n2, int n3, int n4) {
        if (collection != null && collection.size() > 0) {
            JRPrintElement jRPrintElement = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                jRPrintElement = (JRPrintElement)iterator.next();
                if (jRPrintElement instanceof JRPrintAnchor) {
                    this.anchorIndexes.put(((JRPrintAnchor)((Object)jRPrintElement)).getAnchorName(), new JRPrintAnchorIndex(n2, jRPrintElement, n3, n4));
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
                this.collectAnchors(jRPrintFrame.getElements(), n2, n3 + jRPrintFrame.getX(), n4 + jRPrintFrame.getY());
            }
        }
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String string) {
        this.formatFactoryClass = string;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String string) {
        this.localeCode = string;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String string) {
        this.timeZoneId = string;
    }

    private static class DefaultStyleProvider
    implements JRDefaultStyleProvider,
    Serializable {
        private static final long serialVersionUID = 10200L;
        private JRReportFont defaultFont;
        private JRStyle defaultStyle;

        public DefaultStyleProvider(JRReportFont jRReportFont, JRStyle jRStyle) {
            this.defaultFont = jRReportFont;
            this.defaultStyle = jRStyle;
        }

        public JRReportFont getDefaultFont() {
            return this.defaultFont;
        }

        public void a(JRReportFont jRReportFont) {
            this.defaultFont = jRReportFont;
        }

        public JRStyle getDefaultStyle() {
            return this.defaultStyle;
        }

        public void a(JRStyle jRStyle) {
            this.defaultStyle = jRStyle;
        }
    }
}

