/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;

public class BucketingService {
    public static final String PROPERTY_BUCKET_MEASURE_LIMIT = "net.sf.jasperreports.crosstab.bucket.measure.limit";
    public static final byte DIMENSION_ROW = 0;
    public static final byte DIMENSION_COLUMN = 1;
    public static final int DIMENSIONS = 2;
    public final BucketDefinition[] allBuckets;
    public final BucketDefinition[][] buckets;
    public final int rowBucketCount;
    public final int colBucketCount;
    public final boolean[][] retrieveTotal;
    private boolean[] rowRetrTotals;
    private int rowRetrTotalMin;
    private int rowRetrTotalMax;
    private int[] rowRetrColMax;
    public final MeasureDefinition[] measures;
    public final int origMeasureCount;
    public final int[] measureIndexes;
    public final boolean sorted;
    public final BucketMap bucketValueMap;
    public long dataCount;
    public boolean processed;
    public HeaderCell[][] colHeaders;
    public HeaderCell[][] rowHeaders;
    public CrosstabCell[][] cells;
    private final MeasureDefinition.MeasureValue[] zeroUserMeasureValues;
    private final int bucketMeasureLimit;
    private int runningBucketMeasureCount = 0;

    public BucketingService(List list, List list2, List list3, boolean bl2, boolean[][] blArray) {
        int n2;
        this.sorted = bl2;
        this.buckets = new BucketDefinition[2][];
        this.rowBucketCount = list.size();
        this.buckets[0] = new BucketDefinition[this.rowBucketCount];
        list.toArray(this.buckets[0]);
        this.colBucketCount = list2.size();
        this.buckets[1] = new BucketDefinition[this.colBucketCount];
        list2.toArray(this.buckets[1]);
        this.allBuckets = new BucketDefinition[this.rowBucketCount + this.colBucketCount];
        System.arraycopy(this.buckets[0], 0, this.allBuckets, 0, this.rowBucketCount);
        System.arraycopy(this.buckets[1], 0, this.allBuckets, this.rowBucketCount, this.colBucketCount);
        this.origMeasureCount = list3.size();
        ArrayList arrayList = new ArrayList(list3.size() * 2);
        ArrayList arrayList2 = new ArrayList(list3.size() * 2);
        for (n2 = 0; n2 < list3.size(); ++n2) {
            MeasureDefinition measureDefinition = (MeasureDefinition)list3.get(n2);
            this.addMeasure(measureDefinition, n2, arrayList, arrayList2);
        }
        this.measures = new MeasureDefinition[arrayList.size()];
        arrayList.toArray(this.measures);
        this.measureIndexes = new int[arrayList2.size()];
        for (n2 = 0; n2 < this.measureIndexes.length; ++n2) {
            this.measureIndexes[n2] = (Integer)arrayList2.get(n2);
        }
        this.retrieveTotal = blArray;
        this.checkTotals();
        this.bucketValueMap = this.createBucketMap(0);
        this.zeroUserMeasureValues = this.initUserMeasureValues();
        this.bucketMeasureLimit = JRProperties.getIntegerProperty(PROPERTY_BUCKET_MEASURE_LIMIT, 0);
    }

    public void checkTotals() {
        int n2;
        int n3;
        this.rowRetrTotalMin = this.rowBucketCount + 1;
        this.rowRetrTotalMax = -1;
        this.rowRetrTotals = new boolean[this.rowBucketCount + 1];
        this.rowRetrColMax = new int[this.rowBucketCount + 1];
        for (n3 = 0; n3 <= this.rowBucketCount; ++n3) {
            this.rowRetrColMax[n3] = -1;
            boolean bl2 = false;
            for (n2 = 0; n2 <= this.colBucketCount; ++n2) {
                if (!this.retrieveTotal[n3][n2]) continue;
                bl2 = true;
                this.rowRetrColMax[n3] = n2;
            }
            this.rowRetrTotals[n3] = bl2;
            if (!bl2) continue;
            if (n3 < this.rowRetrTotalMin) {
                this.rowRetrTotalMin = n3;
            }
            this.rowRetrTotalMax = n3;
            if (n3 >= this.rowBucketCount) continue;
            this.allBuckets[n3].setComputeTotal();
        }
        for (n3 = 0; n3 < this.colBucketCount; ++n3) {
            BucketDefinition bucketDefinition = this.allBuckets[this.rowBucketCount + n3];
            if (bucketDefinition.computeTotal()) continue;
            n2 = 0;
            for (int i2 = 0; n2 == 0 && i2 <= this.rowBucketCount; ++i2) {
                n2 = this.retrieveTotal[i2][n3];
            }
            if (n2 == 0) continue;
            bucketDefinition.setComputeTotal();
        }
        for (n3 = 0; n3 < 2; ++n3) {
            boolean bl3 = false;
            for (n2 = 0; n2 < this.buckets[n3].length; ++n2) {
                if (bl3) {
                    this.buckets[n3][n2].setComputeTotal();
                    continue;
                }
                bl3 = this.buckets[n3][n2].computeTotal();
            }
        }
    }

    public void clear() {
        this.bucketValueMap.b();
        this.processed = false;
        this.dataCount = 0L;
        this.runningBucketMeasureCount = 0;
    }

    public BucketMap createBucketMap(int n2) {
        BucketMap bucketMap = this.sorted ? new BucketListMap(this, n2, false) : new BucketTreeMap(this, n2);
        return bucketMap;
    }

    public BucketListMap createCollectBucketMap(int n2) {
        return new BucketListMap(this, n2, true);
    }

    public void addMeasure(MeasureDefinition measureDefinition, int n2, List list, List list2) {
        switch (measureDefinition.getCalculation()) {
            case 3: 
            case 7: {
                MeasureDefinition measureDefinition2 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)2);
                this.addMeasure(measureDefinition2, n2, list, list2);
                MeasureDefinition measureDefinition3 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)1);
                this.addMeasure(measureDefinition3, n2, list, list2);
                break;
            }
            case 6: {
                MeasureDefinition measureDefinition4 = MeasureDefinition.createHelperMeasure(measureDefinition, (byte)7);
                this.addMeasure(measureDefinition4, n2, list, list2);
                break;
            }
            case 10: {
                MeasureDefinition measureDefinition5 = MeasureDefinition.createDistinctCountHelperMeasure(measureDefinition);
                this.addMeasure(measureDefinition5, n2, list, list2);
                break;
            }
        }
        list.add(measureDefinition);
        list2.add(new Integer(n2));
    }

    public void addData(Object[] objectArray, Object[] objectArray2) throws JRException {
        if (this.processed) {
            throw new JRException("Crosstab data has already been processed.");
        }
        ++this.dataCount;
        BucketDefinition.Bucket[] bucketArray = this.getBucketValues(objectArray);
        MeasureDefinition.MeasureValue[] measureValueArray = this.bucketValueMap.a(bucketArray);
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            measureValueArray[i2].addValue(objectArray2[this.measureIndexes[i2]]);
        }
    }

    public void bucketMeasuresCreated() {
        this.runningBucketMeasureCount += this.origMeasureCount;
        this.checkBucketMeasureCount(this.runningBucketMeasureCount);
    }

    public BucketDefinition.Bucket[] getBucketValues(Object[] objectArray) {
        BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.allBuckets.length];
        for (int i2 = 0; i2 < this.allBuckets.length; ++i2) {
            BucketDefinition bucketDefinition = this.allBuckets[i2];
            Object object = objectArray[i2];
            bucketArray[i2] = bucketDefinition.create(object);
        }
        return bucketArray;
    }

    public MeasureDefinition.MeasureValue[] initMeasureValues() {
        MeasureDefinition.MeasureValue[] measureValueArray = new MeasureDefinition.MeasureValue[this.measures.length];
        block5: for (int i2 = 0; i2 < this.measures.length; ++i2) {
            MeasureDefinition measureDefinition = this.measures[i2];
            measureValueArray[i2] = new MeasureDefinition.MeasureValue(measureDefinition);
            switch (measureDefinition.getCalculation()) {
                case 3: 
                case 7: {
                    measureValueArray[i2].setHelper(measureValueArray[i2 - 2], (byte)1);
                    measureValueArray[i2].setHelper(measureValueArray[i2 - 1], (byte)0);
                    continue block5;
                }
                case 6: {
                    measureValueArray[i2].setHelper(measureValueArray[i2 - 1], (byte)2);
                }
                case 10: {
                    measureValueArray[i2].setHelper(measureValueArray[i2 - 1], (byte)0);
                }
            }
        }
        return measureValueArray;
    }

    public MeasureDefinition.MeasureValue[] initUserMeasureValues() {
        MeasureDefinition.MeasureValue[] measureValueArray = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int n2 = 0;
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            if (this.measures[i2].isSystemDefined()) continue;
            measureValueArray[n2] = new MeasureDefinition.MeasureValue(this.measures[i2]);
            ++n2;
        }
        return measureValueArray;
    }

    public void processData() throws JRException {
        if (!this.processed) {
            if (this.dataCount > 0L) {
                if (this.allBuckets[this.rowBucketCount - 1].computeTotal() || this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
                    this.computeTotals(this.bucketValueMap);
                }
                this.createCrosstab();
            }
            this.processed = true;
        }
    }

    public boolean hasData() {
        return this.dataCount > 0L;
    }

    public HeaderCell[][] getColumnHeaders() {
        return this.colHeaders;
    }

    public HeaderCell[][] getRowHeaders() {
        return this.rowHeaders;
    }

    public CrosstabCell[][] getCrosstabCells() {
        return this.cells;
    }

    public MeasureDefinition.MeasureValue[] getMeasureValues(BucketDefinition.Bucket[] bucketArray) {
        BucketMap bucketMap = this.bucketValueMap;
        for (int n2 = 0; bucketMap != null && n2 < this.allBuckets.length - 1; bucketMap = (BucketMap)bucketMap.a(bucketArray[n2]), ++n2) {
        }
        return bucketMap == null ? null : (MeasureDefinition.MeasureValue[])bucketMap.a(bucketArray[this.allBuckets.length - 1]);
    }

    public MeasureDefinition.MeasureValue[] getUserMeasureValues(MeasureDefinition.MeasureValue[] measureValueArray) {
        MeasureDefinition.MeasureValue[] measureValueArray2 = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int n2 = 0;
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            if (this.measures[i2].isSystemDefined()) continue;
            measureValueArray2[n2] = measureValueArray[i2];
            ++n2;
        }
        return measureValueArray2;
    }

    public MeasureDefinition.MeasureValue[] getGrandTotals() {
        BucketMap bucketMap = this.bucketValueMap;
        for (int i2 = 0; bucketMap != null && i2 < this.allBuckets.length - 1; ++i2) {
            bucketMap = (BucketMap)bucketMap.a().getValue();
        }
        return bucketMap == null ? null : (MeasureDefinition.MeasureValue[])bucketMap.a().getValue();
    }

    public void computeTotals(BucketMap bucketMap) throws JRException {
        boolean bl2;
        boolean bl3 = bl2 = bucketMap.b >= this.rowBucketCount;
        if (bl2 && !this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
            return;
        }
        if (!bucketMap.c) {
            Iterator iterator = bucketMap.c();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.computeTotals((BucketMap)entry.getValue());
            }
        }
        if (this.allBuckets[bucketMap.b].computeTotal()) {
            if (bl2) {
                this.computeColumnTotal(bucketMap);
            } else {
                this.computeRowTotals(bucketMap);
            }
        }
    }

    public void sumVals(MeasureDefinition.MeasureValue[] measureValueArray, MeasureDefinition.MeasureValue[] measureValueArray2) throws JRException {
        for (int i2 = 0; i2 < this.measures.length; ++i2) {
            measureValueArray[i2].addValue(measureValueArray2[i2]);
        }
    }

    public void computeColumnTotal(BucketMap bucketMap) throws JRException {
        MeasureDefinition.MeasureValue[] measureValueArray = this.initMeasureValues();
        Iterator iterator = bucketMap.c();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            for (int i2 = bucketMap.b + 1; i2 < this.allBuckets.length; ++i2) {
                entry = ((BucketMap)entry.getValue()).a();
            }
            this.sumVals(measureValueArray, (MeasureDefinition.MeasureValue[])entry.getValue());
        }
        for (int i3 = bucketMap.b + 1; i3 < this.allBuckets.length; ++i3) {
            bucketMap = bucketMap.d();
        }
        bucketMap.a(measureValueArray);
    }

    public void computeRowTotals(BucketMap bucketMap) throws JRException {
        BucketListMap bucketListMap = this.createCollectBucketMap(this.rowBucketCount);
        Object object = bucketMap.c();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            for (int i2 = bucketMap.b + 1; i2 < this.rowBucketCount; ++i2) {
                entry = ((BucketMap)entry.getValue()).a();
            }
            bucketListMap.a((BucketMap)entry.getValue(), true);
        }
        object = bucketMap;
        for (int i3 = bucketMap.b + 1; i3 < this.rowBucketCount; ++i3) {
            object = ((BucketMap)object).d();
        }
        ((BucketMap)object).a(bucketListMap);
    }

    public void createCrosstab() throws JRException {
        BucketListMap bucketListMap;
        int n2;
        CollectedList[] collectedListArray = new CollectedList[2];
        collectedListArray[0] = this.createHeadersList((byte)0, this.bucketValueMap, 0, false);
        if (this.allBuckets[0].computeTotal()) {
            BucketMap bucketMap = this.bucketValueMap;
            for (n2 = 0; n2 < this.rowBucketCount; ++n2) {
                bucketMap = (BucketMap)bucketMap.a().getValue();
            }
            bucketListMap = (BucketListMap)bucketMap;
        } else {
            bucketListMap = this.createCollectBucketMap(this.rowBucketCount);
            this.collectCols(bucketListMap, this.bucketValueMap);
        }
        collectedListArray[1] = this.createHeadersList((byte)1, bucketListMap, 0, false);
        int n3 = collectedListArray[0].b;
        n2 = collectedListArray[1].b;
        int n4 = n3 * n2 * this.origMeasureCount;
        this.checkBucketMeasureCount(n4);
        this.colHeaders = this.createHeaders((byte)1, collectedListArray);
        this.rowHeaders = this.createHeaders((byte)0, collectedListArray);
        this.cells = new CrosstabCell[n3][n2];
        this.fillCells(collectedListArray, this.bucketValueMap, 0, new int[]{0, 0}, new ArrayList(), new ArrayList());
    }

    public void checkBucketMeasureCount(int n2) {
        if (this.bucketMeasureLimit > 0 && n2 > this.bucketMeasureLimit) {
            throw new JRRuntimeException("Crosstab bucket/measure limit (" + this.bucketMeasureLimit + ") exceeded.");
        }
    }

    public void collectCols(BucketListMap bucketListMap, BucketMap bucketMap) throws JRException {
        if (this.allBuckets[bucketMap.b].computeTotal()) {
            BucketMap bucketMap2 = bucketMap;
            for (int i2 = bucketMap.b; i2 < this.rowBucketCount; ++i2) {
                bucketMap2 = (BucketMap)bucketMap2.a().getValue();
            }
            bucketListMap.a(bucketMap2, false);
            return;
        }
        Iterator iterator = bucketMap.c();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketMap bucketMap3 = (BucketMap)entry.getValue();
            if (bucketMap.b == this.rowBucketCount - 1) {
                bucketListMap.a(bucketMap3, false);
                continue;
            }
            this.collectCols(bucketListMap, bucketMap3);
        }
    }

    public CollectedList createHeadersList(byte by2, BucketMap bucketMap, int n2, boolean bl2) {
        CollectedList collectedList = new CollectedList();
        Iterator iterator = bucketMap.c();
        while (iterator.hasNext()) {
            CollectedList collectedList2;
            Map.Entry entry = (Map.Entry)iterator.next();
            BucketDefinition.Bucket bucket = (BucketDefinition.Bucket)entry.getKey();
            boolean bl3 = bucket.isTotal();
            byte by3 = this.allBuckets[bucketMap.b].getTotalPosition();
            boolean bl4 = !bl3 || bl2 || by3 != 0;
            if (!bl4) continue;
            if (n2 + 1 < this.buckets[by2].length) {
                BucketMap bucketMap2 = (BucketMap)entry.getValue();
                collectedList2 = this.createHeadersList(by2, bucketMap2, n2 + 1, bl2 || bl3);
            } else {
                collectedList2 = new CollectedList();
                collectedList2.b = 1;
            }
            collectedList2.a = bucket;
            if (bl3) {
                if (by3 == 1) {
                    collectedList.addFirst(collectedList2);
                    continue;
                }
                collectedList.add(collectedList2);
                continue;
            }
            collectedList.add(collectedList2);
        }
        if (collectedList.b == 0) {
            collectedList.b = 1;
        }
        return collectedList;
    }

    public HeaderCell[][] createHeaders(byte by2, CollectedList[] collectedListArray) {
        HeaderCell[][] headerCellArray = new HeaderCell[this.buckets[by2].length][collectedListArray[by2].b];
        ArrayList arrayList = new ArrayList();
        this.fillHeaders(by2, headerCellArray, 0, 0, collectedListArray[by2], arrayList);
        return headerCellArray;
    }

    public void fillHeaders(byte by2, HeaderCell[][] headerCellArray, int n2, int n3, CollectedList collectedList, List list) {
        if (n2 == this.buckets[by2].length) {
            return;
        }
        Iterator iterator = collectedList.iterator();
        while (iterator.hasNext()) {
            CollectedList collectedList2 = (CollectedList)iterator.next();
            list.add(collectedList2.a);
            int n4 = collectedList2.a.isTotal() ? this.buckets[by2].length - n2 : 1;
            BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.buckets[by2].length];
            list.toArray(bucketArray);
            headerCellArray[n2][n3] = new HeaderCell(bucketArray, collectedList2.b, n4);
            if (!collectedList2.a.isTotal()) {
                this.fillHeaders(by2, headerCellArray, n2 + 1, n3, collectedList2, list);
            }
            n3 += collectedList2.b;
            list.remove(list.size() - 1);
        }
    }

    public void fillCells(CollectedList[] collectedListArray, BucketMap bucketMap, int n2, int[] nArray, List list, List list2) {
        int n3;
        list2.add(bucketMap);
        int n4 = n2 < this.rowBucketCount ? 0 : 1;
        boolean bl2 = n2 == this.allBuckets.length - 1;
        CollectedList[] collectedListArray2 = null;
        if (!bl2) {
            collectedListArray2 = new CollectedList[2];
            for (n3 = 0; n3 < 2; ++n3) {
                if (n3 == n4) continue;
                collectedListArray2[n3] = collectedListArray[n3];
            }
        }
        n3 = n2 == this.buckets[0].length - 1 ? 1 : 0;
        CollectedList collectedList = collectedListArray[n4];
        Iterator iterator = bucketMap == null ? null : bucketMap.c();
        Map.Entry entry = iterator != null && iterator.hasNext() ? (Map.Entry)iterator.next() : null;
        Iterator iterator2 = collectedList.iterator();
        while (iterator2.hasNext()) {
            CollectedList collectedList2 = (CollectedList)iterator2.next();
            Map.Entry entry2 = null;
            if (collectedList2.a.isTotal()) {
                if (bucketMap != null) {
                    entry2 = bucketMap.a();
                }
            } else if (entry != null && entry.getKey().equals(collectedList2.a)) {
                entry2 = entry;
                entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
            }
            list.add(collectedList2.a);
            if (bl2) {
                this.fillCell(nArray, list, list2, entry2);
            } else {
                collectedListArray2[n4] = collectedList2;
                BucketMap bucketMap2 = entry2 == null ? null : (BucketMap)entry2.getValue();
                this.fillCells(collectedListArray2, bucketMap2, n2 + 1, nArray, list, list2);
            }
            list.remove(list.size() - 1);
            if (n3 == 0) continue;
            nArray[0] = nArray[0] + 1;
            nArray[1] = 0;
        }
        list2.remove(list2.size() - 1);
    }

    public void fillCell(int[] nArray, List list, List list2, Map.Entry entry) {
        Iterator iterator = list.iterator();
        BucketDefinition.Bucket[] bucketArray = new BucketDefinition.Bucket[this.buckets[0].length];
        for (int i2 = 0; i2 < bucketArray.length; ++i2) {
            bucketArray[i2] = (BucketDefinition.Bucket)iterator.next();
        }
        BucketDefinition.Bucket[] bucketArray2 = new BucketDefinition.Bucket[this.buckets[1].length];
        for (int i3 = 0; i3 < bucketArray2.length; ++i3) {
            bucketArray2[i3] = (BucketDefinition.Bucket)iterator.next();
        }
        MeasureDefinition.MeasureValue[] measureValueArray = entry == null ? this.zeroUserMeasureValues : this.getUserMeasureValues((MeasureDefinition.MeasureValue[])entry.getValue());
        MeasureDefinition.MeasureValue[][][] measureValueArray2 = this.retrieveTotals(list, list2);
        this.cells[nArray[0]][nArray[1]] = new CrosstabCell(bucketArray, bucketArray2, measureValueArray, measureValueArray2);
        nArray[1] = nArray[1] + 1;
    }

    public MeasureDefinition.MeasureValue[][][] retrieveTotals(List list, List list2) {
        MeasureDefinition.MeasureValue[][][] measureValueArray = new MeasureDefinition.MeasureValue[this.rowBucketCount + 1][this.colBucketCount + 1][];
        for (int i2 = this.rowRetrTotalMax; i2 >= this.rowRetrTotalMin; --i2) {
            Object object;
            int n2;
            if (!this.rowRetrTotals[i2]) continue;
            BucketMap bucketMap = (BucketMap)list2.get(i2);
            for (n2 = i2; bucketMap != null && n2 < this.rowBucketCount; ++n2) {
                object = bucketMap.a();
                bucketMap = object == null ? null : (BucketMap)object.getValue();
            }
            for (n2 = 0; n2 <= this.rowRetrColMax[i2]; ++n2) {
                object = bucketMap;
                if (n2 < this.colBucketCount - 1) {
                    if (i2 == this.rowBucketCount) {
                        bucketMap = (BucketMap)list2.get(this.rowBucketCount + n2 + 1);
                    } else if (bucketMap != null) {
                        bucketMap = (BucketMap)bucketMap.a((BucketDefinition.Bucket)list.get(this.rowBucketCount + n2));
                    }
                }
                if (!this.retrieveTotal[i2][n2]) continue;
                for (int i3 = n2 + 1; object != null && i3 < this.colBucketCount; ++i3) {
                    object = (BucketMap)((BucketMap)object).a().getValue();
                }
                if (object != null) {
                    if (n2 == this.colBucketCount) {
                        MeasureDefinition.MeasureValue[] measureValueArray2 = (MeasureDefinition.MeasureValue[])((BucketMap)object).a((BucketDefinition.Bucket)list.get(this.rowBucketCount + this.colBucketCount - 1));
                        measureValueArray[i2][n2] = this.getUserMeasureValues(measureValueArray2);
                    } else {
                        Map.Entry entry = ((BucketMap)object).a();
                        if (entry != null) {
                            MeasureDefinition.MeasureValue[] measureValueArray3 = (MeasureDefinition.MeasureValue[])entry.getValue();
                            measureValueArray[i2][n2] = this.getUserMeasureValues(measureValueArray3);
                        }
                    }
                }
                if (measureValueArray[i2][n2] != null) continue;
                measureValueArray[i2][n2] = this.zeroUserMeasureValues;
            }
        }
        return measureValueArray;
    }

    protected static class CollectedList
    extends LinkedList {
        private static final long serialVersionUID = 10200L;
        public int b = 0;
        public BucketDefinition.Bucket a;

        public boolean add(Object object) {
            boolean bl2 = super.add(object);
            this.incrementSpan(object);
            return bl2;
        }

        public void addFirst(Object object) {
            super.addFirst(object);
            this.incrementSpan(object);
        }

        public void addLast(Object object) {
            super.add(object);
            this.incrementSpan(object);
        }

        private void incrementSpan(Object object) {
            this.b = object != null && object instanceof CollectedList ? (this.b += ((CollectedList)object).b) : ++this.b;
        }

        public String toString() {
            return this.a + "/" + this.b + ": " + super.toString();
        }
    }

    protected class BucketListMap
    extends BucketMap {
        public List d;
        private final BucketingService this$0;

        public BucketListMap(BucketingService bucketingService, int n2, boolean bl2) {
            super(bucketingService, n2);
            this.this$0 = bucketingService;
            this.d = bl2 ? new LinkedList() : new ArrayList();
        }

        public void b() {
            this.d.clear();
        }

        public Iterator c() {
            return this.d.iterator();
        }

        private void add(BucketDefinition.Bucket bucket, Object object) {
            this.d.add(new MapEntry(bucket, object));
        }

        public Object a(BucketDefinition.Bucket bucket) {
            int n2 = Collections.binarySearch(this.d, new MapEntry(bucket, null));
            return n2 >= 0 ? ((MapEntry)this.d.get((int)n2)).b : null;
        }

        public MeasureDefinition.MeasureValue[] a(BucketDefinition.Bucket[] bucketArray) {
            int n2;
            Object object = this;
            BucketListMap bucketListMap = null;
            for (n2 = 0; n2 < this.this$0.allBuckets.length; ++n2) {
                bucketListMap = object;
                int n3 = bucketListMap.d.size();
                if (n3 == 0) break;
                MapEntry mapEntry = (MapEntry)bucketListMap.d.get(n3 - 1);
                if (!mapEntry.a.equals(bucketArray[n2])) break;
                object = mapEntry.b;
            }
            if (n2 == this.this$0.allBuckets.length) {
                return (MeasureDefinition.MeasureValue[])object;
            }
            while (n2 < this.this$0.allBuckets.length - 1) {
                BucketListMap bucketListMap2 = new BucketListMap(this.this$0, n2 + 1, false);
                bucketListMap.add(bucketArray[n2], bucketListMap2);
                bucketListMap = bucketListMap2;
                ++n2;
            }
            MeasureDefinition.MeasureValue[] measureValueArray = this.this$0.initMeasureValues();
            bucketListMap.add(bucketArray[n2], measureValueArray);
            this.this$0.bucketMeasuresCreated();
            return measureValueArray;
        }

        public void a(Object object) {
            this.add(this.a, object);
        }

        public Map.Entry a() {
            MapEntry mapEntry = (MapEntry)this.d.get(this.d.size() - 1);
            if (mapEntry.a.isTotal()) {
                return mapEntry;
            }
            return null;
        }

        public void a(BucketMap bucketMap, boolean bl2) throws JRException {
            Map.Entry entry;
            ListIterator<MapEntry> listIterator = this.d.listIterator();
            MapEntry mapEntry = listIterator.hasNext() ? (MapEntry)listIterator.next() : null;
            Iterator iterator = bucketMap.c();
            Map.Entry entry2 = entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
            while (entry != null) {
                int n2;
                BucketDefinition.Bucket bucket = (BucketDefinition.Bucket)entry.getKey();
                int n3 = n2 = mapEntry == null ? -1 : bucket.compareTo(mapEntry.a);
                if (n2 <= 0) {
                    Object object;
                    MeasureDefinition.MeasureValue[] measureValueArray = null;
                    if (this.c) {
                        if (bl2) {
                            MeasureDefinition.MeasureValue[] measureValueArray2 = object = n2 == 0 ? (MeasureDefinition.MeasureValue[])mapEntry.b : null;
                            if (object == null) {
                                measureValueArray = object = this.this$0.initMeasureValues();
                            }
                            this.this$0.sumVals((MeasureDefinition.MeasureValue[])object, (MeasureDefinition.MeasureValue[])entry.getValue());
                        }
                    } else {
                        MeasureDefinition.MeasureValue[] measureValueArray3 = object = n2 == 0 ? (MeasureDefinition.MeasureValue[])mapEntry.b : null;
                        if (object == null) {
                            measureValueArray = object = this.this$0.createCollectBucketMap(this.b + 1);
                        }
                        object.a((BucketMap)entry.getValue(), bl2);
                    }
                    if (n2 < 0) {
                        if (mapEntry != null) {
                            listIterator.previous();
                        }
                        listIterator.add(new MapEntry(bucket, measureValueArray));
                        if (mapEntry != null) {
                            listIterator.next();
                        }
                    }
                    Map.Entry entry3 = entry = iterator.hasNext() ? (Map.Entry)iterator.next() : null;
                }
                if (n2 < 0) continue;
                mapEntry = listIterator.hasNext() ? (MapEntry)listIterator.next() : null;
            }
        }
    }

    protected class BucketTreeMap
    extends BucketMap {
        public TreeMap d;
        private final BucketingService this$0;

        public BucketTreeMap(BucketingService bucketingService, int n2) {
            super(bucketingService, n2);
            this.this$0 = bucketingService;
            this.d = new TreeMap();
        }

        public void b() {
            this.d.clear();
        }

        public Iterator c() {
            return this.d.entrySet().iterator();
        }

        public Object a(BucketDefinition.Bucket bucket) {
            return this.d.get(bucket);
        }

        public MeasureDefinition.MeasureValue[] a(BucketDefinition.Bucket[] bucketArray) {
            BucketTreeMap bucketTreeMap = (BucketTreeMap)this.this$0.bucketValueMap;
            for (int i2 = 0; i2 < bucketArray.length - 1; ++i2) {
                BucketTreeMap bucketTreeMap2 = (BucketTreeMap)bucketTreeMap.a(bucketArray[i2]);
                if (bucketTreeMap2 == null) {
                    bucketTreeMap2 = new BucketTreeMap(this.this$0, i2 + 1);
                    bucketTreeMap.d.put(bucketArray[i2], bucketTreeMap2);
                }
                bucketTreeMap = bucketTreeMap2;
            }
            MeasureDefinition.MeasureValue[] measureValueArray = (MeasureDefinition.MeasureValue[])bucketTreeMap.a(bucketArray[bucketArray.length - 1]);
            if (measureValueArray == null) {
                measureValueArray = this.this$0.initMeasureValues();
                bucketTreeMap.d.put(bucketArray[bucketArray.length - 1], measureValueArray);
                this.this$0.bucketMeasuresCreated();
            }
            return measureValueArray;
        }

        public void a(Object object) {
            this.d.put(this.a, object);
        }

        public Map.Entry a() {
            Object object = this.a(this.a);
            return object == null ? null : new MapEntry(this.a, object);
        }

        public String toString() {
            return this.d.toString();
        }
    }

    protected abstract class BucketMap {
        public final int b;
        public final boolean c;
        public final BucketDefinition.Bucket a;
        private final BucketingService this$0;

        public BucketMap(BucketingService bucketingService, int n2) {
            this.this$0 = bucketingService;
            this.b = n2;
            this.c = n2 == bucketingService.allBuckets.length - 1;
            this.a = bucketingService.allBuckets[n2].VALUE_TOTAL;
        }

        public BucketMap d() {
            BucketMap bucketMap = this.this$0.createBucketMap(this.b + 1);
            this.a(bucketMap);
            return bucketMap;
        }

        public abstract void b();

        public abstract Iterator c();

        public abstract Object a(BucketDefinition.Bucket var1);

        public abstract MeasureDefinition.MeasureValue[] a(BucketDefinition.Bucket[] var1);

        public abstract void a(Object var1);

        public abstract Map.Entry a();
    }

    protected static class MapEntry
    implements Map.Entry,
    Comparable {
        public final BucketDefinition.Bucket a;
        public final Object b;

        public MapEntry(BucketDefinition.Bucket bucket, Object object) {
            this.a = bucket;
            this.b = object;
        }

        public Object getKey() {
            return this.a;
        }

        public Object getValue() {
            return this.b;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object object) {
            return this.a.compareTo(((MapEntry)object).a);
        }

        public String toString() {
            return this.a + ":" + this.b;
        }
    }
}

