/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.Comparator;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BucketDefinition {
    public static final byte ORDER_ASCENDING = 1;
    public static final byte ORDER_DESCENDING = 2;
    public static final byte TOTAL_POSITION_NONE = 0;
    public static final byte TOTAL_POSITION_START = 1;
    public static final byte TOTAL_POSITION_END = 2;
    public static final byte VALUE_TYPE_VALUE = 0;
    public static final byte VALUE_TYPE_NULL = 1;
    public static final byte VALUE_TYPE_TOTAL = 2;
    public final Bucket VALUE_TOTAL = new Bucket(this, 2);
    public final Bucket VALUE_NULL = new Bucket(this, 1);
    public final Comparator comparator;
    private final byte totalPosition;
    private boolean computeTotal;
    public static Class a;

    public BucketDefinition(Class clazz, Comparator comparator, byte by2, byte by3) throws JRException {
        if (comparator == null && !(a == null ? (a = BucketDefinition.a("java.lang.Comparable")) : a).isAssignableFrom(clazz)) {
            throw new JRException("The bucket expression values are not comparable and no comparator specified.");
        }
        switch (by2) {
            case 2: {
                if (comparator == null) {
                    this.comparator = new ReverseComparator();
                    break;
                }
                this.comparator = new ReverseComparator(comparator);
                break;
            }
            default: {
                this.comparator = comparator;
            }
        }
        this.totalPosition = by3;
        this.computeTotal = by3 != 0;
    }

    public boolean computeTotal() {
        return this.computeTotal;
    }

    public void setComputeTotal() {
        this.computeTotal = true;
    }

    public byte getTotalPosition() {
        return this.totalPosition;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Bucket create(Object object) {
        if (object == null) {
            return this.VALUE_NULL;
        }
        return new Bucket(this, object);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Bucket
    implements Comparable {
        private final Object value;
        private final byte type;
        private final BucketDefinition this$0;

        public Bucket(BucketDefinition bucketDefinition, byte by2) {
            this.this$0 = bucketDefinition;
            this.value = null;
            this.type = by2;
        }

        public Bucket(BucketDefinition bucketDefinition, Object object) {
            this.this$0 = bucketDefinition;
            this.value = object;
            this.type = 0;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Bucket)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Bucket bucket = (Bucket)object;
            if (this.type != 0) {
                return this.type == bucket.type;
            }
            return bucket.type == 0 && this.value.equals(bucket.value);
        }

        public int hashCode() {
            int n2 = this.type;
            if (this.type == 0) {
                n2 = 37 * n2 + this.value.hashCode();
            }
            return n2;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "NULL";
                }
                case 2: {
                    return "TOTAL";
                }
            }
            return String.valueOf(this.value);
        }

        public int compareTo(Object object) {
            Bucket bucket = (Bucket)object;
            if (this.type != bucket.type) {
                return this.type - bucket.type;
            }
            if (this.type != 0) {
                return 0;
            }
            if (this.this$0.comparator != null) {
                return this.this$0.comparator.compare(this.value, bucket.value);
            }
            return ((Comparable)this.value).compareTo(bucket.value);
        }

        public boolean isTotal() {
            return this.type == 2;
        }
    }
}

