/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseCrosstab
extends JRBaseElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_RUN_DIRECTION = "runDirection";
    public int id;
    public JRCrosstabParameter[] parameters;
    public JRVariable[] variables;
    public JRExpression parametersMapExpression;
    public JRCrosstabDataset dataset;
    public JRCrosstabRowGroup[] rowGroups;
    public JRCrosstabColumnGroup[] columnGroups;
    public JRCrosstabMeasure[] measures;
    public int columnBreakOffset;
    public boolean repeatColumnHeaders = true;
    public boolean repeatRowHeaders = true;
    public byte runDirection;
    public JRCrosstabCell[][] cells;
    public JRCellContents whenNoDataCell;
    public JRCellContents headerCell;

    public JRBaseCrosstab(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory, int n2) {
        super(jRCrosstab, jRBaseObjectFactory);
        this.id = n2;
        this.columnBreakOffset = jRCrosstab.getColumnBreakOffset();
        this.repeatColumnHeaders = jRCrosstab.isRepeatColumnHeaders();
        this.repeatRowHeaders = jRCrosstab.isRepeatRowHeaders();
        this.runDirection = jRCrosstab.getRunDirection();
        this.dataset = jRBaseObjectFactory.getCrosstabDataset(jRCrosstab.getDataset());
        this.copyParameters(jRCrosstab, jRBaseObjectFactory);
        this.copyVariables(jRCrosstab, jRBaseObjectFactory);
        this.headerCell = jRBaseObjectFactory.getCell(jRCrosstab.getHeaderCell());
        this.copyRowGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyColumnGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyMeasures(jRCrosstab, jRBaseObjectFactory);
        this.copyCells(jRCrosstab, jRBaseObjectFactory);
        this.whenNoDataCell = jRBaseObjectFactory.getCell(jRCrosstab.getWhenNoDataCell());
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    private void copyParameters(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            this.parameters = new JRCrosstabParameter[jRCrosstabParameterArray.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = jRBaseObjectFactory.getCrosstabParameter(jRCrosstabParameterArray[i2]);
            }
        }
        this.parametersMapExpression = jRBaseObjectFactory.getExpression(jRCrosstab.getParametersMapExpression());
    }

    private void copyVariables(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRVariable[] jRVariableArray = jRCrosstab.getVariables();
        if (jRVariableArray != null) {
            this.variables = new JRVariable[jRVariableArray.length];
            for (int i2 = 0; i2 < jRVariableArray.length; ++i2) {
                this.variables[i2] = jRBaseObjectFactory.getVariable(jRVariableArray[i2]);
            }
        }
    }

    private void copyRowGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            this.rowGroups = new JRCrosstabRowGroup[jRCrosstabRowGroupArray.length];
            for (int i2 = 0; i2 < jRCrosstabRowGroupArray.length; ++i2) {
                this.rowGroups[i2] = jRBaseObjectFactory.getCrosstabRowGroup(jRCrosstabRowGroupArray[i2]);
            }
        }
    }

    private void copyColumnGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        if (jRCrosstabColumnGroupArray != null) {
            this.columnGroups = new JRCrosstabColumnGroup[jRCrosstabColumnGroupArray.length];
            for (int i2 = 0; i2 < jRCrosstabColumnGroupArray.length; ++i2) {
                this.columnGroups[i2] = jRBaseObjectFactory.getCrosstabColumnGroup(jRCrosstabColumnGroupArray[i2]);
            }
        }
    }

    private void copyMeasures(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        if (jRCrosstabMeasureArray != null) {
            this.measures = new JRCrosstabMeasure[jRCrosstabMeasureArray.length];
            for (int i2 = 0; i2 < jRCrosstabMeasureArray.length; ++i2) {
                this.measures[i2] = jRBaseObjectFactory.getCrosstabMeasure(jRCrosstabMeasureArray[i2]);
            }
        }
    }

    private void copyCells(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        if (jRCrosstabCellArray != null) {
            this.cells = new JRCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
            for (int i2 = 0; i2 <= this.rowGroups.length; ++i2) {
                for (int i3 = 0; i3 <= this.columnGroups.length; ++i3) {
                    this.cells[i2][i3] = jRBaseObjectFactory.getCrosstabCell(jRCrosstabCellArray[i2][i3]);
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitCrosstab(this);
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public JRCrosstabCell[][] getCells() {
        return this.cells;
    }

    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public static JRElement getElementByKey(JRCrosstab jRCrosstab, String string) {
        JRElement jRElement = null;
        if (jRCrosstab.getHeaderCell() != null) {
            jRElement = jRCrosstab.getHeaderCell().getElementByKey(string);
        }
        if (jRElement == null) {
            jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getRowGroups(), string);
        }
        if (jRElement == null) {
            jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getColumnGroups(), string);
        }
        if (jRElement == null) {
            if (jRCrosstab instanceof JRDesignCrosstab) {
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                Iterator iterator = list.iterator();
                while (jRElement == null && iterator.hasNext()) {
                    JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                    jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                }
            } else {
                JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
                for (int i2 = jRCrosstabCellArray.length - 1; jRElement == null && i2 >= 0; --i2) {
                    for (int i3 = jRCrosstabCellArray[i2].length - 1; jRElement == null && i3 >= 0; --i3) {
                        JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[i2][i3];
                        if (jRCrosstabCell == null) continue;
                        jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                    }
                }
            }
        }
        if (jRElement == null && jRCrosstab.getWhenNoDataCell() != null) {
            jRElement = jRCrosstab.getWhenNoDataCell().getElementByKey(string);
        }
        return jRElement;
    }

    private static JRElement getHeadersElement(JRCrosstabGroup[] jRCrosstabGroupArray, String string) {
        JRElement jRElement = null;
        if (jRCrosstabGroupArray != null) {
            for (int i2 = 0; jRElement == null && i2 < jRCrosstabGroupArray.length; ++i2) {
                JRCellContents jRCellContents = jRCrosstabGroupArray[i2].getHeader();
                jRElement = jRCellContents.getElementByKey(string);
                if (jRElement != null) continue;
                JRCellContents jRCellContents2 = jRCrosstabGroupArray[i2].getTotalHeader();
                jRElement = jRCellContents2.getElementByKey(string);
            }
        }
        return jRElement;
    }

    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public byte getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(byte by2) {
        byte by3 = this.runDirection;
        this.runDirection = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_RUN_DIRECTION, by3, this.runDirection);
    }

    public Object clone() {
        return null;
    }
}

