/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    public JRGroovyCompiler() {
        super(false);
    }

    public String compileUnits(JRCompilationUnit[] jRCompilationUnitArray, String string, File file) throws JRException {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setUseNewGroovy(true);
        CompilationUnit compilationUnit = new CompilationUnit(compilerConfiguration);
        for (int i2 = 0; i2 < jRCompilationUnitArray.length; ++i2) {
            compilationUnit.addSource("calculator_" + jRCompilationUnitArray[i2].getName(), (InputStream)new ByteArrayInputStream(jRCompilationUnitArray[i2].getSourceCode().getBytes()));
        }
        ClassCollector classCollector = new ClassCollector(null);
        compilationUnit.setClassgenCallback((CompilationUnit.ClassgenCallback)classCollector);
        try {
            compilationUnit.compile(7);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compilationFailedException.toString());
        }
        if (classCollector.classes.size() < jRCompilationUnitArray.length) {
            throw new JRException("Too few groovy class were generated.");
        }
        if (classCollector.classCount > jRCompilationUnitArray.length) {
            throw new JRException("Too many groovy classes were generated.\nPlease make sure that you don't use Groovy features such as closures that are not supported by this report compiler.\n");
        }
        for (int i3 = 0; i3 < jRCompilationUnitArray.length; ++i3) {
            jRCompilationUnitArray[i3].setCompileData((Serializable)classCollector.classes.get(jRCompilationUnitArray[i3].getName()));
        }
        return null;
    }

    public void checkLanguage(String string) throws JRException {
        if (!"groovy".equals(string) && !"java".equals(string)) {
            throw new JRException("Language \"" + string + "\" not supported by this report compiler.\n" + "Expecting \"groovy\" or \"java\" instead.");
        }
    }

    public JRCompilationSourceCode generateSourceCode(JRSourceCompileTask jRSourceCompileTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRGroovyGenerator.generateClass(jRSourceCompileTask), null);
    }

    public String getSourceFileName(String string) {
        return string + ".groovy";
    }

    public static class 1 {
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public Map classes = new HashMap();
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor classVisitor, ClassNode classNode) throws CompilationFailedException {
            ++this.classCount;
            String string = classNode.getName();
            if (!this.classes.containsKey(string)) {
                byte[] byArray = ((ClassWriter)classVisitor).toByteArray();
                this.classes.put(string, byArray);
            }
        }

        public ClassCollector(1 var1_1) {
            this();
        }
    }
}

