/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRBshGenerator {
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    public final JRSourceCompileTask sourceTask;
    public Map parametersMap;
    public Map fieldsMap;
    public Map variablesMap;
    public JRVariable[] variables;

    public JRBshGenerator(JRSourceCompileTask jRSourceCompileTask) {
        this.sourceTask = jRSourceCompileTask;
        this.parametersMap = jRSourceCompileTask.getParametersMap();
        this.fieldsMap = jRSourceCompileTask.getFieldsMap();
        this.variablesMap = jRSourceCompileTask.getVariablesMap();
        this.variables = jRSourceCompileTask.getVariables();
    }

    public static String generateScript(JRSourceCompileTask jRSourceCompileTask) {
        JRBshGenerator jRBshGenerator = new JRBshGenerator(jRSourceCompileTask);
        return jRBshGenerator.generateScript();
    }

    public String generateScript() {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateScriptStart(stringBuffer);
        this.generateDeclarations(stringBuffer);
        this.generateInitMethod(stringBuffer);
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        List list = this.sourceTask.getExpressions();
        stringBuffer.append(this.generateMethod((byte)3, list));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList arrayList = new ArrayList();
            stringBuffer.append(this.generateMethod((byte)1, arrayList));
            stringBuffer.append(this.generateMethod((byte)2, arrayList));
        } else {
            stringBuffer.append(this.generateMethod((byte)1, list));
            stringBuffer.append(this.generateMethod((byte)2, list));
        }
        this.generateScriptEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public final void generateScriptStart(StringBuffer stringBuffer) {
        stringBuffer.append("//\n");
        stringBuffer.append("// Generated by JasperReports - ");
        stringBuffer.append(new SimpleDateFormat().format(new Date()));
        stringBuffer.append("\n");
        stringBuffer.append("//\n");
        stringBuffer.append("import net.sf.jasperreports.engine.*;\n");
        stringBuffer.append("import net.sf.jasperreports.engine.fill.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import java.math.*;\n");
        stringBuffer.append("import java.text.*;\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.net.*;\n");
        stringBuffer.append("\n");
        String[] stringArray = this.sourceTask.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringBuffer.append("import ");
                stringBuffer.append(stringArray[i2]);
                stringBuffer.append(";\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("createBshEvaluator()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    JREvaluator evaluator = null;\n");
        stringBuffer.append("\n");
    }

    public final void generateDeclarations(StringBuffer stringBuffer) {
        Iterator iterator;
        Set set;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            set = this.parametersMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    JRFillParameter parameter_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        stringBuffer.append("\n");
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            set = this.fieldsMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    JRFillField field_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        stringBuffer.append("\n");
        if (this.variables != null && this.variables.length > 0) {
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                stringBuffer.append("    JRFillVariable variable_");
                stringBuffer.append(JRStringUtil.getLiteral(this.variables[i2].getName()));
                stringBuffer.append(" = null;\n");
            }
        }
    }

    public final void generateInitMethod(StringBuffer stringBuffer) {
        Iterator iterator;
        String string;
        Object object;
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    init(\n");
        stringBuffer.append("        JREvaluator evaluator,\n");
        stringBuffer.append("        Map parsm,\n");
        stringBuffer.append("        Map fldsm,\n");
        stringBuffer.append("        Map varsm\n");
        stringBuffer.append("        )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        super.evaluator = evaluator;\n");
        stringBuffer.append("\n");
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            object = this.parametersMap.keySet();
            string = null;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("        super.parameter_");
                stringBuffer.append(JRStringUtil.getLiteral(string));
                stringBuffer.append(" = (JRFillParameter)parsm.get(\"");
                stringBuffer.append(string);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("\n");
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            object = this.fieldsMap.keySet();
            string = null;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("        super.field_");
                stringBuffer.append(JRStringUtil.getLiteral(string));
                stringBuffer.append(" = (JRFillField)fldsm.get(\"");
                stringBuffer.append(string);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("\n");
        if (this.variables != null && this.variables.length > 0) {
            object = null;
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                object = this.variables[i2].getName();
                stringBuffer.append("        super.variable_");
                stringBuffer.append(JRStringUtil.getLiteral((String)object));
                stringBuffer.append(" = (JRFillVariable)varsm.get(\"");
                stringBuffer.append((String)object);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("    }\n");
    }

    public void generateScriptEnd(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("    str(String key)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.evaluator.str(key);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.evaluator.msg(pattern, arg0);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0, Object arg1)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.evaluator.msg(pattern, arg0, arg1);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0, Object arg1, Object arg2)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.evaluator.msg(pattern, arg0, arg1, arg2);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object[] args)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.evaluator.msg(pattern, args);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return this;\n");
        stringBuffer.append("}\n");
    }

    public final String generateMethod(byte by2, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Object evaluate");
        stringBuffer.append((String)methodSuffixMap.get(new Byte(by2)));
        stringBuffer.append("(int id)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        Object value = null;\n");
        stringBuffer.append("\n");
        stringBuffer.append("        switch (id)\n");
        stringBuffer.append("        {\n");
        if (list != null && !list.isEmpty()) {
            JRExpression jRExpression = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jRExpression = (JRExpression)iterator.next();
                stringBuffer.append("            case ");
                stringBuffer.append(this.sourceTask.getExpressionId(jRExpression));
                stringBuffer.append(" :\n");
                stringBuffer.append("            {\n");
                stringBuffer.append("                value = (");
                stringBuffer.append(jRExpression.getValueClassName());
                stringBuffer.append(")(");
                stringBuffer.append(this.generateExpression(jRExpression, by2));
                stringBuffer.append(");\n");
                stringBuffer.append("                break;\n");
                stringBuffer.append("            }\n");
            }
        }
        stringBuffer.append("           default :\n");
        stringBuffer.append("           {\n");
        stringBuffer.append("           }\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("        \n");
        stringBuffer.append("        return value;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String generateExpression(JRExpression jRExpression, byte by2) {
        JRParameter jRParameter = null;
        JRField jRField = null;
        JRVariable jRVariable = null;
        StringBuffer stringBuffer = new StringBuffer();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        JRExpressionChunk jRExpressionChunk = null;
        String string = null;
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            block7: for (int i2 = 0; i2 < jRExpressionChunkArray.length; ++i2) {
                jRExpressionChunk = jRExpressionChunkArray[i2];
                string = jRExpressionChunk.getText();
                if (string == null) {
                    string = "";
                }
                switch (jRExpressionChunk.getType()) {
                    case 1: {
                        stringBuffer.append(string);
                        continue block7;
                    }
                    case 2: {
                        jRParameter = (JRParameter)this.parametersMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRParameter.getValueClassName());
                        stringBuffer.append(")super.parameter_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jRField = (JRField)this.fieldsMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRField.getValueClassName());
                        stringBuffer.append(")super.field_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)fieldPrefixMap.get(new Byte(by2)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jRVariable = (JRVariable)this.variablesMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRVariable.getValueClassName());
                        stringBuffer.append(")super.variable_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)variablePrefixMap.get(new Byte(by2)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        jRParameter = (JRParameter)this.parametersMap.get(string);
                        stringBuffer.append("super.evaluator.str(\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\")");
                    }
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

