/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultHighLowDataset;

public class JRFillHighLowDataset
extends JRFillChartDataset
implements JRHighLowDataset {
    private String series = null;
    private List elements = new ArrayList();
    private Date date = null;
    private Number high = null;
    private Number low = null;
    private Number open = null;
    private Number close = null;
    private Number volume = null;
    private JRPrintHyperlink itemHyperlink;
    private List itemHyperlinks;

    public JRFillHighLowDataset(JRHighLowDataset jRHighLowDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRHighLowDataset, jRFillObjectFactory);
    }

    public void customInitialize() {
        this.elements = new ArrayList();
        this.itemHyperlinks = new ArrayList();
    }

    public void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        this.series = (String)jRCalculator.evaluate(this.getSeriesExpression());
        this.date = (Date)jRCalculator.evaluate(this.getDateExpression());
        this.high = (Number)jRCalculator.evaluate(this.getHighExpression());
        this.low = (Number)jRCalculator.evaluate(this.getLowExpression());
        this.open = (Number)jRCalculator.evaluate(this.getOpenExpression());
        this.close = (Number)jRCalculator.evaluate(this.getCloseExpression());
        this.volume = (Number)jRCalculator.evaluate(this.getVolumeExpression());
        if (this.hasItemHyperlink()) {
            this.evaluateSectionHyperlink(jRCalculator);
        }
    }

    public void evaluateSectionHyperlink(JRCalculator jRCalculator) throws JRExpressionEvalException {
        try {
            this.itemHyperlink = JRFillHyperlinkHelper.evaluateHyperlink(this.getItemHyperlink(), jRCalculator, (byte)3);
        }
        catch (JRExpressionEvalException jRExpressionEvalException) {
            throw jRExpressionEvalException;
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void customIncrement() {
        this.elements.add(new HighLowElement(this.date, this.high, this.low, this.open, this.close, this.volume));
        if (this.hasItemHyperlink()) {
            this.itemHyperlinks.add(this.itemHyperlink);
        }
    }

    public Dataset getCustomDataset() {
        int n2 = this.elements.size();
        if (n2 > 0) {
            Date[] dateArray = new Date[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            double[] dArray4 = new double[n2];
            double[] dArray5 = new double[n2];
            for (int i2 = 0; i2 < this.elements.size(); ++i2) {
                HighLowElement highLowElement = (HighLowElement)this.elements.get(i2);
                dateArray[i2] = new Date(highLowElement.getDate().getTime());
                dArray[i2] = highLowElement.getHigh().doubleValue();
                dArray2[i2] = highLowElement.getLow().doubleValue();
                dArray3[i2] = highLowElement.getOpen().doubleValue();
                dArray4[i2] = highLowElement.getClose().doubleValue();
                dArray5[i2] = highLowElement.getVolume().doubleValue();
            }
            return new DefaultHighLowDataset((Comparable)((Object)this.series), dateArray, dArray, dArray2, dArray3, dArray4, dArray5);
        }
        return null;
    }

    public JRExpression getSeriesExpression() {
        return ((JRHighLowDataset)this.parent).getSeriesExpression();
    }

    public JRExpression getDateExpression() {
        return ((JRHighLowDataset)this.parent).getDateExpression();
    }

    public JRExpression getHighExpression() {
        return ((JRHighLowDataset)this.parent).getHighExpression();
    }

    public JRExpression getLowExpression() {
        return ((JRHighLowDataset)this.parent).getLowExpression();
    }

    public JRExpression getOpenExpression() {
        return ((JRHighLowDataset)this.parent).getOpenExpression();
    }

    public JRExpression getCloseExpression() {
        return ((JRHighLowDataset)this.parent).getCloseExpression();
    }

    public JRExpression getVolumeExpression() {
        return ((JRHighLowDataset)this.parent).getVolumeExpression();
    }

    public byte getDatasetType() {
        return 7;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public JRHyperlink getItemHyperlink() {
        return ((JRHighLowDataset)this.parent).getItemHyperlink();
    }

    public boolean hasItemHyperlink() {
        return !JRHyperlinkHelper.isEmpty(this.getItemHyperlink());
    }

    public List getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }

    private static class HighLowElement {
        public Date e;
        public Number a;
        public Number f;
        public Number c;
        public Number d;
        public Number b;

        public HighLowElement(Date date, Number number, Number number2, Number number3, Number number4, Number number5) {
            if (date == null) {
                throw new JRRuntimeException("Date value is null in high-low series.");
            }
            this.e = date;
            if (number == null) {
                throw new JRRuntimeException("High value is null in high-low series.");
            }
            this.a = number;
            if (number2 == null) {
                throw new JRRuntimeException("Low value is null in high-low series.");
            }
            this.f = number2;
            if (number3 == null) {
                throw new JRRuntimeException("Open value is null in high-low series.");
            }
            this.c = number3;
            if (number4 == null) {
                throw new JRRuntimeException("Close value is null in high-low series.");
            }
            this.d = number4;
            if (number5 == null) {
                throw new JRRuntimeException("Volume value is null in high-low series.");
            }
            this.b = number5;
        }

        public Date getDate() {
            return this.e;
        }

        public void setDate(Date date) {
            this.e = date;
        }

        public Number getHigh() {
            return this.a;
        }

        public void setHigh(Number number) {
            this.a = number;
        }

        public Number getLow() {
            return this.f;
        }

        public void setLow(Number number) {
            this.f = number;
        }

        public Number getOpen() {
            return this.c;
        }

        public void setOpen(Number number) {
            this.c = number;
        }

        public Number getClose() {
            return this.d;
        }

        public void setClose(Number number) {
            this.d = number;
        }

        public Number getVolume() {
            return this.b;
        }

        public void setVolume(Number number) {
            this.b = number;
        }
    }
}

