/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;

public class EventListenerProxy
implements InvocationHandler {
    private static boolean working;
    private EventListener listener;

    public EventListenerProxy(EventListener eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("EventListener cannot be null");
        }
        this.listener = eventListener;
    }

    public static EventListener create(Class clazz, EventListener eventListener) {
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("EventListener " + eventListener + " must implement " + clazz.getName());
        }
        return (EventListener)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new EventListenerProxy(eventListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (working) {
            return null;
        }
        try {
            working = true;
            Object object2 = method.invoke((Object)this.listener, objectArray);
            return object2;
        }
        finally {
            working = false;
        }
    }
}

