/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfField;
import com.lowagie.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractRtfField
extends Chunk
implements RtfField {
    private static final byte[] fldDirty = "\\flddirty".getBytes();
    private static final byte[] fldPriv = "\\fldpriv".getBytes();
    private static final byte[] fldLock = "\\fldlock".getBytes();
    private static final byte[] fldEdit = "\\fldedit".getBytes();
    private static final byte[] fldAlt = "\\fldalt".getBytes();
    private boolean rtfFieldIsLocked = false;
    private boolean rtfFieldIsDirty = false;
    private boolean rtfFieldWasEdited = false;
    private boolean rtfFieldIsPrivate = false;
    private boolean rtfFieldIsAlt = false;

    public AbstractRtfField(String string, Font font) {
        super(string, font);
    }

    public final boolean isLocked() {
        return this.rtfFieldIsLocked;
    }

    public final void setLocked(boolean bl2) {
        this.rtfFieldIsLocked = bl2;
    }

    public final void setDirty(boolean bl2) {
        this.rtfFieldIsDirty = bl2;
    }

    public final boolean isDirty() {
        return this.rtfFieldIsDirty;
    }

    public final void setEdited(boolean bl2) {
        this.rtfFieldWasEdited = bl2;
    }

    public final boolean wasEdited() {
        return this.rtfFieldWasEdited;
    }

    public final void setPrivate(boolean bl2) {
        this.rtfFieldIsPrivate = bl2;
    }

    public final boolean isPrivate() {
        return this.rtfFieldIsPrivate;
    }

    public abstract void writeRtfFieldInitializationStuff(OutputStream var1) throws IOException;

    public abstract void writeRtfFieldResultStuff(OutputStream var1) throws IOException;

    public final void setAlt(boolean bl2) {
        this.rtfFieldIsAlt = bl2;
    }

    public final boolean isAlt() {
        return this.rtfFieldIsAlt;
    }

    public final String content() {
        return "";
    }

    public void write(RtfWriter rtfWriter, OutputStream outputStream) throws IOException {
        this.writeRtfFieldBegin(outputStream);
        this.writeRtfFieldModifiers(outputStream);
        this.writeRtfFieldInstBegin(outputStream);
        rtfWriter.writeInitialFontSignature(outputStream, this);
        this.writeRtfFieldInitializationStuff(outputStream);
        this.writeRtfFieldInstEnd(outputStream);
        this.writeRtfFieldResultBegin(outputStream);
        rtfWriter.writeInitialFontSignature(outputStream, this);
        this.writeRtfFieldResultStuff(outputStream);
        this.writeRtfFieldResultEnd(outputStream);
        this.writeRtfFieldEnd(outputStream);
    }

    public final void writeRtfFieldBegin(OutputStream outputStream) throws IOException {
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.field);
    }

    public final void writeRtfFieldModifiers(OutputStream outputStream) throws IOException {
        if (this.isDirty()) {
            outputStream.write(fldDirty);
        }
        if (this.wasEdited()) {
            outputStream.write(fldEdit);
        }
        if (this.isLocked()) {
            outputStream.write(fldLock);
        }
        if (this.isPrivate()) {
            outputStream.write(fldPriv);
        }
    }

    public final void writeRtfFieldInstBegin(OutputStream outputStream) throws IOException {
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.fieldContent);
        outputStream.write(32);
    }

    public final void writeRtfFieldInstEnd(OutputStream outputStream) throws IOException {
        if (this.isAlt()) {
            outputStream.write(fldAlt);
            outputStream.write(32);
        }
        outputStream.write(125);
    }

    public final void writeRtfFieldResultBegin(OutputStream outputStream) throws IOException {
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write(RtfWriter.fieldDisplay);
        outputStream.write(32);
    }

    public final void writeRtfFieldResultEnd(OutputStream outputStream) throws IOException {
        outputStream.write(32);
        outputStream.write(125);
    }

    public final void writeRtfFieldEnd(OutputStream outputStream) throws IOException {
        outputStream.write(125);
    }
}

