/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.TIFFDirectory;
import com.lowagie.text.pdf.codec.TIFFFaxDecoder;
import com.lowagie.text.pdf.codec.TIFFField;
import com.lowagie.text.pdf.codec.TIFFLZWDecoder;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class TiffImage {
    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            return TIFFDirectory.getNumDirectories(randomAccessFileOrArray);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int a(TIFFField tIFFField, int n2) {
        if (tIFFField == null) {
            return 0;
        }
        long[] lArray = tIFFField.getAsRational(0);
        float f2 = (float)lArray[0] / (float)lArray[1];
        int n3 = 0;
        switch (n2) {
            case 1: 
            case 2: {
                n3 = (int)f2;
                break;
            }
            case 3: {
                n3 = (int)((double)f2 * 2.54);
            }
        }
        return n3;
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n2) {
        return TiffImage.getTiffImage(randomAccessFileOrArray, n2, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n2, boolean bl2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The page number must be >= 1.");
        }
        try {
            Object object;
            Object object2;
            long l2;
            TIFFDirectory tIFFDirectory = new TIFFDirectory(randomAccessFileOrArray, n2 - 1);
            if (tIFFDirectory.isTagPresent(322)) {
                throw new IllegalArgumentException("Tiles are not supported.");
            }
            int n3 = (int)tIFFDirectory.getFieldAsLong(259);
            switch (n3) {
                case 2: 
                case 3: 
                case 4: 
                case 32771: {
                    break;
                }
                default: {
                    return TiffImage.getTiffImageColor(tIFFDirectory, randomAccessFileOrArray);
                }
            }
            Image image = null;
            long l3 = 0L;
            long l4 = 0L;
            int n4 = 1;
            int n5 = (int)tIFFDirectory.getFieldAsLong(257);
            int n6 = (int)tIFFDirectory.getFieldAsLong(256);
            int n7 = 0;
            int n8 = 0;
            float f2 = 0.0f;
            int n9 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n9 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n7 = TiffImage.a(tIFFDirectory.getField(282), n9);
            n8 = TiffImage.a(tIFFDirectory.getField(283), n9);
            if (n9 == 1) {
                if (n8 != 0) {
                    f2 = (float)n7 / (float)n8;
                }
                n7 = 0;
                n8 = 0;
            }
            long l5 = 0xFFFFFFFFL;
            if (tIFFDirectory.isTagPresent(278)) {
                l5 = tIFFDirectory.getFieldAsLong(278);
            }
            int n10 = (int)Math.min((long)n5, l5);
            TIFFField tIFFField = tIFFDirectory.getField(273);
            long[] lArray = TiffImage.a(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.a(tIFFDirectory, 279);
            boolean bl3 = false;
            TIFFField tIFFField2 = tIFFDirectory.getField(266);
            if (tIFFField2 != null) {
                n4 = tIFFField2.getAsInt(0);
            }
            bl3 = n4 == 2;
            int n11 = 0;
            if (tIFFDirectory.isTagPresent(262) && (l2 = tIFFDirectory.getFieldAsLong(262)) == 1L) {
                n11 |= 1;
            }
            int n12 = 0;
            switch (n3) {
                case 2: 
                case 32771: {
                    n12 = 257;
                    n11 |= 0xA;
                    break;
                }
                case 3: {
                    n12 = 257;
                    n11 |= 0xC;
                    object2 = tIFFDirectory.getField(292);
                    if (object2 == null) break;
                    l3 = ((TIFFField)object2).getAsLong(0);
                    if ((l3 & 1L) != 0L) {
                        n3 = 258;
                    }
                    if ((l3 & 4L) == 0L) break;
                    n11 |= 2;
                    break;
                }
                case 4: {
                    n12 = 256;
                    object = tIFFDirectory.getField(293);
                    if (object == null) break;
                    l4 = ((TIFFField)object).getAsLong(0);
                }
            }
            if (bl2 && n10 == n5) {
                object2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully((byte[])object2);
                image = Image.getInstance(n6, n5, bl3, n12, n11, (byte[])object2);
                image.setInverted(true);
            } else {
                int n13 = n5;
                object = new CCITTG4Encoder(n6);
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    byte[] byArray = new byte[(int)lArray2[i2]];
                    randomAccessFileOrArray.seek(lArray[i2]);
                    randomAccessFileOrArray.readFully(byArray);
                    int n14 = Math.min(n10, n13);
                    TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(n4, n6, n14);
                    byte[] byArray2 = new byte[(n6 + 7) / 8 * n14];
                    switch (n3) {
                        case 2: 
                        case 32771: {
                            tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n14);
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n14);
                            break;
                        }
                        case 3: {
                            try {
                                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n14, l3);
                            }
                            catch (Exception exception) {
                                l3 ^= 4L;
                                try {
                                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n14, l3);
                                }
                                catch (Exception exception2) {
                                    throw exception;
                                }
                            }
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n14);
                            break;
                        }
                        case 4: {
                            tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n14, l4);
                            ((CCITTG4Encoder)object).encodeT6Lines(byArray2, 0, n14);
                        }
                    }
                    n13 -= n10;
                }
                byte[] byArray = ((CCITTG4Encoder)object).close();
                image = Image.getInstance(n6, n5, false, 256, n11 & 1, byArray);
            }
            image.setDpi(n7, n8);
            image.setXYRatio(f2);
            if (tIFFDirectory.isTagPresent(34675)) {
                TIFFField tIFFField3 = tIFFDirectory.getField(34675);
                image.tagICC(ICC_Profile.getInstance(tIFFField3.getAsBytes()));
            }
            image.setOriginalType(5);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static Image getTiffImageColor(TIFFDirectory tIFFDirectory, RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            Object[] objectArray;
            int n2 = (int)tIFFDirectory.getFieldAsLong(259);
            int n3 = 1;
            TIFFLZWDecoder tIFFLZWDecoder = null;
            switch (n2) {
                case 1: 
                case 5: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The compression " + n2 + " is not supported.");
                }
            }
            int n4 = (int)tIFFDirectory.getFieldAsLong(262);
            switch (n4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The photometric " + n4 + " is not supported.");
                }
            }
            if (tIFFDirectory.isTagPresent(284) && tIFFDirectory.getFieldAsLong(284) == 2L) {
                throw new IllegalArgumentException("Planar images are not supported.");
            }
            if (tIFFDirectory.isTagPresent(338)) {
                throw new IllegalArgumentException("Extra samples are not supported.");
            }
            int n5 = 1;
            if (tIFFDirectory.isTagPresent(277)) {
                n5 = (int)tIFFDirectory.getFieldAsLong(277);
            }
            int n6 = 1;
            if (tIFFDirectory.isTagPresent(258)) {
                n6 = (int)tIFFDirectory.getFieldAsLong(258);
            }
            switch (n6) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bits per sample " + n6 + " is not supported.");
                }
            }
            Image image = null;
            int n7 = (int)tIFFDirectory.getFieldAsLong(257);
            int n8 = (int)tIFFDirectory.getFieldAsLong(256);
            int n9 = 0;
            int n10 = 0;
            int n11 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n11 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n9 = TiffImage.a(tIFFDirectory.getField(282), n11);
            n9 = TiffImage.a(tIFFDirectory.getField(283), n11);
            int n12 = (int)tIFFDirectory.getFieldAsLong(278);
            long[] lArray = TiffImage.a(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.a(tIFFDirectory, 279);
            if (n2 == 5) {
                TIFFField tIFFField = tIFFDirectory.getField(317);
                if (tIFFField != null) {
                    n3 = tIFFField.getAsInt(0);
                    if (n3 != 1 && n3 != 2) {
                        throw new RuntimeException("Illegal value for Predictor in TIFF file.");
                    }
                    if (n3 == 2 && n6 != 8) {
                        throw new RuntimeException(n6 + "-bit samples are not supported for Horizontal differencing Predictor.");
                    }
                }
                tIFFLZWDecoder = new TIFFLZWDecoder(n8, n3, n5);
            }
            int n13 = n7;
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            CCITTG4Encoder cCITTG4Encoder = null;
            if (n6 == 1 && n5 == 1) {
                cCITTG4Encoder = new CCITTG4Encoder(n8);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            }
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                objectArray = new byte[(int)lArray2[i2]];
                randomAccessFileOrArray.seek(lArray[i2]);
                randomAccessFileOrArray.readFully((byte[])objectArray);
                int n14 = Math.min(n12, n13);
                byte[] byArray = null;
                if (n2 != 1) {
                    byArray = new byte[(n8 * n6 * n5 + 7) / 8 * n14];
                }
                switch (n2) {
                    case 32946: {
                        TiffImage.inflate(objectArray, byArray);
                        break;
                    }
                    case 1: {
                        byArray = objectArray;
                        break;
                    }
                    case 32773: {
                        TiffImage.decodePackbits(objectArray, byArray);
                        break;
                    }
                    case 5: {
                        tIFFLZWDecoder.decode((byte[])objectArray, byArray, n14);
                    }
                }
                if (n6 == 1 && n5 == 1) {
                    cCITTG4Encoder.encodeT6Lines(byArray, 0, n14);
                } else {
                    deflaterOutputStream.write(byArray);
                }
                n13 -= n12;
            }
            if (n6 == 1 && n5 == 1) {
                image = Image.getInstance(n8, n7, false, 256, n4 == 1 ? 1 : 0, cCITTG4Encoder.close());
            } else {
                deflaterOutputStream.close();
                image = Image.getInstance(n8, n7, n5, n6, byteArrayOutputStream.toByteArray());
                image.setDeflated(true);
            }
            image.setDpi(n9, n10);
            if (tIFFDirectory.isTagPresent(34675)) {
                TIFFField tIFFField = tIFFDirectory.getField(34675);
                image.tagICC(ICC_Profile.getInstance(tIFFField.getAsBytes()));
            }
            if (tIFFDirectory.isTagPresent(320)) {
                TIFFField tIFFField = tIFFDirectory.getField(320);
                objectArray = tIFFField.getAsChars();
                byte[] byArray = new byte[objectArray.length];
                int n15 = objectArray.length / 3;
                int n16 = n15 * 2;
                for (int i3 = 0; i3 < n15; ++i3) {
                    byArray[i3 * 3] = (byte)(objectArray[i3] >>> 8);
                    byArray[i3 * 3 + 1] = (byte)(objectArray[i3 + n15] >>> 8);
                    byArray[i3 * 3 + 2] = (byte)(objectArray[i3 + n16] >>> 8);
                }
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(PdfName.INDEXED);
                pdfArray.add(PdfName.DEVICERGB);
                pdfArray.add(new PdfNumber(n15 - 1));
                pdfArray.add(new PdfString(byArray));
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.COLORSPACE, pdfArray);
                image.setAdditional(pdfDictionary);
            }
            if (n4 == 0) {
                image.setInverted(true);
            }
            image.setOriginalType(5);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static long[] a(TIFFDirectory tIFFDirectory, int n2) {
        long[] lArray;
        TIFFField tIFFField = tIFFDirectory.getField(n2);
        if (tIFFField == null) {
            return null;
        }
        if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                lArray[i2] = cArray[i2];
            }
        }
        return lArray;
    }

    public static void decodePackbits(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4;
            byte by2;
            if ((by2 = byArray[n2++]) >= 0 && by2 <= 127) {
                for (n4 = 0; n4 < by2 + 1; ++n4) {
                    byArray2[n3++] = byArray[n2++];
                }
                continue;
            }
            if (by2 <= -1 && by2 >= -127) {
                byte by3 = byArray[n2++];
                for (n4 = 0; n4 < -by2 + 1; ++n4) {
                    byArray2[n3++] = by3;
                }
                continue;
            }
            ++n2;
        }
    }

    public static void inflate(byte[] byArray, byte[] byArray2) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new ExceptionConverter(dataFormatException);
        }
    }
}

