/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PngImage {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String gAMA = "gAMA";
    public static final String cHRM = "cHRM";
    public static final String sRGB = "sRGB";
    public static final String iCCP = "iCCP";
    private static final int TRANSFERSIZE = 4096;
    private static final int PNG_FILTER_NONE = 0;
    private static final int PNG_FILTER_SUB = 1;
    private static final int PNG_FILTER_UP = 2;
    private static final int PNG_FILTER_AVERAGE = 3;
    private static final int PNG_FILTER_PAETH = 4;
    private static final PdfName[] intents = new PdfName[]{PdfName.PERCEPTUAL, PdfName.RELATIVECALORIMETRIC, PdfName.SATURATION, PdfName.ABSOLUTECALORIMETRIC};
    public InputStream K;
    public DataInputStream w;
    public int a;
    public int z;
    public int B;
    public int c;
    public int v;
    public int h;
    public int x;
    public PdfDictionary o = new PdfDictionary();
    public byte[] A;
    public byte[] g;
    public byte[] j;
    public NewByteArrayOutputStream p = new NewByteArrayOutputStream();
    public int l;
    public int E;
    public float n;
    public boolean m;
    public boolean I;
    public int u = -1;
    public int r = -1;
    public int q = -1;
    public int e;
    public int C;
    public byte[] k;
    public float s = 1.0f;
    public boolean D = false;
    public float f;
    public float d;
    public float y;
    public float b;
    public float H;
    public float G;
    public float t;
    public float F;
    public PdfName i;
    public ICC_Profile J;

    public PngImage(InputStream inputStream) {
        this.K = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Image image = PngImage.getImage(inputStream);
            image.setUrl(uRL);
            Image image2 = image;
            return image2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Image getImage(InputStream inputStream) throws IOException {
        PngImage pngImage = new PngImage(inputStream);
        return pngImage.a();
    }

    public static Image getImage(String string) throws IOException {
        return PngImage.getImage(Image.toURL(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Image image = PngImage.getImage(byteArrayInputStream);
            image.setOriginalData(byArray);
            Image image2 = image;
            return image2;
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
    }

    public boolean a(String string) {
        if (string.length() != 4) {
            return false;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') continue;
            return false;
        }
        return true;
    }

    public void b() throws IOException {
        for (int i2 = 0; i2 < PNGID.length; ++i2) {
            if (PNGID[i2] == this.K.read()) continue;
            throw new IOException("File is not a valid PNG.");
        }
        byte[] byArray = new byte[4096];
        while (true) {
            int n2;
            int n3;
            int n4;
            String string = PngImage.getString(this.K);
            if (n4 < 0 || !this.a(string)) {
                throw new IOException("Corrupted PNG file.");
            }
            if (IDAT.equals(string)) {
                int n5;
                for (n4 = PngImage.getInt(this.K); n4 != 0; n4 -= n5) {
                    n5 = this.K.read(byArray, 0, Math.min(n4, 4096));
                    if (n5 < 0) {
                        return;
                    }
                    this.p.write(byArray, 0, n5);
                }
            } else if (tRNS.equals(string)) {
                switch (this.c) {
                    case 0: {
                        if (n4 < 2) break;
                        n4 -= 2;
                        int n6 = PngImage.getWord(this.K);
                        if (this.B == 16) {
                            this.u = n6;
                            break;
                        }
                        this.o.put(PdfName.MASK, new PdfLiteral("[" + n6 + " " + n6 + "]"));
                        break;
                    }
                    case 2: {
                        if (n4 < 6) break;
                        n4 -= 6;
                        int n7 = PngImage.getWord(this.K);
                        n3 = PngImage.getWord(this.K);
                        n2 = PngImage.getWord(this.K);
                        if (this.B == 16) {
                            this.u = n7;
                            this.r = n3;
                            this.q = n2;
                            break;
                        }
                        this.o.put(PdfName.MASK, new PdfLiteral("[" + n7 + " " + n7 + " " + n3 + " " + n3 + " " + n2 + " " + n2 + "]"));
                        break;
                    }
                    case 3: {
                        if (n4 <= 0) break;
                        this.j = new byte[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            this.j[i3] = (byte)this.K.read();
                        }
                        n4 = 0;
                    }
                }
                Image.skip(this.K, n4);
            } else if (IHDR.equals(string)) {
                this.a = PngImage.getInt(this.K);
                this.z = PngImage.getInt(this.K);
                this.B = this.K.read();
                this.c = this.K.read();
                this.v = this.K.read();
                this.h = this.K.read();
                this.x = this.K.read();
            } else if (PLTE.equals(string)) {
                if (this.c == 3) {
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.INDEXED);
                    pdfArray.add(this.c());
                    pdfArray.add(new PdfNumber(n4 / 3 - 1));
                    ByteBuffer byteBuffer = new ByteBuffer();
                    while (n4-- > 0) {
                        byteBuffer.append_i(this.K.read());
                    }
                    this.k = byteBuffer.toByteArray();
                    pdfArray.add(new PdfString(this.k));
                    this.o.put(PdfName.COLORSPACE, pdfArray);
                } else {
                    Image.skip(this.K, n4);
                }
            } else if (pHYs.equals(string)) {
                int n8 = PngImage.getInt(this.K);
                n3 = PngImage.getInt(this.K);
                n2 = this.K.read();
                if (n2 == 1) {
                    this.l = (int)((float)n8 * 0.0254f);
                    this.E = (int)((float)n3 * 0.0254f);
                } else if (n3 != 0) {
                    this.n = (float)n8 / (float)n3;
                }
            } else if (cHRM.equals(string)) {
                this.f = (float)PngImage.getInt(this.K) / 100000.0f;
                this.d = (float)PngImage.getInt(this.K) / 100000.0f;
                this.y = (float)PngImage.getInt(this.K) / 100000.0f;
                this.b = (float)PngImage.getInt(this.K) / 100000.0f;
                this.H = (float)PngImage.getInt(this.K) / 100000.0f;
                this.G = (float)PngImage.getInt(this.K) / 100000.0f;
                this.t = (float)PngImage.getInt(this.K) / 100000.0f;
                this.F = (float)PngImage.getInt(this.K) / 100000.0f;
                this.D = !(Math.abs(this.f) < 1.0E-4f || Math.abs(this.d) < 1.0E-4f || Math.abs(this.y) < 1.0E-4f || Math.abs(this.b) < 1.0E-4f || Math.abs(this.H) < 1.0E-4f || Math.abs(this.G) < 1.0E-4f || Math.abs(this.t) < 1.0E-4f || Math.abs(this.F) < 1.0E-4f);
            } else if (sRGB.equals(string)) {
                int n9 = this.K.read();
                this.i = intents[n9];
                this.s = 2.2f;
                this.f = 0.3127f;
                this.d = 0.329f;
                this.y = 0.64f;
                this.b = 0.33f;
                this.H = 0.3f;
                this.G = 0.6f;
                this.t = 0.15f;
                this.F = 0.06f;
                this.D = true;
            } else if (gAMA.equals(string)) {
                int n10 = PngImage.getInt(this.K);
                if (n10 != 0) {
                    this.s = 100000.0f / (float)n10;
                    if (!this.D) {
                        this.f = 0.3127f;
                        this.d = 0.329f;
                        this.y = 0.64f;
                        this.b = 0.33f;
                        this.H = 0.3f;
                        this.G = 0.6f;
                        this.t = 0.15f;
                        this.F = 0.06f;
                        this.D = true;
                    }
                }
            } else if (iCCP.equals(string)) {
                do {
                    --n4;
                } while (this.K.read() != 0);
                this.K.read();
                byte[] byArray2 = new byte[--n4];
                n3 = 0;
                while (n4 > 0) {
                    n2 = this.K.read(byArray2, n3, n4);
                    if (n2 < 0) {
                        throw new IOException("Premature end of file.");
                    }
                    n3 += n2;
                    n4 -= n2;
                }
                byte[] byArray3 = PdfReader.FlateDecode(byArray2, true);
                byArray2 = null;
                try {
                    this.J = ICC_Profile.getInstance(byArray3);
                }
                catch (Exception exception) {
                    this.J = null;
                }
            } else {
                if (IEND.equals(string)) break;
                Image.skip(this.K, n4);
            }
            Image.skip(this.K, 4);
        }
    }

    public PdfObject c() {
        if (this.J != null) {
            if ((this.c & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        if (this.s == 1.0f && !this.D) {
            if ((this.c & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        if ((this.c & 2) == 0) {
            if (this.s == 1.0f) {
                return PdfName.DEVICEGRAY;
            }
            pdfArray.add(PdfName.CALGRAY);
            pdfDictionary.put(PdfName.GAMMA, new PdfNumber(this.s));
            pdfDictionary.put(PdfName.WHITEPOINT, new PdfLiteral("[1 1 1]"));
            pdfArray.add(pdfDictionary);
        } else {
            PdfObject pdfObject = new PdfLiteral("[1 1 1]");
            pdfArray.add(PdfName.CALRGB);
            if (this.s != 1.0f) {
                PdfArray pdfArray2 = new PdfArray();
                PdfNumber pdfNumber = new PdfNumber(this.s);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfDictionary.put(PdfName.GAMMA, pdfArray2);
            }
            if (this.D) {
                float f2 = this.d * ((this.H - this.t) * this.b - (this.y - this.t) * this.G + (this.y - this.H) * this.F);
                float f3 = this.b * ((this.H - this.t) * this.d - (this.f - this.t) * this.G + (this.f - this.H) * this.F) / f2;
                float f4 = f3 * this.y / this.b;
                float f5 = f3 * ((1.0f - this.y) / this.b - 1.0f);
                float f6 = -this.G * ((this.y - this.t) * this.d - (this.f - this.t) * this.b + (this.f - this.y) * this.F) / f2;
                float f7 = f6 * this.H / this.G;
                float f8 = f6 * ((1.0f - this.H) / this.G - 1.0f);
                float f9 = this.F * ((this.y - this.H) * this.d - (this.f - this.H) * this.d + (this.f - this.y) * this.G) / f2;
                float f10 = f9 * this.t / this.F;
                float f11 = f9 * ((1.0f - this.t) / this.F - 1.0f);
                float f12 = f4 + f7 + f10;
                float f13 = 1.0f;
                float f14 = f5 + f8 + f11;
                PdfArray pdfArray3 = new PdfArray();
                pdfArray3.add(new PdfNumber(f12));
                pdfArray3.add(new PdfNumber(f13));
                pdfArray3.add(new PdfNumber(f14));
                pdfObject = pdfArray3;
                PdfArray pdfArray4 = new PdfArray();
                pdfArray4.add(new PdfNumber(f4));
                pdfArray4.add(new PdfNumber(f3));
                pdfArray4.add(new PdfNumber(f5));
                pdfArray4.add(new PdfNumber(f7));
                pdfArray4.add(new PdfNumber(f6));
                pdfArray4.add(new PdfNumber(f8));
                pdfArray4.add(new PdfNumber(f10));
                pdfArray4.add(new PdfNumber(f9));
                pdfArray4.add(new PdfNumber(f11));
                pdfDictionary.put(PdfName.MATRIX, pdfArray4);
            }
            pdfDictionary.put(PdfName.WHITEPOINT, pdfObject);
            pdfArray.add(pdfDictionary);
        }
        return pdfArray;
    }

    public Image a() throws IOException {
        this.b();
        try {
            Object object;
            Image image;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            int n6 = 0;
            this.I = false;
            if (this.j != null) {
                for (n4 = 0; n4 < this.j.length; ++n4) {
                    n3 = this.j[n4] & 0xFF;
                    if (n3 == 0) {
                        ++n5;
                        n6 = n4;
                    }
                    if (n3 == 0 || n3 == 255) continue;
                    this.I = true;
                    break;
                }
            }
            if ((this.c & 4) != 0) {
                this.I = true;
            }
            boolean bl2 = this.m = !this.I && (n5 > 1 || this.u >= 0);
            if (!this.I && !this.m && n5 == 1) {
                this.o.put(PdfName.MASK, new PdfLiteral("[" + n6 + " " + n6 + "]"));
            }
            n4 = this.x == 1 || this.B == 16 || (this.c & 4) != 0 || this.I || this.m ? 1 : 0;
            switch (this.c) {
                case 0: {
                    this.e = 1;
                    break;
                }
                case 2: {
                    this.e = 3;
                    break;
                }
                case 3: {
                    this.e = 1;
                    break;
                }
                case 4: {
                    this.e = 2;
                    break;
                }
                case 6: {
                    this.e = 4;
                }
            }
            if (n4 != 0) {
                this.d();
            }
            n3 = this.e;
            if ((this.c & 4) != 0) {
                --n3;
            }
            if ((n2 = this.B) == 16) {
                n2 = 8;
            }
            if (this.A != null) {
                image = Image.getInstance(this.a, this.z, n3, n2, this.A);
            } else {
                image = new ImgRaw(this.a, this.z, n3, n2, this.p.toByteArray());
                image.setDeflated(true);
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.BITSPERCOMPONENT, new PdfNumber(this.B));
                ((PdfDictionary)object).put(PdfName.PREDICTOR, new PdfNumber(15));
                ((PdfDictionary)object).put(PdfName.COLUMNS, new PdfNumber(this.a));
                ((PdfDictionary)object).put(PdfName.COLORS, new PdfNumber(this.c == 3 || (this.c & 2) == 0 ? 1 : 3));
                this.o.put(PdfName.DECODEPARMS, (PdfObject)object);
            }
            if (this.o.get(PdfName.COLORSPACE) == null) {
                this.o.put(PdfName.COLORSPACE, this.c());
            }
            if (this.i != null) {
                this.o.put(PdfName.INTENT, this.i);
            }
            if (this.o.size() > 0) {
                image.setAdditional(this.o);
            }
            if (this.J != null) {
                image.tagICC(this.J);
            }
            if (this.I) {
                object = Image.getInstance(this.a, this.z, 1, 8, this.g);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            if (this.m) {
                object = Image.getInstance(this.a, this.z, 1, 1, this.g);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            image.setDpi(this.l, this.E);
            image.setXYRatio(this.n);
            image.setOriginalType(2);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void d() {
        int n2 = this.B;
        if (n2 == 16) {
            n2 = 8;
        }
        int n3 = -1;
        this.C = this.B == 16 ? 2 : 1;
        switch (this.c) {
            case 0: {
                n3 = (n2 * this.a + 7) / 8 * this.z;
                break;
            }
            case 2: {
                n3 = this.a * 3 * this.z;
                this.C *= 3;
                break;
            }
            case 3: {
                if (this.x == 1) {
                    n3 = (n2 * this.a + 7) / 8 * this.z;
                }
                this.C = 1;
                break;
            }
            case 4: {
                n3 = this.a * this.z;
                this.C *= 2;
                break;
            }
            case 6: {
                n3 = this.a * 3 * this.z;
                this.C *= 4;
            }
        }
        if (n3 >= 0) {
            this.A = new byte[n3];
        }
        if (this.I) {
            this.g = new byte[this.a * this.z];
        } else if (this.m) {
            this.g = new byte[(this.a + 7) / 8 * this.z];
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.p.getBuf(), 0, this.p.size());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        this.w = new DataInputStream(inflaterInputStream);
        if (this.x != 1) {
            this.a(0, 0, 1, 1, this.a, this.z);
        } else {
            this.a(0, 0, 8, 8, (this.a + 7) / 8, (this.z + 7) / 8);
            this.a(4, 0, 8, 8, (this.a + 3) / 8, (this.z + 7) / 8);
            this.a(0, 4, 4, 8, (this.a + 3) / 4, (this.z + 3) / 8);
            this.a(2, 0, 4, 4, (this.a + 1) / 4, (this.z + 3) / 4);
            this.a(0, 2, 2, 4, (this.a + 1) / 2, (this.z + 1) / 4);
            this.a(1, 0, 2, 2, this.a / 2, (this.z + 1) / 2);
            this.a(0, 1, 1, 2, this.a, this.z / 2);
        }
    }

    public void a(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 0 || n7 == 0) {
            return;
        }
        int n8 = (this.e * n6 * this.B + 7) / 8;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        int n9 = 0;
        int n10 = n3;
        while (n9 < n7) {
            int n11 = 0;
            try {
                n11 = this.w.read();
                this.w.readFully(byArray, 0, n8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n11) {
                case 0: {
                    break;
                }
                case 1: {
                    PngImage.decodeSubFilter(byArray, n8, this.C);
                    break;
                }
                case 2: {
                    PngImage.decodeUpFilter(byArray, byArray2, n8);
                    break;
                }
                case 3: {
                    PngImage.decodeAverageFilter(byArray, byArray2, n8, this.C);
                    break;
                }
                case 4: {
                    PngImage.decodePaethFilter(byArray, byArray2, n8, this.C);
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            this.a(byArray, n2, n4, n10, n6);
            byte[] byArray3 = byArray2;
            byArray2 = byArray;
            byArray = byArray3;
            ++n9;
            n10 += n5;
        }
    }

    public void a(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int[] nArray = this.a(byArray);
        int n9 = 0;
        switch (this.c) {
            case 0: 
            case 3: 
            case 4: {
                n9 = 1;
                break;
            }
            case 2: 
            case 6: {
                n9 = 3;
            }
        }
        if (this.A != null) {
            n8 = n2;
            n7 = (n9 * this.a * (this.B == 16 ? 8 : this.B) + 7) / 8;
            for (n6 = 0; n6 < n5; ++n6) {
                PngImage.a(this.A, nArray, this.e * n6, n9, n8, n4, this.B, n7);
                n8 += n3;
            }
        }
        if (this.I) {
            if ((this.c & 4) != 0) {
                if (this.B == 16) {
                    for (n7 = 0; n7 < n5; ++n7) {
                        int n10 = n7 * this.e + n9;
                        nArray[n10] = nArray[n10] >>> 8;
                    }
                }
                n7 = this.a;
                n8 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    PngImage.a(this.g, nArray, this.e * n6 + n9, 1, n8, n4, 8, n7);
                    n8 += n3;
                }
            } else {
                n7 = this.a;
                int[] nArray2 = new int[1];
                n8 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    int n11 = nArray[n6];
                    int n12 = 255;
                    if (n11 < this.j.length) {
                        nArray2[0] = this.j[n11];
                    }
                    PngImage.a(this.g, nArray2, 0, 1, n8, n4, 8, n7);
                    n8 += n3;
                }
            }
        } else if (this.m) {
            switch (this.c) {
                case 3: {
                    n7 = (this.a + 7) / 8;
                    int[] nArray3 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n13 = nArray[n6];
                        boolean bl2 = false;
                        if (n13 < this.j.length) {
                            nArray3[0] = this.j[n13] == 0 ? 1 : 0;
                        }
                        PngImage.a(this.g, nArray3, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
                case 0: {
                    n7 = (this.a + 7) / 8;
                    int[] nArray4 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n14 = nArray[n6];
                        nArray4[0] = n14 == this.u ? 1 : 0;
                        PngImage.a(this.g, nArray4, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
                case 2: {
                    n7 = (this.a + 7) / 8;
                    int[] nArray5 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n15 = this.e * n6;
                        nArray5[0] = nArray[n15] == this.u && nArray[n15 + 1] == this.r && nArray[n15 + 2] == this.q ? 1 : 0;
                        PngImage.a(this.g, nArray5, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
            }
        }
    }

    public static void a(byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 8) {
            int n8 = n7 * n5 + n3 * n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n8 + i2] = (byte)nArray[i2 + n2];
            }
        } else if (n6 == 16) {
            int n9 = n7 * n5 + n3 * n4;
            for (int i3 = 0; i3 < n3; ++i3) {
                byArray[n9 + i3] = (byte)(nArray[i3 + n2] >>> 8);
            }
        } else {
            int n10 = n7 * n5 + n4 / (8 / n6);
            int n11 = nArray[n2] << 8 - n6 * (n4 % (8 / n6)) - n6;
            int n12 = n10;
            byArray[n12] = (byte)(byArray[n12] | n11);
        }
    }

    public int[] a(byte[] byArray) {
        switch (this.B) {
            case 8: {
                int[] nArray = new int[byArray.length];
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = byArray[i2] & 0xFF;
                }
                return nArray;
            }
            case 16: {
                int[] nArray = new int[byArray.length / 2];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray[i3] = ((byArray[i3 * 2] & 0xFF) << 8) + (byArray[i3 * 2 + 1] & 0xFF);
                }
                return nArray;
            }
        }
        int[] nArray = new int[byArray.length * 8 / this.B];
        int n2 = 0;
        int n3 = 8 / this.B;
        int n4 = (1 << this.B) - 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            for (int i5 = n3 - 1; i5 >= 0; --i5) {
                nArray[n2++] = byArray[i4] >>> this.B * i5 & n4;
            }
        }
        return nArray;
    }

    private static void decodeSubFilter(byte[] byArray, int n2, int n3) {
        for (int i2 = n3; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n4 += byArray[i2 - n3] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray2[i2] & 0xFF;
            byArray[i2] = (byte)(n3 + n4);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4 / 2);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + (n7 + n4) / 2);
        }
    }

    private static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = Math.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            int n8 = byArray2[n6 - n3] & 0xFF;
            byArray[n6] = (byte)(n5 + PngImage.paethPredictor(n7, n4, n8));
        }
    }

    public static final int getInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    public static final int getWord(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    public static final String getString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 4; ++i2) {
            stringBuffer.append((char)inputStream.read());
        }
        return stringBuffer.toString();
    }

    public static class NewByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }
    }
}

