/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.SimpleXMLDocHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Stack;

public class SimpleXMLParser {
    private static final HashMap fIANA2JavaMap = new HashMap();
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;

    private static int popMode(Stack stack) {
        if (!stack.empty()) {
            return (Integer)stack.pop();
        }
        return 15;
    }

    private SimpleXMLParser() {
    }

    public static void parse(SimpleXMLDocHandler simpleXMLDocHandler, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = inputStream.read(byArray);
        if (n2 != 4) {
            throw new IOException("Insufficient length.");
        }
        String string = SimpleXMLParser.getEncodingName(byArray);
        String string2 = null;
        if (string.equals("UTF-8")) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n3 = inputStream.read()) != -1 && n3 != 62) {
                stringBuffer.append((char)n3);
            }
            string2 = stringBuffer.toString();
        } else if (string.equals("CP037")) {
            int n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n4 = inputStream.read()) != -1 && n4 != 110) {
                byteArrayOutputStream.write(n4);
            }
            string2 = new String(byteArrayOutputStream.toByteArray(), "CP037");
        }
        if (string2 != null && (string2 = SimpleXMLParser.getDeclaredEncoding(string2)) != null) {
            string = string2;
        }
        SimpleXMLParser.parse(simpleXMLDocHandler, new InputStreamReader(inputStream, SimpleXMLParser.getJavaEncoding(string)));
    }

    private static String getDeclaredEncoding(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf("encoding");
        if (n3 < 0) {
            return null;
        }
        int n4 = string.indexOf(34, n3);
        if (n4 == (n2 = string.indexOf(39, n3))) {
            return null;
        }
        if (n4 < 0 && n2 > 0 || n2 > 0 && n2 < n4) {
            int n5 = string.indexOf(39, n2 + 1);
            if (n5 < 0) {
                return null;
            }
            return string.substring(n2 + 1, n5);
        }
        if (n2 < 0 && n4 > 0 || n4 > 0 && n4 < n2) {
            int n6 = string.indexOf(34, n4 + 1);
            if (n6 < 0) {
                return null;
            }
            return string.substring(n4 + 1, n6);
        }
        return null;
    }

    public static String getJavaEncoding(String string) {
        String string2 = string.toUpperCase();
        String string3 = (String)fIANA2JavaMap.get(string2);
        if (string3 == null) {
            string3 = string;
        }
        return string3;
    }

    public static void parse(SimpleXMLDocHandler simpleXMLDocHandler, Reader reader) throws IOException {
        Stack<Integer> stack = new Stack<Integer>();
        int n2 = 0;
        int n3 = 15;
        int n4 = 0;
        int n5 = 34;
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = null;
        String string2 = null;
        String string3 = null;
        HashMap<String, String> hashMap = null;
        stack = new Stack();
        simpleXMLDocHandler.startDocument();
        int n6 = 1;
        int n7 = 0;
        boolean bl2 = false;
        while ((n4 = reader.read()) != -1) {
            if (n4 == 10 && bl2) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                bl2 = false;
            } else if (n4 == 10) {
                ++n6;
                n7 = 0;
            } else if (n4 == 13) {
                bl2 = true;
                n4 = 10;
                ++n6;
                n7 = 0;
            } else {
                ++n7;
            }
            if (n3 == 11) {
                simpleXMLDocHandler.endDocument();
                return;
            }
            if (n3 == 1) {
                if (n4 == 60) {
                    stack.push(new Integer(n3));
                    n3 = 5;
                    if (stringBuffer.length() <= 0) continue;
                    simpleXMLDocHandler.text(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                if (n4 == 38) {
                    stack.push(new Integer(n3));
                    n3 = 2;
                    stringBuffer2.setLength(0);
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 4) {
                if (n4 == 62) {
                    n3 = SimpleXMLParser.popMode(stack);
                    string = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    if (--n2 == 0) {
                        n3 = 11;
                    }
                    simpleXMLDocHandler.endElement(string);
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 16) {
                if (n4 == 62 && stringBuffer.toString().endsWith("]]")) {
                    stringBuffer.setLength(stringBuffer.length() - 2);
                    simpleXMLDocHandler.text(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n3 = SimpleXMLParser.popMode(stack);
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 13) {
                if (n4 == 62 && stringBuffer.toString().endsWith("--")) {
                    stringBuffer.setLength(0);
                    n3 = SimpleXMLParser.popMode(stack);
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 15) {
                if (n4 != 60) continue;
                n3 = 1;
                stack.push(new Integer(n3));
                n3 = 5;
                continue;
            }
            if (n3 == 14) {
                if (n4 != 62 || (n3 = SimpleXMLParser.popMode(stack)) != 1) continue;
                n3 = 15;
                continue;
            }
            if (n3 == 5) {
                n3 = SimpleXMLParser.popMode(stack);
                if (n4 == 47) {
                    stack.push(new Integer(n3));
                    n3 = 4;
                    continue;
                }
                if (n4 == 63) {
                    n3 = 14;
                    continue;
                }
                stack.push(new Integer(n3));
                n3 = 3;
                string = null;
                hashMap = new HashMap<String, String>();
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 2) {
                if (n4 == 59) {
                    n3 = SimpleXMLParser.popMode(stack);
                    String string4 = stringBuffer2.toString();
                    stringBuffer2.setLength(0);
                    if (string4.equals("lt")) {
                        stringBuffer.append('<');
                        continue;
                    }
                    if (string4.equals("gt")) {
                        stringBuffer.append('>');
                        continue;
                    }
                    if (string4.equals("amp")) {
                        stringBuffer.append('&');
                        continue;
                    }
                    if (string4.equals("quot")) {
                        stringBuffer.append('\"');
                        continue;
                    }
                    if (string4.equals("apos")) {
                        stringBuffer.append('\'');
                        continue;
                    }
                    if (string4.startsWith("#x")) {
                        stringBuffer.append((char)Integer.parseInt(string4.substring(2), 16));
                        continue;
                    }
                    if (string4.startsWith("#")) {
                        stringBuffer.append((char)Integer.parseInt(string4.substring(1)));
                        continue;
                    }
                    SimpleXMLParser.exc("Unknown entity: &" + string4 + ";", n6, n7);
                    continue;
                }
                stringBuffer2.append((char)n4);
                continue;
            }
            if (n3 == 12) {
                if (string == null) {
                    string = stringBuffer.toString();
                }
                if (n4 != 62) {
                    SimpleXMLParser.exc("Expected > for tag: <" + string + "/>", n6, n7);
                }
                simpleXMLDocHandler.startElement(string, hashMap);
                simpleXMLDocHandler.endElement(string);
                if (n2 == 0) {
                    simpleXMLDocHandler.endDocument();
                    return;
                }
                stringBuffer.setLength(0);
                hashMap = new HashMap();
                string = null;
                n3 = SimpleXMLParser.popMode(stack);
                continue;
            }
            if (n3 == 3) {
                if (n4 == 62) {
                    if (string == null) {
                        string = stringBuffer.toString();
                    }
                    stringBuffer.setLength(0);
                    ++n2;
                    simpleXMLDocHandler.startElement(string, hashMap);
                    string = null;
                    hashMap = new HashMap();
                    n3 = SimpleXMLParser.popMode(stack);
                    continue;
                }
                if (n4 == 47) {
                    n3 = 12;
                    continue;
                }
                if (n4 == 45 && stringBuffer.toString().equals("!-")) {
                    n3 = 13;
                    continue;
                }
                if (n4 == 91 && stringBuffer.toString().equals("![CDATA")) {
                    n3 = 16;
                    stringBuffer.setLength(0);
                    continue;
                }
                if (n4 == 69 && stringBuffer.toString().equals("!DOCTYP")) {
                    stringBuffer.setLength(0);
                    n3 = 14;
                    continue;
                }
                if (Character.isWhitespace((char)n4)) {
                    string = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    n3 = 8;
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 7) {
                if (n4 == n5) {
                    string3 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    hashMap.put(string2, string3);
                    n3 = 8;
                    continue;
                }
                if (" \r\n\t".indexOf(n4) >= 0) {
                    stringBuffer.append(' ');
                    continue;
                }
                if (n4 == 38) {
                    stack.push(new Integer(n3));
                    n3 = 2;
                    stringBuffer2.setLength(0);
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 10) {
                if (n4 == 34 || n4 == 39) {
                    n5 = n4;
                    n3 = 7;
                    continue;
                }
                if (Character.isWhitespace((char)n4)) continue;
                SimpleXMLParser.exc("Error in attribute processing", n6, n7);
                continue;
            }
            if (n3 == 6) {
                if (Character.isWhitespace((char)n4)) {
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    n3 = 9;
                    continue;
                }
                if (n4 == 61) {
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    n3 = 10;
                    continue;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 9) {
                if (n4 == 61) {
                    n3 = 10;
                    continue;
                }
                if (Character.isWhitespace((char)n4)) continue;
                SimpleXMLParser.exc("Error in attribute processing.", n6, n7);
                continue;
            }
            if (n3 != 8) continue;
            if (n4 == 62) {
                n3 = SimpleXMLParser.popMode(stack);
                simpleXMLDocHandler.startElement(string, hashMap);
                ++n2;
                string = null;
                hashMap = new HashMap();
                continue;
            }
            if (n4 == 47) {
                n3 = 12;
                continue;
            }
            if (Character.isWhitespace((char)n4)) continue;
            n3 = 6;
            stringBuffer.append((char)n4);
        }
        if (n3 == 11) {
            simpleXMLDocHandler.endDocument();
        } else {
            SimpleXMLParser.exc("missing end tag", n6, n7);
        }
    }

    private static void exc(String string, int n2, int n3) throws IOException {
        throw new IOException(string + " near line " + n2 + ", column " + n3);
    }

    public static String escapeXML(String string, boolean bl2) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    if (bl2 && c2 > '\u007f') {
                        stringBuffer.append("&#").append((int)c2).append(";");
                        continue block7;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getEncodingName(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return "UTF-16BE";
        }
        if (n2 == 255 && n3 == 254) {
            return "UTF-16LE";
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return "UTF-8";
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return "UTF-16BE";
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return "UTF-16LE";
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return "CP037";
        }
        return "UTF-8";
    }

    static {
        fIANA2JavaMap.put("BIG5", "Big5");
        fIANA2JavaMap.put("CSBIG5", "Big5");
        fIANA2JavaMap.put("CP037", "CP037");
        fIANA2JavaMap.put("IBM037", "CP037");
        fIANA2JavaMap.put("CSIBM037", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-US", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-CA", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-NL", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-WT", "CP037");
        fIANA2JavaMap.put("IBM277", "CP277");
        fIANA2JavaMap.put("CP277", "CP277");
        fIANA2JavaMap.put("CSIBM277", "CP277");
        fIANA2JavaMap.put("EBCDIC-CP-DK", "CP277");
        fIANA2JavaMap.put("EBCDIC-CP-NO", "CP277");
        fIANA2JavaMap.put("IBM278", "CP278");
        fIANA2JavaMap.put("CP278", "CP278");
        fIANA2JavaMap.put("CSIBM278", "CP278");
        fIANA2JavaMap.put("EBCDIC-CP-FI", "CP278");
        fIANA2JavaMap.put("EBCDIC-CP-SE", "CP278");
        fIANA2JavaMap.put("IBM280", "CP280");
        fIANA2JavaMap.put("CP280", "CP280");
        fIANA2JavaMap.put("CSIBM280", "CP280");
        fIANA2JavaMap.put("EBCDIC-CP-IT", "CP280");
        fIANA2JavaMap.put("IBM284", "CP284");
        fIANA2JavaMap.put("CP284", "CP284");
        fIANA2JavaMap.put("CSIBM284", "CP284");
        fIANA2JavaMap.put("EBCDIC-CP-ES", "CP284");
        fIANA2JavaMap.put("EBCDIC-CP-GB", "CP285");
        fIANA2JavaMap.put("IBM285", "CP285");
        fIANA2JavaMap.put("CP285", "CP285");
        fIANA2JavaMap.put("CSIBM285", "CP285");
        fIANA2JavaMap.put("EBCDIC-CP-FR", "CP297");
        fIANA2JavaMap.put("IBM297", "CP297");
        fIANA2JavaMap.put("CP297", "CP297");
        fIANA2JavaMap.put("CSIBM297", "CP297");
        fIANA2JavaMap.put("EBCDIC-CP-AR1", "CP420");
        fIANA2JavaMap.put("IBM420", "CP420");
        fIANA2JavaMap.put("CP420", "CP420");
        fIANA2JavaMap.put("CSIBM420", "CP420");
        fIANA2JavaMap.put("EBCDIC-CP-HE", "CP424");
        fIANA2JavaMap.put("IBM424", "CP424");
        fIANA2JavaMap.put("CP424", "CP424");
        fIANA2JavaMap.put("CSIBM424", "CP424");
        fIANA2JavaMap.put("EBCDIC-CP-CH", "CP500");
        fIANA2JavaMap.put("IBM500", "CP500");
        fIANA2JavaMap.put("CP500", "CP500");
        fIANA2JavaMap.put("CSIBM500", "CP500");
        fIANA2JavaMap.put("EBCDIC-CP-CH", "CP500");
        fIANA2JavaMap.put("EBCDIC-CP-BE", "CP500");
        fIANA2JavaMap.put("IBM868", "CP868");
        fIANA2JavaMap.put("CP868", "CP868");
        fIANA2JavaMap.put("CSIBM868", "CP868");
        fIANA2JavaMap.put("CP-AR", "CP868");
        fIANA2JavaMap.put("IBM869", "CP869");
        fIANA2JavaMap.put("CP869", "CP869");
        fIANA2JavaMap.put("CSIBM869", "CP869");
        fIANA2JavaMap.put("CP-GR", "CP869");
        fIANA2JavaMap.put("IBM870", "CP870");
        fIANA2JavaMap.put("CP870", "CP870");
        fIANA2JavaMap.put("CSIBM870", "CP870");
        fIANA2JavaMap.put("EBCDIC-CP-ROECE", "CP870");
        fIANA2JavaMap.put("EBCDIC-CP-YU", "CP870");
        fIANA2JavaMap.put("IBM871", "CP871");
        fIANA2JavaMap.put("CP871", "CP871");
        fIANA2JavaMap.put("CSIBM871", "CP871");
        fIANA2JavaMap.put("EBCDIC-CP-IS", "CP871");
        fIANA2JavaMap.put("IBM918", "CP918");
        fIANA2JavaMap.put("CP918", "CP918");
        fIANA2JavaMap.put("CSIBM918", "CP918");
        fIANA2JavaMap.put("EBCDIC-CP-AR2", "CP918");
        fIANA2JavaMap.put("EUC-JP", "EUCJIS");
        fIANA2JavaMap.put("CSEUCPkdFmtJapanese", "EUCJIS");
        fIANA2JavaMap.put("EUC-KR", "KSC5601");
        fIANA2JavaMap.put("GB2312", "GB2312");
        fIANA2JavaMap.put("CSGB2312", "GB2312");
        fIANA2JavaMap.put("ISO-2022-JP", "JIS");
        fIANA2JavaMap.put("CSISO2022JP", "JIS");
        fIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
        fIANA2JavaMap.put("CSISO2022KR", "ISO2022KR");
        fIANA2JavaMap.put("ISO-2022-CN", "ISO2022CN");
        fIANA2JavaMap.put("X0201", "JIS0201");
        fIANA2JavaMap.put("CSISO13JISC6220JP", "JIS0201");
        fIANA2JavaMap.put("X0208", "JIS0208");
        fIANA2JavaMap.put("ISO-IR-87", "JIS0208");
        fIANA2JavaMap.put("X0208dbiJIS_X0208-1983", "JIS0208");
        fIANA2JavaMap.put("CSISO87JISX0208", "JIS0208");
        fIANA2JavaMap.put("X0212", "JIS0212");
        fIANA2JavaMap.put("ISO-IR-159", "JIS0212");
        fIANA2JavaMap.put("CSISO159JISX02121990", "JIS0212");
        fIANA2JavaMap.put("SHIFT_JIS", "SJIS");
        fIANA2JavaMap.put("CSSHIFT_JIS", "SJIS");
        fIANA2JavaMap.put("MS_Kanji", "SJIS");
        fIANA2JavaMap.put("WINDOWS-1250", "Cp1250");
        fIANA2JavaMap.put("WINDOWS-1251", "Cp1251");
        fIANA2JavaMap.put("WINDOWS-1252", "Cp1252");
        fIANA2JavaMap.put("WINDOWS-1253", "Cp1253");
        fIANA2JavaMap.put("WINDOWS-1254", "Cp1254");
        fIANA2JavaMap.put("WINDOWS-1255", "Cp1255");
        fIANA2JavaMap.put("WINDOWS-1256", "Cp1256");
        fIANA2JavaMap.put("WINDOWS-1257", "Cp1257");
        fIANA2JavaMap.put("WINDOWS-1258", "Cp1258");
        fIANA2JavaMap.put("TIS-620", "TIS620");
        fIANA2JavaMap.put("ISO-8859-1", "ISO8859_1");
        fIANA2JavaMap.put("ISO-IR-100", "ISO8859_1");
        fIANA2JavaMap.put("ISO_8859-1", "ISO8859_1");
        fIANA2JavaMap.put("LATIN1", "ISO8859_1");
        fIANA2JavaMap.put("CSISOLATIN1", "ISO8859_1");
        fIANA2JavaMap.put("L1", "ISO8859_1");
        fIANA2JavaMap.put("IBM819", "ISO8859_1");
        fIANA2JavaMap.put("CP819", "ISO8859_1");
        fIANA2JavaMap.put("ISO-8859-2", "ISO8859_2");
        fIANA2JavaMap.put("ISO-IR-101", "ISO8859_2");
        fIANA2JavaMap.put("ISO_8859-2", "ISO8859_2");
        fIANA2JavaMap.put("LATIN2", "ISO8859_2");
        fIANA2JavaMap.put("CSISOLATIN2", "ISO8859_2");
        fIANA2JavaMap.put("L2", "ISO8859_2");
        fIANA2JavaMap.put("ISO-8859-3", "ISO8859_3");
        fIANA2JavaMap.put("ISO-IR-109", "ISO8859_3");
        fIANA2JavaMap.put("ISO_8859-3", "ISO8859_3");
        fIANA2JavaMap.put("LATIN3", "ISO8859_3");
        fIANA2JavaMap.put("CSISOLATIN3", "ISO8859_3");
        fIANA2JavaMap.put("L3", "ISO8859_3");
        fIANA2JavaMap.put("ISO-8859-4", "ISO8859_4");
        fIANA2JavaMap.put("ISO-IR-110", "ISO8859_4");
        fIANA2JavaMap.put("ISO_8859-4", "ISO8859_4");
        fIANA2JavaMap.put("LATIN4", "ISO8859_4");
        fIANA2JavaMap.put("CSISOLATIN4", "ISO8859_4");
        fIANA2JavaMap.put("L4", "ISO8859_4");
        fIANA2JavaMap.put("ISO-8859-5", "ISO8859_5");
        fIANA2JavaMap.put("ISO-IR-144", "ISO8859_5");
        fIANA2JavaMap.put("ISO_8859-5", "ISO8859_5");
        fIANA2JavaMap.put("CYRILLIC", "ISO8859_5");
        fIANA2JavaMap.put("CSISOLATINCYRILLIC", "ISO8859_5");
        fIANA2JavaMap.put("ISO-8859-6", "ISO8859_6");
        fIANA2JavaMap.put("ISO-IR-127", "ISO8859_6");
        fIANA2JavaMap.put("ISO_8859-6", "ISO8859_6");
        fIANA2JavaMap.put("ECMA-114", "ISO8859_6");
        fIANA2JavaMap.put("ASMO-708", "ISO8859_6");
        fIANA2JavaMap.put("ARABIC", "ISO8859_6");
        fIANA2JavaMap.put("CSISOLATINARABIC", "ISO8859_6");
        fIANA2JavaMap.put("ISO-8859-7", "ISO8859_7");
        fIANA2JavaMap.put("ISO-IR-126", "ISO8859_7");
        fIANA2JavaMap.put("ISO_8859-7", "ISO8859_7");
        fIANA2JavaMap.put("ELOT_928", "ISO8859_7");
        fIANA2JavaMap.put("ECMA-118", "ISO8859_7");
        fIANA2JavaMap.put("GREEK", "ISO8859_7");
        fIANA2JavaMap.put("CSISOLATINGREEK", "ISO8859_7");
        fIANA2JavaMap.put("GREEK8", "ISO8859_7");
        fIANA2JavaMap.put("ISO-8859-8", "ISO8859_8");
        fIANA2JavaMap.put("ISO-8859-8-I", "ISO8859_8");
        fIANA2JavaMap.put("ISO-IR-138", "ISO8859_8");
        fIANA2JavaMap.put("ISO_8859-8", "ISO8859_8");
        fIANA2JavaMap.put("HEBREW", "ISO8859_8");
        fIANA2JavaMap.put("CSISOLATINHEBREW", "ISO8859_8");
        fIANA2JavaMap.put("ISO-8859-9", "ISO8859_9");
        fIANA2JavaMap.put("ISO-IR-148", "ISO8859_9");
        fIANA2JavaMap.put("ISO_8859-9", "ISO8859_9");
        fIANA2JavaMap.put("LATIN5", "ISO8859_9");
        fIANA2JavaMap.put("CSISOLATIN5", "ISO8859_9");
        fIANA2JavaMap.put("L5", "ISO8859_9");
        fIANA2JavaMap.put("KOI8-R", "KOI8_R");
        fIANA2JavaMap.put("CSKOI8-R", "KOI8_R");
        fIANA2JavaMap.put("US-ASCII", "ASCII");
        fIANA2JavaMap.put("ISO-IR-6", "ASCII");
        fIANA2JavaMap.put("ANSI_X3.4-1986", "ASCII");
        fIANA2JavaMap.put("ISO_646.IRV:1991", "ASCII");
        fIANA2JavaMap.put("ASCII", "ASCII");
        fIANA2JavaMap.put("CSASCII", "ASCII");
        fIANA2JavaMap.put("ISO646-US", "ASCII");
        fIANA2JavaMap.put("US", "ASCII");
        fIANA2JavaMap.put("IBM367", "ASCII");
        fIANA2JavaMap.put("CP367", "ASCII");
        fIANA2JavaMap.put("UTF-8", "UTF8");
        fIANA2JavaMap.put("UTF-16", "Unicode");
        fIANA2JavaMap.put("UTF-16BE", "UnicodeBig");
        fIANA2JavaMap.put("UTF-16LE", "UnicodeLittle");
    }
}

