/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormXObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfTransparencyGroup;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfTemplate
extends PdfContentByte {
    public static final int TYPE_TEMPLATE = 1;
    public static final int TYPE_IMPORTED = 2;
    public static final int TYPE_PATTERN = 3;
    public int type = 1;
    public PdfIndirectReference thisReference;
    public PageResources pageResources;
    public Rectangle bBox = new Rectangle(0.0f, 0.0f);
    public PdfArray matrix;
    public PdfTransparencyGroup group;

    public PdfTemplate() {
        super(null);
    }

    public PdfTemplate(PdfWriter pdfWriter) {
        super(pdfWriter);
        this.pageResources = new PageResources();
        this.thisReference = this.writer.getPdfIndirectReference();
    }

    public void setWidth(float f2) {
        this.bBox.setLeft(0.0f);
        this.bBox.setRight(f2);
    }

    public void setHeight(float f2) {
        this.bBox.setBottom(0.0f);
        this.bBox.setTop(f2);
    }

    public float getWidth() {
        return this.bBox.width();
    }

    public float getHeight() {
        return this.bBox.height();
    }

    public Rectangle getBoundingBox() {
        return this.bBox;
    }

    public void setBoundingBox(Rectangle rectangle) {
        this.bBox = rectangle;
    }

    public void setMatrix(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.matrix = new PdfArray();
        this.matrix.add(new PdfNumber(f2));
        this.matrix.add(new PdfNumber(f3));
        this.matrix.add(new PdfNumber(f4));
        this.matrix.add(new PdfNumber(f5));
        this.matrix.add(new PdfNumber(f6));
        this.matrix.add(new PdfNumber(f7));
    }

    public PdfArray f() {
        return this.matrix;
    }

    public PdfIndirectReference g() {
        return this.thisReference;
    }

    public void beginVariableText() {
        this.content.append("/Tx BMC ");
    }

    public void endVariableText() {
        this.content.append("EMC ");
    }

    public PdfObject d() {
        return this.c().a();
    }

    public PdfStream e() throws IOException {
        return new PdfFormXObject(this);
    }

    public PdfContentByte getDuplicate() {
        PdfTemplate pdfTemplate = new PdfTemplate();
        pdfTemplate.writer = this.writer;
        pdfTemplate.pdf = this.pdf;
        pdfTemplate.thisReference = this.thisReference;
        pdfTemplate.pageResources = this.pageResources;
        pdfTemplate.bBox = new Rectangle(this.bBox);
        pdfTemplate.group = this.group;
        if (this.matrix != null) {
            pdfTemplate.matrix = new PdfArray(this.matrix);
        }
        return pdfTemplate;
    }

    public int getType() {
        return this.type;
    }

    public PageResources c() {
        return this.pageResources;
    }

    public PdfTransparencyGroup getGroup() {
        return this.group;
    }

    public void setGroup(PdfTransparencyGroup pdfTransparencyGroup) {
        this.group = pdfTransparencyGroup;
    }
}

