/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    private float cellpadding;
    private float cellspacing;

    public PdfTable(Table table, float f2, float f3, float f4) {
        super(f2, f4, f3, f4);
        PdfCell pdfCell;
        int n2;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.columns = table.columns();
        this.cellpadding = table.cellpadding();
        this.cellspacing = table.cellspacing();
        float[] fArray = table.getWidths(f2, f3 - f2);
        this.setLeft(fArray[0]);
        this.setRight(fArray[fArray.length - 1]);
        int n3 = 0;
        int n4 = 0;
        int n5 = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int n6 = table.size() + 1;
        float[] fArray2 = new float[n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            fArray2[i2] = f4;
        }
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            Row row = (Row)iterator.next();
            if (row.isEmpty()) {
                if (n3 < n6 - 1 && fArray2[n3 + 1] > fArray2[n3]) {
                    fArray2[n3 + 1] = fArray2[n3];
                }
            } else {
                for (n2 = 0; n2 < row.columns(); ++n2) {
                    Cell cell;
                    block13: {
                        cell = (Cell)row.getCell(n2);
                        if (cell == null) continue;
                        pdfCell = new PdfCell(cell, n3, fArray[n2], fArray[n2 + cell.colspan()], fArray2[n3], this.cellspacing, this.cellpadding);
                        try {
                            if (fArray2[n3] - pdfCell.height() - this.cellpadding < fArray2[n3 + pdfCell.rowspan()]) {
                                fArray2[n3 + pdfCell.rowspan()] = fArray2[n3] - pdfCell.height() - this.cellpadding;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (!(fArray2[n3] - pdfCell.height() < fArray2[n6 - 1])) break block13;
                            fArray2[n6 - 1] = fArray2[n3] - pdfCell.height();
                        }
                    }
                    if (n3 < n5) {
                        pdfCell.b();
                        this.headercells.add(pdfCell);
                    }
                    pdfCell.a(n4);
                    bl2 |= cell.getGroupChange();
                    this.cells.add(pdfCell);
                }
            }
            ++n3;
            if (!bl2) continue;
            ++n4;
        }
        int n7 = this.cells.size();
        for (n2 = 0; n2 < n7; ++n2) {
            pdfCell = (PdfCell)this.cells.get(n2);
            try {
                pdfCell.setBottom(fArray2[pdfCell.rownumber() + pdfCell.rowspan()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                pdfCell.setBottom(fArray2[n6 - 1]);
            }
        }
        this.setBottom(fArray2[n6 - 1]);
    }

    public ArrayList a() {
        return this.headercells;
    }

    public ArrayList c() {
        return this.cells;
    }

    public int b() {
        return this.columns;
    }

    public float d() {
        return this.cellspacing;
    }
}

