/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class PdfString
extends PdfObject {
    public String value = "";
    public String encoding = "PDF";
    public int objNum = 0;
    public int objGen = 0;
    public boolean hexWriting = false;

    public PdfString() {
        super(3);
    }

    public PdfString(String string) {
        super(3);
        this.value = string;
    }

    public PdfString(String string, String string2) {
        super(3);
        this.value = string;
        this.encoding = string2;
    }

    public PdfString(byte[] byArray) {
        super(3);
        this.value = PdfEncodings.convertToString(byArray, null);
        this.encoding = "";
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBytes();
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.e();
        }
        if (pdfEncryption != null) {
            byArray = (byte[])this.bytes.clone();
            pdfEncryption.prepareKey();
            pdfEncryption.encryptRC4(byArray);
        }
        if (this.hexWriting) {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.append('<');
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.appendHex(byArray[i2]);
            }
            byteBuffer.append('>');
            outputStream.write(byteBuffer.toByteArray());
        } else {
            outputStream.write(PdfContentByte.a(byArray));
        }
    }

    public String toString() {
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toUnicodeString() {
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.value;
        }
        this.getBytes();
        if (this.bytes.length >= 2 && this.bytes[0] == -2 && this.bytes[1] == -1) {
            return PdfEncodings.convertToString(this.bytes, "UnicodeBig");
        }
        return PdfEncodings.convertToString(this.bytes, "PDF");
    }

    public void a(int n2, int n3) {
        this.objNum = n2;
        this.objGen = n3;
    }

    public void a(PdfReader pdfReader) {
        PdfEncryption pdfEncryption = pdfReader.a();
        if (pdfEncryption != null) {
            pdfEncryption.setHashKey(this.objNum, this.objGen);
            pdfEncryption.prepareKey();
            this.bytes = PdfEncodings.convertToBytes(this.value, null);
            pdfEncryption.encryptRC4(this.bytes);
            this.value = PdfEncodings.convertToString(this.bytes, null);
        }
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value) ? PdfEncodings.convertToBytes(this.value, "PDF") : PdfEncodings.convertToBytes(this.value, this.encoding);
        }
        return this.bytes;
    }

    public PdfString setWritingMode(boolean bl2) {
        this.hexWriting = bl2;
        return this;
    }
}

