/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    public boolean compressed = false;
    public ByteArrayOutputStream streamBytes = null;
    public static final byte[] g = DocWriter.getISOBytes("\nstream\n");
    public static final byte[] b = DocWriter.getISOBytes("\nendstream");
    public static final int f = g.length + b.length;

    public PdfStream(byte[] byArray) {
        this.type = 7;
        this.bytes = byArray;
        this.put(PdfName.LENGTH, new PdfNumber(byArray.length));
    }

    public PdfStream() {
        this.type = 7;
    }

    public void flateCompress() throws PdfException {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        PdfObject pdfObject = this.get(PdfName.FILTER);
        if (pdfObject != null) {
            if (pdfObject.isName() && ((PdfName)pdfObject).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (pdfObject.isArray() && ((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new PdfException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(deflaterOutputStream);
            } else {
                deflaterOutputStream.write(this.bytes);
            }
            deflaterOutputStream.close();
            this.streamBytes = byteArrayOutputStream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (pdfObject == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray pdfArray = new PdfArray(pdfObject);
                pdfArray.add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, pdfArray);
            }
            this.compressed = true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void superToPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        super.toPdf(pdfWriter, outputStream);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        this.superToPdf(pdfWriter, outputStream);
        outputStream.write(g);
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.e();
        }
        if (pdfEncryption == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(outputStream);
            } else {
                outputStream.write(this.bytes);
            }
        } else {
            byte[] byArray;
            pdfEncryption.prepareKey();
            if (this.streamBytes != null) {
                byArray = this.streamBytes.toByteArray();
                pdfEncryption.encryptRC4(byArray);
            } else {
                byArray = new byte[this.bytes.length];
                pdfEncryption.encryptRC4(this.bytes, byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(b);
    }
}

