/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;

public class PdfFont
implements Comparable {
    private BaseFont font;
    private float size;
    public Image image;

    public PdfFont(BaseFont baseFont, float f2) {
        this.size = f2;
        this.font = baseFont;
    }

    public int compareTo(Object object) {
        if (this.image != null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        try {
            PdfFont pdfFont = (PdfFont)object;
            if (this.font != pdfFont.font) {
                return 1;
            }
            if (this.d() != pdfFont.d()) {
                return 2;
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return -2;
        }
    }

    public float d() {
        if (this.image == null) {
            return this.size;
        }
        return this.image.scaledHeight();
    }

    public float a() {
        if (this.image == null) {
            return this.font.getWidthPoint(" ", this.size);
        }
        return this.image.scaledWidth();
    }

    public float a(char c2) {
        if (this.image == null) {
            return this.font.getWidthPoint(c2, this.size);
        }
        return this.image.scaledWidth();
    }

    public float a(String string) {
        if (this.image == null) {
            return this.font.getWidthPoint(string, this.size);
        }
        return this.image.scaledWidth();
    }

    public BaseFont c() {
        return this.font;
    }

    public void a(Image image) {
        this.image = image;
    }

    public static PdfFont b() {
        try {
            BaseFont baseFont = BaseFont.createFont("Helvetica", "Cp1252", false);
            return new PdfFont(baseFont, 12.0f);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

