/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfCopy
extends PdfWriter {
    public HashMap indirects;
    public HashMap indirectMap;
    public int currentObjectNum = 1;
    public PdfReader reader;
    public PdfIndirectReference acroForm;
    public PdfIndirectReference topPageParent;
    public ArrayList pageNumbersToRefs = new ArrayList();
    public List newBookmarks;

    public PdfCopy(Document document, OutputStream outputStream) throws DocumentException {
        super(new PdfDocument(), outputStream);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.root.c(this.topPageParent);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n2) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.b() != pdfReader) {
                try {
                    this.currentPdfReaderInstance.d().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.b(n2);
    }

    public PdfIndirectReference copyIndirect(PRIndirectReference pRIndirectReference) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        RefKey refKey = new RefKey(this, pRIndirectReference);
        IndirectReferences indirectReferences = (IndirectReferences)this.indirects.get(refKey);
        if (indirectReferences != null) {
            pdfIndirectReference = indirectReferences.a();
            if (indirectReferences.b()) {
                return pdfIndirectReference;
            }
        } else {
            pdfIndirectReference = this.body.a();
            indirectReferences = new IndirectReferences(this, pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        indirectReferences.c();
        PdfObject pdfObject = this.copyObject(PdfReader.getPdfObject(pRIndirectReference));
        PdfIndirectObject pdfIndirectObject = this.body.a(pdfObject, pdfIndirectReference);
        return pdfIndirectReference;
    }

    public PdfDictionary copyDictionary(PdfDictionary pdfDictionary) throws IOException, BadPdfFormatException {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfName pdfName = (PdfName)pdfDictionary.get(PdfName.TYPE);
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName2 = (PdfName)iterator.next();
            PdfObject pdfObject = pdfDictionary.get(pdfName2);
            if (pdfName2.equals(PdfName.PARENT) && pdfName != null && pdfName.equals(PdfName.PAGE)) {
                pdfDictionary2.put(PdfName.PARENT, this.topPageParent);
                continue;
            }
            pdfDictionary2.put(pdfName2, this.copyObject(pdfObject));
        }
        return pdfDictionary2;
    }

    public PdfStream copyStream(PRStream pRStream) throws IOException, BadPdfFormatException {
        PRStream pRStream2 = new PRStream(pRStream, null);
        Iterator iterator = pRStream.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = pRStream.get(pdfName);
            pRStream2.put(pdfName, this.copyObject(pdfObject));
        }
        return pRStream2;
    }

    public PdfArray copyArray(PdfArray pdfArray) throws IOException, BadPdfFormatException {
        PdfArray pdfArray2 = new PdfArray();
        Iterator iterator = pdfArray.getArrayList().iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = (PdfObject)iterator.next();
            pdfArray2.add(this.copyObject(pdfObject));
        }
        return pdfArray2;
    }

    public PdfObject copyObject(PdfObject pdfObject) throws IOException, BadPdfFormatException {
        switch (pdfObject.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)pdfObject);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)pdfObject);
            }
            case 5: {
                return this.copyArray((PdfArray)pdfObject);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return pdfObject;
            }
            case 7: {
                return this.copyStream((PRStream)pdfObject);
            }
        }
        if (pdfObject.type < 0) {
            String string = ((PdfLiteral)pdfObject).toString();
            if (string.equals("true") || string.equals("false")) {
                return new PdfBoolean(string);
            }
            return new PdfLiteral(string);
        }
        System.out.println("CANNOT COPY type " + pdfObject.type);
        return null;
    }

    public int setFromIPage(PdfImportedPage pdfImportedPage) {
        int n2 = pdfImportedPage.getPageNumber();
        PdfReaderInstance pdfReaderInstance = this.currentPdfReaderInstance = pdfImportedPage.h();
        this.reader = pdfReaderInstance.b();
        this.setFromReader(this.reader);
        return n2;
    }

    public void setFromReader(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.indirects = (HashMap)this.indirectMap.get(pdfReader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(pdfReader, this.indirects);
            PdfDictionary pdfDictionary = pdfReader.getCatalog();
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.PAGES);
            this.indirects.put(new RefKey(this, pRIndirectReference), new IndirectReferences(this, this.topPageParent));
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.ACROFORM);
            if (pRIndirectReference != null) {
                if (this.acroForm == null) {
                    this.acroForm = this.body.a();
                }
                this.indirects.put(new RefKey(this, pRIndirectReference), new IndirectReferences(this, this.acroForm));
            }
        }
    }

    public void addPage(PdfImportedPage pdfImportedPage) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        int n2 = this.setFromIPage(pdfImportedPage);
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n2);
        RefKey refKey = new RefKey(this, pRIndirectReference);
        IndirectReferences indirectReferences = (IndirectReferences)this.indirects.get(refKey);
        if (indirectReferences != null) {
            pdfIndirectReference = indirectReferences.a();
        } else {
            pdfIndirectReference = this.body.a();
            indirectReferences = new IndirectReferences(this, pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        this.pageReferences.add(pdfIndirectReference);
        ++this.currentPageNumber;
        if (!indirectReferences.b()) {
            indirectReferences.c();
            PdfDictionary pdfDictionary2 = this.copyDictionary(pdfDictionary);
            pdfDictionary2.put(PdfName.PARENT, this.topPageParent);
            PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfDictionary2, pdfIndirectReference);
        }
        this.root.b(pdfIndirectReference);
        this.pageNumbersToRefs.add(pdfIndirectReference);
    }

    public PdfIndirectReference getPageReference(int n2) {
        if (n2 < 0 || n2 > this.pageNumbersToRefs.size()) {
            throw new IllegalArgumentException("Invalid page number " + n2);
        }
        return (PdfIndirectReference)this.pageNumbersToRefs.get(n2 - 1);
    }

    public void copyAcroForm(PdfReader pdfReader) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        this.setFromReader(pdfReader);
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.ACROFORM);
        RefKey refKey = new RefKey(this, pRIndirectReference);
        IndirectReferences indirectReferences = (IndirectReferences)this.indirects.get(refKey);
        if (indirectReferences != null) {
            this.acroForm = pdfIndirectReference = indirectReferences.a();
        } else {
            this.acroForm = pdfIndirectReference = this.body.a();
            indirectReferences = new IndirectReferences(this, pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        if (!indirectReferences.b()) {
            indirectReferences.c();
            PdfDictionary pdfDictionary2 = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(pRIndirectReference));
            PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfDictionary2, pdfIndirectReference);
        }
    }

    public PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        try {
            if (this.newBookmarks != null && this.newBookmarks.size() > 0) {
                this.setViewerPreferences(32);
            }
            PdfDocument.PdfCatalog pdfCatalog = ((PdfDocument)this.document).a(pdfIndirectReference);
            if (this.acroForm != null) {
                pdfCatalog.put(PdfName.ACROFORM, this.acroForm);
            }
            if (this.newBookmarks == null || this.newBookmarks.size() == 0) {
                return pdfCatalog;
            }
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfIndirectReference pdfIndirectReference2 = this.getPdfIndirectReference();
            Object[] objectArray = SimpleBookmark.a(this, pdfIndirectReference2, this.newBookmarks, false);
            pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
            pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
            pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
            this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            pdfCatalog.put(PdfName.OUTLINES, pdfIndirectReference2);
            return pdfCatalog;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public synchronized void close() {
        if (this.open) {
            PdfReaderInstance pdfReaderInstance = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (pdfReaderInstance != null) {
                try {
                    pdfReaderInstance.d().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public PdfIndirectReference a(PdfImage pdfImage) throws PdfException {
        return null;
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) {
        return null;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
    }

    public PdfIndirectReference a(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        return null;
    }

    protected class RefKey {
        public int a;
        public int b;
        private final PdfCopy this$0;

        public RefKey(PdfCopy pdfCopy, PRIndirectReference pRIndirectReference) {
            this.this$0 = pdfCopy;
            this.a = pRIndirectReference.getNumber();
            this.b = pRIndirectReference.getGeneration();
        }

        public int hashCode() {
            return (this.b << 16) + this.a;
        }

        public boolean equals(Object object) {
            RefKey refKey = (RefKey)object;
            return this.b == refKey.b && this.a == refKey.a;
        }

        public String toString() {
            return "" + this.a + " " + this.b;
        }
    }

    public class IndirectReferences {
        public PdfIndirectReference b;
        public boolean a;
        private final PdfCopy this$0;

        public IndirectReferences(PdfCopy pdfCopy, PdfIndirectReference pdfIndirectReference) {
            this.this$0 = pdfCopy;
            this.b = pdfIndirectReference;
            this.a = false;
        }

        public void c() {
            this.a = true;
        }

        public boolean b() {
            return this.a;
        }

        public PdfIndirectReference a() {
            return this.b;
        }
    }
}

