/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRendition;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.net.URL;

public class PdfAction
extends PdfDictionary {
    public static final int FIRSTPAGE = 1;
    public static final int PREVPAGE = 2;
    public static final int NEXTPAGE = 3;
    public static final int LASTPAGE = 4;
    public static final int PRINTDIALOG = 5;
    public static final int SUBMIT_EXCLUDE = 1;
    public static final int SUBMIT_INCLUDE_NO_VALUE_FIELDS = 2;
    public static final int SUBMIT_HTML_FORMAT = 4;
    public static final int SUBMIT_HTML_GET = 8;
    public static final int SUBMIT_COORDINATES = 16;
    public static final int RESET_EXCLUDE = 1;

    public PdfAction() {
    }

    public PdfAction(URL uRL) {
        this(uRL.toExternalForm());
    }

    public PdfAction(URL uRL, boolean bl2) {
        this(uRL.toExternalForm(), bl2);
    }

    public PdfAction(String string) {
        this(string, false);
    }

    public PdfAction(String string, boolean bl2) {
        this.put(PdfName.S, PdfName.URI);
        this.put(PdfName.URI, new PdfString(string));
        if (bl2) {
            this.put(PdfName.ISMAP, PdfBoolean.PDFTRUE);
        }
    }

    public PdfAction(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.S, PdfName.GOTO);
        this.put(PdfName.D, pdfIndirectReference);
    }

    public PdfAction(String string, String string2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfString(string2));
    }

    public PdfAction(String string, int n2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfLiteral("[" + (n2 - 1) + " /FitH 10000]"));
    }

    public PdfAction(int n2) {
        this.put(PdfName.S, PdfName.NAMED);
        switch (n2) {
            case 1: {
                this.put(PdfName.N, PdfName.FIRSTPAGE);
                break;
            }
            case 4: {
                this.put(PdfName.N, PdfName.LASTPAGE);
                break;
            }
            case 3: {
                this.put(PdfName.N, PdfName.NEXTPAGE);
                break;
            }
            case 2: {
                this.put(PdfName.N, PdfName.PREVPAGE);
                break;
            }
            case 5: {
                this.put(PdfName.S, PdfName.JAVASCRIPT);
                this.put(PdfName.JS, new PdfString("this.print(true);\r"));
                break;
            }
            default: {
                throw new RuntimeException("Invalid named action.");
            }
        }
    }

    public PdfAction(String string, String string2, String string3, String string4) {
        this.put(PdfName.S, PdfName.LAUNCH);
        if (string2 == null && string3 == null && string4 == null) {
            this.put(PdfName.F, new PdfString(string));
        } else {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.F, new PdfString(string));
            if (string2 != null) {
                pdfDictionary.put(PdfName.P, new PdfString(string2));
            }
            if (string3 != null) {
                pdfDictionary.put(PdfName.O, new PdfString(string3));
            }
            if (string4 != null) {
                pdfDictionary.put(PdfName.D, new PdfString(string4));
            }
            this.put(PdfName.WIN, pdfDictionary);
        }
    }

    public static PdfAction createLaunch(String string, String string2, String string3, String string4) {
        return new PdfAction(string, string2, string3, string4);
    }

    public static PdfAction rendition(String string, PdfFileSpecification pdfFileSpecification, String string2, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RENDITION);
        pdfAction.put(PdfName.R, new PdfRendition(string, pdfFileSpecification, string2));
        pdfAction.put(new PdfName("OP"), new PdfNumber(0));
        pdfAction.put(new PdfName("AN"), pdfIndirectReference);
        return pdfAction;
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.JAVASCRIPT);
        if (bl2 && string.length() < 50) {
            pdfAction.put(PdfName.JS, new PdfString(string, "UnicodeBig"));
        } else if (!bl2 && string.length() < 100) {
            pdfAction.put(PdfName.JS, new PdfString(string));
        } else {
            try {
                byte[] byArray = PdfEncodings.convertToBytes(string, bl2 ? "UnicodeBig" : "PDF");
                PdfStream pdfStream = new PdfStream(byArray);
                pdfStream.flateCompress();
                pdfAction.put(PdfName.JS, pdfWriter.addToBody(pdfStream).getIndirectReference());
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        return pdfAction;
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter) {
        return PdfAction.javaScript(string, pdfWriter, false);
    }

    public static PdfAction a(PdfObject pdfObject, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.HIDE);
        pdfAction.put(PdfName.T, pdfObject);
        if (!bl2) {
            pdfAction.put(PdfName.H, PdfBoolean.PDFFALSE);
        }
        return pdfAction;
    }

    public static PdfAction createHide(PdfAnnotation pdfAnnotation, boolean bl2) {
        return PdfAction.a(pdfAnnotation.d(), bl2);
    }

    public static PdfAction createHide(String string, boolean bl2) {
        return PdfAction.a(new PdfString(string), bl2);
    }

    public static PdfArray a(Object[] objectArray) {
        PdfArray pdfArray = new PdfArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof String) {
                pdfArray.add(new PdfString((String)object));
                continue;
            }
            if (object instanceof PdfAnnotation) {
                pdfArray.add(((PdfAnnotation)object).d());
                continue;
            }
            throw new RuntimeException("The array must contain String or PdfAnnotation.");
        }
        return pdfArray;
    }

    public static PdfAction createHide(Object[] objectArray, boolean bl2) {
        return PdfAction.a(PdfAction.a(objectArray), bl2);
    }

    public static PdfAction createSubmitForm(String string, Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.SUBMITFORM);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.F, new PdfString(string));
        pdfDictionary.put(PdfName.FS, PdfName.URL);
        pdfAction.put(PdfName.F, pdfDictionary);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.a(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createResetForm(Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RESETFORM);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.a(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createImportData(String string) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.IMPORTDATA);
        pdfAction.put(PdfName.F, new PdfString(string));
        return pdfAction;
    }

    public void next(PdfAction pdfAction) {
        PdfObject pdfObject = this.get(PdfName.NEXT);
        if (pdfObject == null) {
            this.put(PdfName.NEXT, pdfAction);
        } else if (pdfObject.isDictionary()) {
            PdfArray pdfArray = new PdfArray(pdfObject);
            pdfArray.add(pdfAction);
            this.put(PdfName.NEXT, pdfArray);
        } else {
            ((PdfArray)pdfObject).add(pdfAction);
        }
    }

    public static PdfAction gotoLocalPage(int n2, PdfDestination pdfDestination, PdfWriter pdfWriter) {
        PdfIndirectReference pdfIndirectReference = pdfWriter.getPageReference(n2);
        pdfDestination.addPage(pdfIndirectReference);
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTO);
        pdfAction.put(PdfName.D, pdfDestination);
        return pdfAction;
    }

    public static PdfAction gotoLocalPage(String string, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTO);
        if (bl2) {
            pdfAction.put(PdfName.D, new PdfName(string));
        } else {
            pdfAction.put(PdfName.D, new PdfString(string, null));
        }
        return pdfAction;
    }

    public static PdfAction gotoRemotePage(String string, String string2, boolean bl2, boolean bl3) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.F, new PdfString(string));
        pdfAction.put(PdfName.S, PdfName.GOTOR);
        if (bl2) {
            pdfAction.put(PdfName.D, new PdfName(string2));
        } else {
            pdfAction.put(PdfName.D, new PdfString(string2, null));
        }
        if (bl3) {
            pdfAction.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
        }
        return pdfAction;
    }
}

