/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.util.Arrays;

public class IntHashtable {
    private IntHashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable(int n2, float f2) {
        if (n2 <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f2;
        this.table = new IntHashtableEntry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public IntHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = intHashtableEntryArray.length;
        while (n3-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.b == n2) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.c;
            }
        }
        return false;
    }

    public boolean containsKey(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.d == n3 && intHashtableEntry.a == n2) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.c;
        }
        return false;
    }

    public int get(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.d == n3 && intHashtableEntry.a == n2) {
                return intHashtableEntry.b;
            }
            intHashtableEntry = intHashtableEntry.c;
        }
        return 0;
    }

    public void rehash() {
        int n2 = this.table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2 * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = intHashtableEntryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.c;
                int n5 = (intHashtableEntry2.d & Integer.MAX_VALUE) % n3;
                intHashtableEntry2.c = intHashtableEntryArray2[n5];
                intHashtableEntryArray2[n5] = intHashtableEntry2;
            }
        }
    }

    public int put(int n2, int n3) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n4 = n2;
        int n5 = (n4 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n5];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.d == n4 && intHashtableEntry.a == n2) {
                int n6 = intHashtableEntry.b;
                intHashtableEntry.b = n3;
                return n6;
            }
            intHashtableEntry = intHashtableEntry.c;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n2, n3);
        }
        intHashtableEntry = new IntHashtableEntry(this);
        intHashtableEntry.d = n4;
        intHashtableEntry.a = n2;
        intHashtableEntry.b = n3;
        intHashtableEntry.c = intHashtableEntryArray[n5];
        intHashtableEntryArray[n5] = intHashtableEntry;
        ++this.count;
        return 0;
    }

    public int remove(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.d == n3 && intHashtableEntry.a == n2) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.c = intHashtableEntry.c;
                } else {
                    intHashtableEntryArray[n4] = intHashtableEntry.c;
                }
                --this.count;
                return intHashtableEntry.b;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.c;
        }
        return 0;
    }

    public void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = intHashtableEntryArray.length;
        while (--n2 >= 0) {
            intHashtableEntryArray[n2] = null;
        }
        this.count = 0;
    }

    public int[] toOrderedKeys() {
        int[] nArray = this.getKeys();
        Arrays.sort(nArray);
        return nArray;
    }

    public int[] getKeys() {
        int[] nArray = new int[this.count];
        int n2 = 0;
        int n3 = this.table.length;
        IntHashtableEntry intHashtableEntry = null;
        while (true) {
            if (intHashtableEntry == null) {
                while (n3-- > 0 && (intHashtableEntry = this.table[n3]) == null) {
                }
            }
            if (intHashtableEntry == null) break;
            IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry2.c;
            nArray[n2++] = intHashtableEntry2.a;
        }
        return nArray;
    }

    public int getOneKey() {
        if (this.count == 0) {
            return 0;
        }
        int n2 = this.table.length;
        IntHashtableEntry intHashtableEntry = null;
        while (n2-- > 0 && (intHashtableEntry = this.table[n2]) == null) {
        }
        if (intHashtableEntry == null) {
            return 0;
        }
        return intHashtableEntry.a;
    }

    public class IntHashtableEntry {
        public int d;
        public int a;
        public int b;
        public IntHashtableEntry c;
        private final IntHashtable this$0;

        public IntHashtableEntry(IntHashtable intHashtable) {
            this.this$0 = intHashtable;
        }
    }
}

