/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class FontDetails {
    public PdfIndirectReference g;
    public PdfName j;
    public BaseFont f;
    public TrueTypeFontUnicode h;
    public CJKFont i;
    public byte[] a;
    public HashMap c;
    public IntHashtable e;
    public int d;
    public boolean b;
    public boolean subset = true;

    public FontDetails(PdfName pdfName, PdfIndirectReference pdfIndirectReference, BaseFont baseFont) {
        this.j = pdfName;
        this.g = pdfIndirectReference;
        this.f = baseFont;
        this.d = baseFont.getFontType();
        switch (this.d) {
            case 0: 
            case 1: {
                this.a = new byte[256];
                break;
            }
            case 2: {
                this.e = new IntHashtable();
                this.i = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.c = new HashMap();
                this.h = (TrueTypeFontUnicode)baseFont;
                this.b = baseFont.isFontSpecific();
            }
        }
    }

    public PdfIndirectReference b() {
        return this.g;
    }

    public PdfName a() {
        return this.j;
    }

    public BaseFont c() {
        return this.f;
    }

    public byte[] a(String string) {
        byte[] byArray = null;
        switch (this.d) {
            case 0: 
            case 1: {
                byArray = this.f.b(string);
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.a[byArray[i2] & 0xFF] = 1;
                }
                break;
            }
            case 2: {
                int n3 = string.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.e.put(this.i.getCidCode(string.charAt(i3)), 0);
                }
                byArray = this.f.b(string);
                break;
            }
            case 4: {
                byArray = this.f.b(string);
                break;
            }
            case 3: {
                try {
                    int n4;
                    int n5 = string.length();
                    int[] nArray = null;
                    char[] cArray = new char[n5];
                    int n6 = 0;
                    if (this.b) {
                        byArray = PdfEncodings.convertToBytes(string, "symboltt");
                        n5 = byArray.length;
                        for (n4 = 0; n4 < n5; ++n4) {
                            nArray = this.h.getMetricsTT(byArray[n4] & 0xFF);
                            if (nArray == null) continue;
                            this.c.put(new Integer(nArray[0]), new int[]{nArray[0], nArray[1], this.h.c(byArray[n4] & 0xFF)});
                            cArray[n6++] = (char)nArray[0];
                        }
                    } else {
                        for (n4 = 0; n4 < n5; ++n4) {
                            char c2 = string.charAt(n4);
                            nArray = this.h.getMetricsTT(c2);
                            if (nArray == null) continue;
                            int n7 = nArray[0];
                            Integer n8 = new Integer(n7);
                            if (!this.c.containsKey(n8)) {
                                this.c.put(n8, new int[]{n7, nArray[1], c2});
                            }
                            cArray[n6++] = (char)n7;
                        }
                    }
                    String string2 = new String(cArray, 0, n6);
                    byArray = string2.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExceptionConverter(unsupportedEncodingException);
                }
            }
        }
        return byArray;
    }

    public void a(PdfWriter pdfWriter) {
        try {
            switch (this.d) {
                case 0: 
                case 1: {
                    int n2;
                    int n3;
                    if (this.subset) {
                        for (n3 = 0; n3 < 256 && this.a[n3] == 0; ++n3) {
                        }
                        for (n2 = 255; n2 >= n3 && this.a[n2] == 0; --n2) {
                        }
                        if (n3 > 255) {
                            n3 = 255;
                            n2 = 255;
                        }
                    } else {
                        for (int i2 = 0; i2 < this.a.length; ++i2) {
                            this.a[i2] = 1;
                        }
                        n3 = 0;
                        n2 = this.a.length - 1;
                    }
                    this.f.a(pdfWriter, this.g, new Object[]{new Integer(n3), new Integer(n2), this.a});
                    break;
                }
                case 2: {
                    this.f.a(pdfWriter, this.g, new Object[]{this.e});
                    break;
                }
                case 3: {
                    this.f.a(pdfWriter, this.g, new Object[]{this.c});
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl2) {
        this.subset = bl2;
    }
}

