/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import java.util.ArrayList;
import java.util.Iterator;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    public int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    public static final int LINE_STATUS_OK = 0;
    public static final int LINE_STATUS_OFFLIMITS = 1;
    public static final int LINE_STATUS_NOLINE = 2;
    public float maxY;
    public float minY;
    public int alignment = 0;
    public ArrayList leftWall;
    public ArrayList rightWall;
    public BidiLine bidiLine = new BidiLine();
    public float yLine;
    public float currentLeading = 16.0f;
    public float fixedLeading = 16.0f;
    public float multipliedLeading = 0.0f;
    public PdfContentByte canvas;
    public int lineStatus;
    public float indent = 0.0f;
    public float followingIndent = 0.0f;
    public float rightIndent = 0.0f;
    public float extraParagraphSpace = 0.0f;
    public float rectangularWidth = -1.0f;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private int arabicOptions = 0;
    public float descender;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
    }

    public static ColumnText duplicate(ColumnText columnText) {
        ColumnText columnText2 = new ColumnText(null);
        columnText2.setSimpleVars(columnText);
        columnText2.bidiLine = new BidiLine(columnText.bidiLine);
        return columnText2;
    }

    public ColumnText setACopy(ColumnText columnText) {
        this.setSimpleVars(columnText);
        this.bidiLine = new BidiLine(columnText.bidiLine);
        return this;
    }

    public void setSimpleVars(ColumnText columnText) {
        this.maxY = columnText.maxY;
        this.minY = columnText.minY;
        this.alignment = columnText.alignment;
        this.leftWall = null;
        if (columnText.leftWall != null) {
            this.leftWall = new ArrayList(columnText.leftWall);
        }
        this.rightWall = null;
        if (columnText.rightWall != null) {
            this.rightWall = new ArrayList(columnText.rightWall);
        }
        this.yLine = columnText.yLine;
        this.currentLeading = columnText.currentLeading;
        this.fixedLeading = columnText.fixedLeading;
        this.multipliedLeading = columnText.multipliedLeading;
        this.canvas = columnText.canvas;
        this.lineStatus = columnText.lineStatus;
        this.indent = columnText.indent;
        this.followingIndent = columnText.followingIndent;
        this.rightIndent = columnText.rightIndent;
        this.extraParagraphSpace = columnText.extraParagraphSpace;
        this.rectangularWidth = columnText.rectangularWidth;
        this.spaceCharRatio = columnText.spaceCharRatio;
        this.lastWasNewline = columnText.lastWasNewline;
        this.linesWritten = columnText.linesWritten;
        this.arabicOptions = columnText.arabicOptions;
        this.descender = columnText.descender;
    }

    public void addText(Phrase phrase) {
        Iterator iterator = phrase.getChunks().iterator();
        while (iterator.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void addText(Chunk chunk) {
        this.bidiLine.addChunk(new PdfChunk(chunk, null));
    }

    public ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (int i2 = 0; i2 < fArray.length - 2; i2 += 2) {
            float f2 = fArray[i2];
            float f3 = fArray[i2 + 1];
            float f4 = fArray[i2 + 2];
            float f5 = fArray[i2 + 3];
            if (f3 == f5) continue;
            float f6 = (f2 - f4) / (f3 - f5);
            float f7 = f2 - f6 * f3;
            float[] fArray2 = new float[]{Math.min(f3, f5), Math.max(f3, f5), f6, f7};
            arrayList.add(fArray2);
            this.maxY = Math.max(this.maxY, fArray2[1]);
            this.minY = Math.min(this.minY, fArray2[0]);
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    public float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            float[] fArray = (float[])arrayList.get(i2);
            if (this.yLine < fArray[0] || this.yLine > fArray[1]) continue;
            return fArray[2] * this.yLine + fArray[3];
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    public float[] findLimitsOneLine() {
        float f2 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f3 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f2, f3};
    }

    public float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        boolean bl2 = false;
        while (true) {
            if (bl2 && this.currentLeading == 0.0f) {
                return null;
            }
            bl2 = true;
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
    }

    public void setSimpleColumn(Phrase phrase, float f2, float f3, float f4, float f5, float f6, int n2) {
        this.addText(phrase);
        this.setSimpleColumn(f2, f3, f4, f5, f6, n2);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5, float f6, int n2) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        fArray[0] = Math.min(f2, f4);
        fArray[1] = Math.max(f3, f5);
        fArray[2] = fArray[0];
        fArray[3] = Math.min(f3, f5);
        fArray2[0] = Math.max(f2, f4);
        fArray2[1] = fArray[1];
        fArray2[2] = fArray2[0];
        fArray2[3] = fArray[3];
        this.setColumns(fArray, fArray2);
        this.setLeading(f6);
        this.alignment = n2;
        this.yLine = fArray[1];
        this.rectangularWidth = Math.abs(f2 - f4);
    }

    public void setLeading(float f2) {
        this.fixedLeading = f2;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f2, float f3) {
        this.fixedLeading = f2;
        this.multipliedLeading = f3;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f2) {
        this.yLine = f2;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f2) {
        this.indent = f2;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f2) {
        this.followingIndent = f2;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f2) {
        this.rightIndent = f2;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl2) throws DocumentException {
        int n2;
        PdfContentByte pdfContentByte;
        boolean bl3;
        block25: {
            this.descender = 0.0f;
            this.linesWritten = 0;
            bl3 = false;
            float f2 = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f3 = new Float(0.0f);
            objectArray[1] = f3;
            PdfDocument pdfDocument = null;
            PdfContentByte pdfContentByte2 = null;
            pdfContentByte = null;
            int n3 = 1;
            if (this.runDirection != 0) {
                n3 = this.runDirection;
            }
            if (this.canvas != null) {
                pdfContentByte2 = this.canvas;
                pdfDocument = this.canvas.getPdfDocument();
                pdfContentByte = this.canvas.getDuplicate();
            } else if (!bl2) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl2) {
                if (f2 == 0.0f) {
                    f2 = pdfContentByte.getPdfWriter().getSpaceCharRatio();
                } else if (f2 < 0.001f) {
                    f2 = 0.001f;
                }
            }
            float f4 = 0.0f;
            n2 = 0;
            if (this.rectangularWidth > 0.0f) {
                while (true) {
                    float f5 = f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= f4 + this.rightIndent) {
                        n2 = 2;
                        if (this.bidiLine.isEmpty()) {
                            n2 |= 1;
                        }
                        break block25;
                    }
                    if (this.bidiLine.isEmpty()) {
                        n2 = 1;
                        break block25;
                    }
                    float f6 = this.yLine;
                    PdfLine pdfLine = this.bidiLine.processLine(this.rectangularWidth - f4 - this.rightIndent, this.alignment, n3, this.arabicOptions);
                    if (pdfLine == null) {
                        n2 = 1;
                        break block25;
                    }
                    float f7 = pdfLine.e();
                    this.currentLeading = this.fixedLeading + f7 * this.multipliedLeading;
                    float[] fArray = this.findLimitsTwoLines();
                    if (fArray == null) {
                        n2 = 2;
                        this.yLine = f6;
                        this.bidiLine.restore();
                        break block25;
                    }
                    float f8 = Math.max(fArray[0], fArray[2]);
                    if (!bl2 && !bl3) {
                        pdfContentByte.beginText();
                        bl3 = true;
                    }
                    if (!bl2) {
                        objectArray[0] = pdfFont;
                        pdfContentByte.setTextMatrix(f8 + (pdfLine.a() ? this.rightIndent : f4) + pdfLine.f(), this.yLine);
                        pdfDocument.a(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    this.lastWasNewline = pdfLine.isNewlineSplit();
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = pdfLine.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine pdfLine;
                f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                float f9 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n2 = 2;
                    if (this.bidiLine.isEmpty()) {
                        n2 |= 1;
                    }
                    this.yLine = f9;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    n2 = 1;
                    this.yLine = f9;
                    break;
                }
                float f10 = Math.max(fArray[0], fArray[2]);
                float f11 = Math.min(fArray[1], fArray[3]);
                if (f11 - f10 <= f4 + this.rightIndent) continue;
                if (!bl2 && !bl3) {
                    pdfContentByte.beginText();
                    bl3 = true;
                }
                if ((pdfLine = this.bidiLine.processLine(f11 - f10 - f4 - this.rightIndent, this.alignment, n3, this.arabicOptions)) == null) {
                    n2 = 1;
                    this.yLine = f9;
                    break;
                }
                if (!bl2) {
                    objectArray[0] = pdfFont;
                    pdfContentByte.setTextMatrix(f10 + (pdfLine.a() ? this.rightIndent : f4) + pdfLine.f(), this.yLine);
                    pdfDocument.a(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                    pdfFont = (PdfFont)objectArray[0];
                }
                this.lastWasNewline = pdfLine.isNewlineSplit();
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = pdfLine.getDescender();
            }
        }
        if (bl3) {
            pdfContentByte.endText();
            this.canvas.add(pdfContentByte);
        }
        return n2;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }

    public void clearChunks() {
        this.bidiLine.clearChunks();
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new RuntimeException("Invalid run direction: " + n2);
        }
        this.runDirection = n2;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n2) {
        this.arabicOptions = n2;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int n2, int n3) {
        ColumnText columnText = new ColumnText(null);
        columnText.addText(phrase);
        PdfLine pdfLine = columnText.bidiLine.processLine(20000.0f, 0, n2, n3);
        if (pdfLine == null) {
            return 0.0f;
        }
        return 20000.0f - pdfLine.c();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n2, Phrase phrase, float f2, float f3, float f4, int n3, int n4) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            n2 = 0;
        }
        pdfContentByte.saveState();
        if (f4 == 0.0f) {
            pdfContentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, f2, f3);
        } else {
            double d2 = (double)f4 * Math.PI / 180.0;
            float f5 = (float)Math.cos(d2);
            float f6 = (float)Math.sin(d2);
            pdfContentByte.concatCTM(f5, f6, -f6, f5, f2, f3);
        }
        ColumnText columnText = new ColumnText(pdfContentByte);
        if (n2 == 0) {
            columnText.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n2);
        } else if (n2 == 2) {
            columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, n2);
        } else {
            columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n2);
        }
        if (n3 == 3) {
            if (n2 == 0) {
                n2 = 2;
            } else if (n2 == 2) {
                n2 = 0;
            }
        }
        columnText.setAlignment(n2);
        columnText.setArabicOptions(n4);
        columnText.setRunDirection(n3);
        try {
            columnText.go();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        pdfContentByte.restoreState();
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n2, Phrase phrase, float f2, float f3, float f4) {
        ColumnText.showTextAligned(pdfContentByte, n2, phrase, f2, f3, f4, 1, 0);
    }
}

