/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class BarcodeEAN128
extends Barcode128 {
    public static HashMap ids;
    public static IntHashtable codesB;
    private String codeText = "";
    private StringBuffer bCode = new StringBuffer(50);
    private int checksum = 0;
    private int ponderation = 2;

    public BarcodeEAN128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 10;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public Rectangle getBarcodeSize(float f2) {
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.font != null) {
            f4 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            String string = this.codeText;
            f3 = this.font.getWidthPoint(string, this.size);
        }
        float f5 = Math.max(f2, f3);
        float f6 = this.barHeight + f4;
        return new Rectangle(f5, f6);
    }

    public byte[] getBarsEAN128(String string) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n2 = string.length();
        if (n2 == 0) {
            linkedList.add(b[104]);
            this.bCode.append('\u00cc');
            linkedList.add(b[102]);
            this.bCode.append('\u00ca');
            return this.getBarsArray(linkedList);
        }
        int n3 = 0;
        linkedList.add(b[105]);
        this.bCode.append('\u00cd');
        linkedList.add(b[102]);
        this.bCode.append('\u00ca');
        this.checksum += 105;
        this.checksum += 102;
        String string2 = "";
        while (string2 != null) {
            string2 = this.getBloc(string, n3);
            if (string2 == null) continue;
            n3 += string2.length();
            this.bCode.append(string2);
            linkedList.add(this.getBarsCode(string2));
        }
        int n4 = this.checksum % 103;
        linkedList.add(b[n4]);
        this.bCode.append((char)n4);
        linkedList.add(a);
        this.bCode.append('\u0000');
        byte[] byArray = this.getBarsArray(linkedList);
        return byArray;
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f2 = 0.0f;
        byte[] byArray = this.getBarsEAN128(this.code);
        if (this.font != null) {
            f2 = this.font.getWidthPoint(this.codeText, this.size);
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f4 = this.barHeight - this.baseline;
            } else {
                f4 = -this.font.getFontDescriptor(3, this.size);
                f3 = f4 + this.baseline;
            }
        }
        boolean bl2 = true;
        float f5 = (float)(byArray.length / 6 * 11 + 2) * this.x;
        float f6 = 0.0f;
        float f7 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f5) {
                    f6 = f2 - f5;
                    break;
                }
                f7 = f5 - f2;
                break;
            }
            default: {
                if (f2 > f5) {
                    f6 = (f2 - f5) / 2.0f;
                    break;
                }
                f7 = (f5 - f2) / 2.0f;
            }
        }
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8 = (float)byArray[i2] * this.x;
            if (bl2) {
                pdfContentByte.rectangle(f6, f3, f8, this.barHeight);
            }
            bl2 = !bl2;
            f6 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f7, f4);
            pdfContentByte.showText(this.codeText);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize(f5);
    }

    public byte[] getBarsCode(String string) {
        try {
            int n2;
            int n3;
            int n4 = 0;
            String string2 = string;
            boolean bl2 = string.endsWith("\u00ca");
            if (bl2) {
                string2 = string.substring(0, string.length() - 1);
                ++n4;
            }
            int n5 = 0;
            if (string2.length() % 2 != 0) {
                n4 = n4 + (string2.length() + 1) / 2 + 2;
                n5 = string2.length() - 1;
            } else {
                n4 += string2.length() / 2;
                n5 = string2.length();
            }
            byte[] byArray = new byte[n4 * 6];
            int[] nArray = new int[2];
            int n6 = 0;
            for (int i2 = 0; i2 < n5 && string2 != null && !"".equals(string2); i2 += 2) {
                nArray[0] = Integer.parseInt("" + string2.charAt(0));
                nArray[1] = Integer.parseInt("" + string2.charAt(1));
                string2 = string2.substring(2);
                n3 = nArray[0] * 10 + nArray[1];
                byte[] byArray2 = b[n3];
                this.checksum += this.ponderation * n3;
                ++this.ponderation;
                for (n2 = 0; n2 < 6; ++n2) {
                    byArray[n6] = b[n3][n2];
                    ++n6;
                }
            }
            if (string2 != null && string2.length() > 0) {
                int n7;
                n3 = string2.charAt(0);
                this.checksum += this.ponderation * 100;
                ++this.ponderation;
                for (n7 = 0; n7 < 6; ++n7) {
                    byArray[n6] = b[100][n7];
                    ++n6;
                }
                n7 = codesB.get(n3);
                for (n2 = 0; n2 < 6; ++n2) {
                    byArray[n6] = b[n7][n2];
                    ++n6;
                }
                this.checksum += this.ponderation * n7;
                ++this.ponderation;
                this.checksum += this.ponderation * 99;
                ++this.ponderation;
                for (n2 = 0; n2 < 6; ++n2) {
                    byArray[n6] = b[99][n2];
                    ++n6;
                }
            }
            if (bl2) {
                this.checksum += this.ponderation * 102;
                ++this.ponderation;
                for (n3 = 0; n3 < 6; ++n3) {
                    byArray[n6] = b[102][n3];
                    ++n6;
                }
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public String getBloc(String string, int n2) {
        Object object;
        Object object2 = null;
        String string2 = null;
        Iterator iterator = ids.keySet().iterator();
        String string3 = string.substring(n2);
        if (string3 == null || "".equals(string3.trim())) {
            return string2;
        }
        while (object2 == null && iterator.hasNext()) {
            object = (String)iterator.next();
            if (!string3.startsWith((String)object)) continue;
            object2 = object;
            this.codeText = this.codeText + "(" + (String)object2 + ")";
        }
        object = (IdentifierEAN)ids.get(object2);
        if (object != null) {
            if (((IdentifierEAN)object).isVariable()) {
                int n3 = string3.indexOf(202);
                if (n3 > 0) {
                    string2 = string3.substring(0, n3 + 1);
                    this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length(), n3) : this.codeText + string2.substring(0, n3);
                } else {
                    string2 = string3;
                    this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length()) : this.codeText + string2;
                }
            } else {
                string2 = string.substring(n2, n2 + ((IdentifierEAN)object).getSize());
                this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length()) : this.codeText + string2;
            }
        }
        return string2;
    }

    private byte[] getBarsArray(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 += ((byte[])iterator.next()).length;
        }
        byte[] byArray = new byte[n2];
        iterator = linkedList.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            byte[] byArray2 = (byte[])iterator.next();
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[n3] = byArray2[i2];
                ++n3;
            }
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        int n2;
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.codeType == 11) {
                n2 = this.code.indexOf(65535);
                string = n2 < 0 ? "" : this.code.substring(n2 + 1);
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : 307 + this.code;
        n2 = string.length();
        float f4 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    static {
        int n2;
        codesB = new IntHashtable(100);
        ids = new HashMap(10000);
        ids.put("00", new IdentifierEAN("00", "n2+n18", 20, false));
        ids.put("01", new IdentifierEAN("01", "n2+n14", 16, false));
        ids.put("02", new IdentifierEAN("02", "n2+n14", 16, false));
        ids.put("10", new IdentifierEAN("10", "n2+an...20", -1, true));
        ids.put("11", new IdentifierEAN("11", "n2+n6", 8, false));
        ids.put("13", new IdentifierEAN("13", "n2+n6", 8, false));
        ids.put("15", new IdentifierEAN("15", "n2+n6", 8, false));
        ids.put("17", new IdentifierEAN("17", "n2+n6", 8, false));
        ids.put("20", new IdentifierEAN("20", "n2+n6", 8, false));
        ids.put("21", new IdentifierEAN("21", "n2+an...20", -1, true));
        ids.put("22", new IdentifierEAN("22", "n2+an...29", -1, true));
        ids.put("230", new IdentifierEAN("230", "n3+n...19", -1, true));
        ids.put("231", new IdentifierEAN("231", "n3+n...19", -1, true));
        ids.put("232", new IdentifierEAN("232", "n3+n...19", -1, true));
        ids.put("233", new IdentifierEAN("233", "n3+n...19", -1, true));
        ids.put("234", new IdentifierEAN("234", "n3+n...19", -1, true));
        ids.put("235", new IdentifierEAN("235", "n3+n...19", -1, true));
        ids.put("236", new IdentifierEAN("236", "n3+n...19", -1, true));
        ids.put("237", new IdentifierEAN("237", "n3+n...19", -1, true));
        ids.put("238", new IdentifierEAN("238", "n3+n...19", -1, true));
        ids.put("239", new IdentifierEAN("239", "n3+n...19", -1, true));
        ids.put("240", new IdentifierEAN("240", "n3+an...30", -1, true));
        ids.put("241", new IdentifierEAN("241", "n3+an...30", -1, true));
        ids.put("250", new IdentifierEAN("250", "n3+an...30", -1, true));
        ids.put("30", new IdentifierEAN("30", "n2+n...8", -1, true));
        for (n2 = 3100; n2 < 3700; ++n2) {
            ids.put("" + n2, new IdentifierEAN("" + n2, "n2+n...8", -1, true));
        }
        ids.put("337", new IdentifierEAN("337", "n4+n6", 10, false));
        ids.put("37", new IdentifierEAN("37", "n2+n...8", -1, true));
        ids.put("400", new IdentifierEAN("400", "n3+an...30", -1, true));
        ids.put("401", new IdentifierEAN("401", "n3+an...30", -1, true));
        ids.put("402", new IdentifierEAN("402", "n3+n17", 20, false));
        ids.put("403", new IdentifierEAN("403", "n3+an...30", -1, true));
        ids.put("410", new IdentifierEAN("410", "n3+n13", 16, false));
        ids.put("411", new IdentifierEAN("411", "n3+n13", 16, false));
        ids.put("412", new IdentifierEAN("412", "n3+n13", 16, false));
        ids.put("413", new IdentifierEAN("413", "n3+n13", 16, false));
        ids.put("414", new IdentifierEAN("414", "n3+n13", 16, false));
        ids.put("420", new IdentifierEAN("420", "n3+an...9", -1, true));
        ids.put("421", new IdentifierEAN("421", "n3+n3+an...9", -1, true));
        ids.put("422", new IdentifierEAN("422", "n3+n3", 6, false));
        ids.put("8001", new IdentifierEAN("8001", "n4+n14", 18, false));
        ids.put("8002", new IdentifierEAN("8002", "n4+an...30", -1, true));
        ids.put("8003", new IdentifierEAN("8003", "n4+n14+an...16", -1, true));
        ids.put("8004", new IdentifierEAN("8004", "n4+an...30", -1, true));
        ids.put("8005", new IdentifierEAN("8005", "n4+n6", 10, false));
        ids.put("8006", new IdentifierEAN("8006", "n4+n14+n2+n2", 22, false));
        ids.put("8018", new IdentifierEAN("8018", "n4+n18", 22, false));
        ids.put("8100", new IdentifierEAN("8100", "n4+n1+n5", 10, false));
        ids.put("8101", new IdentifierEAN("8101", "n4+n1+n5+n4", 14, false));
        ids.put("8102", new IdentifierEAN("8102", "n4+n1+n1", 6, false));
        ids.put("90", new IdentifierEAN("90", "n2+an...30", -1, true));
        for (n2 = 91; n2 < 100; ++n2) {
            ids.put("" + n2, new IdentifierEAN("" + n2, "n2+an...30", -1, true));
        }
        for (n2 = 0; n2 < 95; ++n2) {
            codesB.put(n2 + 32, n2);
        }
        for (n2 = 95; n2 < 196; ++n2) {
            codesB.put(n2 - 95 + 195, n2);
        }
    }

    public static class IdentifierEAN {
        private boolean variable;
        private String id;
        private String format;
        private int size;

        public IdentifierEAN(String string, String string2, int n2, boolean bl2) {
            this.id = string;
            this.format = string2;
            this.variable = bl2;
            this.size = n2;
        }

        public boolean isVariable() {
            return this.variable;
        }

        public void setVariable(boolean bl2) {
            this.variable = bl2;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String string) {
            this.format = string;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n2) {
            this.size = n2;
        }
    }
}

