/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaDo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImgWMF
extends Image
implements Element {
    public ImgWMF(Image image) {
        super(image);
    }

    public ImgWMF(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public ImgWMF(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public ImgWMF(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block6: {
            this.type = 35;
            this.originalType = 6;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                InputMeta inputMeta = new InputMeta(inputStream);
                if (inputMeta.readInt() != -1698247209) {
                    throw new BadElementException(string + " is not a valid placeable windows metafile.");
                }
                inputMeta.readWord();
                int n2 = inputMeta.readShort();
                int n3 = inputMeta.readShort();
                int n4 = inputMeta.readShort();
                int n5 = inputMeta.readShort();
                int n6 = inputMeta.readWord();
                this.dpiX = 72;
                this.dpiY = 72;
                this.scaledHeight = (float)(n5 - n3) / (float)n6 * 72.0f;
                this.setTop(this.scaledHeight);
                this.scaledWidth = (float)(n4 - n2) / (float)n6 * 72.0f;
                this.setRight(this.scaledWidth);
                Object var10_9 = null;
                if (inputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readWMF(PdfTemplate pdfTemplate) throws IOException, DocumentException {
        this.setTemplateData(pdfTemplate);
        pdfTemplate.setWidth(this.width());
        pdfTemplate.setHeight(this.height());
        InputStream inputStream = null;
        try {
            inputStream = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            MetaDo metaDo = new MetaDo(inputStream, pdfTemplate);
            metaDo.readAll();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

