/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.Options;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public final class WindowsTabbedPaneUI
extends com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets NORTH_INSETS = new Insets(1, 0, 0, 0);
    private static final Insets WEST_INSETS = new Insets(0, 1, 0, 0);
    private static final Insets SOUTH_INSETS = new Insets(0, 0, 1, 0);
    private static final Insets EAST_INSETS = new Insets(0, 0, 0, 1);
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
    }

    private boolean hasNoContentBorder() {
        return this.hasEmbeddedTabs() || Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return this.embeddedTabs == null ? false : this.embeddedTabs;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeHandler(this, null);
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void embeddedTabsPropertyChanged(Boolean bl2) {
        this.embeddedTabs = bl2;
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl2) {
        this.noContentBorder = bl2;
        this.doLayout();
    }

    public Icon getIconForTab(int n2) {
        String string = this.tabPane.getTitleAt(n2);
        boolean bl2 = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl2 ? null : super.getIconForTab(n2);
    }

    public Insets getContentBorderInsets(int n2) {
        if (!this.hasNoContentBorder()) {
            return this.contentBorderInsets;
        }
        if (this.hasEmbeddedTabs()) {
            return EMPTY_INSETS;
        }
        switch (n2) {
            case 4: {
                return EAST_INSETS;
            }
            case 2: {
                return WEST_INSETS;
            }
            case 1: {
                return NORTH_INSETS;
            }
        }
        return SOUTH_INSETS;
    }

    public int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        switch (n2) {
            case 4: {
                return bl2 ? 2 : 0;
            }
            case 2: {
                return bl2 ? -2 : 0;
            }
        }
        return 0;
    }

    public int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        return 0;
    }

    public Insets getSelectedTabPadInsets(int n2) {
        int n3;
        if (this.hasEmbeddedTabs()) {
            return EMPTY_INSETS;
        }
        if (this.hasNoContentBorder()) {
            switch (n2) {
                case 2: {
                    return new Insets(1, 2, 1, 0);
                }
                case 4: {
                    return new Insets(1, 0, 1, 2);
                }
                case 1: {
                    return new Insets(2, 2, 0, 2);
                }
                case 3: {
                    return new Insets(0, 2, 2, 2);
                }
            }
            return EMPTY_INSETS;
        }
        Insets insets = super.getSelectedTabPadInsets(n2);
        insets.left = insets.right = (n3 = insets.left + insets.right / 2);
        return insets;
    }

    public Insets getTabAreaInsets(int n2) {
        return this.hasEmbeddedTabs() ? EMPTY_INSETS : super.getTabAreaInsets(n2);
    }

    public void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle;
        if (this.hasNoContentBorder() && n2 != 1) {
            return;
        }
        Rectangle rectangle2 = rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        if (n2 != 1 || n3 < 0 || rectangle.y + rectangle.height + 1 < n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            super.paintContentBorderTopEdge(graphics, n2, n3, n4, n5, n6, n7);
        } else {
            graphics.setColor(this.lightHighlight);
            graphics.fillRect(n4, n5, rectangle.x + 1 - n4, 1);
            graphics.fillRect(rectangle.x + rectangle.width, n5, n4 + n6 - 2 - rectangle.x - rectangle.width, 1);
        }
    }

    public void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
            if (n2 != 3 || n3 < 0 || rectangle.y - 1 > n7 + n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
                super.paintContentBorderBottomEdge(graphics, n2, n3, n4, n5, n6, n7);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n4, n5 + n7 - 1, 1, 1);
                graphics.setColor(this.shadow);
                graphics.fillRect(n4 + 1, n5 + n7 - 2, rectangle.x - 1 - n4, 1);
                graphics.fillRect(rectangle.x + rectangle.width, n5 + n7 - 2, n4 + n6 - 2 - rectangle.x - rectangle.width, 1);
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n4, n5 + n7 - 1, rectangle.x - n4, 1);
                graphics.fillRect(rectangle.x + rectangle.width - 1, n5 + n7 - 1, n4 + n6 - rectangle.x - rectangle.width, 1);
            }
        } else if (n2 == 3) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n4, n5 + n7, n6, 1);
        }
    }

    public void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
            if (n2 != 2 || n3 < 0 || rectangle.x + rectangle.width + 1 < n4 || rectangle.y < n5 || rectangle.y > n5 + n7) {
                super.paintContentBorderLeftEdge(graphics, n2, n3, n4, n5, n6, n7);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n4, n5, 1, rectangle.y + 1 - n5);
                graphics.fillRect(n4, rectangle.y + rectangle.height, 1, n5 + n7 - 1 - rectangle.y - rectangle.height);
            }
        } else if (n2 == 2) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n4, n5, 1, n7);
        }
    }

    public void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.hasNoContentBorder()) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
            if (n2 != 4 || n3 < 0 || rectangle.x - 1 > n4 + n6 || rectangle.y < n5 || rectangle.y > n5 + n7) {
                super.paintContentBorderRightEdge(graphics, n2, n3, n4, n5, n6, n7);
            } else {
                graphics.setColor(this.lightHighlight);
                graphics.fillRect(n4 + n6 - 1, n5, 1, 1);
                graphics.setColor(this.shadow);
                graphics.fillRect(n4 + n6 - 2, n5 + 1, 1, rectangle.y - 1 - n5);
                graphics.fillRect(n4 + n6 - 2, rectangle.y + rectangle.height, 1, n5 + n7 - 1 - rectangle.y - rectangle.height);
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n4 + n6 - 1, n5, 1, rectangle.y - n5);
                graphics.fillRect(n4 + n6 - 1, rectangle.y + rectangle.height - 1, 1, n5 + n7 - rectangle.y - rectangle.height);
            }
        } else if (n2 == 4) {
            graphics.setColor(this.shadow);
            graphics.fillRect(n4 + n6, n5, 1, n7);
        }
    }

    public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (!this.hasEmbeddedTabs()) {
            super.paintTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl2);
            return;
        }
        graphics.translate(n4 - 1, n5 - 1);
        switch (n2) {
            case 1: {
                n13 = 1;
                n12 = n6 - 2;
                n11 = 1;
                n10 = 1;
                n9 = n7 - 1;
                n8 = 0;
                break;
            }
            case 3: {
                n13 = 1;
                n12 = n6 - 2;
                n11 = 1;
                n10 = 0;
                n9 = n7 - 1;
                n8 = 1;
                break;
            }
            case 2: {
                n13 = 1;
                n12 = n6 - 1;
                n11 = 0;
                n10 = 1;
                n9 = n7 - 3;
                n8 = 1;
                break;
            }
            default: {
                n13 = 0;
                n12 = n6 - 1;
                n11 = 1;
                n10 = 1;
                n9 = n7 - 3;
                n8 = 1;
            }
        }
        if (bl2) {
            graphics.setColor(this.lightHighlight);
            graphics.drawRect(n13, n10, n13 + n12 + n11, n10 + n9 + n8);
            graphics.setColor(this.shadow);
            graphics.fillRect(1 + n13, 0, n12, n10);
            graphics.fillRect(0, 1 + n10, n13, n9);
            graphics.fillRect(2 * n13 + n12 + 2 * n11, 1 + n10, n11, n9);
            graphics.fillRect(1 + n13, 2 * n10 + n9 + 2 * n8, n12, n8);
            graphics.fillRect(1, 1, n13, n10);
            graphics.fillRect(2 * n13 + n12 + n11, 1, n11, n10);
            graphics.fillRect(1, 2 * n10 + n9 + n8, n13, n8);
            graphics.fillRect(2 * n13 + n12 + n11, 2 * n10 + n9 + n8, n11, n8);
        } else {
            graphics.setColor(this.shadow);
            graphics.fillRect(n13 + n12 + 2 * n11, n8 * n9 / 2, n11, n9 * 2 / 3);
            graphics.fillRect(n11 * n12 / 2, n10 + n9 + 2 * n8, n12 / 2 + 2, n8);
        }
        graphics.translate(-n4 + 1, -n5 + 1);
    }

    public void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        if (!this.hasEmbeddedTabs()) {
            super.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
            return;
        }
        if (this.tabPane.hasFocus() && bl2) {
            graphics.setColor(this.focus);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle2.x - 2, rectangle2.y, rectangle2.width + 3, rectangle2.height);
        }
    }

    public boolean shouldRotateTabRuns(int n2) {
        return !this.hasEmbeddedTabs();
    }

    public void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        if (!(n2 != 4 && n2 != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
            n4 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    public static void b(WindowsTabbedPaneUI windowsTabbedPaneUI, Boolean bl2) {
        windowsTabbedPaneUI.embeddedTabsPropertyChanged(bl2);
    }

    public static void a(WindowsTabbedPaneUI windowsTabbedPaneUI, Boolean bl2) {
        windowsTabbedPaneUI.noContentBorderPropertyChanged(bl2);
    }

    public static class 1 {
    }

    private class MyPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        private final WindowsTabbedPaneUI this$0;

        private MyPropertyChangeHandler(WindowsTabbedPaneUI windowsTabbedPaneUI) {
            super((BasicTabbedPaneUI)((Object)windowsTabbedPaneUI));
            this.this$0 = windowsTabbedPaneUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (null == string) {
                return;
            }
            if (string.equals("jgoodies.embeddedTabs")) {
                WindowsTabbedPaneUI.b(this.this$0, (Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("jgoodies.noContentBorder")) {
                WindowsTabbedPaneUI.a(this.this$0, (Boolean)propertyChangeEvent.getNewValue());
                return;
            }
        }

        public MyPropertyChangeHandler(WindowsTabbedPaneUI windowsTabbedPaneUI, 1 var2_2) {
            this(windowsTabbedPaneUI);
        }
    }
}

