/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.windows.WindowsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public final class WindowsBorders {
    private static Border menuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border separatorBorder;
    private static Border etchedBorder;
    private static Border menuBarHeaderBorder;
    private static Border toolBarHeaderBorder;
    private static Border rolloverButtonBorder;

    public static Border getButtonBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ButtonBorder buttonBorder = new ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight"), uIDefaults.getColor("controlText"));
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(buttonBorder, new BasicBorders.MarginBorder());
        return compoundBorderUIResource;
    }

    public static Border b() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(null), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    public static Border a() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(null), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    public static Border f() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(null), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    public static Border c() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(null), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    public static Border e() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder(null);
        }
        return popupMenuBorder;
    }

    public static Border d() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(null), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    public static Border g() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(null), new RolloverMarginBorder(null));
        }
        return rolloverButtonBorder;
    }

    private static void drawBezel(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, Color color, Color color2, Color color3, Color color4, Color color5) {
        Color color6 = graphics.getColor();
        graphics.translate(n2, n3);
        if (bl2 && bl3) {
            graphics.setColor(color2);
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.setColor(color);
            graphics.drawRect(1, 1, n4 - 3, n5 - 3);
        } else if (bl2) {
            BasicGraphicsUtils.drawLoweredBezel(graphics, n2, n3, n4, n5, color, color2, color3, color4);
        } else if (bl3) {
            graphics.setColor(color5);
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.setColor(color4);
            graphics.drawLine(1, 1, 1, n5 - 3);
            graphics.drawLine(2, 1, n4 - 3, 1);
            graphics.setColor(color3);
            graphics.drawLine(2, 2, 2, n5 - 4);
            graphics.drawLine(3, 2, n4 - 4, 2);
            graphics.setColor(color);
            graphics.drawLine(2, n5 - 3, n4 - 3, n5 - 3);
            graphics.drawLine(n4 - 3, 2, n4 - 3, n5 - 4);
            graphics.setColor(color2);
            graphics.drawLine(1, n5 - 2, n4 - 2, n5 - 2);
            graphics.drawLine(n4 - 2, n5 - 2, n4 - 2, 1);
        } else {
            graphics.setColor(color4);
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n4 - 2, 0);
            graphics.setColor(color3);
            graphics.drawLine(1, 1, 1, n5 - 3);
            graphics.drawLine(2, 1, n4 - 3, 1);
            graphics.setColor(color);
            graphics.drawLine(1, n5 - 2, n4 - 2, n5 - 2);
            graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 3);
            graphics.setColor(color2);
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 0);
        }
        graphics.translate(-n2, -n3);
        graphics.setColor(color6);
    }

    public static void a(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, Color color, Color color2, Color color3, Color color4, Color color5) {
        WindowsBorders.drawBezel(graphics, n2, n3, n4, n5, bl2, bl3, color, color2, color3, color4, color5);
    }

    public static class 1 {
    }

    private static class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private MenuBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isSelected()) {
                WindowsUtils.b(graphics, n2, n3, n4, n5);
            } else if (buttonModel.isRollover()) {
                WindowsUtils.a(graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public MenuBorder(1 var1_1) {
            this();
        }
    }

    private static class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            WindowsUtils.b(graphics, n2, n3 - 1, n4, n5 + 1);
            WindowsUtils.a(graphics, n2 + 1, n3, n4 - 2, n5 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public ToolBarHeaderBorder(1 var1_1) {
            this();
        }
    }

    private static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.setColor(UIManager.getColor("MenuItem.background"));
            graphics.drawRect(1, 1, n4 - 3, n5 - 3);
            graphics.drawRect(2, 2, n4 - 5, n5 - 5);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public PopupMenuBorder(1 var1_1) {
            this();
        }
    }

    private static class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            WindowsUtils.b(graphics, n2, n3, n4, n5 + 1);
            WindowsUtils.a(graphics, n2 + 1, n3 + 1, n4 - 2, n5 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public MenuBarHeaderBorder(1 var1_1) {
            this();
        }
    }

    private static class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            WindowsUtils.b(graphics, n2, n3, n4, n5);
            WindowsUtils.a(graphics, n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public EtchedBorder(1 var1_1) {
            this();
        }
    }

    public static class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            WindowsUtils.b(graphics, n2, n3, n4, n5);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    public static class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            WindowsUtils.a(graphics, n2, n3, n4, n5);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 3, 2, 1);

        private SeparatorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(UIManager.getColor("Separator.foreground"));
            graphics.drawLine(0, n5 - 2, n4 - 1, n5 - 2);
            graphics.setColor(UIManager.getColor("Separator.background"));
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public SeparatorBorder(1 var1_1) {
            this();
        }
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }

        public RolloverMarginBorder(1 var1_1) {
            this();
        }
    }

    private static class RolloverButtonBorder
    extends AbstractButtonBorder {
        private RolloverButtonBorder() {
            super(null);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover()) {
                    super.paintBorder(component, graphics, n2, n3, n4, n5);
                }
                return;
            }
            if (buttonModel.isSelected()) {
                WindowsUtils.b(graphics, n2, n3, n4, n5);
            } else if (buttonModel.isRollover()) {
                super.paintBorder(component, graphics, n2, n3, n4, n5);
            }
        }

        public RolloverButtonBorder(1 var1_1) {
            this();
        }
    }

    private static abstract class AbstractButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private AbstractButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed()) {
                WindowsUtils.b(graphics, n2, n3, n4, n5);
            } else {
                WindowsUtils.a(graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public AbstractButtonBorder(1 var1_1) {
            this();
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private final Color shadow;
        private final Color darkShadow;
        private final Color highlight;
        private final Color lightHighlight;
        private final Color defaultColor;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4, Color color5) {
            this.shadow = color;
            this.darkShadow = color2;
            this.highlight = color3;
            this.lightHighlight = color4;
            this.defaultColor = color5;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl4 = bl2 = buttonModel.isPressed() && buttonModel.isArmed();
                if (component instanceof JButton) {
                    bl3 = ((JButton)component).isDefaultButton();
                }
            }
            WindowsBorders.a(graphics, n2, n3, n4, n5, bl2, bl3, this.shadow, this.darkShadow, this.highlight, this.lightHighlight, this.defaultColor);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, EMPTY_INSETS);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }
    }
}

