/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateLineStyle(jComponent.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler(this, null);
        jComponent.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(jComponent);
    }

    public void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(graphics, n2, n3, n4);
        }
    }

    public void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(graphics, n2, n3, n4);
        }
    }

    public void drawCentered(Component component, Graphics graphics, Icon icon, int n2, int n3) {
        icon.paintIcon(component, graphics, n2 - icon.getIconWidth() / 2 - 1, n3 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object object) {
        this.linesEnabled = !"None".equals(object);
    }

    public static void a(PlasticTreeUI plasticTreeUI, Object object) {
        plasticTreeUI.updateLineStyle(object);
    }

    public static class 1 {
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private final PlasticTreeUI this$0;

        private LineStyleHandler(PlasticTreeUI plasticTreeUI) {
            this.this$0 = plasticTreeUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals("JTree.lineStyle")) {
                PlasticTreeUI.a(this.this$0, object);
            }
        }

        public LineStyleHandler(PlasticTreeUI plasticTreeUI, 1 var2_2) {
            this(plasticTreeUI);
        }
    }
}

