/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public final class PlasticTabbedPaneUI
extends MetalTabbedPaneUI {
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;
    private AbstractRenderer renderer;
    private ScrollableTabSupport tabScroller;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
        this.renderer = this.createRenderer(this.tabPane);
    }

    public void uninstallUI(JComponent jComponent) {
        this.renderer = null;
        super.uninstallUI(jComponent);
    }

    public void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this, this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
    }

    public void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    public void installListeners() {
        super.installListeners();
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4 && this.scrollableTabLayoutEnabled()) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
    }

    public void uninstallListeners() {
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        super.uninstallListeners();
    }

    public void installKeyboardActions() {
        super.installKeyboardActions();
        if (this.scrollableTabLayoutEnabled()) {
            ScrollTabsForwardAction scrollTabsForwardAction = new ScrollTabsForwardAction(null);
            ScrollTabsBackwardAction scrollTabsBackwardAction = new ScrollTabsBackwardAction(null);
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
            actionMap.put("scrollTabsForwardAction", scrollTabsForwardAction);
            actionMap.put("scrollTabsBackwardAction", scrollTabsBackwardAction);
            this.tabScroller.scrollForwardButton.setAction(scrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(scrollTabsBackwardAction);
        }
    }

    private boolean hasNoContentBorder() {
        return Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return Boolean.TRUE.equals(this.embeddedTabs);
    }

    private AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
        return this.hasEmbeddedTabs() ? AbstractRenderer.b(jTabbedPane) : AbstractRenderer.a(this.tabPane);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeHandler(this, null);
    }

    public ChangeListener createChangeListener() {
        return new TabSelectionHandler(this, null);
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void tabPlacementChanged() {
        this.renderer = this.createRenderer(this.tabPane);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.a();
        }
        this.doLayout();
    }

    private void embeddedTabsPropertyChanged(Boolean bl2) {
        this.embeddedTabs = bl2;
        this.renderer = this.createRenderer(this.tabPane);
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl2) {
        this.noContentBorder = bl2;
        this.tabPane.repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2);
        }
        this.paintContentBorder(graphics, n3, n2);
    }

    public void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n5 = 0;
        int n6 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n2) {
                case 2: 
                case 4: {
                    int n7 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n7 || rectangle3.y + rectangle3.height <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = rectangle3.x;
                    n6 = n7 - 1;
                    break;
                }
                default: {
                    int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n7 || rectangle3.x + rectangle3.width <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = n7 - 1;
                    n6 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        object = this.tabPane.getTitleAt(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n2, n3, bl2, n5, n6);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n2, Rectangle rectangle, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case 2: 
            case 4: {
                n4 = rectangle.width;
                n5 = rectangle.x;
                n6 = rectangle.x + rectangle.width;
                n7 = rectangle.y;
                break;
            }
            default: {
                n4 = rectangle.height;
                n5 = rectangle.y;
                n6 = rectangle.y + rectangle.height;
                n7 = rectangle.x;
            }
        }
        int n8 = n4 / 12;
        if (n4 % 12 > 0) {
            ++n8;
        }
        int n9 = 2 + n8 * 8;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        nArray[n10] = n7;
        nArray2[n10++] = n6;
        nArray[n10] = n7;
        nArray2[n10++] = n5;
        block3: for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < this.xCropLen.length; ++i3) {
                nArray[n10] = n3 - this.xCropLen[i3];
                nArray2[n10] = n5 + i2 * 12 + this.yCropLen[i3];
                if (nArray2[n10] >= n6) {
                    nArray2[n10] = n6;
                    ++n10;
                    continue block3;
                }
                ++n10;
            }
        }
        if (n2 == 1 || n2 == 3) {
            return new Polygon(nArray, nArray2, n10);
        }
        return new Polygon(nArray2, nArray, n10);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl2, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i2 = n4; i2 <= n4 + this.rects[n3].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n5 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n5 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i4 = n5; i4 <= n5 + this.rects[n3].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n4 - this.xCropLen[i5], i4 + this.yCropLen[i5], n4 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    public Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x + point.x - point2.x;
            rectangle.y = this.rects[n2].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n8 = this.tabPane.getTabPlacement();
        boolean bl2 = n8 == 1 || n8 == 3;
        int n9 = n4 = bl2 ? n2 : n3;
        while (n6 != n7) {
            int n10;
            int n11;
            int n12 = (n7 + n6) / 2;
            if (bl2) {
                n11 = this.rects[n12].x;
                n10 = n11 + this.rects[n12].width;
            } else {
                n11 = this.rects[n12].y;
                n10 = n11 + this.rects[n12].height;
            }
            if (n4 < n11) {
                n7 = n12;
                if (n6 != n7) continue;
                return Math.max(0, n12 - 1);
            }
            if (n4 >= n10) {
                n6 = n12;
                if (n7 - n6 > 1) continue;
                return Math.max(n12 + 1, n5 - 1);
            }
            return n12;
        }
        return n6;
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 - point2.x + point3.x;
        point.y = n3 - point2.y + point3.y;
        return point;
    }

    public void paintTabArea(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5;
            int n6 = this.tabRuns[i2];
            int n7 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            for (int i3 = n5 = n7 != 0 ? n7 - 1 : n4 - 1; i3 >= n6; --i3) {
                if (i3 == n3 || !this.rects[i3].intersects(rectangle3)) continue;
                this.paintTab(graphics, n2, this.rects, i3, rectangle, rectangle2);
            }
        }
        if (n3 >= 0 && this.rects[n3].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n3, rectangle, rectangle2);
        }
    }

    public void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        Rectangle rectangle4 = new Rectangle(rectangle);
        if (bl2) {
            Insets insets = this.getSelectedTabPadInsets(n2);
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.bottom + insets.top;
        }
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        if (!(n2 != 4 && n2 != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            n4 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            rectangle2.y += rectangle4.height % 2;
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    public Icon getIconForTab(int n2) {
        String string = this.tabPane.getTitleAt(n2);
        boolean bl2 = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl2 ? null : super.getIconForTab(n2);
    }

    public LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout(this, null);
        }
        return new TabbedPaneLayout(this, null);
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    public boolean isTabInFirstRun(int n2) {
        return this.getRunForTab(this.tabPane.getTabCount(), n2) == 0;
    }

    public void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        graphics.setColor(this.selectColor == null ? this.tabPane.getBackground() : this.selectColor);
        graphics.fillRect(n6, n7, n8, n9);
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        boolean bl2 = n3 >= 0 && this.isTabInFirstRun(n3);
        boolean bl3 = !this.hasNoContentBorder();
        this.renderer.paintContentBorderTopEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderLeftEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderBottomEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
        this.renderer.paintContentBorderRightEdge(graphics, n6, n7, n8, n9, bl2, rectangle, bl3);
    }

    public Insets getContentBorderInsets(int n2) {
        return this.renderer.getContentBorderInsets(super.getContentBorderInsets(n2));
    }

    public Insets getTabAreaInsets(int n2) {
        return this.renderer.getTabAreaInsets(super.getTabAreaInsets(n2));
    }

    public int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        return this.renderer.getTabLabelShiftX(n3, bl2);
    }

    public int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        return this.renderer.getTabLabelShiftY(n3, bl2);
    }

    public int getTabRunOverlay(int n2) {
        return this.renderer.getTabRunOverlay(this.tabRunOverlay);
    }

    public boolean shouldPadTabRun(int n2, int n3) {
        return this.renderer.shouldPadTabRun(n3, super.shouldPadTabRun(n2, n3));
    }

    public int getTabRunIndent(int n2, int n3) {
        return this.renderer.getTabRunIndent(n3);
    }

    public Insets getTabInsets(int n2, int n3) {
        return this.renderer.getTabInsets(n3, this.tabInsets);
    }

    public Insets getSelectedTabPadInsets(int n2) {
        return this.renderer.getSelectedTabPadInsets();
    }

    public void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        this.renderer.paintFocusIndicator(graphics, rectangleArray, n3, rectangle, rectangle2, bl2);
    }

    public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.renderer.paintTabBackground(graphics, n3, n4, n5, n6, n7, bl2);
    }

    public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.renderer.paintTabBorder(graphics, n3, n4, n5, n6, n7, bl2);
    }

    public boolean shouldRotateTabRuns(int n2) {
        return false;
    }

    private boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    public static Rectangle[] S(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bb(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static ScrollableTabSupport ab(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabScroller;
    }

    public static AbstractRenderer bh(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.renderer;
    }

    public static void aK(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.tabPlacementChanged();
    }

    public static void a(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl2) {
        plasticTabbedPaneUI.embeddedTabsPropertyChanged(bl2);
    }

    public static void b(PlasticTabbedPaneUI plasticTabbedPaneUI, Boolean bl2) {
        plasticTabbedPaneUI.noContentBorderPropertyChanged(bl2);
    }

    public static FontMetrics l(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    public static JTabbedPane h(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane F(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane as(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane ba(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static int B(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int q(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    public static int E(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int p(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    public static int m(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int l(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int d(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    public static int ai(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int h(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int m(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    public static int w(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    public static int g(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    public static Rectangle[] O(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] e(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bn(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int[] c(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int y(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    public static int D(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int a(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n2, n3, fontMetrics);
    }

    public static int e(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int p(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int aF(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int[] M(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static void aa(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    public static int[] aj(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int J(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int aU(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    public static int K(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int bu(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static Rectangle[] X(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] al(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int[] ax(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int s(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    public static int k(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int b(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabHeight(n2, n3, n4);
    }

    public static int n(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int g(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int aQ(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int[] br(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static void aM(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        plasticTabbedPaneUI.expandTabRunsArray();
    }

    public static int[] j(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int aO(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int B(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount++;
    }

    public static int f(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int aA(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int z(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    public static int b(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int D(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int aH(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.selectedRun;
    }

    public static int aJ(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int[] bi(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int[] a(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int aT(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static Rectangle[] v(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int R(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int aG(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static Rectangle[] s(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int bd(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int aL(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static Rectangle[] n(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] V(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bo(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static boolean aW(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.scrollableTabLayoutEnabled();
    }

    public static int i(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    public static int o(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    public static JTabbedPane bf(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane ah(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane aq(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane U(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static Component aE(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getVisibleComponent();
    }

    public static void a(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    public static JTabbedPane aI(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static void b(PlasticTabbedPaneUI plasticTabbedPaneUI, Component component) {
        plasticTabbedPaneUI.setVisibleComponent(component);
    }

    public static JTabbedPane x(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane G(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static int z(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int af(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int d(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n2, n3, n4);
    }

    public static int L(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int am(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int f(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaWidth(n2, n3, n4);
    }

    public static int aS(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int ar(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int c(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n2, n3, n4);
    }

    public static int av(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.runCount;
    }

    public static int H(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int a(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabAreaHeight(n2, n3, n4);
    }

    public static JTabbedPane Q(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static Rectangle[] ay(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] W(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] N(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] ao(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] at(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bm(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bj(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] k(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static boolean aD(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.requestFocusForVisibleComponent();
    }

    public static JTabbedPane ak(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static FontMetrics bc(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.getFontMetrics();
    }

    public static JTabbedPane aX(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane i(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane aV(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane aR(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static int C(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int t(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabWidth(n2);
    }

    public static int v(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int b(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        return plasticTabbedPaneUI.calculateMaxTabHeight(n2);
    }

    public static int c(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    public static int f(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    public static int x(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.selectedRun = n2;
        return plasticTabbedPaneUI.selectedRun;
    }

    public static int a(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.runCount = n2;
        return plasticTabbedPaneUI.runCount;
    }

    public static Rectangle[] au(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] aZ(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] y(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int[] bk(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int u(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int C(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int b(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, FontMetrics fontMetrics) {
        return plasticTabbedPaneUI.calculateTabWidth(n2, n3, fontMetrics);
    }

    public static int r(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabWidth = n2;
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int E(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int aw(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static Rectangle[] bg(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] an(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static int[] bq(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabRuns;
    }

    public static int A(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int Z(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static int e(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3, int n4) {
        return plasticTabbedPaneUI.calculateTabHeight(n2, n3, n4);
    }

    public static int j(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
        plasticTabbedPaneUI.maxTabHeight = n2;
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int t(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabHeight;
    }

    public static int aC(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.maxTabWidth;
    }

    public static Rectangle[] Y(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bt(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] aY(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static JTabbedPane ad(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane d(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane ac(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane ap(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane r(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static Rectangle[] ae(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] bl(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static JTabbedPane o(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane aN(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static int a(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2, int n3) {
        return plasticTabbedPaneUI.getClosestTab(n2, n3);
    }

    public static Rectangle[] bp(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static Rectangle[] be(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.rects;
    }

    public static JTabbedPane aB(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane P(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane w(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane aP(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane T(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane A(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane u(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane q(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane bs(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane az(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane I(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static JTabbedPane ag(PlasticTabbedPaneUI plasticTabbedPaneUI) {
        return plasticTabbedPaneUI.tabPane;
    }

    public static class 1 {
    }

    private static class TopRenderer
    extends AbstractRenderer {
        private TopRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return new Insets(insets.top, insets.left + 4, insets.bottom, insets.right);
        }

        public int getTabLabelShiftY(int n2, boolean bl2) {
            return bl2 ? -1 : 0;
        }

        public int getTabRunOverlay(int n2) {
            return n2 - 2;
        }

        public int getTabRunIndent(int n2) {
            return 6 * n2;
        }

        public Insets getSelectedTabPadInsets() {
            return NORTH_INSETS;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top - 1, insets.left - 4, insets.bottom, insets.right - 4);
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
            if (!this.tabPane.hasFocus() || !bl2) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n2];
            int n3 = rectangle3.y + 1;
            int n4 = rectangle3.x + 4;
            int n5 = rectangle3.height - 3;
            int n6 = rectangle3.width - 9;
            graphics.setColor(this.focus);
            graphics.drawRect(n4, n3, n6, n5);
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = bl2 ? 0 : 1;
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4 + n7, n5, n6 / 2);
            graphics.fillRect(n3 - 1, n4 + n7 + n6 / 2, n5 + 2, n6 - n6 / 2);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.translate(n3 - 4, n4);
            int n7 = 0;
            int n8 = n5 + 6;
            graphics.setColor(this.selectHighlight);
            graphics.drawLine(1, n6 - 1, 4, n7 + 4);
            graphics.fillRect(5, n7 + 2, 1, 2);
            graphics.fillRect(6, n7 + 1, 1, 1);
            graphics.fillRect(7, n7, n8 - 12, 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n8, n6 - 1, n8 - 3, n7 + 4);
            graphics.fillRect(n8 - 4, n7 + 2, 1, 2);
            graphics.fillRect(n8 - 5, n7 + 1, 1, 1);
            graphics.translate(-n3 + 4, -n4);
        }

        public void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            int n6 = n2 + n4 - 1;
            int n7 = n3;
            graphics.setColor(this.selectHighlight);
            if (bl2 && rectangle.x >= n2 && rectangle.x <= n2 + n4) {
                graphics.fillRect(n2, n7, rectangle.x - 2 - n2, 1);
                if (rectangle.x + rectangle.width < n2 + n4 - 2) {
                    graphics.fillRect(rectangle.x + rectangle.width + 2, n7, n6 - 2 - rectangle.x - rectangle.width, 1);
                } else {
                    graphics.fillRect(n2 + n4 - 2, n7, 1, 1);
                }
            } else {
                graphics.fillRect(n2, n7, n4 - 1, 1);
            }
        }

        public int getTabsOverlay() {
            return 6;
        }

        public TopRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class TopEmbeddedRenderer
    extends AbstractRenderer {
        private TopEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        public Insets getContentBorderInsets(Insets insets) {
            return NORTH_INSETS;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left + 1, insets.bottom, insets.right);
        }

        public Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4, n5, n6);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.translate(n3, n4);
            int n7 = n5;
            int n8 = n6;
            if (this.isFirstDisplayedTab(n2, n3, this.tabPane.getBounds().x)) {
                if (bl2) {
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, 1, n8);
                    graphics.fillRect(0, 0, n7 - 1, 1);
                    graphics.fillRect(n7 - 1, 0, 1, n8);
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n7 - 1, 0, 1, 1);
                    graphics.fillRect(n7, 1, 1, n8);
                }
            } else if (bl2) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 1, 1, n8 - 1);
                graphics.fillRect(2, 0, n7 - 3, 1);
                graphics.fillRect(n7 - 1, 1, 1, n8 - 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 1, 1, n8 - 1);
                graphics.fillRect(1, 0, 1, 1);
                graphics.fillRect(n7 - 1, 0, 1, 1);
                graphics.fillRect(n7, 1, 1, n8);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, 1, n8 + 2 - n8 / 2);
            }
            graphics.translate(-n3, -n4);
        }

        public void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n2, n3, n4, 1);
        }

        public TopEmbeddedRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class RightRenderer
    extends AbstractRenderer {
        private RightRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public int getTabLabelShiftX(int n2, boolean bl2) {
            return 1;
        }

        public int getTabRunOverlay(int n2) {
            return 1;
        }

        public boolean shouldPadTabRun(int n2, boolean bl2) {
            return false;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left - 5, insets.bottom + 1, insets.right - 5);
        }

        public Insets getSelectedTabPadInsets() {
            return EAST_INSETS;
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
            if (!this.tabPane.hasFocus() || !bl2) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n2];
            int n3 = rectangle3.y + 2;
            int n4 = rectangle3.x + 3;
            int n5 = rectangle3.height - 5;
            int n6 = rectangle3.width - 6;
            graphics.setColor(this.focus);
            graphics.drawRect(n4, n3, n6, n5);
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            if (!bl2) {
                graphics.setColor(this.selectLight);
                graphics.fillRect(n3, n4, n5, n6);
            } else {
                graphics.setColor(this.selectColor);
                graphics.fillRect(n3 + 2, n4, n5 - 2, n6);
            }
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6 - 1;
            int n8 = n5;
            graphics.translate(n3, n4);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(0, 0, n8 - 1, 1);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(n8 - 1, 1, 1, 1);
            graphics.fillRect(n8, 2, 1, n7 - 3);
            graphics.fillRect(n8 - 1, n7 - 1, 1, 1);
            graphics.fillRect(0, n7, n8 - 1, 1);
            graphics.translate(-n3, -n4);
        }

        public void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.darkShadow);
            if (bl2 && rectangle.y >= n3 && rectangle.y <= n3 + n5) {
                graphics.fillRect(n2 + n4 - 1, n3, 1, rectangle.y - n3);
                if (rectangle.y + rectangle.height < n3 + n5 - 2) {
                    graphics.fillRect(n2 + n4 - 1, rectangle.y + rectangle.height, 1, n3 + n5 - rectangle.y - rectangle.height);
                }
            } else {
                graphics.fillRect(n2 + n4 - 1, n3, 1, n5 - 1);
            }
        }

        public RightRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class RightEmbeddedRenderer
    extends AbstractRenderer {
        private RightEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        public Insets getContentBorderInsets(Insets insets) {
            return EAST_INSETS;
        }

        public int getTabRunIndent(int n2) {
            return 4 * n2;
        }

        public int getTabRunOverlay(int n2) {
            return 0;
        }

        public boolean shouldPadTabRun(int n2, boolean bl2) {
            return false;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        public Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4, n5, n6);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6;
            int n8 = n5 - 1;
            graphics.translate(n3 + 1, n4);
            if (this.isFirstDisplayedTab(n2, n4, this.tabPane.getBounds().y)) {
                if (bl2) {
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n8 - 1, n7 - 1, 1, 1);
                    graphics.fillRect(0, n7, n8 - 1, 1);
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, n8 - 1, 1);
                    graphics.fillRect(n8 - 1, 0, 1, n7 - 1);
                    graphics.fillRect(0, n7 - 1, n8 - 1, 1);
                }
            } else if (bl2) {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, -1, n8 - 1, 1);
                graphics.fillRect(n8 - 1, 0, 1, 1);
                graphics.fillRect(n8 - 1, n7 - 1, 1, 1);
                graphics.fillRect(0, n7, n8 - 1, 1);
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(0, 0, n8 - 1, 1);
                graphics.fillRect(n8 - 1, 1, 1, n7 - 2);
                graphics.fillRect(0, n7 - 1, n8 - 1, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(2 * n8 / 3, 0, n8 / 3, 1);
            }
            graphics.translate(-n3 - 1, -n4);
        }

        public void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n2 + n4 - 1, n3, 1, n5);
        }

        public RightEmbeddedRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class LeftRenderer
    extends AbstractRenderer {
        private LeftRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        }

        public int getTabLabelShiftX(int n2, boolean bl2) {
            return 1;
        }

        public int getTabRunOverlay(int n2) {
            return 1;
        }

        public boolean shouldPadTabRun(int n2, boolean bl2) {
            return false;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left - 5, insets.bottom + 1, insets.right - 5);
        }

        public Insets getSelectedTabPadInsets() {
            return WEST_INSETS;
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
            if (!this.tabPane.hasFocus() || !bl2) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n2];
            int n3 = rectangle3.y + 2;
            int n4 = rectangle3.x + 3;
            int n5 = rectangle3.height - 5;
            int n6 = rectangle3.width - 6;
            graphics.setColor(this.focus);
            graphics.drawRect(n4, n3, n6, n5);
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            if (!bl2) {
                graphics.setColor(this.selectLight);
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 2);
            } else {
                graphics.setColor(this.selectColor);
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 2);
            }
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6 - 1;
            int n8 = 0;
            graphics.translate(n3, n4);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(n8 + 2, 0, n5 - 2 - n8, 1);
            graphics.fillRect(n8 + 1, 1, 1, 1);
            graphics.fillRect(n8, 2, 1, n7 - 3);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(n8 + 1, n7 - 1, 1, 1);
            graphics.fillRect(n8 + 2, n7, n5 - 2 - n8, 1);
            graphics.translate(-n3, -n4);
        }

        public void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.selectHighlight);
            if (bl2 && rectangle.y >= n3 && rectangle.y <= n3 + n5) {
                graphics.fillRect(n2, n3, 1, rectangle.y + 1 - n3);
                if (rectangle.y + rectangle.height < n3 + n5 - 2) {
                    graphics.fillRect(n2, rectangle.y + rectangle.height - 1, 1, n3 + n5 - rectangle.y - rectangle.height);
                }
            } else {
                graphics.fillRect(n2, n3, 1, n5 - 1);
            }
        }

        public LeftRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class LeftEmbeddedRenderer
    extends AbstractRenderer {
        private LeftEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        public Insets getContentBorderInsets(Insets insets) {
            return WEST_INSETS;
        }

        public int getTabRunOverlay(int n2) {
            return 0;
        }

        public boolean shouldPadTabRun(int n2, boolean bl2) {
            return false;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        public Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4, n5, n6);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6;
            int n8 = n5;
            graphics.translate(n3, n4);
            if (this.isFirstDisplayedTab(n2, n4, this.tabPane.getBounds().y)) {
                if (bl2) {
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, n8, 1);
                    graphics.fillRect(0, 0, 1, n7 - 1);
                    graphics.fillRect(1, n7 - 1, n8 - 1, 1);
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(0, n7 - 1, 1, 1);
                    graphics.fillRect(1, n7, n8 - 1, 1);
                }
            } else if (bl2) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 1, n8 - 1, 1);
                graphics.fillRect(0, 2, 1, n7 - 2);
                graphics.fillRect(1, n7 - 1, n8 - 1, 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(1, 0, n8 - 1, 1);
                graphics.fillRect(0, 1, 1, 1);
                graphics.fillRect(0, n7 - 1, 1, 1);
                graphics.fillRect(1, n7, n8 - 1, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, n8 / 3, 1);
            }
            graphics.translate(-n3, -n4);
        }

        public void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n2, n3, 1, n5);
        }

        public LeftEmbeddedRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static final class BottomRenderer
    extends AbstractRenderer {
        private BottomRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return new Insets(insets.top, insets.left + 5, insets.bottom, insets.right);
        }

        public int getTabLabelShiftY(int n2, boolean bl2) {
            return bl2 ? 0 : -1;
        }

        public int getTabRunOverlay(int n2) {
            return n2 - 2;
        }

        public int getTabRunIndent(int n2) {
            return 6 * n2;
        }

        public Insets getSelectedTabPadInsets() {
            return SOUTH_INSETS;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left - 2, insets.bottom, insets.right - 2);
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
            if (!this.tabPane.hasFocus() || !bl2) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n2];
            int n3 = rectangle3.y;
            int n4 = rectangle3.x + 6;
            int n5 = rectangle3.height - 3;
            int n6 = rectangle3.width - 12;
            graphics.setColor(this.focus);
            graphics.drawRect(n4, n3, n6, n5);
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4, n5, n6);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6 - 1;
            int n8 = n5 + 4;
            graphics.translate(n3 - 3, n4);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(0, 0, 1, 2);
            graphics.drawLine(0, 2, 4, n7 - 4);
            graphics.fillRect(5, n7 - 3, 1, 2);
            graphics.fillRect(6, n7 - 1, 1, 1);
            graphics.fillRect(7, n7, 1, 1);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(8, n7, n8 - 13, 1);
            graphics.drawLine(n8 + 1, 0, n8 - 3, n7 - 4);
            graphics.fillRect(n8 - 4, n7 - 3, 1, 2);
            graphics.fillRect(n8 - 5, n7 - 1, 1, 1);
            graphics.translate(-n3 + 3, -n4);
        }

        public void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            int n6 = n3 + n5 - 1;
            int n7 = n2 + n4 - 1;
            graphics.translate(n2, n6);
            if (bl2 && rectangle.x >= n2 && rectangle.x <= n2 + n4) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(0, 0, rectangle.x - n2 - 2, 1);
                if (rectangle.x + rectangle.width < n2 + n4 - 2) {
                    graphics.setColor(this.darkShadow);
                    graphics.fillRect(rectangle.x + rectangle.width + 2 - n2, 0, n7 - rectangle.x - rectangle.width - 2, 1);
                }
            } else {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(0, 0, n4 - 1, 1);
            }
            graphics.translate(-n2, -n6);
        }

        public int getTabsOverlay() {
            return 4;
        }

        public BottomRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class BottomEmbeddedRenderer
    extends AbstractRenderer {
        private BottomEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane, null);
        }

        public Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        public Insets getContentBorderInsets(Insets insets) {
            return SOUTH_INSETS;
        }

        public Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        public Insets getTabInsets(int n2, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        public void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        }

        public void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n3, n4, n5 + 1, n6);
        }

        public void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            int n7 = n6;
            int n8 = n5 + 1;
            graphics.translate(n3, n4);
            if (this.isFirstDisplayedTab(n2, n3, this.tabPane.getBounds().x)) {
                if (bl2) {
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n8, 0, 1, n7 - 1);
                    graphics.fillRect(n8 - 1, n7 - 1, 1, 1);
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, 1, n7);
                    graphics.fillRect(n8 - 1, 0, 1, n7 - 1);
                    graphics.fillRect(1, n7 - 1, n8 - 2, 1);
                }
            } else if (bl2) {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, 1, n7 - 1);
                graphics.fillRect(1, n7 - 1, 1, 1);
                graphics.fillRect(n8, 0, 1, n7 - 1);
                graphics.fillRect(n8 - 1, n7 - 1, 1, 1);
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 0, 1, n7 - 1);
                graphics.fillRect(n8 - 1, 0, 1, n7 - 1);
                graphics.fillRect(2, n7 - 1, n8 - 3, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(1, n6 / 2, 1, n6 - n6 / 2);
            }
            graphics.translate(-n3, -n4);
        }

        public void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n2, n3 + n5 - 1, n4, 1);
        }

        public BottomEmbeddedRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static abstract class AbstractRenderer {
        public static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        public static final Insets NORTH_INSETS = new Insets(1, 0, 0, 0);
        public static final Insets WEST_INSETS = new Insets(0, 1, 0, 0);
        public static final Insets SOUTH_INSETS = new Insets(0, 0, 1, 0);
        public static final Insets EAST_INSETS = new Insets(0, 0, 0, 1);
        public final JTabbedPane tabPane;
        public final int tabPlacement;
        public Color shadowColor;
        public Color darkShadow;
        public Color selectColor;
        public Color selectLight;
        public Color selectHighlight;
        public Color lightHighlight;
        public Color focus;

        private AbstractRenderer(JTabbedPane jTabbedPane) {
            this.initColors();
            this.tabPane = jTabbedPane;
            this.tabPlacement = jTabbedPane.getTabPlacement();
        }

        private static AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    return new TopRenderer(jTabbedPane, null);
                }
                case 3: {
                    return new BottomRenderer(jTabbedPane, null);
                }
                case 2: {
                    return new LeftRenderer(jTabbedPane, null);
                }
                case 4: {
                    return new RightRenderer(jTabbedPane, null);
                }
            }
            return new TopRenderer(jTabbedPane, null);
        }

        private static AbstractRenderer createEmbeddedRenderer(JTabbedPane jTabbedPane) {
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    return new TopEmbeddedRenderer(jTabbedPane, null);
                }
                case 3: {
                    return new BottomEmbeddedRenderer(jTabbedPane, null);
                }
                case 2: {
                    return new LeftEmbeddedRenderer(jTabbedPane, null);
                }
                case 4: {
                    return new RightEmbeddedRenderer(jTabbedPane, null);
                }
            }
            return new TopEmbeddedRenderer(jTabbedPane, null);
        }

        private void initColors() {
            this.shadowColor = UIManager.getColor("TabbedPane.shadow");
            this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
            this.selectColor = UIManager.getColor("TabbedPane.selected");
            this.focus = UIManager.getColor("TabbedPane.focus");
            this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
            this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
            this.selectLight = new Color((2 * this.selectColor.getRed() + this.selectHighlight.getRed()) / 3, (2 * this.selectColor.getGreen() + this.selectHighlight.getGreen()) / 3, (2 * this.selectColor.getBlue() + this.selectHighlight.getBlue()) / 3);
        }

        public boolean isFirstDisplayedTab(int n2, int n3, int n4) {
            return n2 == 0;
        }

        public Insets getTabAreaInsets(Insets insets) {
            return insets;
        }

        public Insets getContentBorderInsets(Insets insets) {
            return insets;
        }

        public int getTabLabelShiftX(int n2, boolean bl2) {
            return 0;
        }

        public int getTabLabelShiftY(int n2, boolean bl2) {
            return 0;
        }

        public int getTabRunOverlay(int n2) {
            return n2;
        }

        public boolean shouldPadTabRun(int n2, boolean bl2) {
            return bl2;
        }

        public int getTabRunIndent(int n2) {
            return 0;
        }

        public abstract Insets getTabInsets(int var1, Insets var2);

        public abstract void paintFocusIndicator(Graphics var1, Rectangle[] var2, int var3, Rectangle var4, Rectangle var5, boolean var6);

        public abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

        public abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

        public Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        public void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            if (bl3) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(n2, n3, n4 - 1, 1);
            }
        }

        public void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            if (bl3) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n2, n3 + n5 - 1, n4 - 1, 1);
            }
        }

        public void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            if (bl3) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(n2, n3, 1, n5 - 1);
            }
        }

        public void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, Rectangle rectangle, boolean bl3) {
            if (bl3) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n2 + n4 - 1, n3, 1, n5);
            }
        }

        public int getTabsOverlay() {
            return 0;
        }

        public static AbstractRenderer b(JTabbedPane jTabbedPane) {
            return AbstractRenderer.createEmbeddedRenderer(jTabbedPane);
        }

        public static AbstractRenderer a(JTabbedPane jTabbedPane) {
            return AbstractRenderer.createRenderer(jTabbedPane);
        }

        public AbstractRenderer(JTabbedPane jTabbedPane, 1 var2_2) {
            this(jTabbedPane);
        }
    }

    private static class ArrowButton
    extends JButton
    implements UIResource {
        private final int buttonWidth;
        private final int direction;
        private boolean mouseIsOver;

        public ArrowButton(int n2, int n3) {
            this.direction = n2;
            this.buttonWidth = n3;
            this.setRequestFocusEnabled(false);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            switch (mouseEvent.getID()) {
                case 504: {
                    this.mouseIsOver = true;
                    this.revalidate();
                    this.repaint();
                    break;
                }
                case 505: {
                    this.mouseIsOver = false;
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        public void paintBorder(Graphics graphics) {
            if (this.mouseIsOver && this.isEnabled()) {
                super.paintBorder(graphics);
            }
        }

        public void paintComponent(Graphics graphics) {
            if (this.mouseIsOver) {
                super.paintComponent(graphics);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintArrow(graphics);
        }

        private void paintArrow(Graphics graphics) {
            int n2;
            int n3;
            Color color = graphics.getColor();
            boolean bl2 = this.isEnabled();
            graphics.setColor(bl2 ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled());
            switch (this.direction) {
                case 1: 
                case 5: {
                    n3 = 9;
                    n2 = 5;
                    break;
                }
                default: {
                    n3 = 5;
                    n2 = 9;
                }
            }
            int n4 = (this.getWidth() - n3) / 2;
            int n5 = (this.getHeight() - n2) / 2;
            graphics.translate(n4, n5);
            boolean bl3 = !this.mouseIsOver || !bl2;
            Color color2 = bl2 ? PlasticLookAndFeel.getControlShadow() : UIManager.getColor("ScrollBar.highlight");
            switch (this.direction) {
                case 1: {
                    graphics.fillRect(0, 4, 9, 1);
                    graphics.fillRect(1, 3, 7, 1);
                    graphics.fillRect(2, 2, 5, 1);
                    graphics.fillRect(3, 1, 3, 1);
                    graphics.fillRect(4, 0, 1, 1);
                    if (!bl3) break;
                    graphics.setColor(color2);
                    graphics.fillRect(1, 5, 9, 1);
                    break;
                }
                case 5: {
                    graphics.fillRect(0, 0, 9, 1);
                    graphics.fillRect(1, 1, 7, 1);
                    graphics.fillRect(2, 2, 5, 1);
                    graphics.fillRect(3, 3, 3, 1);
                    graphics.fillRect(4, 4, 1, 1);
                    if (!bl3) break;
                    graphics.setColor(color2);
                    graphics.drawLine(5, 4, 8, 1);
                    graphics.drawLine(5, 5, 9, 1);
                    break;
                }
                case 7: {
                    graphics.fillRect(0, 4, 1, 1);
                    graphics.fillRect(1, 3, 1, 3);
                    graphics.fillRect(2, 2, 1, 5);
                    graphics.fillRect(3, 1, 1, 7);
                    graphics.fillRect(4, 0, 1, 9);
                    if (!bl3) break;
                    graphics.setColor(color2);
                    graphics.fillRect(5, 1, 1, 9);
                    break;
                }
                case 3: {
                    graphics.fillRect(0, 0, 1, 9);
                    graphics.fillRect(1, 1, 1, 7);
                    graphics.fillRect(2, 2, 1, 5);
                    graphics.fillRect(3, 3, 1, 3);
                    graphics.fillRect(4, 4, 1, 1);
                    if (!bl3) break;
                    graphics.setColor(color2);
                    graphics.drawLine(1, 8, 4, 5);
                    graphics.drawLine(1, 9, 5, 5);
                }
            }
            graphics.translate(-n4, -n5);
            graphics.setColor(color);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        private final PlasticTabbedPaneUI this$0;

        public ScrollableTabPanel(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            super(null);
            this.this$0 = plasticTabbedPaneUI;
            this.setOpaque(PlasticTabbedPaneUI.bs(plasticTabbedPaneUI).isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = PlasticTabbedPaneUI.az(plasticTabbedPaneUI).getBackground();
            }
            this.setBackground(color);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.this$0.paintTabArea(graphics, PlasticTabbedPaneUI.I(this.this$0).getTabPlacement(), PlasticTabbedPaneUI.ag(this.this$0).getSelectedIndex());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        private final PlasticTabbedPaneUI this$0;

        public ScrollableTabViewport(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            this.this$0 = plasticTabbedPaneUI;
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(PlasticTabbedPaneUI.u(plasticTabbedPaneUI).isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = PlasticTabbedPaneUI.q(plasticTabbedPaneUI).getBackground();
            }
            this.setBackground(color);
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition;
        private final PlasticTabbedPaneUI this$0;

        public ScrollableTabSupport(PlasticTabbedPaneUI plasticTabbedPaneUI, int n2) {
            this.this$0 = plasticTabbedPaneUI;
            this.tabViewPosition = new Point(0, 0);
            this.viewport = new ScrollableTabViewport(plasticTabbedPaneUI);
            this.tabPanel = new ScrollableTabPanel(plasticTabbedPaneUI);
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.a();
        }

        public void a() {
            if (this.scrollForwardButton != null) {
                PlasticTabbedPaneUI.ad(this.this$0).remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                PlasticTabbedPaneUI.d(this.this$0).remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            int n2 = PlasticTabbedPaneUI.ac(this.this$0).getTabPlacement();
            int n3 = UIManager.getInt("ScrollBar.width");
            if (n2 == 1 || n2 == 3) {
                this.scrollForwardButton = new ArrowButton(3, n3);
                this.scrollBackwardButton = new ArrowButton(7, n3);
            } else {
                this.scrollForwardButton = new ArrowButton(5, n3);
                this.scrollBackwardButton = new ArrowButton(1, n3);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            PlasticTabbedPaneUI.ap(this.this$0).add(this.scrollForwardButton);
            PlasticTabbedPaneUI.r(this.this$0).add(this.scrollBackwardButton);
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n2) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : PlasticTabbedPaneUI.ae((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].x - PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay();
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n5 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : PlasticTabbedPaneUI.bl((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n2 = PlasticTabbedPaneUI.o(this.this$0).getTabPlacement();
            int n3 = PlasticTabbedPaneUI.aN(this.this$0).getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = PlasticTabbedPaneUI.a(this.this$0, rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n3) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        if (PlasticTabbedPaneUI.bp((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (PlasticTabbedPaneUI.be((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = this.this$0.getContentBorderInsets(n2);
            switch (n2) {
                case 2: {
                    PlasticTabbedPaneUI.aB(this.this$0).repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    PlasticTabbedPaneUI.P(this.this$0).repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    PlasticTabbedPaneUI.w(this.this$0).repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    PlasticTabbedPaneUI.aP(this.this$0).repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Action action;
            ActionMap actionMap = PlasticTabbedPaneUI.T(this.this$0).getActionMap();
            if (actionMap != null && (action = actionMap.get(string = actionEvent.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(PlasticTabbedPaneUI.A(this.this$0), 1001, null, actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private final PlasticTabbedPaneUI this$0;

        private TabbedPaneScrollLayout(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            super(plasticTabbedPaneUI, null);
            this.this$0 = plasticTabbedPaneUI;
        }

        public int preferredTabAreaHeight(int n2, int n3) {
            return PlasticTabbedPaneUI.i(this.this$0, n2);
        }

        public int preferredTabAreaWidth(int n2, int n3) {
            return PlasticTabbedPaneUI.o(this.this$0, n2);
        }

        public void layoutContainer(Container container) {
            int n2 = PlasticTabbedPaneUI.bf(this.this$0).getTabPlacement();
            int n3 = PlasticTabbedPaneUI.ah(this.this$0).getTabCount();
            Insets insets = PlasticTabbedPaneUI.aq(this.this$0).getInsets();
            int n4 = PlasticTabbedPaneUI.U(this.this$0).getSelectedIndex();
            Component component = PlasticTabbedPaneUI.aE(this.this$0);
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    PlasticTabbedPaneUI.a(this.this$0, null);
                }
            } else {
                Component component2 = PlasticTabbedPaneUI.aI(this.this$0).getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    PlasticTabbedPaneUI.b(this.this$0, component2);
                }
                Insets insets2 = this.this$0.getContentBorderInsets(n2);
                Rectangle rectangle = PlasticTabbedPaneUI.x(this.this$0).getBounds();
                int n5 = PlasticTabbedPaneUI.G(this.this$0).getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n2) {
                        case 2: {
                            n13 = PlasticTabbedPaneUI.d(this.this$0, n2, PlasticTabbedPaneUI.z(this.this$0), PlasticTabbedPaneUI.af(this.this$0));
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = PlasticTabbedPaneUI.f(this.this$0, n2, PlasticTabbedPaneUI.L(this.this$0), PlasticTabbedPaneUI.am(this.this$0));
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = PlasticTabbedPaneUI.c(this.this$0, n2, PlasticTabbedPaneUI.aS(this.this$0), PlasticTabbedPaneUI.ar(this.this$0));
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = PlasticTabbedPaneUI.a(this.this$0, n2, PlasticTabbedPaneUI.av(this.this$0), PlasticTabbedPaneUI.H(this.this$0));
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        Component component3;
                        Component component4 = PlasticTabbedPaneUI.Q(this.this$0).getComponent(i2);
                        if (PlasticTabbedPaneUI.ab(this.this$0) != null && component4 == PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).viewport) {
                            component3 = (JViewport)component4;
                            cloneable = ((JViewport)component3).getViewRect();
                            n17 = n13;
                            n16 = n12;
                            Dimension dimension = PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).scrollForwardButton.getPreferredSize();
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n15 = PlasticTabbedPaneUI.ay((PlasticTabbedPaneUI)this.this$0)[n3 - 1].y + PlasticTabbedPaneUI.W((PlasticTabbedPaneUI)this.this$0)[n3 - 1].height;
                                    if (n15 <= n12) break;
                                    int n18 = n16 = n12 > 2 * dimension.height ? n12 - 2 * dimension.height : 0;
                                    if (n15 - cloneable.y > n16) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = PlasticTabbedPaneUI.N((PlasticTabbedPaneUI)this.this$0)[n3 - 1].x + PlasticTabbedPaneUI.ao((PlasticTabbedPaneUI)this.this$0)[n3 - 1].width + PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay();
                                    if (n14 <= n13) break;
                                    int n19 = n17 = n13 > 2 * dimension.width ? n13 - 2 * dimension.width : 0;
                                    if (n14 - cloneable.x > n17) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component4.setBounds(n11, n10, n17, n16);
                            continue;
                        }
                        if (PlasticTabbedPaneUI.ab(this.this$0) != null && (component4 == PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).scrollForwardButton || component4 == PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).scrollBackwardButton)) {
                            component3 = component4;
                            cloneable = component3.getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            int n20 = ((Dimension)cloneable).width;
                            n15 = ((Dimension)cloneable).height;
                            n14 = 0;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    int n21 = PlasticTabbedPaneUI.at((PlasticTabbedPaneUI)this.this$0)[n3 - 1].y + PlasticTabbedPaneUI.bm((PlasticTabbedPaneUI)this.this$0)[n3 - 1].height;
                                    if (n21 <= n12) break;
                                    n14 = 1;
                                    n17 = n2 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n16 = component4 == PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).scrollForwardButton ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n22 = PlasticTabbedPaneUI.bj((PlasticTabbedPaneUI)this.this$0)[n3 - 1].x + PlasticTabbedPaneUI.k((PlasticTabbedPaneUI)this.this$0)[n3 - 1].width;
                                    if (n22 <= n13) break;
                                    n14 = 1;
                                    n17 = component4 == PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).scrollForwardButton ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n2 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component4.setVisible(n14 != 0);
                            if (n14 == 0) continue;
                            component4.setBounds(n17, n16, n20, n15);
                            continue;
                        }
                        component4.setBounds(n9, n8, n7, n6);
                    }
                    if (bl2 && !PlasticTabbedPaneUI.aD(this.this$0)) {
                        PlasticTabbedPaneUI.ak(this.this$0).requestFocus();
                    }
                }
            }
        }

        public void calculateTabRects(int n2, int n3) {
            int n4;
            FontMetrics fontMetrics = PlasticTabbedPaneUI.bc(this.this$0);
            Dimension dimension = PlasticTabbedPaneUI.aX(this.this$0).getSize();
            Insets insets = PlasticTabbedPaneUI.i(this.this$0).getInsets();
            Insets insets2 = this.this$0.getTabAreaInsets(n2);
            int n5 = fontMetrics.getHeight();
            int n6 = PlasticTabbedPaneUI.aV(this.this$0).getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = PlasticUtils.a((Component)PlasticTabbedPaneUI.aR(this.this$0));
            int n7 = insets2.left;
            int n8 = insets2.top;
            int n9 = 0;
            int n10 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    PlasticTabbedPaneUI.C(this.this$0, PlasticTabbedPaneUI.t(this.this$0, n2));
                    break;
                }
                default: {
                    PlasticTabbedPaneUI.v(this.this$0, PlasticTabbedPaneUI.b(this.this$0, n2));
                }
            }
            PlasticTabbedPaneUI.c(this.this$0, 0);
            PlasticTabbedPaneUI.f(this.this$0, -1);
            if (n3 == 0) {
                return;
            }
            PlasticTabbedPaneUI.x(this.this$0, 0);
            PlasticTabbedPaneUI.a(this.this$0, 1);
            for (n4 = 0; n4 < n3; ++n4) {
                Rectangle rectangle = PlasticTabbedPaneUI.au(this.this$0)[n4];
                if (!bl2) {
                    if (n4 > 0) {
                        rectangle.x = PlasticTabbedPaneUI.aZ((PlasticTabbedPaneUI)this.this$0)[n4 - 1].x + PlasticTabbedPaneUI.y((PlasticTabbedPaneUI)this.this$0)[n4 - 1].width;
                    } else {
                        PlasticTabbedPaneUI.bk((PlasticTabbedPaneUI)this.this$0)[0] = 0;
                        PlasticTabbedPaneUI.u(this.this$0, 0);
                        n10 += PlasticTabbedPaneUI.C(this.this$0);
                        rectangle.x = n7;
                    }
                    rectangle.width = PlasticTabbedPaneUI.b(this.this$0, n2, n4, fontMetrics);
                    n9 = rectangle.x + rectangle.width + PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay();
                    PlasticTabbedPaneUI.r(this.this$0, Math.max(PlasticTabbedPaneUI.E(this.this$0), rectangle.width));
                    rectangle.y = n8;
                    rectangle.height = PlasticTabbedPaneUI.aw(this.this$0);
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = PlasticTabbedPaneUI.bg((PlasticTabbedPaneUI)this.this$0)[n4 - 1].y + PlasticTabbedPaneUI.an((PlasticTabbedPaneUI)this.this$0)[n4 - 1].height;
                } else {
                    PlasticTabbedPaneUI.bq((PlasticTabbedPaneUI)this.this$0)[0] = 0;
                    PlasticTabbedPaneUI.A(this.this$0, 0);
                    n9 = PlasticTabbedPaneUI.Z(this.this$0);
                    rectangle.y = n8;
                }
                rectangle.height = PlasticTabbedPaneUI.e(this.this$0, n2, n4, n5);
                n10 = rectangle.y + rectangle.height;
                PlasticTabbedPaneUI.j(this.this$0, Math.max(PlasticTabbedPaneUI.t(this.this$0), rectangle.height));
                rectangle.x = n7;
                rectangle.width = PlasticTabbedPaneUI.aC(this.this$0);
            }
            this.padSelectedTab(n2, n6);
            if (!bl3 && !bl2) {
                int n11 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n3; ++n4) {
                    PlasticTabbedPaneUI.Y((PlasticTabbedPaneUI)this.this$0)[n4].x = n11 - PlasticTabbedPaneUI.bt((PlasticTabbedPaneUI)this.this$0)[n4].x - PlasticTabbedPaneUI.aY((PlasticTabbedPaneUI)this.this$0)[n4].width;
                }
            }
            PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).tabPanel.setPreferredSize(new Dimension(n9, n10));
        }

        public TabbedPaneScrollLayout(PlasticTabbedPaneUI plasticTabbedPaneUI, 1 var2_2) {
            this(plasticTabbedPaneUI);
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof PlasticArrowButton) {
                jTabbedPane = (JTabbedPane)((PlasticArrowButton)object).getParent();
            } else {
                return;
            }
            PlasticTabbedPaneUI plasticTabbedPaneUI = (PlasticTabbedPaneUI)jTabbedPane.getUI();
            if (PlasticTabbedPaneUI.aW(plasticTabbedPaneUI)) {
                PlasticTabbedPaneUI.ab(plasticTabbedPaneUI).scrollBackward(jTabbedPane.getTabPlacement());
            }
        }

        public ScrollTabsBackwardAction(1 var1_1) {
            this();
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof PlasticArrowButton) {
                jTabbedPane = (JTabbedPane)((PlasticArrowButton)object).getParent();
            } else {
                return;
            }
            PlasticTabbedPaneUI plasticTabbedPaneUI = (PlasticTabbedPaneUI)jTabbedPane.getUI();
            if (PlasticTabbedPaneUI.aW(plasticTabbedPaneUI)) {
                PlasticTabbedPaneUI.ab(plasticTabbedPaneUI).scrollForward(jTabbedPane.getTabPlacement());
            }
        }

        public ScrollTabsForwardAction(1 var1_1) {
            this();
        }
    }

    private class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout
    implements LayoutManager {
        private final PlasticTabbedPaneUI this$0;

        private TabbedPaneLayout(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            super(plasticTabbedPaneUI);
            this.this$0 = plasticTabbedPaneUI;
        }

        public void calculateTabRects(int n2, int n3) {
            int n4;
            Rectangle rectangle;
            int n5;
            int n6;
            int n7;
            int n8;
            FontMetrics fontMetrics = PlasticTabbedPaneUI.l(this.this$0);
            Dimension dimension = PlasticTabbedPaneUI.h(this.this$0).getSize();
            Insets insets = PlasticTabbedPaneUI.F(this.this$0).getInsets();
            Insets insets2 = this.this$0.getTabAreaInsets(n2);
            int n9 = fontMetrics.getHeight();
            int n10 = PlasticTabbedPaneUI.as(this.this$0).getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = PlasticUtils.a((Component)PlasticTabbedPaneUI.ba(this.this$0));
            switch (n2) {
                case 2: {
                    PlasticTabbedPaneUI.B(this.this$0, PlasticTabbedPaneUI.q(this.this$0, n2));
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    PlasticTabbedPaneUI.E(this.this$0, PlasticTabbedPaneUI.p(this.this$0, n2));
                    n8 = dimension.width - insets.right - insets2.right - PlasticTabbedPaneUI.m(this.this$0);
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    PlasticTabbedPaneUI.l(this.this$0, PlasticTabbedPaneUI.d(this.this$0, n2));
                    n8 = insets.left + insets2.left;
                    n7 = dimension.height - insets.bottom - insets2.bottom - PlasticTabbedPaneUI.ai(this.this$0);
                    n6 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    PlasticTabbedPaneUI.h(this.this$0, PlasticTabbedPaneUI.m(this.this$0, n2));
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n11 = this.this$0.getTabRunOverlay(n2);
            PlasticTabbedPaneUI.w(this.this$0, 0);
            PlasticTabbedPaneUI.g(this.this$0, -1);
            int n12 = -1;
            int n13 = n6;
            if (n3 == 0) {
                return;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                rectangle = PlasticTabbedPaneUI.O(this.this$0)[n5];
                ++n12;
                if (!bl2) {
                    if (n5 > 0) {
                        rectangle.x = PlasticTabbedPaneUI.e((PlasticTabbedPaneUI)this.this$0)[n5 - 1].x + PlasticTabbedPaneUI.bn((PlasticTabbedPaneUI)this.this$0)[n5 - 1].width;
                    } else {
                        PlasticTabbedPaneUI.c((PlasticTabbedPaneUI)this.this$0)[0] = 0;
                        PlasticTabbedPaneUI.y(this.this$0, 1);
                        PlasticTabbedPaneUI.D(this.this$0, 0);
                        rectangle.x = n8;
                    }
                    rectangle.width = PlasticTabbedPaneUI.a(this.this$0, n2, n5, fontMetrics);
                    PlasticTabbedPaneUI.e(this.this$0, Math.max(PlasticTabbedPaneUI.p(this.this$0), rectangle.width));
                    if (n12 != 0 && rectangle.x + rectangle.width > n13) {
                        if (PlasticTabbedPaneUI.aF(this.this$0) > PlasticTabbedPaneUI.M(this.this$0).length - 1) {
                            PlasticTabbedPaneUI.aa(this.this$0);
                        }
                        n12 = 0;
                        PlasticTabbedPaneUI.aj((PlasticTabbedPaneUI)this.this$0)[PlasticTabbedPaneUI.J((PlasticTabbedPaneUI)this.this$0)] = n5;
                        PlasticTabbedPaneUI.aU(this.this$0);
                        rectangle.x = n8;
                        n13 -= 2 * this.this$0.getTabRunIndent(n2, PlasticTabbedPaneUI.K(this.this$0));
                    }
                    rectangle.y = n7;
                    rectangle.height = PlasticTabbedPaneUI.bu(this.this$0);
                } else {
                    if (n5 > 0) {
                        rectangle.y = PlasticTabbedPaneUI.X((PlasticTabbedPaneUI)this.this$0)[n5 - 1].y + PlasticTabbedPaneUI.al((PlasticTabbedPaneUI)this.this$0)[n5 - 1].height;
                    } else {
                        PlasticTabbedPaneUI.ax((PlasticTabbedPaneUI)this.this$0)[0] = 0;
                        PlasticTabbedPaneUI.s(this.this$0, 1);
                        PlasticTabbedPaneUI.k(this.this$0, 0);
                        rectangle.y = n7;
                    }
                    rectangle.height = PlasticTabbedPaneUI.b(this.this$0, n2, n5, n9);
                    PlasticTabbedPaneUI.n(this.this$0, Math.max(PlasticTabbedPaneUI.g(this.this$0), rectangle.height));
                    if (n12 != 0 && rectangle.y + rectangle.height > n13) {
                        if (PlasticTabbedPaneUI.aQ(this.this$0) > PlasticTabbedPaneUI.br(this.this$0).length - 1) {
                            PlasticTabbedPaneUI.aM(this.this$0);
                        }
                        PlasticTabbedPaneUI.j((PlasticTabbedPaneUI)this.this$0)[PlasticTabbedPaneUI.aO((PlasticTabbedPaneUI)this.this$0)] = n5;
                        PlasticTabbedPaneUI.B(this.this$0);
                        rectangle.y = n7;
                        n12 = 0;
                        n13 -= 2 * this.this$0.getTabRunIndent(n2, PlasticTabbedPaneUI.f(this.this$0));
                    }
                    rectangle.x = n8;
                    rectangle.width = PlasticTabbedPaneUI.aA(this.this$0);
                }
                if (n5 != n10) continue;
                PlasticTabbedPaneUI.z(this.this$0, PlasticTabbedPaneUI.b(this.this$0) - 1);
            }
            if (PlasticTabbedPaneUI.D(this.this$0) > 1 && this.this$0.shouldRotateTabRuns(n2)) {
                this.rotateTabRuns(n2, PlasticTabbedPaneUI.aH(this.this$0));
            }
            for (n5 = PlasticTabbedPaneUI.aJ(this.this$0) - 1; n5 >= 0; --n5) {
                int n14;
                n4 = PlasticTabbedPaneUI.bi(this.this$0)[n5];
                int n15 = PlasticTabbedPaneUI.a(this.this$0)[n5 == PlasticTabbedPaneUI.aT(this.this$0) - 1 ? 0 : n5 + 1];
                int n16 = n15 != 0 ? n15 - 1 : n3 - 1;
                int n17 = this.this$0.getTabRunIndent(n2, n5);
                if (!bl2) {
                    for (n14 = n4; n14 <= n16; ++n14) {
                        rectangle = PlasticTabbedPaneUI.v(this.this$0)[n14];
                        rectangle.y = n7;
                        rectangle.x += n17;
                    }
                    if (this.this$0.shouldPadTabRun(n2, n5)) {
                        this.padTabRun(n2, n4, n16, n6 - 2 * n17);
                    }
                    if (n2 == 3) {
                        n7 -= PlasticTabbedPaneUI.R(this.this$0) - n11;
                        continue;
                    }
                    n7 += PlasticTabbedPaneUI.aG(this.this$0) - n11;
                    continue;
                }
                for (n14 = n4; n14 <= n16; ++n14) {
                    rectangle = PlasticTabbedPaneUI.s(this.this$0)[n14];
                    rectangle.x = n8;
                    rectangle.y += n17;
                }
                if (this.this$0.shouldPadTabRun(n2, n5)) {
                    this.padTabRun(n2, n4, n16, n6 - 2 * n17);
                }
                if (n2 == 4) {
                    n8 -= PlasticTabbedPaneUI.bd(this.this$0) - n11;
                    continue;
                }
                n8 += PlasticTabbedPaneUI.aL(this.this$0) - n11;
            }
            this.padSelectedTab(n2, n10);
            if (!bl3 && !bl2) {
                n4 = dimension.width - (insets.right + insets2.right);
                for (n5 = 0; n5 < n3; ++n5) {
                    PlasticTabbedPaneUI.n((PlasticTabbedPaneUI)this.this$0)[n5].x = n4 - PlasticTabbedPaneUI.V((PlasticTabbedPaneUI)this.this$0)[n5].x - PlasticTabbedPaneUI.bo((PlasticTabbedPaneUI)this.this$0)[n5].width + PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay();
                }
            }
        }

        public TabbedPaneLayout(PlasticTabbedPaneUI plasticTabbedPaneUI, 1 var2_2) {
            this(plasticTabbedPaneUI);
        }
    }

    private class MyPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        private final PlasticTabbedPaneUI this$0;

        private MyPropertyChangeHandler(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            super(plasticTabbedPaneUI);
            this.this$0 = plasticTabbedPaneUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (null == string) {
                return;
            }
            super.propertyChange(propertyChangeEvent);
            if (string.equals("tabPlacement")) {
                PlasticTabbedPaneUI.aK(this.this$0);
                return;
            }
            if (string.equals("jgoodies.embeddedTabs")) {
                PlasticTabbedPaneUI.a(this.this$0, (Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("jgoodies.noContentBorder")) {
                PlasticTabbedPaneUI.b(this.this$0, (Boolean)propertyChangeEvent.getNewValue());
                return;
            }
        }

        public MyPropertyChangeHandler(PlasticTabbedPaneUI plasticTabbedPaneUI, 1 var2_2) {
            this(plasticTabbedPaneUI);
        }
    }

    private class TabSelectionHandler
    implements ChangeListener {
        private Rectangle rect;
        private final PlasticTabbedPaneUI this$0;

        private TabSelectionHandler(PlasticTabbedPaneUI plasticTabbedPaneUI) {
            this.this$0 = plasticTabbedPaneUI;
            this.rect = new Rectangle();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n2 = jTabbedPane.getSelectedIndex()) < PlasticTabbedPaneUI.S(this.this$0).length && n2 != -1) {
                this.rect.setBounds(PlasticTabbedPaneUI.bb(this.this$0)[n2]);
                Point point = PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).viewport.getViewPosition();
                this.rect.x = this.rect.x < point.x ? (this.rect.x -= PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay()) : (this.rect.x += PlasticTabbedPaneUI.bh(this.this$0).getTabsOverlay());
                PlasticTabbedPaneUI.ab((PlasticTabbedPaneUI)this.this$0).tabPanel.scrollRectToVisible(this.rect);
            }
        }

        public TabSelectionHandler(PlasticTabbedPaneUI plasticTabbedPaneUI, 1 var2_2) {
            this(plasticTabbedPaneUI);
        }
    }
}

