/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public final class PlasticMenuBarUI
extends BasicMenuBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticMenuBarUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    public void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.menuBar.addPropertyChangeListener(this.listener);
    }

    public void uninstallListeners() {
        this.menuBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(this){
            private final PlasticMenuBarUI this$0;
            {
                this.this$0 = plasticMenuBarUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("Plastic.borderStyle")) {
                    this.this$0.installSpecialBorder();
                }
            }
        };
    }

    public void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.menuBar, "Plastic.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else {
            HeaderStyle headerStyle = HeaderStyle.from(this.menuBar);
            if (headerStyle == HeaderStyle.BOTH) {
                string = "headerBorder";
            } else if (headerStyle == HeaderStyle.SINGLE && this.is3D()) {
                string = "etchedBorder";
            } else {
                return;
            }
        }
        LookAndFeel.installBorder(this.menuBar, "MenuBar." + string);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        if (this.is3D()) {
            PlasticUtils.a(graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), true);
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        if (PlasticUtils.a(this.menuBar)) {
            return true;
        }
        if (PlasticUtils.b(this.menuBar)) {
            return false;
        }
        return PlasticUtils.a("MenuBar.") && HeaderStyle.from(this.menuBar) != null && BorderStyle.from(this.menuBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

