/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticComboBoxEditor;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public final class PlasticComboBoxUI
extends MetalComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticComboBoxUI();
    }

    public ComboBoxEditor createEditor() {
        return new PlasticComboBoxEditor.UIResource();
    }

    public ComboPopup createPopup() {
        return new PlasticComboPopup(this, this.comboBox, null);
    }

    private Insets getEditorInsets() {
        if (this.editor instanceof JComponent) {
            return ((JComponent)this.editor).getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    private int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof PlasticComboBoxButton) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)this.arrowButton;
            Insets insets = plasticComboBoxButton.getInsets();
            Insets insets2 = plasticComboBoxButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.height += 2;
            dimension.width += insets3.left + insets3.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets2.left + insets2.right;
            dimension.width += plasticComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets3.top + insets3.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = this.getDisplaySize();
            Insets insets = this.comboBox.getInsets();
            Insets insets4 = this.getEditorInsets();
            int n2 = this.getEditableButtonWidth();
            dimension.width += insets.left + insets.right;
            dimension.width += insets4.left + insets4.right - 1;
            dimension.width += n2;
            dimension.height += insets.top + insets.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public JButton createArrowButton() {
        return new PlasticComboBoxButton(this.comboBox, PlasticIconFactory.c(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    public LayoutManager createLayoutManager() {
        return new PlasticComboBoxLayoutManager(this, null);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.isToolBarComboBox(jComponent)) {
                jComponent.setOpaque(false);
            }
        }
        this.paint(graphics, jComponent);
    }

    public boolean isToolBarComboBox(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new PlasticPropertyChangeListener(this, null);
    }

    public static Insets k(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.getInsets();
    }

    public static int h(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.getEditableButtonWidth();
    }

    public static JButton a(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static JButton j(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static JButton e(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static Component d(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.editor;
    }

    public static Rectangle o(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.rectangleForCurrentValue();
    }

    public static Component l(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.editor;
    }

    public static JButton b(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static JComboBox g(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    public static JComboBox f(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    public static JButton n(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static JList m(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.listBox;
    }

    public static JButton i(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    public static JList c(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.listBox;
    }

    public static class 1 {
    }

    private class PlasticComboPopup
    extends MetalComboBoxUI.MetalComboPopup {
        private final PlasticComboBoxUI this$0;

        private PlasticComboPopup(PlasticComboBoxUI plasticComboBoxUI, JComboBox jComboBox) {
            super(plasticComboBoxUI, jComboBox);
            this.this$0 = plasticComboBoxUI;
        }

        public void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
        }

        public void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }

        public PlasticComboPopup(PlasticComboBoxUI plasticComboBoxUI, JComboBox jComboBox, 1 var3_3) {
            this(plasticComboBoxUI, jComboBox);
        }
    }

    private class PlasticPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private final PlasticComboBoxUI this$0;

        private PlasticPropertyChangeListener(PlasticComboBoxUI plasticComboBoxUI) {
            super(plasticComboBoxUI);
            this.this$0 = plasticComboBoxUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)PlasticComboBoxUI.b(this.this$0);
                plasticComboBoxButton.setIconOnly(PlasticComboBoxUI.g(this.this$0).isEditable());
                PlasticComboBoxUI.f(this.this$0).repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.n(this.this$0).setBackground(color);
                PlasticComboBoxUI.m(this.this$0).setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.i(this.this$0).setForeground(color);
                PlasticComboBoxUI.c(this.this$0).setForeground(color);
            }
        }

        public PlasticPropertyChangeListener(PlasticComboBoxUI plasticComboBoxUI, 1 var2_2) {
            this(plasticComboBoxUI);
        }
    }

    private class PlasticComboBoxLayoutManager
    extends MetalComboBoxUI.MetalComboBoxLayoutManager {
        private final PlasticComboBoxUI this$0;

        private PlasticComboBoxLayoutManager(PlasticComboBoxUI plasticComboBoxUI) {
            super(plasticComboBoxUI);
            this.this$0 = plasticComboBoxUI;
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            if (!jComboBox.isEditable()) {
                super.layoutContainer(container);
                return;
            }
            int n2 = jComboBox.getWidth();
            int n3 = jComboBox.getHeight();
            Insets insets = PlasticComboBoxUI.k(this.this$0);
            int n4 = PlasticComboBoxUI.h(this.this$0);
            int n5 = n3 - (insets.top + insets.bottom);
            if (PlasticComboBoxUI.a(this.this$0) != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    PlasticComboBoxUI.j(this.this$0).setBounds(n2 - (insets.right + n4), insets.top, n4, n5);
                } else {
                    PlasticComboBoxUI.e(this.this$0).setBounds(insets.left, insets.top, n4, n5);
                }
            }
            if (PlasticComboBoxUI.d(this.this$0) != null) {
                PlasticComboBoxUI.l(this.this$0).setBounds(PlasticComboBoxUI.o(this.this$0));
            }
        }

        public PlasticComboBoxLayoutManager(PlasticComboBoxUI plasticComboBoxUI, 1 var2_2) {
            this(plasticComboBoxUI);
        }
    }
}

