/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ButtonMarginListener;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;
    private PropertyChangeListener buttonMarginListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookUtils.installNarrowMargin(abstractButton, this.getPropertyPrefix());
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("Button.borderPaintsFocus"));
    }

    public void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        if (this.buttonMarginListener == null) {
            this.buttonMarginListener = new ButtonMarginListener(this.getPropertyPrefix());
        }
        abstractButton.addPropertyChangeListener("jgoodies.isNarrow", this.buttonMarginListener);
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.buttonMarginListener);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (this.isToolBarButton(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.is3D(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    PlasticUtils.a(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    public void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (this.borderPaintsFocus) {
            return;
        }
        boolean bl2 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
        int n2 = bl2 ? 3 : 2;
        int n3 = abstractButton.getWidth() - 1 - n2 * 2;
        int n4 = abstractButton.getHeight() - 1 - n2 * 2;
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(n2, n2, n3 - 1, n4 - 1);
    }

    public boolean isToolBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    public boolean is3D(AbstractButton abstractButton) {
        if (PlasticUtils.a(abstractButton)) {
            return true;
        }
        if (PlasticUtils.b(abstractButton)) {
            return false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        return PlasticUtils.a("Button.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && (!buttonModel.isPressed() || !buttonModel.isArmed()) && !(abstractButton.getBorder() instanceof EmptyBorder);
    }
}

