/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.MinimumSizedCheckIcon;
import com.jgoodies.looks.common.MinimumSizedIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public final class MenuItemRenderer {
    public static final String HTML_KEY = "html";
    private static final String MAX_TEXT_WIDTH = "maxTextWidth";
    private static final String MAX_ACC_WIDTH = "maxAccWidth";
    private static final Icon NO_ICON = new NullIcon(null);
    public static Rectangle h = new Rectangle(0, 0, 0, 0);
    public static Rectangle a = new Rectangle();
    public static Rectangle g = new Rectangle();
    public static Rectangle c = new Rectangle();
    public static Rectangle b = new Rectangle();
    public static Rectangle f = new Rectangle();
    public static Rectangle e = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    public static Rectangle d = new Rectangle();
    private final JMenuItem menuItem;
    private final boolean iconBorderEnabled;
    private final Font acceleratorFont;
    private final Color selectionForeground;
    private final Color disabledForeground;
    private final Color acceleratorForeground;
    private final Color acceleratorSelectionForeground;
    private final String acceleratorDelimiter;
    private final Icon fillerIcon;

    public MenuItemRenderer(JMenuItem jMenuItem, boolean bl2, Font font, Color color, Color color2, Color color3, Color color4) {
        this.menuItem = jMenuItem;
        this.iconBorderEnabled = bl2;
        this.acceleratorFont = font;
        this.selectionForeground = color;
        this.disabledForeground = color2;
        this.acceleratorForeground = color3;
        this.acceleratorSelectionForeground = color4;
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        this.fillerIcon = new MinimumSizedIcon();
    }

    private Icon getIcon(JMenuItem jMenuItem, Icon icon) {
        Icon icon2 = jMenuItem.getIcon();
        if (icon2 == null) {
            return icon;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            return buttonModel.isSelected() ? jMenuItem.getDisabledSelectedIcon() : jMenuItem.getDisabledIcon();
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            Icon icon3 = jMenuItem.getPressedIcon();
            return icon3 != null ? icon3 : icon2;
        }
        if (buttonModel.isSelected()) {
            Icon icon4 = jMenuItem.getSelectedIcon();
            return icon4 != null ? icon4 : icon2;
        }
        return icon2;
    }

    private boolean hasCustomIcon() {
        return this.getIcon(this.menuItem, null) != null;
    }

    private Icon getWrappedIcon(Icon icon) {
        if (this.hideIcons()) {
            return NO_ICON;
        }
        if (icon == null) {
            return this.fillerIcon;
        }
        return this.iconBorderEnabled && this.hasCustomIcon() ? new MinimumSizedCheckIcon(icon, this.menuItem) : new MinimumSizedIcon(icon);
    }

    private void resetRects() {
        a.setBounds(h);
        g.setBounds(h);
        c.setBounds(h);
        b.setBounds(h);
        f.setBounds(h);
        e.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        d.setBounds(h);
    }

    public Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3;
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n4);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n3 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n3) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        Icon icon3 = this.getWrappedIcon(this.getIcon(this.menuItem, icon));
        Icon icon4 = this.getWrappedIcon(icon2);
        Icon icon5 = icon3.getIconHeight() > this.fillerIcon.getIconHeight() ? icon3 : null;
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon5, icon3, icon4, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), e, a, g, c, b, f, string == null ? 0 : n2, n2);
        d.setBounds(g);
        d = SwingUtilities.computeUnion(MenuItemRenderer.a.x, MenuItemRenderer.a.y, MenuItemRenderer.a.width, MenuItemRenderer.a.height, d);
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n5;
            serializable = (JComponent)container;
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n7 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n8 = n6 != null ? n6 : 0;
            int n9 = n5 = n7 != null ? n7 : 0;
            if (MenuItemRenderer.d.width < n8) {
                MenuItemRenderer.d.width = n8;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, new Integer(MenuItemRenderer.d.width));
            }
            if (MenuItemRenderer.c.width > n5) {
                n5 = MenuItemRenderer.c.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, new Integer(MenuItemRenderer.c.width));
            }
            MenuItemRenderer.d.width += n5;
            MenuItemRenderer.d.width += 10;
        }
        if (this.useCheckAndArrow()) {
            MenuItemRenderer.d.width += MenuItemRenderer.b.width;
            MenuItemRenderer.d.width += n2;
            MenuItemRenderer.d.width += n2;
            MenuItemRenderer.d.width += MenuItemRenderer.f.width;
        }
        MenuItemRenderer.d.width += 2 * n2;
        serializable = jMenuItem.getInsets();
        if (serializable != null) {
            MenuItemRenderer.d.width += ((Insets)serializable).left + ((Insets)serializable).right;
            MenuItemRenderer.d.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (MenuItemRenderer.d.height % 2 == 1) {
            ++MenuItemRenderer.d.height;
        }
        return d.getSize();
    }

    public void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n3 = jMenuItem.getWidth();
        int n4 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        e.setBounds(0, 0, n3, n4);
        MenuItemRenderer.e.x += insets.left;
        MenuItemRenderer.e.y += insets.top;
        MenuItemRenderer.e.width -= insets.right + MenuItemRenderer.e.x;
        MenuItemRenderer.e.height -= insets.bottom + MenuItemRenderer.e.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n5;
            int n6 = keyStroke.getModifiers();
            if (n6 > 0) {
                string = KeyEvent.getKeyModifiersText(n6);
                string = string + this.acceleratorDelimiter;
            }
            string = (n5 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n5) : string + keyStroke.getKeyChar();
        }
        Icon icon3 = this.getWrappedIcon(this.getIcon(this.menuItem, icon));
        MinimumSizedIcon minimumSizedIcon = new MinimumSizedIcon(icon2);
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, null, icon3, minimumSizedIcon, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), e, a, g, c, b, f, jMenuItem.getText() == null ? 0 : n2, n2);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color2);
        }
        icon3.paintIcon(jComponent, graphics, MenuItemRenderer.b.x, MenuItemRenderer.b.y);
        graphics.setColor(color3);
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty(HTML_KEY);
            if (view != null) {
                view.paint(graphics, g);
            } else {
                this.paintText(graphics, jMenuItem, g, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n7 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n8 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n9 = n8 != null ? n8 : MenuItemRenderer.c.width;
                n7 = n9 - MenuItemRenderer.c.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(graphics, string, 0, MenuItemRenderer.c.x - n7, MenuItemRenderer.c.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string, 0, MenuItemRenderer.c.x - n7, MenuItemRenderer.c.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string, 0, MenuItemRenderer.c.x - n7 - 1, MenuItemRenderer.c.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, MenuItemRenderer.c.x - n7, MenuItemRenderer.c.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                minimumSizedIcon.paintIcon(jComponent, graphics, MenuItemRenderer.f.x, MenuItemRenderer.f.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n6, int n7) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        boolean bl2 = this.useCheckAndArrow();
        if (bl2) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (this.isLeftToRight(this.menuItem)) {
            rectangle3.x += n7;
            rectangle2.x += n7;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n7 - rectangle4.width;
            if (bl2) {
                rectangle5.x = rectangle.x;
                rectangle3.x += n7 + rectangle5.width;
                rectangle2.x += n7 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n7 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n7;
            rectangle2.x -= n7;
            rectangle4.x = rectangle.x + rectangle6.width + n7;
            if (bl2) {
                rectangle5.x = rectangle.x + rectangle.width - rectangle5.width;
                rectangle3.x -= n7 + rectangle5.width;
                rectangle2.x -= n7 + rectangle5.width;
                rectangle6.x = rectangle.x + n7;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (bl2) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl2 = this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu();
        return !bl2;
    }

    private boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.isOpaque()) {
            int n2 = jMenuItem.getWidth();
            int n3 = jMenuItem.getHeight();
            Color color2 = buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected() ? color : jMenuItem.getBackground();
            Color color3 = graphics.getColor();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(color3);
        }
    }

    public void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    private boolean hideIcons() {
        Component component;
        Container container = this.menuItem.getParent();
        if (!(container instanceof JPopupMenu)) {
            return false;
        }
        JPopupMenu jPopupMenu = (JPopupMenu)container;
        Object object = jPopupMenu.getClientProperty("jgoodies.noIcons");
        if (object == null && (component = jPopupMenu.getInvoker()) != null && component instanceof JMenu) {
            object = ((JMenu)component).getClientProperty("jgoodies.noIcons");
        }
        return Boolean.TRUE.equals(object);
    }

    public static class 1 {
    }

    private static class NullIcon
    implements Icon {
        private NullIcon() {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public NullIcon(1 var1_1) {
            this();
        }
    }
}

