/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.UnitConverter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public abstract class AbstractUnitConverter
implements UnitConverter {
    private static final int DTP_RESOLUTION = 72;
    private static int defaultScreenResolution = -1;

    public int inchAsPixel(double d2, Component component) {
        return this.inchAsPixel(d2, this.getScreenResolution(component));
    }

    public int millimeterAsPixel(double d2, Component component) {
        return this.millimeterAsPixel(d2, this.getScreenResolution(component));
    }

    public int centimeterAsPixel(double d2, Component component) {
        return this.centimeterAsPixel(d2, this.getScreenResolution(component));
    }

    public int pointAsPixel(int n2, Component component) {
        return this.pointAsPixel(n2, this.getScreenResolution(component));
    }

    public int dialogUnitXAsPixel(int n2, Component component) {
        return this.dialogUnitXAsPixel(n2, this.getDialogBaseUnitsX(component));
    }

    public int dialogUnitYAsPixel(int n2, Component component) {
        return this.dialogUnitYAsPixel(n2, this.getDialogBaseUnitsY(component));
    }

    public abstract double getDialogBaseUnitsX(Component var1);

    public abstract double getDialogBaseUnitsY(Component var1);

    public final int inchAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2);
    }

    public final int millimeterAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2 * 10.0 / 254.0);
    }

    public final int centimeterAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2 * 100.0 / 254.0);
    }

    public final int pointAsPixel(int n2, int n3) {
        return Math.round(n3 * n2 / 72);
    }

    public int dialogUnitXAsPixel(int n2, double d2) {
        return (int)Math.round((double)n2 * d2 / 4.0);
    }

    public int dialogUnitYAsPixel(int n2, double d2) {
        return (int)Math.round((double)n2 * d2 / 8.0);
    }

    public double computeAverageCharWidth(FontMetrics fontMetrics, String string) {
        int n2 = fontMetrics.stringWidth(string);
        double d2 = (double)n2 / (double)string.length();
        return d2;
    }

    public int getScreenResolution(Component component) {
        if (component == null) {
            return this.getDefaultScreenResolution();
        }
        Toolkit toolkit = component.getToolkit();
        return toolkit != null ? toolkit.getScreenResolution() : this.getDefaultScreenResolution();
    }

    public int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return defaultScreenResolution;
    }
}

